/*
 * Decompiled with CFR 0.152.
 */
package bftsmart.communication;

import bftsmart.communication.SystemMessage;
import bftsmart.consensus.messages.ConsensusMessage;
import bftsmart.consensus.roles.Acceptor;
import bftsmart.statemanagement.SMMessage;
import bftsmart.tom.core.TOMLayer;
import bftsmart.tom.core.messages.ForwardedMessage;
import bftsmart.tom.core.messages.TOMMessage;
import bftsmart.tom.leaderchange.LCMessage;
import bftsmart.tom.util.TOMUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.HashMap;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageHandler {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private Acceptor acceptor;
    private TOMLayer tomLayer;
    private Mac mac;

    public MessageHandler() {
        try {
            this.mac = TOMUtil.getMacFactory();
        }
        catch (NoSuchAlgorithmException ex) {
            this.logger.error("Failed to create MAC engine", (Throwable)ex);
        }
    }

    public void setAcceptor(Acceptor acceptor) {
        this.acceptor = acceptor;
    }

    public void setTOMLayer(TOMLayer tomLayer) {
        this.tomLayer = tomLayer;
    }

    protected void processData(SystemMessage sm) {
        if (sm instanceof ConsensusMessage) {
            int myId = this.tomLayer.controller.getStaticConf().getProcessId();
            ConsensusMessage consMsg = (ConsensusMessage)sm;
            if (this.tomLayer.controller.getStaticConf().getUseMACs() == 0 || consMsg.authenticated || consMsg.getSender() == myId) {
                this.acceptor.deliver(consMsg);
            } else if (consMsg.getType() == 44783 && consMsg.getProof() != null) {
                HashMap macVector = (HashMap)consMsg.getProof();
                byte[] recvMAC = (byte[])macVector.get(myId);
                ConsensusMessage cm = new ConsensusMessage(44783, consMsg.getNumber(), consMsg.getEpoch(), consMsg.getSender(), consMsg.getValue());
                ByteArrayOutputStream bOut = new ByteArrayOutputStream(248);
                try {
                    new ObjectOutputStream(bOut).writeObject(cm);
                }
                catch (IOException ex) {
                    this.logger.error("Failed to serialize consensus message", (Throwable)ex);
                }
                byte[] data = bOut.toByteArray();
                byte[] myMAC = null;
                SecretKey key = this.tomLayer.getCommunication().getServersConn().getSecretKey(consMsg.getSender());
                try {
                    this.mac.init(key);
                    myMAC = this.mac.doFinal(data);
                }
                catch (InvalidKeyException ex) {
                    this.logger.error("Failed to generate MAC", (Throwable)ex);
                }
                if (recvMAC != null && myMAC != null && Arrays.equals(recvMAC, myMAC)) {
                    this.acceptor.deliver(consMsg);
                } else {
                    this.logger.warn("Invalid MAC from " + sm.getSender());
                }
            } else {
                this.logger.warn("Discarding unauthenticated message from " + sm.getSender());
            }
        } else if (this.tomLayer.controller.getStaticConf().getUseMACs() == 0 || sm.authenticated) {
            if (sm instanceof LCMessage) {
                LCMessage lcMsg = (LCMessage)sm;
                String type = null;
                switch (lcMsg.getType()) {
                    case 3: {
                        type = "STOP";
                        break;
                    }
                    case 4: {
                        type = "STOPDATA";
                        break;
                    }
                    case 5: {
                        type = "SYNC";
                        break;
                    }
                    default: {
                        type = "LOCAL";
                    }
                }
                if (lcMsg.getReg() != -1 && lcMsg.getSender() != -1) {
                    this.logger.info("Received leader change message of type {} for regency {} from replica {}", new Object[]{type, lcMsg.getReg(), lcMsg.getSender()});
                } else {
                    this.logger.debug("Received leader change message from myself");
                }
                if (lcMsg.TRIGGER_LC_LOCALLY) {
                    this.tomLayer.requestsTimer.run_lc_protocol();
                } else {
                    this.tomLayer.getSynchronizer().deliverTimeoutRequest(lcMsg);
                }
            } else if (sm instanceof ForwardedMessage) {
                TOMMessage request = ((ForwardedMessage)sm).getRequest();
                this.tomLayer.requestReceived(request);
            } else if (sm instanceof SMMessage) {
                SMMessage smsg = (SMMessage)sm;
                switch (smsg.getType()) {
                    case 6: {
                        this.tomLayer.getStateManager().SMRequestDeliver(smsg, this.tomLayer.controller.getStaticConf().isBFT());
                        break;
                    }
                    case 7: {
                        this.tomLayer.getStateManager().SMReplyDeliver(smsg, this.tomLayer.controller.getStaticConf().isBFT());
                        break;
                    }
                    case 11: {
                        this.tomLayer.getStateManager().currentConsensusIdAsked(smsg.getSender());
                        break;
                    }
                    case 12: {
                        this.tomLayer.getStateManager().currentConsensusIdReceived(smsg);
                        break;
                    }
                    default: {
                        this.tomLayer.getStateManager().stateTimeout();
                        break;
                    }
                }
            } else {
                this.logger.warn("UNKNOWN MESSAGE TYPE: " + sm);
            }
        } else {
            this.logger.warn("Discarding unauthenticated message from " + sm.getSender());
        }
    }

    protected void verifyPending() {
        this.tomLayer.processOutOfContext();
    }
}

