/*
 * Decompiled with CFR 0.152.
 */
package bftsmart.communication.client.netty;

import bftsmart.communication.client.CommunicationSystemServerSide;
import bftsmart.communication.client.RequestReceiver;
import bftsmart.communication.client.netty.NettyClientServerSession;
import bftsmart.communication.client.netty.NettyServerPipelineFactory;
import bftsmart.reconfiguration.ServerViewController;
import bftsmart.tom.core.messages.TOMMessage;
import bftsmart.tom.util.TOMUtil;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.nio.channels.ClosedChannelException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.crypto.Mac;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class NettyClientServerCommunicationSystemServerSide
extends SimpleChannelInboundHandler<TOMMessage>
implements CommunicationSystemServerSide {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private RequestReceiver requestReceiver;
    private HashMap sessionTable;
    private ReentrantReadWriteLock rl;
    private ServerViewController controller;
    private boolean closed = false;
    private Channel mainChannel;
    private NettyServerPipelineFactory serverPipelineFactory;

    public NettyClientServerCommunicationSystemServerSide(ServerViewController controller) {
        try {
            String myAddress;
            this.controller = controller;
            this.sessionTable = new HashMap();
            this.rl = new ReentrantReadWriteLock();
            Mac macDummy = TOMUtil.getMacFactory();
            this.serverPipelineFactory = new NettyServerPipelineFactory(this, this.sessionTable, controller, this.rl);
            NioEventLoopGroup bossGroup = new NioEventLoopGroup();
            int nWorkers = this.controller.getStaticConf().getNumNettyWorkers();
            NioEventLoopGroup workerGroup = nWorkers > 0 ? new NioEventLoopGroup(nWorkers) : new NioEventLoopGroup();
            ServerBootstrap b = new ServerBootstrap();
            ((ServerBootstrap)b.group((EventLoopGroup)bossGroup, (EventLoopGroup)workerGroup).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                public void initChannel(SocketChannel ch) throws Exception {
                    ch.pipeline().addLast(new ChannelHandler[]{NettyClientServerCommunicationSystemServerSide.this.serverPipelineFactory.getDecoder()});
                    ch.pipeline().addLast(new ChannelHandler[]{NettyClientServerCommunicationSystemServerSide.this.serverPipelineFactory.getEncoder()});
                    ch.pipeline().addLast(new ChannelHandler[]{NettyClientServerCommunicationSystemServerSide.this.serverPipelineFactory.getHandler()});
                }
            }).childOption(ChannelOption.SO_KEEPALIVE, (Object)true).childOption(ChannelOption.TCP_NODELAY, (Object)true);
            String confAddress = controller.getStaticConf().getRemoteAddress(controller.getStaticConf().getProcessId()).getAddress().getHostAddress();
            if (InetAddress.getLoopbackAddress().getHostAddress().equals(confAddress)) {
                myAddress = InetAddress.getLoopbackAddress().getHostAddress();
            } else if (controller.getStaticConf().getBindAddress().equals("")) {
                myAddress = InetAddress.getLocalHost().getHostAddress();
                if (InetAddress.getLoopbackAddress().getHostAddress().equals(myAddress) && !myAddress.equals(confAddress)) {
                    myAddress = confAddress;
                }
            } else {
                myAddress = controller.getStaticConf().getBindAddress();
            }
            int myPort = controller.getStaticConf().getPort(controller.getStaticConf().getProcessId());
            ChannelFuture f = b.bind((SocketAddress)new InetSocketAddress(myAddress, myPort)).sync();
            this.logger.info("ID = " + controller.getStaticConf().getProcessId());
            this.logger.info("N = " + controller.getCurrentViewN());
            this.logger.info("F = " + controller.getCurrentViewF());
            this.logger.info("Port = " + controller.getStaticConf().getPort(controller.getStaticConf().getProcessId()));
            this.logger.info("requestTimeout = " + controller.getStaticConf().getRequestTimeout());
            this.logger.info("maxBatch = " + controller.getStaticConf().getMaxBatchSize());
            if (controller.getStaticConf().getUseMACs() == 1) {
                this.logger.info("Using MACs");
            }
            if (controller.getStaticConf().getUseSignatures() == 1) {
                this.logger.info("Using Signatures");
            }
            this.logger.info("Binded replica to IP address " + myAddress);
            this.mainChannel = f.channel();
        }
        catch (InterruptedException | UnknownHostException | NoSuchAlgorithmException ex) {
            this.logger.error("Failed to create Netty communication system", (Throwable)ex);
        }
    }

    private void closeChannelAndEventLoop(Channel c) {
        c.flush();
        c.deregister();
        c.close();
        c.eventLoop().shutdownGracefully();
    }

    @Override
    public void shutdown() {
        this.logger.info("Shutting down Netty system");
        this.closed = true;
        this.closeChannelAndEventLoop(this.mainChannel);
        this.rl.readLock().lock();
        ArrayList sessions = new ArrayList(this.sessionTable.values());
        this.rl.readLock().unlock();
        for (NettyClientServerSession ncss : sessions) {
            this.closeChannelAndEventLoop(ncss.getChannel());
        }
        this.logger.info("NettyClientServerCommunicationSystemServerSide is halting.");
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        if (this.closed) {
            this.closeChannelAndEventLoop(ctx.channel());
            return;
        }
        if (cause instanceof ClosedChannelException) {
            this.logger.info("Connection with client closed.");
        } else {
            this.logger.error("Impossible to connect to client.", cause);
        }
    }

    protected void channelRead0(ChannelHandlerContext ctx, TOMMessage sm) throws Exception {
        if (this.closed) {
            this.closeChannelAndEventLoop(ctx.channel());
            return;
        }
        if (this.requestReceiver == null) {
            this.logger.warn("Request receiver is still null!");
        } else {
            this.requestReceiver.requestReceived(sm);
        }
    }

    public void channelActive(ChannelHandlerContext ctx) {
        if (this.closed) {
            this.closeChannelAndEventLoop(ctx.channel());
            return;
        }
        this.logger.info("Session Created, active clients=" + this.sessionTable.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelInactive(ChannelHandlerContext ctx) {
        if (this.closed) {
            this.closeChannelAndEventLoop(ctx.channel());
            return;
        }
        this.rl.writeLock().lock();
        try {
            Set s = this.sessionTable.entrySet();
            for (Map.Entry m : s) {
                NettyClientServerSession value = (NettyClientServerSession)m.getValue();
                if (!ctx.channel().equals(value.getChannel())) continue;
                int key = (Integer)m.getKey();
                this.logger.info("Removing client channel with ID= " + key);
                this.sessionTable.remove(key);
                this.logger.info("Active clients=" + this.sessionTable.size());
                break;
            }
        }
        finally {
            this.rl.writeLock().unlock();
        }
        this.logger.debug("Session Closed, active clients=" + this.sessionTable.size());
    }

    @Override
    public void setRequestReceiver(RequestReceiver tl) {
        this.requestReceiver = tl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send(int[] targets, TOMMessage sm, boolean serializeClassHeaders) {
        DataOutputStream dos = null;
        byte[] data = null;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            dos = new DataOutputStream(baos);
            sm.wExternal(dos);
            dos.flush();
            data = baos.toByteArray();
            sm.serializedMessage = data;
        }
        catch (IOException ex) {
            this.logger.error("Failed to serialize message.", (Throwable)ex);
        }
        sm.signed = false;
        if (sm.signed) {
            byte[] data2 = TOMUtil.signMessage(this.controller.getStaticConf().getPrivateKey(), data);
            sm.serializedMessageSignature = data2;
        }
        for (int i = 0; i < targets.length; ++i) {
            try {
                sm = (TOMMessage)sm.clone();
            }
            catch (CloneNotSupportedException ex) {
                this.logger.error("Failed to clone TOMMessage", (Throwable)ex);
                continue;
            }
            this.rl.readLock().lock();
            try {
                NettyClientServerSession ncss = (NettyClientServerSession)this.sessionTable.get(targets[i]);
                if (ncss != null) {
                    Channel session = ncss.getChannel();
                    sm.destination = targets[i];
                    session.writeAndFlush((Object)sm);
                    continue;
                }
                if (sm.getSequence() >= 0 && sm.getSequence() <= 5) {
                    final int id = targets[i];
                    final TOMMessage msg = sm;
                    Thread t = new Thread(){

                        @Override
                        public void run() {
                            NettyClientServerCommunicationSystemServerSide.this.logger.warn("Received request from " + id + " before establishing Netty connection. Re-trying until connection is established");
                            NettyClientServerSession ncss = null;
                            while (ncss == null) {
                                NettyClientServerCommunicationSystemServerSide.this.rl.readLock().lock();
                                try {
                                    Thread.sleep(1000L);
                                }
                                catch (InterruptedException ex) {
                                    NettyClientServerCommunicationSystemServerSide.this.logger.error("Interruption while sleeping", (Throwable)ex);
                                }
                                ncss = (NettyClientServerSession)NettyClientServerCommunicationSystemServerSide.this.sessionTable.get(id);
                                if (ncss != null) {
                                    Channel session = ncss.getChannel();
                                    msg.destination = id;
                                    session.writeAndFlush((Object)msg);
                                }
                                NettyClientServerCommunicationSystemServerSide.this.rl.readLock().unlock();
                            }
                            NettyClientServerCommunicationSystemServerSide.this.logger.info("Connection with " + id + " established!");
                        }
                    };
                    t.start();
                    continue;
                }
                this.logger.warn("!!!!!!!!NettyClientServerSession is NULL !!!!!! sequence: " + sm.getSequence() + ", ID; " + targets[i]);
                continue;
            }
            finally {
                this.rl.readLock().unlock();
            }
        }
    }

    @Override
    public int[] getClients() {
        this.rl.readLock().lock();
        Set s = this.sessionTable.keySet();
        int[] clients = new int[s.size()];
        Iterator it = s.iterator();
        int i = 0;
        while (it.hasNext()) {
            clients[i] = (Integer)it.next();
            ++i;
        }
        this.rl.readLock().unlock();
        return clients;
    }
}

