/*
 * Decompiled with CFR 0.152.
 */
package bftsmart.communication.server;

import bftsmart.communication.SystemMessage;
import bftsmart.communication.server.ServerConnection;
import bftsmart.reconfiguration.ServerViewController;
import bftsmart.tom.ServiceReplica;
import bftsmart.tom.util.TOMUtil;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServersCommunicationLayer
extends Thread {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private ServerViewController controller;
    private LinkedBlockingQueue<SystemMessage> inQueue;
    private HashMap<Integer, ServerConnection> connections = new HashMap();
    private ServerSocket serverSocket;
    private int me;
    private boolean doWork = true;
    private Lock connectionsLock = new ReentrantLock();
    private ReentrantLock waitViewLock = new ReentrantLock();
    private List<PendingConnection> pendingConn = new LinkedList<PendingConnection>();
    private ServiceReplica replica;
    private SecretKey selfPwd;
    private static final String PASSWORD = "commsyst";

    public ServersCommunicationLayer(ServerViewController controller, LinkedBlockingQueue<SystemMessage> inQueue, ServiceReplica replica) throws Exception {
        String myAddress;
        this.controller = controller;
        this.inQueue = inQueue;
        this.me = controller.getStaticConf().getProcessId();
        this.replica = replica;
        if (controller.isInCurrentView()) {
            int[] initialV = controller.getCurrentViewAcceptors();
            for (int i = 0; i < initialV.length; ++i) {
                if (initialV[i] == this.me) continue;
                this.getConnection(initialV[i]);
            }
        }
        String confAddress = controller.getStaticConf().getRemoteAddress(controller.getStaticConf().getProcessId()).getAddress().getHostAddress();
        if (InetAddress.getLoopbackAddress().getHostAddress().equals(confAddress)) {
            myAddress = InetAddress.getLoopbackAddress().getHostAddress();
        } else if (controller.getStaticConf().getBindAddress().equals("")) {
            myAddress = InetAddress.getLocalHost().getHostAddress();
            if (InetAddress.getLoopbackAddress().getHostAddress().equals(myAddress) && !myAddress.equals(confAddress)) {
                myAddress = confAddress;
            }
        } else {
            myAddress = controller.getStaticConf().getBindAddress();
        }
        int myPort = controller.getStaticConf().getServerToServerPort(controller.getStaticConf().getProcessId());
        this.serverSocket = new ServerSocket(myPort, 50, InetAddress.getByName(myAddress));
        SecretKeyFactory fac = TOMUtil.getSecretFactory();
        PBEKeySpec spec = TOMUtil.generateKeySpec(PASSWORD.toCharArray());
        this.selfPwd = fac.generateSecret(spec);
        this.serverSocket.setSoTimeout(10000);
        this.serverSocket.setReuseAddress(true);
        this.start();
    }

    public SecretKey getSecretKey(int id) {
        if (id == this.controller.getStaticConf().getProcessId()) {
            return this.selfPwd;
        }
        return this.connections.get(id).getSecretKey();
    }

    public void updateConnections() {
        this.connectionsLock.lock();
        if (this.controller.isInCurrentView()) {
            Iterator<Integer> it = this.connections.keySet().iterator();
            LinkedList<Integer> toRemove = new LinkedList<Integer>();
            while (it.hasNext()) {
                int rm = it.next();
                if (this.controller.isCurrentViewMember(rm)) continue;
                toRemove.add(rm);
            }
            for (int i = 0; i < toRemove.size(); ++i) {
                this.connections.remove(toRemove.get(i)).shutdown();
            }
            int[] newV = this.controller.getCurrentViewAcceptors();
            for (int i = 0; i < newV.length; ++i) {
                if (newV[i] == this.me) continue;
                this.getConnection(newV[i]);
            }
        } else {
            Iterator<Integer> it = this.connections.keySet().iterator();
            while (it.hasNext()) {
                this.connections.get(it.next()).shutdown();
            }
        }
        this.connectionsLock.unlock();
    }

    private ServerConnection getConnection(int remoteId) {
        this.connectionsLock.lock();
        ServerConnection ret = this.connections.get(remoteId);
        if (ret == null) {
            ret = new ServerConnection(this.controller, null, remoteId, this.inQueue, this.replica);
            this.connections.put(remoteId, ret);
        }
        this.connectionsLock.unlock();
        return ret;
    }

    public final void send(int[] targets, SystemMessage sm, boolean useMAC) {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream(248);
        try {
            new ObjectOutputStream(bOut).writeObject(sm);
        }
        catch (IOException ex) {
            this.logger.error("Failed to serialize message", (Throwable)ex);
        }
        byte[] data = bOut.toByteArray();
        for (int i : targets) {
            try {
                if (i == this.me) {
                    sm.authenticated = true;
                    this.inQueue.put(sm);
                    continue;
                }
                this.getConnection(i).send(data, useMAC);
            }
            catch (InterruptedException ex) {
                this.logger.error("Interruption while inserting message into inqueue", (Throwable)ex);
            }
        }
    }

    public void shutdown() {
        this.logger.info("Shutting down replica sockets");
        this.doWork = false;
        int[] activeServers = this.controller.getCurrentViewAcceptors();
        for (int i = 0; i < activeServers.length; ++i) {
            if (this.me == activeServers[i]) continue;
            this.getConnection(activeServers[i]).shutdown();
        }
    }

    public void joinViewReceived() {
        this.waitViewLock.lock();
        for (int i = 0; i < this.pendingConn.size(); ++i) {
            PendingConnection pc = this.pendingConn.get(i);
            try {
                this.establishConnection(pc.s, pc.remoteId);
                continue;
            }
            catch (Exception e) {
                this.logger.error("Failed to estabilish connection to " + pc.remoteId, (Throwable)e);
            }
        }
        this.pendingConn.clear();
        this.waitViewLock.unlock();
    }

    @Override
    public void run() {
        while (this.doWork) {
            try {
                Socket newSocket = this.serverSocket.accept();
                ServersCommunicationLayer.setSocketOptions(newSocket);
                int remoteId = new DataInputStream(newSocket.getInputStream()).readInt();
                if (!this.controller.isInCurrentView() && this.controller.getStaticConf().getTTPId() != remoteId) {
                    this.waitViewLock.lock();
                    this.pendingConn.add(new PendingConnection(newSocket, remoteId));
                    this.waitViewLock.unlock();
                    continue;
                }
                this.establishConnection(newSocket, remoteId);
            }
            catch (SocketTimeoutException ex) {
                this.logger.debug("Server socket timed out, retrying");
            }
            catch (IOException ex) {
                this.logger.error("Problem during thread execution", (Throwable)ex);
            }
        }
        try {
            this.serverSocket.close();
        }
        catch (IOException ex) {
            this.logger.error("Failed to close server socket", (Throwable)ex);
        }
        this.logger.info("ServerCommunicationLayer stopped.");
    }

    private void establishConnection(Socket newSocket, int remoteId) throws IOException {
        if (this.controller.getStaticConf().getTTPId() == remoteId || this.controller.isCurrentViewMember(remoteId)) {
            this.connectionsLock.lock();
            if (this.connections.get(remoteId) == null) {
                this.connections.put(remoteId, new ServerConnection(this.controller, newSocket, remoteId, this.inQueue, this.replica));
            } else {
                this.connections.get(remoteId).reconnect(newSocket);
            }
            this.connectionsLock.unlock();
        } else {
            newSocket.close();
        }
    }

    public static void setSocketOptions(Socket socket) {
        try {
            socket.setTcpNoDelay(true);
        }
        catch (SocketException ex) {
            LoggerFactory.getLogger(ServersCommunicationLayer.class).error("Failed to set TCPNODELAY", (Throwable)ex);
        }
    }

    @Override
    public String toString() {
        String str = "inQueue=" + this.inQueue.toString();
        int[] activeServers = this.controller.getCurrentViewAcceptors();
        for (int i = 0; i < activeServers.length; ++i) {
            if (this.me == activeServers[i]) continue;
            str = str + ", connections[" + activeServers[i] + "]: outQueue=" + this.getConnection((int)activeServers[i]).outQueue;
        }
        return str;
    }

    public class PendingConnection {
        public Socket s;
        public int remoteId;

        public PendingConnection(Socket s, int remoteId) {
            this.s = s;
            this.remoteId = remoteId;
        }
    }
}

