/*
 * Decompiled with CFR 0.152.
 */
package bftsmart.consensus;

import bftsmart.consensus.Epoch;
import bftsmart.tom.core.messages.TOMMessage;
import org.slf4j.LoggerFactory;

public class Decision {
    private final int cid;
    private Epoch decisionEpoch = null;
    private int regency;
    private int leader;
    private byte[] value = null;
    private TOMMessage[] deserializedValue = null;
    public TOMMessage firstMessageProposed = null;
    public int batchSize = 0;

    public Decision(int cid) {
        this.cid = cid;
    }

    public void setRegency(int regency) {
        this.regency = regency;
    }

    public void setLeader(int leader) {
        this.leader = leader;
    }

    public int getRegency() {
        return this.regency;
    }

    public int getLeader() {
        return this.leader;
    }

    public void setDecisionEpoch(Epoch epoch) {
        this.decisionEpoch = epoch;
    }

    public Epoch getDecisionEpoch() {
        return this.decisionEpoch;
    }

    public byte[] getValue() {
        while (this.value == null) {
            this.waitForPropose();
            this.value = this.decisionEpoch.propValue;
        }
        return this.value;
    }

    public TOMMessage[] getDeserializedValue() {
        while (this.deserializedValue == null) {
            this.waitForPropose();
            this.deserializedValue = this.decisionEpoch.deserializedPropValue;
        }
        return this.deserializedValue;
    }

    public int getConsensusId() {
        return this.cid;
    }

    private void waitForPropose() {
        while (this.decisionEpoch == null && this.decisionEpoch.deserializedPropValue == null) {
            try {
                LoggerFactory.getLogger(this.getClass()).info("waiting for propose for consensus " + this.cid);
                Thread.sleep(1L);
            }
            catch (InterruptedException ie) {
                LoggerFactory.getLogger(this.getClass()).error("Interruption during sleep", (Throwable)ie);
            }
        }
    }
}

