/*
 * Decompiled with CFR 0.152.
 */
package bftsmart.consensus;

import bftsmart.consensus.Consensus;
import bftsmart.consensus.messages.ConsensusMessage;
import bftsmart.reconfiguration.ServerViewController;
import bftsmart.reconfiguration.views.View;
import bftsmart.tom.core.messages.TOMMessage;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.codec.binary.Base64;

public class Epoch
implements Serializable {
    private static final long serialVersionUID = -2891450035863688295L;
    private final transient Consensus consensus;
    private final int timestamp;
    private final int me;
    private boolean[] writeSetted;
    private boolean[] acceptSetted;
    private byte[][] write;
    private byte[][] accept;
    private boolean alreadyRemoved = false;
    public byte[] propValue = null;
    public TOMMessage[] deserializedPropValue = null;
    public byte[] propValueHash = null;
    public HashSet<ConsensusMessage> proof;
    private View lastView = null;
    private ServerViewController controller;

    public Epoch(ServerViewController controller, Consensus parent, int timestamp) {
        this.consensus = parent;
        this.timestamp = timestamp;
        this.controller = controller;
        this.proof = new HashSet();
        this.lastView = controller.getCurrentView();
        this.me = controller.getStaticConf().getProcessId();
        int n = controller.getCurrentViewN();
        this.writeSetted = new boolean[n];
        this.acceptSetted = new boolean[n];
        Arrays.fill(this.writeSetted, false);
        Arrays.fill(this.acceptSetted, false);
        if (timestamp == 0) {
            this.write = new byte[n][];
            this.accept = new byte[n][];
            Arrays.fill((Object[])this.write, null);
            Arrays.fill((Object[])this.accept, null);
        } else {
            Epoch previousEpoch = this.consensus.getEpoch(timestamp - 1, controller);
            this.write = previousEpoch.getWrite();
            this.accept = previousEpoch.getAccept();
        }
    }

    private void updateArrays() {
        if (this.lastView.getId() != this.controller.getCurrentViewId()) {
            int n = this.controller.getCurrentViewN();
            byte[][] write = new byte[n][];
            byte[][] accept = new byte[n][];
            boolean[] writeSetted = new boolean[n];
            boolean[] acceptSetted = new boolean[n];
            Arrays.fill(writeSetted, false);
            Arrays.fill(acceptSetted, false);
            for (int pid : this.lastView.getProcesses()) {
                if (!this.controller.isCurrentViewMember(pid)) continue;
                int currentPos = this.controller.getCurrentViewPos(pid);
                int lastPos = this.lastView.getPos(pid);
                write[currentPos] = this.write[lastPos];
                accept[currentPos] = this.accept[lastPos];
                writeSetted[currentPos] = this.writeSetted[lastPos];
                acceptSetted[currentPos] = this.acceptSetted[lastPos];
            }
            this.write = write;
            this.accept = accept;
            this.writeSetted = writeSetted;
            this.acceptSetted = acceptSetted;
            this.lastView = this.controller.getCurrentView();
        }
    }

    public void setRemoved() {
        this.alreadyRemoved = true;
    }

    public boolean isRemoved() {
        return this.alreadyRemoved;
    }

    public void addToProof(ConsensusMessage pm) {
        this.proof.add(pm);
    }

    public Set<ConsensusMessage> getProof() {
        return this.proof;
    }

    public int getTimestamp() {
        return this.timestamp;
    }

    public Consensus getConsensus() {
        return this.consensus;
    }

    public boolean isWriteSetted(int acceptor) {
        this.updateArrays();
        int p = this.controller.getCurrentViewPos(acceptor);
        if (p >= 0) {
            return this.write[p] != null;
        }
        return false;
    }

    public boolean isAcceptSetted(int acceptor) {
        this.updateArrays();
        int p = this.controller.getCurrentViewPos(acceptor);
        if (p >= 0) {
            return this.accept[p] != null;
        }
        return false;
    }

    public byte[] getWrite(int acceptor) {
        this.updateArrays();
        int p = this.controller.getCurrentViewPos(acceptor);
        if (p >= 0) {
            return this.write[p];
        }
        return null;
    }

    public byte[][] getWrite() {
        return this.write;
    }

    public void setWrite(int acceptor, byte[] value) {
        this.updateArrays();
        int p = this.controller.getCurrentViewPos(acceptor);
        if (p >= 0) {
            this.write[p] = value;
            this.writeSetted[p] = true;
        }
    }

    public byte[] getAccept(int acceptor) {
        this.updateArrays();
        int p = this.controller.getCurrentViewPos(acceptor);
        if (p >= 0) {
            return this.accept[p];
        }
        return null;
    }

    public byte[][] getAccept() {
        return this.accept;
    }

    public void setAccept(int acceptor, byte[] value) {
        this.updateArrays();
        int p = this.controller.getCurrentViewPos(acceptor);
        if (p >= 0) {
            this.accept[p] = value;
            this.acceptSetted[p] = true;
        }
    }

    public int countWrite(byte[] value) {
        return this.count(this.writeSetted, this.write, value);
    }

    public int countAccept(byte[] value) {
        return this.count(this.acceptSetted, this.accept, value);
    }

    private int count(boolean[] arraySetted, byte[][] array, byte[] value) {
        if (value != null) {
            int counter = 0;
            for (int i = 0; i < array.length; ++i) {
                if (arraySetted == null || !arraySetted[i] || !Arrays.equals(value, array[i])) continue;
                ++counter;
            }
            return counter;
        }
        return 0;
    }

    public String toString() {
        StringBuffer buffWrite = new StringBuffer(1024);
        StringBuffer buffAccept = new StringBuffer(1024);
        buffWrite.append("\n\t\tWrites=(");
        buffAccept.append("\n\t\tAccepts=(");
        for (int i = 0; i < this.write.length - 1; ++i) {
            buffWrite.append("[" + this.str(this.write[i]) + "], ");
            buffAccept.append("[" + this.str(this.accept[i]) + "], ");
        }
        buffWrite.append("[" + this.str(this.write[this.write.length - 1]) + "])");
        buffAccept.append("[" + this.str(this.accept[this.accept.length - 1]) + "])");
        return "\n\t\tCID=" + this.consensus.getId() + " \n\t\tTS=" + this.getTimestamp() + " \n\t\tPropose=[" + (this.propValueHash != null ? this.str(this.propValueHash) : null) + "] " + buffWrite + " " + buffAccept;
    }

    private String str(byte[] obj) {
        if (obj == null) {
            return "null";
        }
        return Base64.encodeBase64String((byte[])obj);
    }

    public boolean equals(Object o) {
        return this == o;
    }

    public void clear() {
        int n = this.controller.getCurrentViewN();
        this.writeSetted = new boolean[n];
        this.acceptSetted = new boolean[n];
        Arrays.fill(this.writeSetted, false);
        Arrays.fill(this.acceptSetted, false);
        this.write = new byte[n][];
        this.accept = new byte[n][];
        Arrays.fill((Object[])this.write, null);
        Arrays.fill((Object[])this.accept, null);
        this.proof = new HashSet();
    }
}

