/*
 * Decompiled with CFR 0.152.
 */
package bftsmart.consensus.messages;

import bftsmart.communication.SystemMessage;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class ConsensusMessage
extends SystemMessage {
    private int number;
    private int epoch;
    private int paxosType;
    private byte[] value = null;
    private Object proof;

    public ConsensusMessage() {
    }

    public ConsensusMessage(int paxosType, int id, int epoch, int from, byte[] value) {
        super(from);
        this.paxosType = paxosType;
        this.number = id;
        this.epoch = epoch;
        this.value = value;
    }

    public ConsensusMessage(int type, int id, int epoch, int from) {
        this(type, id, epoch, from, null);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeInt(this.number);
        out.writeInt(this.epoch);
        out.writeInt(this.paxosType);
        if (this.value == null) {
            out.writeInt(-1);
        } else {
            out.writeInt(this.value.length);
            out.write(this.value);
        }
        if (this.proof != null) {
            out.writeBoolean(true);
            out.writeObject(this.proof);
        } else {
            out.writeBoolean(false);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        boolean asProof;
        super.readExternal(in);
        this.number = in.readInt();
        this.epoch = in.readInt();
        this.paxosType = in.readInt();
        int toRead = in.readInt();
        if (toRead != -1) {
            this.value = new byte[toRead];
            while ((toRead -= in.read(this.value, this.value.length - toRead, toRead)) > 0) {
            }
        }
        if (asProof = in.readBoolean()) {
            this.proof = in.readObject();
        }
    }

    public int getEpoch() {
        return this.epoch;
    }

    public byte[] getValue() {
        return this.value;
    }

    public void setProof(Object proof) {
        this.proof = proof;
    }

    public Object getProof() {
        return this.proof;
    }

    public int getNumber() {
        return this.number;
    }

    public int getType() {
        return this.paxosType;
    }

    public String getPaxosVerboseType() {
        if (this.paxosType == 44781) {
            return "PROPOSE";
        }
        if (this.paxosType == 44783) {
            return "ACCEPT";
        }
        if (this.paxosType == 44782) {
            return "WRITE";
        }
        return "";
    }

    public String toString() {
        return "type=" + this.getPaxosVerboseType() + ", number=" + this.getNumber() + ", epoch=" + this.getEpoch() + ", from=" + this.getSender();
    }
}

