/*
 * Decompiled with CFR 0.152.
 */
package bftsmart.demo.counter;

import bftsmart.tom.ServiceProxy;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class CounterClient {
    public static void main(String[] args) throws IOException {
        if (args.length < 2) {
            System.out.println("Usage: java ... CounterClient <process id> <increment> [<number of operations>]");
            System.out.println("       if <increment> equals 0 the request will be read-only");
            System.out.println("       default <number of operations> equals 1000");
            System.exit(-1);
        }
        ServiceProxy counterProxy = new ServiceProxy(Integer.parseInt(args[0]));
        try {
            int inc = Integer.parseInt(args[1]);
            int numberOfOps = args.length > 2 ? Integer.parseInt(args[2]) : 1000;
            for (int i = 0; i < numberOfOps; ++i) {
                byte[] reply;
                ByteArrayOutputStream out = new ByteArrayOutputStream(4);
                new DataOutputStream(out).writeInt(inc);
                System.out.print("Invocation " + i);
                byte[] byArray = reply = inc == 0 ? counterProxy.invokeUnordered(out.toByteArray()) : counterProxy.invokeOrdered(out.toByteArray());
                if (reply == null) {
                    System.out.println(", ERROR! Exiting.");
                    break;
                }
                int newValue = new DataInputStream(new ByteArrayInputStream(reply)).readInt();
                System.out.println(", returned value: " + newValue);
            }
        }
        catch (IOException | NumberFormatException e) {
            counterProxy.close();
        }
    }
}

