/*
 * Decompiled with CFR 0.152.
 */
package bftsmart.demo.counter;

import bftsmart.tom.MessageContext;
import bftsmart.tom.ServiceReplica;
import bftsmart.tom.server.defaultservices.DefaultSingleRecoverable;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public final class CounterServer
extends DefaultSingleRecoverable {
    private int counter = 0;
    private int iterations = 0;

    public CounterServer(int id) {
        new ServiceReplica(id, this, this);
    }

    @Override
    public byte[] appExecuteUnordered(byte[] command, MessageContext msgCtx) {
        ++this.iterations;
        System.out.println("(" + this.iterations + ") Counter current value: " + this.counter);
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream(4);
            new DataOutputStream(out).writeInt(this.counter);
            return out.toByteArray();
        }
        catch (IOException ex) {
            System.err.println("Invalid request received!");
            return new byte[0];
        }
    }

    @Override
    public byte[] appExecuteOrdered(byte[] command, MessageContext msgCtx) {
        ++this.iterations;
        try {
            int increment = new DataInputStream(new ByteArrayInputStream(command)).readInt();
            this.counter += increment;
            System.out.println("(" + this.iterations + ") Counter was incremented. Current value = " + this.counter);
            ByteArrayOutputStream out = new ByteArrayOutputStream(4);
            new DataOutputStream(out).writeInt(this.counter);
            return out.toByteArray();
        }
        catch (IOException ex) {
            System.err.println("Invalid request received!");
            return new byte[0];
        }
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            System.out.println("Use: java CounterServer <processId>");
            System.exit(-1);
        }
        new CounterServer(Integer.parseInt(args[0]));
    }

    @Override
    public void installSnapshot(byte[] state) {
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(state);
            ObjectInputStream in = new ObjectInputStream(bis);
            this.counter = in.readInt();
            in.close();
            bis.close();
        }
        catch (IOException e) {
            System.err.println("[ERROR] Error deserializing state: " + e.getMessage());
        }
    }

    @Override
    public byte[] getSnapshot() {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(bos);
            out.writeInt(this.counter);
            out.flush();
            bos.flush();
            out.close();
            bos.close();
            return bos.toByteArray();
        }
        catch (IOException ioe) {
            System.err.println("[ERROR] Error serializing state: " + ioe.getMessage());
            return "ERROR".getBytes();
        }
    }
}

