/*
 * Decompiled with CFR 0.152.
 */
package bftsmart.demo.microbenchmarks;

import bftsmart.tom.MessageContext;
import bftsmart.tom.ServiceReplica;
import bftsmart.tom.server.defaultservices.DefaultRecoverable;
import bftsmart.tom.util.Storage;

public class LatencyServer
extends DefaultRecoverable {
    private int interval;
    private int replySize;
    private int iterations = 0;
    private Storage totalLatency = null;
    private Storage consensusLatency = null;
    private Storage preConsLatency = null;
    private Storage posConsLatency = null;
    private Storage proposeLatency = null;
    private Storage writeLatency = null;
    private Storage acceptLatency = null;
    private ServiceReplica replica;

    public LatencyServer(int id, int interval, int replySize) {
        this.interval = interval;
        this.replySize = replySize;
        this.totalLatency = new Storage(interval);
        this.consensusLatency = new Storage(interval);
        this.preConsLatency = new Storage(interval);
        this.posConsLatency = new Storage(interval);
        this.proposeLatency = new Storage(interval);
        this.writeLatency = new Storage(interval);
        this.acceptLatency = new Storage(interval);
        this.replica = new ServiceReplica(id, this, this);
    }

    @Override
    public byte[] appExecuteUnordered(byte[] command, MessageContext msgCtx) {
        return this.execute(command, msgCtx);
    }

    @Override
    public byte[][] appExecuteBatch(byte[][] commands, MessageContext[] msgCtxs, boolean fromConsensus) {
        byte[][] replies = new byte[commands.length][];
        for (int i = 0; i < commands.length; ++i) {
            replies[i] = this.execute(commands[i], msgCtxs[i]);
        }
        return replies;
    }

    public byte[] execute(byte[] command, MessageContext msgCtx) {
        boolean readOnly = false;
        ++this.iterations;
        if (msgCtx != null && msgCtx.getFirstInBatch() != null) {
            readOnly = msgCtx.readOnly;
            msgCtx.getFirstInBatch().executedTime = System.nanoTime();
            this.totalLatency.store(msgCtx.getFirstInBatch().executedTime - msgCtx.getFirstInBatch().receptionTime);
            if (!readOnly) {
                this.consensusLatency.store(msgCtx.getFirstInBatch().decisionTime - msgCtx.getFirstInBatch().consensusStartTime);
                long temp = msgCtx.getFirstInBatch().consensusStartTime - msgCtx.getFirstInBatch().receptionTime;
                this.preConsLatency.store(temp > 0L ? temp : 0L);
                this.posConsLatency.store(msgCtx.getFirstInBatch().executedTime - msgCtx.getFirstInBatch().decisionTime);
                this.proposeLatency.store(msgCtx.getFirstInBatch().writeSentTime - msgCtx.getFirstInBatch().consensusStartTime);
                this.writeLatency.store(msgCtx.getFirstInBatch().acceptSentTime - msgCtx.getFirstInBatch().writeSentTime);
                this.acceptLatency.store(msgCtx.getFirstInBatch().decisionTime - msgCtx.getFirstInBatch().acceptSentTime);
            } else {
                this.consensusLatency.store(0L);
                this.preConsLatency.store(0L);
                this.posConsLatency.store(0L);
                this.proposeLatency.store(0L);
                this.writeLatency.store(0L);
                this.acceptLatency.store(0L);
            }
        } else {
            this.consensusLatency.store(0L);
            this.preConsLatency.store(0L);
            this.posConsLatency.store(0L);
            this.proposeLatency.store(0L);
            this.writeLatency.store(0L);
            this.acceptLatency.store(0L);
        }
        if (this.iterations % this.interval == 0) {
            System.out.println("--- Measurements after " + this.iterations + " ops (" + this.interval + " samples) ---");
            System.out.println("Total latency = " + this.totalLatency.getAverage(false) / 1000.0 + " (+/- " + (long)this.totalLatency.getDP(false) / 1000L + ") us ");
            this.totalLatency.reset();
            System.out.println("Consensus latency = " + this.consensusLatency.getAverage(false) / 1000.0 + " (+/- " + (long)this.consensusLatency.getDP(false) / 1000L + ") us ");
            this.consensusLatency.reset();
            System.out.println("Pre-consensus latency = " + this.preConsLatency.getAverage(false) / 1000.0 + " (+/- " + (long)this.preConsLatency.getDP(false) / 1000L + ") us ");
            this.preConsLatency.reset();
            System.out.println("Pos-consensus latency = " + this.posConsLatency.getAverage(false) / 1000.0 + " (+/- " + (long)this.posConsLatency.getDP(false) / 1000L + ") us ");
            this.posConsLatency.reset();
            System.out.println("Propose latency = " + this.proposeLatency.getAverage(false) / 1000.0 + " (+/- " + (long)this.proposeLatency.getDP(false) / 1000L + ") us ");
            this.proposeLatency.reset();
            System.out.println("Write latency = " + this.writeLatency.getAverage(false) / 1000.0 + " (+/- " + (long)this.writeLatency.getDP(false) / 1000L + ") us ");
            this.writeLatency.reset();
            System.out.println("Accept latency = " + this.acceptLatency.getAverage(false) / 1000.0 + " (+/- " + (long)this.acceptLatency.getDP(false) / 1000L + ") us ");
            this.acceptLatency.reset();
        }
        return new byte[this.replySize];
    }

    public static void main(String[] args) {
        if (args.length < 3) {
            System.out.println("Use: java ...LatencyServer <processId> <measurement interval> <reply size>");
            System.exit(-1);
        }
        int processId = Integer.parseInt(args[0]);
        int interval = Integer.parseInt(args[1]);
        int replySize = Integer.parseInt(args[2]);
        new LatencyServer(processId, interval, replySize);
    }

    @Override
    public void installSnapshot(byte[] state) {
    }

    @Override
    public byte[] getSnapshot() {
        return new byte[0];
    }
}

