/*
 * Decompiled with CFR 0.152.
 */
package bftsmart.demo.microbenchmarks;

import bftsmart.tom.MessageContext;
import bftsmart.tom.ServiceReplica;
import bftsmart.tom.server.defaultservices.DefaultRecoverable;
import bftsmart.tom.util.Storage;

public final class ThroughputLatencyServer
extends DefaultRecoverable {
    private int interval;
    private int replySize;
    private float maxTp = -1.0f;
    private boolean context;
    private byte[] state;
    private int iterations = 0;
    private long throughputMeasurementStartTime = System.currentTimeMillis();
    private Storage totalLatency = null;
    private Storage consensusLatency = null;
    private Storage preConsLatency = null;
    private Storage posConsLatency = null;
    private Storage proposeLatency = null;
    private Storage writeLatency = null;
    private Storage acceptLatency = null;
    private ServiceReplica replica;

    public ThroughputLatencyServer(int id, int interval, int replySize, int stateSize, boolean context) {
        this.interval = interval;
        this.replySize = replySize;
        this.context = context;
        this.state = new byte[stateSize];
        for (int i = 0; i < stateSize; ++i) {
            this.state[i] = (byte)i;
        }
        this.totalLatency = new Storage(interval);
        this.consensusLatency = new Storage(interval);
        this.preConsLatency = new Storage(interval);
        this.posConsLatency = new Storage(interval);
        this.proposeLatency = new Storage(interval);
        this.writeLatency = new Storage(interval);
        this.acceptLatency = new Storage(interval);
        this.replica = new ServiceReplica(id, this, this);
    }

    @Override
    public byte[][] appExecuteBatch(byte[][] commands, MessageContext[] msgCtxs, boolean fromConsensus) {
        byte[][] replies = new byte[commands.length][];
        for (int i = 0; i < commands.length; ++i) {
            replies[i] = this.execute(commands[i], msgCtxs[i]);
        }
        return replies;
    }

    @Override
    public byte[] appExecuteUnordered(byte[] command, MessageContext msgCtx) {
        return this.execute(command, msgCtx);
    }

    public byte[] execute(byte[] command, MessageContext msgCtx) {
        boolean readOnly = false;
        ++this.iterations;
        if (msgCtx != null && msgCtx.getFirstInBatch() != null) {
            readOnly = msgCtx.readOnly;
            msgCtx.getFirstInBatch().executedTime = System.nanoTime();
            this.totalLatency.store(msgCtx.getFirstInBatch().executedTime - msgCtx.getFirstInBatch().receptionTime);
            if (!readOnly) {
                this.consensusLatency.store(msgCtx.getFirstInBatch().decisionTime - msgCtx.getFirstInBatch().consensusStartTime);
                long temp = msgCtx.getFirstInBatch().consensusStartTime - msgCtx.getFirstInBatch().receptionTime;
                this.preConsLatency.store(temp > 0L ? temp : 0L);
                this.posConsLatency.store(msgCtx.getFirstInBatch().executedTime - msgCtx.getFirstInBatch().decisionTime);
                this.proposeLatency.store(msgCtx.getFirstInBatch().writeSentTime - msgCtx.getFirstInBatch().consensusStartTime);
                this.writeLatency.store(msgCtx.getFirstInBatch().acceptSentTime - msgCtx.getFirstInBatch().writeSentTime);
                this.acceptLatency.store(msgCtx.getFirstInBatch().decisionTime - msgCtx.getFirstInBatch().acceptSentTime);
            } else {
                this.consensusLatency.store(0L);
                this.preConsLatency.store(0L);
                this.posConsLatency.store(0L);
                this.proposeLatency.store(0L);
                this.writeLatency.store(0L);
                this.acceptLatency.store(0L);
            }
        } else {
            this.consensusLatency.store(0L);
            this.preConsLatency.store(0L);
            this.posConsLatency.store(0L);
            this.proposeLatency.store(0L);
            this.writeLatency.store(0L);
            this.acceptLatency.store(0L);
        }
        float tp = -1.0f;
        if (this.iterations % this.interval == 0) {
            if (this.context) {
                System.out.println("--- (Context)  iterations: " + this.iterations + " // regency: " + msgCtx.getRegency() + " // consensus: " + msgCtx.getConsensusId() + " ---");
            }
            System.out.println("--- Measurements after " + this.iterations + " ops (" + this.interval + " samples) ---");
            tp = (float)(this.interval * 1000) / (float)(System.currentTimeMillis() - this.throughputMeasurementStartTime);
            if (tp > this.maxTp) {
                this.maxTp = tp;
            }
            System.out.println("Throughput = " + tp + " operations/sec (Maximum observed: " + this.maxTp + " ops/sec)");
            System.out.println("Total latency = " + this.totalLatency.getAverage(false) / 1000.0 + " (+/- " + (long)this.totalLatency.getDP(false) / 1000L + ") us ");
            this.totalLatency.reset();
            System.out.println("Consensus latency = " + this.consensusLatency.getAverage(false) / 1000.0 + " (+/- " + (long)this.consensusLatency.getDP(false) / 1000L + ") us ");
            this.consensusLatency.reset();
            System.out.println("Pre-consensus latency = " + this.preConsLatency.getAverage(false) / 1000.0 + " (+/- " + (long)this.preConsLatency.getDP(false) / 1000L + ") us ");
            this.preConsLatency.reset();
            System.out.println("Pos-consensus latency = " + this.posConsLatency.getAverage(false) / 1000.0 + " (+/- " + (long)this.posConsLatency.getDP(false) / 1000L + ") us ");
            this.posConsLatency.reset();
            System.out.println("Propose latency = " + this.proposeLatency.getAverage(false) / 1000.0 + " (+/- " + (long)this.proposeLatency.getDP(false) / 1000L + ") us ");
            this.proposeLatency.reset();
            System.out.println("Write latency = " + this.writeLatency.getAverage(false) / 1000.0 + " (+/- " + (long)this.writeLatency.getDP(false) / 1000L + ") us ");
            this.writeLatency.reset();
            System.out.println("Accept latency = " + this.acceptLatency.getAverage(false) / 1000.0 + " (+/- " + (long)this.acceptLatency.getDP(false) / 1000L + ") us ");
            this.acceptLatency.reset();
            this.throughputMeasurementStartTime = System.currentTimeMillis();
        }
        return new byte[this.replySize];
    }

    public static void main(String[] args) {
        if (args.length < 5) {
            System.out.println("Usage: ... ThroughputLatencyServer <processId> <measurement interval> <reply size> <state size> <context?>");
            System.exit(-1);
        }
        int processId = Integer.parseInt(args[0]);
        int interval = Integer.parseInt(args[1]);
        int replySize = Integer.parseInt(args[2]);
        int stateSize = Integer.parseInt(args[3]);
        boolean context = Boolean.parseBoolean(args[4]);
        new ThroughputLatencyServer(processId, interval, replySize, stateSize, context);
    }

    @Override
    public void installSnapshot(byte[] state) {
    }

    @Override
    public byte[] getSnapshot() {
        return this.state;
    }
}

