/*
 * Decompiled with CFR 0.152.
 */
package bftsmart.demo.ycsb;

import bftsmart.demo.ycsb.YCSBMessage;
import bftsmart.demo.ycsb.YCSBTable;
import bftsmart.tom.MessageContext;
import bftsmart.tom.ServiceReplica;
import bftsmart.tom.server.defaultservices.DefaultRecoverable;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.TreeMap;

public class YCSBServer
extends DefaultRecoverable {
    private static final boolean _debug = false;
    private TreeMap<String, YCSBTable> mTables = new TreeMap();
    private boolean logPrinted = false;

    public static void main(String[] args) throws Exception {
        if (args.length == 1) {
            new YCSBServer(new Integer(args[0]));
        } else {
            System.out.println("Usage: java ... YCSBServer <replica_id>");
        }
    }

    private YCSBServer(int id) {
        new ServiceReplica(id, this, this);
    }

    @Override
    public byte[][] appExecuteBatch(byte[][] commands, MessageContext[] msgCtx, boolean fromConsensus) {
        byte[][] replies = new byte[commands.length][];
        int index = 0;
        for (byte[] command : commands) {
            if (msgCtx != null && msgCtx[index] != null && msgCtx[index].getConsensusId() % 1000 == 0 && !this.logPrinted) {
                System.out.println("YCSBServer executing CID: " + msgCtx[index].getConsensusId());
                this.logPrinted = true;
            } else {
                this.logPrinted = false;
            }
            YCSBMessage aRequest = YCSBMessage.getObject(command);
            YCSBMessage reply = YCSBMessage.newErrorMessage("");
            if (aRequest == null) {
                replies[index] = reply.getBytes();
                continue;
            }
            block0 : switch (aRequest.getType()) {
                case CREATE: {
                    switch (aRequest.getEntity()) {
                        case RECORD: {
                            if (!this.mTables.containsKey(aRequest.getTable())) {
                                this.mTables.put(aRequest.getTable(), new YCSBTable());
                            }
                            if (this.mTables.get(aRequest.getTable()).containsKey(aRequest.getKey())) break block0;
                            this.mTables.get(aRequest.getTable()).put(aRequest.getKey(), aRequest.getValues());
                            reply = YCSBMessage.newInsertResponse(0);
                            break block0;
                        }
                    }
                    break;
                }
                case UPDATE: {
                    switch (aRequest.getEntity()) {
                        case RECORD: {
                            if (!this.mTables.containsKey(aRequest.getTable())) {
                                this.mTables.put(aRequest.getTable(), new YCSBTable());
                            }
                            this.mTables.get(aRequest.getTable()).put(aRequest.getKey(), aRequest.getValues());
                            reply = YCSBMessage.newUpdateResponse(1);
                            break block0;
                        }
                    }
                }
            }
            replies[index++] = reply.getBytes();
        }
        return replies;
    }

    @Override
    public byte[] appExecuteUnordered(byte[] theCommand, MessageContext theContext) {
        YCSBMessage aRequest = YCSBMessage.getObject(theCommand);
        YCSBMessage reply = YCSBMessage.newErrorMessage("");
        if (aRequest == null) {
            return reply.getBytes();
        }
        switch (aRequest.getType()) {
            case READ: {
                switch (aRequest.getEntity()) {
                    case RECORD: {
                        reply = !this.mTables.containsKey(aRequest.getTable()) ? YCSBMessage.newErrorMessage("Table not found") : (!this.mTables.get(aRequest.getTable()).containsKey(aRequest.getKey()) ? YCSBMessage.newErrorMessage("Record not found") : YCSBMessage.newReadResponse((HashMap)this.mTables.get(aRequest.getTable()).get(aRequest.getKey()), 0));
                    }
                }
            }
        }
        return reply.getBytes();
    }

    @Override
    public void installSnapshot(byte[] state) {
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(state);
            ObjectInputStream in = new ObjectInputStream(bis);
            this.mTables = (TreeMap)in.readObject();
            in.close();
            bis.close();
        }
        catch (IOException | ClassNotFoundException e) {
            System.err.println("[ERROR] Error deserializing state: " + e.getMessage());
        }
    }

    @Override
    public byte[] getSnapshot() {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(bos);
            out.writeObject(this.mTables);
            out.flush();
            bos.flush();
            out.close();
            bos.close();
            return bos.toByteArray();
        }
        catch (IOException ioe) {
            System.err.println("[ERROR] Error serializing state: " + ioe.getMessage());
            return "ERROR".getBytes();
        }
    }
}

