/*
 * Decompiled with CFR 0.152.
 */
package bftsmart.reconfiguration;

import bftsmart.communication.server.ServerConnection;
import bftsmart.reconfiguration.Reconfiguration;
import bftsmart.reconfiguration.ReconfigureReply;
import bftsmart.reconfiguration.ServerViewController;
import bftsmart.reconfiguration.VMMessage;
import bftsmart.reconfiguration.views.View;
import bftsmart.tom.util.KeyLoader;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ViewManager {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private int id;
    private Reconfiguration rec = null;
    private ServerViewController controller;
    private List<Integer> addIds = new LinkedList<Integer>();

    public ViewManager(KeyLoader loader) {
        this("", loader);
    }

    public ViewManager(String configHome, KeyLoader loader) {
        this.id = this.loadID(configHome);
        this.controller = new ServerViewController(this.id, configHome, loader);
        this.rec = new Reconfiguration(this.id, configHome, loader);
    }

    public void connect() {
        this.rec.connect();
    }

    private int loadID(String configHome) {
        try {
            String path = "";
            String sep = System.getProperty("file.separator");
            path = configHome == null || configHome.equals("") ? "config" + sep + "system.config" : configHome + sep + "system.config";
            FileReader fr = new FileReader(path);
            BufferedReader rd = new BufferedReader(fr);
            String line = null;
            while ((line = rd.readLine()) != null) {
                StringTokenizer str;
                if (line.startsWith("#") || (str = new StringTokenizer(line, "=")).countTokens() <= 1 || !str.nextToken().trim().equals("system.ttp.id")) continue;
                fr.close();
                rd.close();
                return Integer.parseInt(str.nextToken().trim());
            }
            fr.close();
            rd.close();
            return -1;
        }
        catch (Exception e) {
            this.logger.error("Could not load ID", (Throwable)e);
            return -1;
        }
    }

    public void addServer(int id, String ip, int port) {
        this.controller.getStaticConf().addHostInfo(id, ip, port);
        this.rec.addServer(id, ip, port);
        this.addIds.add(id);
    }

    public void removeServer(int id) {
        this.rec.removeServer(id);
    }

    public void setF(int f) {
        this.rec.setF(f);
    }

    public void executeUpdates() {
        this.connect();
        ReconfigureReply r = this.rec.execute();
        View v = r.getView();
        this.logger.info("New view f: " + v.getF());
        VMMessage msg = new VMMessage(this.id, r);
        if (this.addIds.size() > 0) {
            this.sendResponse(this.addIds.toArray(new Integer[1]), msg);
            this.addIds.clear();
        }
    }

    private ServerConnection getConnection(int remoteId) {
        return new ServerConnection(this.controller, null, remoteId, null, null);
    }

    public void sendResponse(Integer[] targets, VMMessage sm) {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        try {
            new ObjectOutputStream(bOut).writeObject(sm);
        }
        catch (IOException ex) {
            this.logger.error("Could not serialize message", (Throwable)ex);
        }
        byte[] data = bOut.toByteArray();
        for (Integer i : targets) {
            try {
                if (i == this.id) continue;
                this.getConnection(i).send(data, true);
            }
            catch (InterruptedException ex) {
                this.logger.error("Failed to send data to target", (Throwable)ex);
            }
        }
    }

    public void close() {
        this.rec.close();
    }
}

