/*
 * Decompiled with CFR 0.152.
 */
package bftsmart.reconfiguration.util;

import bftsmart.reconfiguration.util.HostsConfig;
import bftsmart.reconfiguration.util.RSAKeyLoader;
import bftsmart.tom.util.KeyLoader;
import bftsmart.tom.util.TOMUtil;
import java.io.BufferedReader;
import java.io.FileReader;
import java.math.BigInteger;
import java.net.InetSocketAddress;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Configuration {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    protected int processId;
    protected boolean channelsBlocking;
    protected BigInteger DH_P;
    protected BigInteger DH_G;
    protected int autoConnectLimit;
    protected Map<String, String> configs;
    protected HostsConfig hosts;
    protected KeyLoader keyLoader;
    public static final String DEFAULT_HMAC = "HmacSHA512";
    public static final String DEFAULT_SECRETKEY = "PBKDF2WithHmacSHA1";
    public static final String DEFAULT_SIGNATURE = "SHA512withRSA";
    public static final String DEFAULT_HASH = "SHA-512";
    public static final String DEFAULT_HMAC_PROVIDER = "SunJCE";
    public static final String DEFAULT_SECRETKEY_PROVIDER = "SunJCE";
    public static final String DEFAULT_SIGNATURE_PROVIDER = "SunRsaSign";
    public static final String DEFAULT_HASH_PROVIDER = "SUN";
    private String hmacAlgorithm;
    private String secretKeyAlgorithm;
    private String signatureAlgorithm;
    private String hashAlgorithm;
    private String hmacAlgorithmProvider;
    private String secretKeyAlgorithmProvider;
    private String signatureAlgorithmProvider;
    private String hashAlgorithmProvider;
    protected String configHome = "";
    protected static String hostsFileName = "";
    protected boolean defaultKeys = false;

    public Configuration(int procId, KeyLoader loader) {
        this.processId = procId;
        this.keyLoader = loader;
        this.init();
    }

    public Configuration(int procId, String configHomeParam, KeyLoader loader) {
        this.processId = procId;
        this.configHome = configHomeParam;
        this.keyLoader = loader;
        this.init();
    }

    protected void init() {
        try {
            this.hosts = new HostsConfig(this.configHome, hostsFileName);
            this.loadConfig();
            String s = this.configs.remove("system.autoconnect");
            this.autoConnectLimit = s == null ? -1 : Integer.parseInt(s);
            s = this.configs.remove("system.channels.blocking");
            this.channelsBlocking = s == null ? false : s.equalsIgnoreCase("true");
            s = this.configs.remove("system.communication.hmacAlgorithm");
            this.hmacAlgorithm = s == null ? DEFAULT_HMAC : s;
            s = this.configs.remove("system.communication.secretKeyAlgorithm");
            this.secretKeyAlgorithm = s == null ? DEFAULT_SECRETKEY : s;
            s = this.configs.remove("system.communication.signatureAlgorithm");
            this.signatureAlgorithm = s == null ? DEFAULT_SIGNATURE : s;
            s = this.configs.remove("system.communication.hashAlgorithm");
            this.hashAlgorithm = s == null ? DEFAULT_HASH : s;
            s = this.configs.remove("system.communication.hmacAlgorithmProvider");
            this.hmacAlgorithmProvider = s == null ? "SunJCE" : s;
            s = this.configs.remove("system.communication.secretKeyAlgorithmProvider");
            this.secretKeyAlgorithmProvider = s == null ? "SunJCE" : s;
            s = this.configs.remove("system.communication.signatureAlgorithmProvider");
            this.signatureAlgorithmProvider = s == null ? DEFAULT_SIGNATURE_PROVIDER : s;
            s = this.configs.remove("system.communication.hashAlgorithmProvider");
            this.hashAlgorithmProvider = s == null ? DEFAULT_HASH_PROVIDER : s;
            s = this.configs.remove("system.communication.defaultkeys");
            this.defaultKeys = s == null ? false : s.equalsIgnoreCase("true");
            s = this.configs.remove("system.diffie-hellman.p");
            if (s == null) {
                String pHexString = "FFFFFFFF FFFFFFFF C90FDAA2 2168C234 C4C6628B 80DC1CD129024E08 8A67CC74 020BBEA6 3B139B22 514A0879 8E3404DDEF9519B3 CD3A431B 302B0A6D F25F1437 4FE1356D 6D51C245E485B576 625E7EC6 F44C42E9 A637ED6B 0BFF5CB6 F406B7EDEE386BFB 5A899FA5 AE9F2411 7C4B1FE6 49286651 ECE65381FFFFFFFF FFFFFFFF";
                this.DH_P = new BigInteger(pHexString.replaceAll(" ", ""), 16);
            } else {
                this.DH_P = new BigInteger(s, 16);
            }
            s = this.configs.remove("system.diffie-hellman.g");
            this.DH_G = s == null ? new BigInteger("2") : new BigInteger(s);
            if (this.keyLoader == null) {
                this.keyLoader = new RSAKeyLoader(this.processId, this.configHome, this.defaultKeys, this.signatureAlgorithm);
            }
            TOMUtil.init(this.hmacAlgorithm, this.secretKeyAlgorithm, this.keyLoader.getSignatureAlgorithm(), this.hashAlgorithm, this.hmacAlgorithmProvider, this.secretKeyAlgorithmProvider, this.signatureAlgorithmProvider, this.hashAlgorithmProvider);
        }
        catch (Exception e) {
            LoggerFactory.getLogger(this.getClass()).error("Wrong system.config file format.");
        }
    }

    public String getConfigHome() {
        return this.configHome;
    }

    public boolean useDefaultKeys() {
        return this.defaultKeys;
    }

    public final boolean isHostSetted(int id) {
        return this.hosts.getHost(id) != null;
    }

    public final boolean useBlockingChannels() {
        return this.channelsBlocking;
    }

    public final int getAutoConnectLimit() {
        return this.autoConnectLimit;
    }

    public final BigInteger getDHP() {
        return this.DH_P;
    }

    public final BigInteger getDHG() {
        return this.DH_G;
    }

    public final String getHmacAlgorithm() {
        return this.hmacAlgorithm;
    }

    public final String getSecretKeyAlgorithm() {
        return this.secretKeyAlgorithm;
    }

    public final String getSignatureAlgorithm() {
        return this.signatureAlgorithm;
    }

    public final String getHashAlgorithm() {
        return this.hashAlgorithm;
    }

    public final String getHmacAlgorithmProvider() {
        return this.hmacAlgorithmProvider;
    }

    public final String getSecretKeyAlgorithmProvider() {
        return this.secretKeyAlgorithmProvider;
    }

    public final String getSignatureAlgorithmProvider() {
        return this.signatureAlgorithmProvider;
    }

    public final String getHashAlgorithmProvider() {
        return this.hashAlgorithmProvider;
    }

    public final String getProperty(String key) {
        String o = this.configs.get(key);
        if (o != null) {
            return o.toString();
        }
        return null;
    }

    public final Map<String, String> getProperties() {
        return this.configs;
    }

    public final InetSocketAddress getRemoteAddress(int id) {
        return this.hosts.getRemoteAddress(id);
    }

    public final InetSocketAddress getServerToServerRemoteAddress(int id) {
        return this.hosts.getServerToServerRemoteAddress(id);
    }

    public final InetSocketAddress getLocalAddress(int id) {
        return this.hosts.getLocalAddress(id);
    }

    public final String getHost(int id) {
        return this.hosts.getHost(id);
    }

    public final int getPort(int id) {
        return this.hosts.getPort(id);
    }

    public final int getServerToServerPort(int id) {
        return this.hosts.getServerToServerPort(id);
    }

    public final int getProcessId() {
        return this.processId;
    }

    public final void setProcessId(int processId) {
        this.processId = processId;
    }

    public final void addHostInfo(int id, String host, int port) {
        this.hosts.add(id, host, port);
    }

    public PublicKey getPublicKey() {
        try {
            return this.keyLoader.loadPublicKey();
        }
        catch (Exception e) {
            this.logger.error("Could not load public key", (Throwable)e);
            return null;
        }
    }

    public PublicKey getPublicKey(int id) {
        try {
            return this.keyLoader.loadPublicKey(id);
        }
        catch (Exception e) {
            this.logger.error("Could not load public key", (Throwable)e);
            return null;
        }
    }

    public PrivateKey getPrivateKey() {
        try {
            return this.keyLoader.loadPrivateKey();
        }
        catch (Exception e) {
            this.logger.error("Could not load private key", (Throwable)e);
            return null;
        }
    }

    private void loadConfig() {
        this.configs = new HashMap<String, String>();
        try {
            if (this.configHome == null || this.configHome.equals("")) {
                this.configHome = "config";
            }
            String sep = System.getProperty("file.separator");
            String path = this.configHome + sep + "system.config";
            FileReader fr = new FileReader(path);
            BufferedReader rd = new BufferedReader(fr);
            String line = null;
            while ((line = rd.readLine()) != null) {
                StringTokenizer str;
                if (line.startsWith("#") || (str = new StringTokenizer(line, "=")).countTokens() <= 1) continue;
                this.configs.put(str.nextToken().trim(), str.nextToken().trim());
            }
            fr.close();
            rd.close();
        }
        catch (Exception e) {
            LoggerFactory.getLogger(this.getClass()).error("Could not load configuration", (Throwable)e);
        }
    }
}

