/*
 * Decompiled with CFR 0.152.
 */
package bftsmart.statemanagement.strategy.durability;

import bftsmart.statemanagement.ApplicationState;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.Socket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StateSender
implements Runnable {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Socket socket;
    private ApplicationState state;

    public StateSender(Socket socket) {
        this.socket = socket;
    }

    public void setState(ApplicationState state) {
        this.state = state;
    }

    @Override
    public void run() {
        try {
            OutputStream os = this.socket.getOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(os);
            this.logger.debug("Sending state in different socket");
            oos.writeObject(this.state);
            this.logger.debug("Sent state in different socket");
            oos.close();
            this.socket.close();
        }
        catch (IOException e) {
            this.logger.error("Could not send state", (Throwable)e);
        }
    }
}

