/*
 * Decompiled with CFR 0.152.
 */
package bftsmart.tom;

import bftsmart.communication.client.ReplyListener;
import bftsmart.reconfiguration.views.View;
import bftsmart.tom.RequestContext;
import bftsmart.tom.ServiceProxy;
import bftsmart.tom.core.messages.TOMMessage;
import bftsmart.tom.core.messages.TOMMessageType;
import bftsmart.tom.util.Extractor;
import bftsmart.tom.util.KeyLoader;
import bftsmart.tom.util.TOMUtil;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsynchServiceProxy
extends ServiceProxy {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private HashMap<Integer, RequestContext> requestsContext;
    private HashMap<Integer, TOMMessage[]> requestsReplies;
    private HashMap<Integer, Integer> requestsAlias;

    public AsynchServiceProxy(int processId) {
        this(processId, null);
        this.init();
    }

    public AsynchServiceProxy(int processId, String configHome) {
        super(processId, configHome);
        this.init();
    }

    public AsynchServiceProxy(int processId, String configHome, KeyLoader loader) {
        super(processId, configHome, loader);
        this.init();
    }

    public AsynchServiceProxy(int processId, String configHome, Comparator<byte[]> replyComparator, Extractor replyExtractor, KeyLoader loader) {
        super(processId, configHome, replyComparator, replyExtractor, loader);
        this.init();
    }

    private void init() {
        this.requestsContext = new HashMap();
        this.requestsReplies = new HashMap();
        this.requestsAlias = new HashMap();
    }

    private View newView(byte[] bytes) {
        Object o = TOMUtil.getObject(bytes);
        return o != null && o instanceof View ? (View)o : null;
    }

    public int invokeAsynchRequest(byte[] request, ReplyListener replyListener, TOMMessageType reqType) {
        return this.invokeAsynchRequest(request, super.getViewManager().getCurrentViewProcesses(), replyListener, reqType);
    }

    public int invokeAsynchRequest(byte[] request, int[] targets, ReplyListener replyListener, TOMMessageType reqType) {
        return this.invokeAsynch(request, targets, replyListener, reqType);
    }

    public void cleanAsynchRequest(int requestId) {
        Integer id = requestId;
        do {
            this.requestsContext.remove(id);
            this.requestsReplies.remove(id);
        } while ((id = this.requestsAlias.remove(id)) != null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replyReceived(final TOMMessage reply) {
        this.logger.debug("Asynchronously received reply from " + reply.getSender() + " with sequence number " + reply.getSequence() + " and operation ID " + reply.getOperationId());
        try {
            this.canReceiveLock.lock();
            final RequestContext requestContext = this.requestsContext.get(reply.getOperationId());
            if (requestContext == null) {
                super.replyReceived(reply);
                return;
            }
            if (this.contains(requestContext.getTargets(), reply.getSender()) && reply.getSequence() == requestContext.getReqId() && reply.getReqType().compareTo(requestContext.getRequestType()) == 0) {
                this.logger.debug("Deliverying message from " + reply.getSender() + " with sequence number " + reply.getSequence() + " and operation ID " + reply.getOperationId() + " to the listener");
                ReplyListener replyListener = requestContext.getReplyListener();
                View v = null;
                if (replyListener != null) {
                    v = this.newView(reply.getContent());
                    if (v != null && !this.requestsAlias.containsKey(reply.getOperationId())) {
                        TOMMessage[] replies = this.requestsReplies.get(reply.getOperationId());
                        int sameContent = 1;
                        int replyQuorum = this.getReplyQuorum();
                        int pos = this.getViewManager().getCurrentViewPos(reply.getSender());
                        replies[pos] = reply;
                        for (int i = 0; i < replies.length; ++i) {
                            if (replies[i] == null || i == pos && this.getViewManager().getCurrentViewN() != 1 || reply.getReqType() == TOMMessageType.ORDERED_REQUEST && !Arrays.equals(replies[i].getContent(), reply.getContent())) continue;
                            ++sameContent;
                        }
                        if (sameContent >= replyQuorum) {
                            if (v.getId() > this.getViewManager().getCurrentViewId()) {
                                this.reconfigureTo(v);
                            }
                            requestContext.getReplyListener().reset();
                            Thread t = new Thread(){

                                @Override
                                public void run() {
                                    int id = AsynchServiceProxy.this.invokeAsynch(requestContext.getRequest(), requestContext.getTargets(), requestContext.getReplyListener(), TOMMessageType.ORDERED_REQUEST);
                                    AsynchServiceProxy.this.requestsAlias.put(reply.getOperationId(), id);
                                }
                            };
                            t.start();
                        }
                    } else if (!this.requestsAlias.containsKey(reply.getOperationId())) {
                        requestContext.getReplyListener().replyReceived(requestContext, reply);
                    }
                }
            }
        }
        catch (Exception ex) {
            this.logger.error("Error processing received request", (Throwable)ex);
        }
        finally {
            this.canReceiveLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int invokeAsynch(byte[] request, int[] targets, ReplyListener replyListener, TOMMessageType reqType) {
        this.logger.debug("Asynchronously sending request to " + Arrays.toString(targets));
        RequestContext requestContext = null;
        this.canSendLock.lock();
        requestContext = new RequestContext(this.generateRequestId(reqType), this.generateOperationId(), reqType, targets, System.currentTimeMillis(), replyListener, request);
        try {
            this.logger.debug("Storing request context for " + requestContext.getOperationId());
            this.requestsContext.put(requestContext.getOperationId(), requestContext);
            this.requestsReplies.put(requestContext.getOperationId(), new TOMMessage[super.getViewManager().getCurrentViewN()]);
            this.sendMessageToTargets(request, requestContext.getReqId(), requestContext.getOperationId(), targets, reqType);
        }
        finally {
            this.canSendLock.unlock();
        }
        return requestContext.getOperationId();
    }

    private boolean contains(int[] targets, int senderId) {
        for (int i = 0; i < targets.length; ++i) {
            if (targets[i] != senderId) continue;
            return true;
        }
        return false;
    }
}

