/*
 * Decompiled with CFR 0.152.
 */
package bftsmart.tom;

import bftsmart.reconfiguration.ReconfigureReply;
import bftsmart.reconfiguration.views.View;
import bftsmart.tom.core.TOMSender;
import bftsmart.tom.core.messages.TOMMessage;
import bftsmart.tom.core.messages.TOMMessageType;
import bftsmart.tom.util.Extractor;
import bftsmart.tom.util.KeyLoader;
import bftsmart.tom.util.TOMUtil;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Random;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceProxy
extends TOMSender {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    protected ReentrantLock canReceiveLock = new ReentrantLock();
    protected ReentrantLock canSendLock = new ReentrantLock();
    private Semaphore sm = new Semaphore(0);
    private int reqId = -1;
    private int operationId = -1;
    private TOMMessageType requestType;
    private int replyQuorum = 0;
    private TOMMessage[] replies = null;
    private int receivedReplies = 0;
    private TOMMessage response = null;
    private int invokeTimeout = 40;
    private Comparator<byte[]> comparator;
    private Extractor extractor;
    private Random rand = new Random(System.currentTimeMillis());
    private int replyServer;
    private HashResponseController hashResponseController;
    private int invokeUnorderedHashedTimeout = 10;

    public ServiceProxy(int processId) {
        this(processId, null, null, null, null);
    }

    public ServiceProxy(int processId, String configHome) {
        this(processId, configHome, null, null, null);
    }

    public ServiceProxy(int processId, String configHome, KeyLoader loader) {
        this(processId, configHome, null, null, loader);
    }

    public ServiceProxy(int processId, String configHome, Comparator<byte[]> replyComparator, Extractor replyExtractor, KeyLoader loader) {
        if (configHome == null) {
            this.init(processId, loader);
        } else {
            this.init(processId, configHome, loader);
        }
        this.replies = new TOMMessage[this.getViewManager().getCurrentViewN()];
        this.comparator = replyComparator != null ? replyComparator : new Comparator<byte[]>(){

            @Override
            public int compare(byte[] o1, byte[] o2) {
                return Arrays.equals(o1, o2) ? 0 : -1;
            }
        };
        this.extractor = replyExtractor != null ? replyExtractor : new Extractor(){

            @Override
            public TOMMessage extractResponse(TOMMessage[] replies, int sameContent, int lastReceived) {
                return replies[lastReceived];
            }
        };
    }

    public int getInvokeTimeout() {
        return this.invokeTimeout;
    }

    public int getInvokeUnorderedHashedTimeout() {
        return this.invokeUnorderedHashedTimeout;
    }

    public void setInvokeTimeout(int invokeTimeout) {
        this.invokeTimeout = invokeTimeout;
    }

    public void setInvokeUnorderedHashedTimeout(int timeout) {
        this.invokeUnorderedHashedTimeout = timeout;
    }

    public byte[] invokeOrdered(byte[] request) {
        return this.invoke(request, TOMMessageType.ORDERED_REQUEST);
    }

    public byte[] invokeUnordered(byte[] request) {
        return this.invoke(request, TOMMessageType.UNORDERED_REQUEST);
    }

    public byte[] invokeUnorderedHashed(byte[] request) {
        return this.invoke(request, TOMMessageType.UNORDERED_HASHED_REQUEST);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] invoke(byte[] request, TOMMessageType reqType) {
        block25: {
            Object sm;
            this.canSendLock.lock();
            Arrays.fill(this.replies, null);
            this.receivedReplies = 0;
            this.response = null;
            this.replyQuorum = this.getReplyQuorum();
            this.reqId = this.generateRequestId(reqType);
            this.operationId = this.generateOperationId();
            this.requestType = reqType;
            this.replyServer = -1;
            this.hashResponseController = null;
            if (this.requestType == TOMMessageType.UNORDERED_HASHED_REQUEST) {
                this.replyServer = this.getRandomlyServerId();
                this.logger.debug("[" + this.getClass().getName() + "] replyServerId(" + this.replyServer + ") pos(" + this.getViewManager().getCurrentViewPos(this.replyServer) + ")");
                this.hashResponseController = new HashResponseController(this.getViewManager().getCurrentViewPos(this.replyServer), this.getViewManager().getCurrentViewProcesses().length);
                sm = new TOMMessage(this.getProcessId(), this.getSession(), this.reqId, this.operationId, request, this.getViewManager().getCurrentViewId(), this.requestType);
                ((TOMMessage)sm).setReplyServer(this.replyServer);
                this.TOMulticast((TOMMessage)sm);
            } else {
                this.TOMulticast(request, this.reqId, this.operationId, reqType);
            }
            this.logger.debug("Sending request (" + (Object)((Object)reqType) + ") with reqId=" + this.reqId);
            this.logger.debug("Expected number of matching replies: " + this.replyQuorum);
            try {
                if (reqType == TOMMessageType.UNORDERED_HASHED_REQUEST) {
                    if (!this.sm.tryAcquire(this.invokeUnorderedHashedTimeout, TimeUnit.SECONDS)) {
                        this.logger.info("######## UNORDERED HASHED REQUEST TIMOUT ########");
                        this.canSendLock.unlock();
                        sm = this.invoke(request, TOMMessageType.ORDERED_REQUEST);
                        if (!this.canSendLock.isHeldByCurrentThread()) return sm;
                        this.canSendLock.unlock();
                        return sm;
                    }
                    break block25;
                }
            }
            catch (InterruptedException ex) {
                this.logger.error("Problem aquiring semaphore", (Throwable)ex);
                break block25;
            }
            {
                if (this.sm.tryAcquire(this.invokeTimeout, TimeUnit.SECONDS)) break block25;
                this.logger.info("###################TIMEOUT#######################");
                this.logger.info("Reply timeout for reqId=" + this.reqId + ", Replies received: " + this.receivedReplies);
                this.canSendLock.unlock();
                sm = null;
                if (!this.canSendLock.isHeldByCurrentThread()) return sm;
                this.canSendLock.unlock();
                return sm;
            }
        }
        this.logger.debug("Response extracted = " + this.response);
        byte[] ret = null;
        if (this.response == null) {
            this.logger.debug("Received n-f replies and no response could be extracted.");
            this.canSendLock.unlock();
            if (reqType != TOMMessageType.UNORDERED_REQUEST) {
                if (reqType != TOMMessageType.UNORDERED_HASHED_REQUEST) throw new RuntimeException("Received n-f replies without f+1 of them matching.");
            }
            this.logger.debug("###################RETRY#######################");
            return this.invokeOrdered(request);
        }
        if (reqType == TOMMessageType.ORDERED_REQUEST) {
            if (this.response.getViewID() != this.getViewManager().getCurrentViewId()) {
                this.reconfigureTo((View)TOMUtil.getObject(this.response.getContent()));
                this.canSendLock.unlock();
                return this.invoke(request, reqType);
            }
            ret = this.response.getContent();
            return ret;
        }
        if (reqType == TOMMessageType.UNORDERED_REQUEST || reqType == TOMMessageType.UNORDERED_HASHED_REQUEST) {
            if (this.response.getViewID() != this.getViewManager().getCurrentViewId()) {
                this.canSendLock.unlock();
                return this.invoke(request, TOMMessageType.ORDERED_REQUEST);
            }
            ret = this.response.getContent();
            return ret;
        }
        if (this.response.getViewID() > this.getViewManager().getCurrentViewId()) {
            this.logger.debug("Reconfiguration request' reply received!");
            Object r = TOMUtil.getObject(this.response.getContent());
            if (r instanceof View) {
                this.reconfigureTo((View)r);
                this.canSendLock.unlock();
                return this.invoke(request, reqType);
            }
            if (r instanceof ReconfigureReply) {
                this.reconfigureTo(((ReconfigureReply)r).getView());
                ret = this.response.getContent();
                return ret;
            } else {
                this.logger.debug("Unknown response type");
            }
            return ret;
        }
        this.logger.debug("Unexpected execution flow");
        return ret;
    }

    protected void reconfigureTo(View v) {
        this.logger.debug("Installing a most up-to-date view with id=" + v.getId());
        this.getViewManager().reconfigureTo(v);
        this.getViewManager().getViewStore().storeView(v);
        this.replies = new TOMMessage[this.getViewManager().getCurrentViewN()];
        this.getCommunicationSystem().updateConnections();
    }

    @Override
    public void replyReceived(TOMMessage reply) {
        this.logger.debug("Synchronously received reply from " + reply.getSender() + " with sequence number " + reply.getSequence());
        try {
            this.canReceiveLock.lock();
            if (this.reqId == -1) {
                this.logger.debug("throwing out request: sender=" + reply.getSender() + " reqId=" + reply.getSequence());
                this.canReceiveLock.unlock();
                return;
            }
            int pos = this.getViewManager().getCurrentViewPos(reply.getSender());
            if (pos < 0) {
                this.canReceiveLock.unlock();
                return;
            }
            int sameContent = 1;
            if (reply.getSequence() == this.reqId && reply.getReqType() == this.requestType) {
                this.logger.debug("Receiving reply from " + reply.getSender() + " with reqId:" + reply.getSequence() + ". Putting on pos=" + pos);
                if (this.requestType == TOMMessageType.UNORDERED_HASHED_REQUEST) {
                    this.response = this.hashResponseController.getResponse(pos, reply);
                    if (this.response != null) {
                        this.reqId = -1;
                        this.sm.release();
                        this.canReceiveLock.unlock();
                        return;
                    }
                } else {
                    if (this.replies[pos] == null) {
                        ++this.receivedReplies;
                    }
                    this.replies[pos] = reply;
                    for (int i = 0; i < this.replies.length; ++i) {
                        if (i == pos && this.getViewManager().getCurrentViewN() != 1 || this.replies[i] == null || this.comparator.compare(this.replies[i].getContent(), reply.getContent()) != 0 || ++sameContent < this.replyQuorum) continue;
                        this.response = this.extractor.extractResponse(this.replies, sameContent, pos);
                        this.reqId = -1;
                        this.sm.release();
                        this.canReceiveLock.unlock();
                        return;
                    }
                }
                if (this.response == null) {
                    if (this.requestType.equals((Object)TOMMessageType.ORDERED_REQUEST)) {
                        if (this.receivedReplies == this.getViewManager().getCurrentViewN()) {
                            this.reqId = -1;
                            this.sm.release();
                        }
                    } else if (this.requestType.equals((Object)TOMMessageType.UNORDERED_HASHED_REQUEST)) {
                        if (this.hashResponseController.getNumberReplies() == this.getViewManager().getCurrentViewN()) {
                            this.reqId = -1;
                            this.sm.release();
                        }
                    } else if (this.receivedReplies != sameContent) {
                        this.reqId = -1;
                        this.sm.release();
                    }
                }
            } else {
                this.logger.debug("Ignoring reply from " + reply.getSender() + " with reqId:" + reply.getSequence() + ". Currently wait reqId= " + this.reqId);
            }
            this.canReceiveLock.unlock();
        }
        catch (Exception ex) {
            this.logger.error("Problem processing reply", (Throwable)ex);
            this.canReceiveLock.unlock();
        }
    }

    protected int getReplyQuorum() {
        if (this.getViewManager().getStaticConf().isBFT()) {
            return (int)Math.ceil((this.getViewManager().getCurrentViewN() + this.getViewManager().getCurrentViewF()) / 2) + 1;
        }
        return (int)Math.ceil(this.getViewManager().getCurrentViewN() / 2) + 1;
    }

    private int getRandomlyServerId() {
        int numServers = super.getViewManager().getCurrentViewProcesses().length;
        int pos = this.rand.nextInt(numServers);
        return super.getViewManager().getCurrentViewProcesses()[pos];
    }

    private class HashResponseController {
        private TOMMessage reply;
        private byte[][] hashReplies;
        private int replyServerPos;
        private int countHashReplies;

        public HashResponseController(int replyServerPos, int length) {
            this.replyServerPos = replyServerPos;
            this.hashReplies = new byte[length][];
            this.reply = null;
            this.countHashReplies = 0;
        }

        public TOMMessage getResponse(int pos, TOMMessage tomMessage) {
            if (this.hashReplies[pos] == null) {
                ++this.countHashReplies;
            }
            if (this.replyServerPos == pos) {
                this.reply = tomMessage;
                this.hashReplies[pos] = TOMUtil.computeHash(tomMessage.getContent());
            } else {
                this.hashReplies[pos] = tomMessage.getContent();
            }
            ServiceProxy.this.logger.debug("[" + this.getClass().getName() + "] hashReplies[" + pos + "]=" + Arrays.toString(this.hashReplies[pos]));
            if (this.hashReplies[this.replyServerPos] != null) {
                int sameContent = 1;
                for (int i = 0; i < ServiceProxy.this.replies.length; ++i) {
                    if (i == this.replyServerPos && ServiceProxy.this.getViewManager().getCurrentViewN() != 1 || this.hashReplies[i] == null || !Arrays.equals(this.hashReplies[i], this.hashReplies[this.replyServerPos]) || ++sameContent < ServiceProxy.this.replyQuorum) continue;
                    return this.reply;
                }
            }
            return null;
        }

        public int getNumberReplies() {
            return this.countHashReplies;
        }
    }
}

