/*
 * Decompiled with CFR 0.152.
 */
package bftsmart.tom.leaderchange;

import bftsmart.consensus.TimestampValuePair;
import bftsmart.consensus.messages.ConsensusMessage;
import bftsmart.reconfiguration.ServerViewController;
import bftsmart.tom.core.TOMLayer;
import bftsmart.tom.core.messages.TOMMessage;
import bftsmart.tom.leaderchange.CertifiedDecision;
import bftsmart.tom.leaderchange.CollectData;
import bftsmart.tom.util.TOMUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.SignedObject;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LCManager {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private int lastreg;
    private int nextreg;
    private List<TOMMessage> currentRequestTimedOut = null;
    private List<TOMMessage> requestsFromSTOP = null;
    private HashMap<Integer, HashSet<Integer>> stops;
    private HashMap<Integer, HashSet<CertifiedDecision>> lastCIDs;
    private HashMap<Integer, HashSet<SignedObject>> collects;
    private ServerViewController SVController;
    private MessageDigest md;
    private TOMLayer tomLayer;
    private int currentLeader;
    private Mac mac;

    public LCManager(TOMLayer tomLayer, ServerViewController SVController, MessageDigest md) {
        this.tomLayer = tomLayer;
        this.lastreg = 0;
        this.nextreg = 0;
        this.currentLeader = 0;
        this.stops = new HashMap();
        this.lastCIDs = new HashMap();
        this.collects = new HashMap();
        this.SVController = SVController;
        this.md = md;
        try {
            this.mac = TOMUtil.getMacFactory();
        }
        catch (NoSuchAlgorithmException ex) {
            this.logger.error("Could not instantiate MAC algorithm", (Throwable)ex);
        }
    }

    public int getNewLeader() {
        int[] proc = this.SVController.getCurrentViewProcesses();
        int minProc = proc[0];
        int maxProc = proc[0];
        for (int p : proc) {
            if (p < minProc) {
                minProc = p;
            }
            if (p <= maxProc) continue;
            maxProc = p;
        }
        do {
            ++this.currentLeader;
            if (this.currentLeader <= maxProc) continue;
            this.currentLeader = minProc;
        } while (!this.SVController.isCurrentViewMember(this.currentLeader));
        return this.currentLeader;
    }

    public void setNewLeader(int leader) {
        this.currentLeader = leader;
    }

    public void setCurrentRequestTimedOut(List<TOMMessage> currentRequestTimedOut) {
        this.currentRequestTimedOut = currentRequestTimedOut;
    }

    public List<TOMMessage> getCurrentRequestTimedOut() {
        return this.currentRequestTimedOut;
    }

    public void clearCurrentRequestTimedOut() {
        if (this.currentRequestTimedOut != null) {
            this.currentRequestTimedOut.clear();
        }
        this.currentRequestTimedOut = null;
    }

    public void addRequestsFromSTOP(TOMMessage[] requestsFromSTOP) {
        if (this.requestsFromSTOP == null) {
            this.requestsFromSTOP = new LinkedList<TOMMessage>();
        }
        for (TOMMessage m : requestsFromSTOP) {
            this.requestsFromSTOP.add(m);
        }
    }

    public List<TOMMessage> getRequestsFromSTOP() {
        return this.requestsFromSTOP;
    }

    public void clearRequestsFromSTOP() {
        if (this.requestsFromSTOP != null) {
            this.requestsFromSTOP.clear();
        }
        this.requestsFromSTOP = null;
    }

    public void setLastReg(int lastreg) {
        this.lastreg = lastreg;
    }

    public int getLastReg() {
        return this.lastreg;
    }

    public void setNextReg(int nextreg) {
        this.nextreg = nextreg;
    }

    public int getNextReg() {
        return this.nextreg;
    }

    public void addStop(int regency, int pid) {
        HashSet<Integer> pids = this.stops.get(regency);
        if (pids == null) {
            pids = new HashSet();
        }
        pids.add(pid);
        this.stops.put(regency, pids);
    }

    public void removeStops(int regency) {
        Integer[] keys = new Integer[this.stops.keySet().size()];
        this.stops.keySet().toArray(keys);
        for (int i = 0; i < keys.length; ++i) {
            if (keys[i] > regency) continue;
            this.stops.remove(keys[i]);
        }
    }

    public int getStopsSize(int regency) {
        HashSet<Integer> pids = this.stops.get(regency);
        return pids == null ? 0 : pids.size();
    }

    public void addLastCID(int regency, CertifiedDecision lastCID) {
        HashSet<CertifiedDecision> last = this.lastCIDs.get(regency);
        if (last == null) {
            last = new HashSet();
        }
        last.add(lastCID);
        this.lastCIDs.put(regency, last);
    }

    public void removeLastCIDs(int regency) {
        Integer[] keys = new Integer[this.lastCIDs.keySet().size()];
        this.lastCIDs.keySet().toArray(keys);
        for (int i = 0; i < keys.length; ++i) {
            if (keys[i] > regency) continue;
            this.lastCIDs.remove(keys[i]);
        }
    }

    public int getLastCIDsSize(int regency) {
        HashSet<CertifiedDecision> last = this.lastCIDs.get(regency);
        return last == null ? 0 : last.size();
    }

    public HashSet<CertifiedDecision> getLastCIDs(int regency) {
        return this.lastCIDs.get(regency);
    }

    public void setLastCIDs(int regency, HashSet<CertifiedDecision> lasts) {
        this.lastCIDs.put(regency, lasts);
    }

    public void addCollect(int regency, SignedObject signedCollect) {
        HashSet<SignedObject> c = this.collects.get(regency);
        if (c == null) {
            c = new HashSet();
        }
        c.add(signedCollect);
        this.collects.put(regency, c);
    }

    public void removeCollects(int regency) {
        Integer[] keys = new Integer[this.collects.keySet().size()];
        this.collects.keySet().toArray(keys);
        for (int i = 0; i < keys.length; ++i) {
            if (keys[i] > regency) continue;
            this.collects.remove(keys[i]);
        }
    }

    public int getCollectsSize(int regency) {
        HashSet<SignedObject> c = this.collects.get(regency);
        return c == null ? 0 : c.size();
    }

    public HashSet<SignedObject> getCollects(int regency) {
        return this.collects.get(regency);
    }

    public void setCollects(int regency, HashSet<SignedObject> colls) {
        this.collects.put(regency, colls);
    }

    public boolean sound(HashSet<CollectData> collects) {
        this.logger.debug("I collected the context from " + collects.size() + " replicas");
        if (collects == null) {
            return false;
        }
        HashSet<Integer> timestamps = new HashSet<Integer>();
        HashSet<byte[]> values = new HashSet<byte[]>();
        for (CollectData c : collects) {
            this.logger.debug("Context for replica " + c.getPid() + ": CID[" + c.getCid() + "] WRITESET[" + c.getWriteSet() + "] (VALTS,VAL)[" + c.getQuorumWrites() + "]");
            timestamps.add(c.getQuorumWrites().getTimestamp());
            if (!Arrays.equals(c.getQuorumWrites().getValue(), new byte[0])) {
                boolean insert = true;
                for (byte[] b : values) {
                    if (!Arrays.equals(b, c.getQuorumWrites().getValue())) continue;
                    insert = false;
                    break;
                }
                if (insert) {
                    values.add(c.getQuorumWrites().getValue());
                }
            }
            for (TimestampValuePair rv : c.getWriteSet()) {
                timestamps.add(rv.getTimestamp());
                boolean insert = true;
                for (byte[] b : values) {
                    if (!Arrays.equals(b, rv.getHashedValue())) continue;
                    insert = false;
                    break;
                }
                if (!insert) continue;
                values.add(rv.getHashedValue());
            }
        }
        this.logger.debug("number of timestamps: " + timestamps.size());
        this.logger.debug("number of values: " + values.size());
        Iterator<CollectData> iterator = timestamps.iterator();
        while (iterator.hasNext()) {
            int r = (Integer)((Object)iterator.next());
            for (byte[] v : values) {
                this.logger.debug("testing predicate BIND for timestamp/value pair (" + r + " , " + Arrays.toString(v) + ")");
                if (!this.binds(r, v, collects)) continue;
                this.logger.debug("Predicate BIND is true for timestamp/value pair (" + r + " , " + Arrays.toString(v) + ")");
                this.logger.debug("Predicate SOUND is true for the for context collected from N-F replicas");
                return true;
            }
        }
        this.logger.debug("No timestamp/value pair passed on the BIND predicate");
        boolean unbound = this.unbound(collects);
        if (unbound) {
            this.logger.debug("Predicate UNBOUND is true for N-F replicas");
            this.logger.debug("Predicate SOUND is true for the for context collected from N-F replicas");
        }
        return unbound;
    }

    public boolean binds(int timestamp, byte[] value, HashSet<CollectData> collects) {
        if (value == null || collects == null) {
            this.logger.debug("Received null objects, returning false");
            return false;
        }
        if (collects.size() < this.SVController.getCurrentViewN() - this.SVController.getCurrentViewF()) {
            this.logger.debug("Less than N-F contexts collected from replicas, returning false");
            return false;
        }
        return this.quorumHighest(timestamp, value, collects) && this.certifiedValue(timestamp, value, collects);
    }

    public byte[] getBindValue(HashSet<CollectData> collects) {
        if (collects == null) {
            return null;
        }
        HashSet<Integer> timestamps = new HashSet<Integer>();
        HashSet<byte[]> values = new HashSet<byte[]>();
        for (CollectData c : collects) {
            timestamps.add(c.getQuorumWrites().getTimestamp());
            if (!Arrays.equals(c.getQuorumWrites().getValue(), new byte[0])) {
                boolean insert = true;
                for (byte[] b : values) {
                    if (!Arrays.equals(b, c.getQuorumWrites().getValue())) continue;
                    insert = false;
                    break;
                }
                if (insert) {
                    values.add(c.getQuorumWrites().getValue());
                }
            }
            for (TimestampValuePair rv : c.getWriteSet()) {
                timestamps.add(rv.getTimestamp());
                boolean insert = true;
                for (byte[] b : values) {
                    if (!Arrays.equals(b, rv.getHashedValue())) continue;
                    insert = false;
                    break;
                }
                if (!insert) continue;
                values.add(rv.getHashedValue());
            }
        }
        Iterator<CollectData> iterator = timestamps.iterator();
        while (iterator.hasNext()) {
            int r = (Integer)((Object)iterator.next());
            for (byte[] v : values) {
                if (r < 0 || !this.binds(r, v, collects)) continue;
                for (CollectData c : collects) {
                    for (TimestampValuePair rv : c.getWriteSet()) {
                        if (rv.getValue() == null || !Arrays.equals(v, rv.getHashedValue())) continue;
                        return rv.getValue();
                    }
                }
            }
        }
        return null;
    }

    public boolean unbound(HashSet<CollectData> collects) {
        if (collects == null) {
            return false;
        }
        boolean unbound = false;
        int count = 0;
        if (collects.size() >= this.SVController.getCurrentViewN() - this.SVController.getCurrentViewF()) {
            for (CollectData c : collects) {
                if (c.getQuorumWrites().getTimestamp() != 0) continue;
                ++count;
            }
        } else {
            return false;
        }
        unbound = this.SVController.getStaticConf().isBFT() ? count > (this.SVController.getCurrentViewN() + this.SVController.getCurrentViewF()) / 2 : count > this.SVController.getCurrentViewN() / 2;
        return unbound;
    }

    public boolean quorumHighest(int timestamp, byte[] value, HashSet<CollectData> collects) {
        if (collects == null || value == null) {
            return false;
        }
        boolean appears = false;
        boolean quorum = false;
        for (CollectData c : collects) {
            if (c.getQuorumWrites().getTimestamp() != timestamp || !Arrays.equals(value, c.getQuorumWrites().getValue())) continue;
            appears = true;
            break;
        }
        if (appears) {
            this.logger.debug("timestamp/value pair (" + timestamp + " , " + Arrays.toString(value) + ") appears in at least one replica context");
        }
        int count = 0;
        for (CollectData c : collects) {
            if (c.getQuorumWrites().getTimestamp() >= timestamp && (c.getQuorumWrites().getTimestamp() != timestamp || !Arrays.equals(value, c.getQuorumWrites().getValue()))) continue;
            ++count;
        }
        if (this.SVController.getStaticConf().isBFT()) {
            quorum = count > (this.SVController.getCurrentViewN() + this.SVController.getCurrentViewF()) / 2;
        } else {
            boolean bl = quorum = count > this.SVController.getCurrentViewN() / 2;
        }
        if (quorum) {
            this.logger.debug("timestamp/value pair (" + timestamp + " , " + Arrays.toString(value) + ") has the highest timestamp among a " + (this.SVController.getStaticConf().isBFT() ? "Byzantine" : "simple") + " quorum of replica contexts");
        }
        return appears && quorum;
    }

    public boolean certifiedValue(int timestamp, byte[] value, HashSet<CollectData> collects) {
        if (collects == null || value == null) {
            return false;
        }
        boolean certified = false;
        int count = 0;
        for (CollectData c : collects) {
            for (TimestampValuePair pv : c.getWriteSet()) {
                if (pv.getTimestamp() < timestamp || !Arrays.equals(value, pv.getHashedValue())) continue;
                ++count;
            }
        }
        if (this.SVController.getStaticConf().isBFT()) {
            certified = count > this.SVController.getCurrentViewF();
        } else {
            boolean bl = certified = count > 0;
        }
        if (certified) {
            this.logger.debug("timestamp/value pair (" + timestamp + " , " + Arrays.toString(value) + ") has been written by at least " + count + " replica(s)");
        }
        return certified;
    }

    public HashSet<CollectData> selectCollects(int regency, int cid) {
        HashSet<SignedObject> c = this.collects.get(regency);
        if (c == null) {
            return null;
        }
        return this.normalizeCollects(this.getSignedCollects(c), cid, regency);
    }

    public HashSet<CollectData> selectCollects(HashSet<SignedObject> signedObjects, int cid, int regency) {
        if (signedObjects == null) {
            return null;
        }
        return this.normalizeCollects(this.getSignedCollects(signedObjects), cid, regency);
    }

    private HashSet<CollectData> getSignedCollects(HashSet<SignedObject> signedCollects) {
        HashSet<CollectData> colls = new HashSet<CollectData>();
        for (SignedObject so : signedCollects) {
            try {
                CollectData c = (CollectData)so.getObject();
                int sender = c.getPid();
                if (!this.tomLayer.verifySignature(so, sender)) continue;
                colls.add(c);
            }
            catch (IOException | ClassNotFoundException ex) {
                this.logger.error("Error processing collect data", (Throwable)ex);
            }
        }
        return colls;
    }

    private HashSet<CollectData> normalizeCollects(HashSet<CollectData> collects, int cid, int regency) {
        HashSet<CollectData> result = new HashSet<CollectData>();
        for (CollectData c : collects) {
            if (c.getCid() == cid) {
                result.add(c);
                continue;
            }
            result.add(new CollectData(c.getPid(), cid, regency, new TimestampValuePair(0, new byte[0]), new HashSet<TimestampValuePair>()));
        }
        for (CollectData c : result) {
            for (TimestampValuePair rv : c.getWriteSet()) {
                if (rv.getValue() != null && rv.getValue().length > 0) {
                    rv.setHashedValue(this.md.digest(rv.getValue()));
                    continue;
                }
                rv.setHashedValue(new byte[0]);
            }
        }
        return result;
    }

    public CertifiedDecision getHighestLastCID(int ts) {
        CertifiedDecision highest = new CertifiedDecision(-2, -2, null, null);
        HashSet<CertifiedDecision> lasts = this.lastCIDs.get(ts);
        if (lasts == null) {
            return null;
        }
        for (CertifiedDecision l : lasts) {
            if (this.tomLayer.controller.getStaticConf().isBFT() && this.hasValidProof(l) && l.getCID() > highest.getCID()) {
                highest = l;
                continue;
            }
            if (l.getCID() <= highest.getCID()) continue;
            highest = l;
        }
        return highest;
    }

    public boolean hasValidProof(CertifiedDecision cDec) {
        if (cDec.getCID() == -1) {
            return true;
        }
        byte[] hashedValue = this.md.digest(cDec.getDecision());
        Set<ConsensusMessage> ConsensusMessages = cDec.getConsMessages();
        int myId = this.tomLayer.controller.getStaticConf().getProcessId();
        int certificateCurrentView = 2 * this.tomLayer.controller.getCurrentViewF() + 1;
        int certificateLastView = -1;
        if (this.tomLayer.controller.getLastView() != null) {
            certificateLastView = 2 * this.tomLayer.controller.getLastView().getF() + 1;
        }
        int countValid = 0;
        SecretKey secretKey = null;
        PublicKey pubKey = null;
        HashSet<Integer> alreadyCounted = new HashSet<Integer>();
        for (ConsensusMessage consMsg : ConsensusMessages) {
            ConsensusMessage cm = new ConsensusMessage(consMsg.getType(), consMsg.getNumber(), consMsg.getEpoch(), consMsg.getSender(), consMsg.getValue());
            ByteArrayOutputStream bOut = new ByteArrayOutputStream(248);
            try {
                new ObjectOutputStream(bOut).writeObject(cm);
            }
            catch (IOException ex) {
                this.logger.error("Could not serialize message", (Throwable)ex);
            }
            byte[] data = bOut.toByteArray();
            if (consMsg.getProof() instanceof HashMap) {
                this.logger.debug("Proof made of MAC vector");
                HashMap macVector = (HashMap)consMsg.getProof();
                byte[] recvMAC = (byte[])macVector.get(myId);
                byte[] myMAC = null;
                secretKey = this.tomLayer.getCommunication().getServersConn().getSecretKey(consMsg.getSender());
                try {
                    this.mac.init(secretKey);
                    myMAC = this.mac.doFinal(data);
                }
                catch (InvalidKeyException ex) {
                    this.logger.error("Could not compute MAC", (Throwable)ex);
                }
                if (recvMAC == null || myMAC == null || !Arrays.equals(recvMAC, myMAC) || !Arrays.equals(consMsg.getValue(), hashedValue) || consMsg.getNumber() != cDec.getCID() || alreadyCounted.contains(consMsg.getSender())) continue;
                alreadyCounted.add(consMsg.getSender());
                ++countValid;
                continue;
            }
            if (consMsg.getProof() instanceof byte[]) {
                byte[] signature;
                this.logger.debug("Proof made of Signatures");
                pubKey = this.SVController.getStaticConf().getPublicKey(consMsg.getSender());
                if (!TOMUtil.verifySignature(pubKey, data, signature = (byte[])consMsg.getProof()) || alreadyCounted.contains(consMsg.getSender())) continue;
                alreadyCounted.add(consMsg.getSender());
                ++countValid;
                continue;
            }
            this.logger.debug("Proof is message is invalid");
        }
        if (certificateLastView != -1 && pubKey != null) {
            this.logger.debug("Computing certificate based on previous view");
        }
        return countValid >= (certificateLastView != -1 && pubKey != null ? certificateLastView : certificateCurrentView);
    }

    public byte[] getLastCIDValue(int regency, int cid) {
        HashSet<CertifiedDecision> lasts = this.lastCIDs.get(regency);
        if (lasts == null) {
            return null;
        }
        byte[] result = null;
        for (CertifiedDecision l : lasts) {
            if (l.getCID() != cid) continue;
            result = l.getDecision();
            break;
        }
        return result;
    }

    public int getETS(int cid, Set<CollectData> collects) {
        int ets = -1;
        int count = 0;
        for (CollectData c : collects) {
            if (c.getCid() != cid) continue;
            if (c.getEts() > ets) {
                ets = c.getEts();
                count = 1;
                continue;
            }
            if (c.getEts() != ets) continue;
            ++count;
        }
        return count > this.SVController.getCurrentViewF() ? ets : -1;
    }
}

