/*
 * Decompiled with CFR 0.152.
 */
package bftsmart.tom.server.defaultservices;

import bftsmart.statemanagement.ApplicationState;
import bftsmart.tom.MessageContext;
import bftsmart.tom.server.defaultservices.CommandsInfo;
import bftsmart.tom.server.defaultservices.DefaultApplicationState;
import bftsmart.tom.server.defaultservices.FileRecoverer;
import bftsmart.tom.server.defaultservices.StateLog;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;

public class DiskStateLog
extends StateLog {
    private int id;
    public static final String DEFAULT_DIR = "files".concat(System.getProperty("file.separator"));
    private static final int INT_BYTE_SIZE = 4;
    private static final int EOF = 0;
    private RandomAccessFile log;
    private boolean syncLog;
    private String logPath;
    private String lastCkpPath;
    private boolean syncCkp;
    private boolean isToLog;
    private ReentrantLock checkpointLock = new ReentrantLock();
    private Map<Integer, Long> logPointers;

    public DiskStateLog(int id, byte[] initialState, byte[] initialHash, boolean isToLog, boolean syncLog, boolean syncCkp) {
        super(id, initialState, initialHash);
        this.id = id;
        this.isToLog = isToLog;
        this.syncLog = syncLog;
        this.syncCkp = syncCkp;
        this.logPointers = new HashMap<Integer, Long>();
    }

    private void createLogFile() {
        this.logPath = DEFAULT_DIR + String.valueOf(this.id) + "." + System.currentTimeMillis() + ".log";
        try {
            this.log = new RandomAccessFile(this.logPath, this.syncLog ? "rwd" : "rw");
        }
        catch (FileNotFoundException e) {
            this.logger.error("Failed to create log file", (Throwable)e);
        }
    }

    @Override
    public void addMessageBatch(byte[][] commands, MessageContext[] msgCtx, int consensusId) {
        CommandsInfo command = new CommandsInfo(commands, msgCtx);
        if (this.isToLog) {
            if (this.log == null) {
                this.createLogFile();
            }
            this.writeCommandToDisk(command, consensusId);
        }
        this.setLastCID(consensusId);
    }

    private void writeCommandToDisk(CommandsInfo commandsInfo, int consensusId) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            oos.writeObject(commandsInfo);
            oos.flush();
            byte[] batchBytes = bos.toByteArray();
            ByteBuffer bf = ByteBuffer.allocate(12 + batchBytes.length);
            bf.putInt(batchBytes.length);
            bf.put(batchBytes);
            bf.putInt(0);
            bf.putInt(consensusId);
            this.log.write(bf.array());
            this.log.seek(this.log.length() - 8L);
        }
        catch (IOException e) {
            this.logger.error("Failed to write command to disk", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void newCheckpoint(byte[] state, byte[] stateHash, int consensusId) {
        String ckpPath = DEFAULT_DIR + String.valueOf(this.id) + "." + System.currentTimeMillis() + ".tmp";
        try {
            this.checkpointLock.lock();
            RandomAccessFile ckp = new RandomAccessFile(ckpPath, this.syncCkp ? "rwd" : "rw");
            ByteBuffer bf = ByteBuffer.allocate(state.length + stateHash.length + 16);
            bf.putInt(state.length);
            bf.put(state);
            bf.putInt(stateHash.length);
            bf.put(stateHash);
            bf.putInt(0);
            bf.putInt(consensusId);
            byte[] ckpState = bf.array();
            ckp.write(ckpState);
            ckp.close();
            if (this.isToLog) {
                this.deleteLogFile();
            }
            this.deleteLastCkp();
            this.renameCkp(ckpPath);
            if (this.isToLog) {
                this.createLogFile();
            }
        }
        catch (FileNotFoundException e) {
            this.logger.error("Failed to open checkpoint file", (Throwable)e);
        }
        catch (IOException e) {
            this.logger.error("Failed to write checkpoint to disk", (Throwable)e);
        }
        finally {
            this.checkpointLock.unlock();
        }
    }

    private void renameCkp(String ckpPath) {
        String finalCkpPath = ckpPath.replace(".tmp", ".ckp");
        new File(ckpPath).renameTo(new File(finalCkpPath));
        this.lastCkpPath = finalCkpPath;
    }

    private void deleteLastCkp() {
        if (this.lastCkpPath != null) {
            new File(this.lastCkpPath).delete();
        }
    }

    private void deleteLogFile() {
        try {
            if (this.log != null) {
                this.log.close();
            }
            new File(this.logPath).delete();
        }
        catch (IOException e) {
            this.logger.error("Failed to delete log file", (Throwable)e);
        }
    }

    @Override
    public DefaultApplicationState getApplicationState(int cid, boolean sendState) {
        CommandsInfo[] batches = null;
        int lastCheckpointCID = this.getLastCheckpointCID();
        int lastCID = this.getLastCID();
        this.logger.debug("LAST CKP CID = " + lastCheckpointCID);
        this.logger.debug("CID = " + cid);
        this.logger.debug("LAST CID = " + lastCID);
        if (cid >= lastCheckpointCID && cid <= lastCID) {
            int size = cid - lastCheckpointCID;
            FileRecoverer fr = new FileRecoverer(this.id, DEFAULT_DIR);
            if (size > 0) {
                CommandsInfo[] recoveredBatches = fr.getLogState(size, this.logPath);
                batches = new CommandsInfo[size];
                for (int i = 0; i < size; ++i) {
                    batches[i] = recoveredBatches[i];
                }
            }
            this.checkpointLock.lock();
            byte[] ckpState = fr.getCkpState(this.lastCkpPath);
            byte[] ckpStateHash = fr.getCkpStateHash();
            this.checkpointLock.unlock();
            this.logger.info("FINISHED READING STATE");
            return new DefaultApplicationState(batches, lastCheckpointCID, cid, (byte[])(sendState ? ckpState : null), ckpStateHash, this.id);
        }
        return null;
    }

    public void transferApplicationState(SocketChannel sChannel, int cid) {
        FileRecoverer fr = new FileRecoverer(this.id, DEFAULT_DIR);
        fr.transferCkpState(sChannel, this.lastCkpPath);
    }

    public void setLastCID(int cid, int checkpointPeriod, int checkpointPortion) {
        super.setLastCID(cid);
        if (cid % checkpointPeriod % checkpointPortion == checkpointPortion - 1) {
            int ckpReplicaIndex = (cid % checkpointPeriod + 1) / checkpointPortion - 1;
            try {
                this.logger.info("Replica " + ckpReplicaIndex + " took checkpoint. My current log pointer is " + this.log.getFilePointer());
                this.logPointers.put(ckpReplicaIndex, this.log.getFilePointer());
            }
            catch (IOException e) {
                this.logger.error("Failed to get file pointer", (Throwable)e);
            }
        }
    }

    @Override
    public void update(DefaultApplicationState transState) {
        this.newCheckpoint(transState.getState(), transState.getStateHash(), transState.getLastCheckpointCID());
        this.setLastCheckpointCID(transState.getLastCheckpointCID());
    }

    protected ApplicationState loadDurableState() {
        FileRecoverer fr = new FileRecoverer(this.id, DEFAULT_DIR);
        this.lastCkpPath = fr.getLatestFile(".ckp");
        this.logPath = fr.getLatestFile(".log");
        byte[] checkpoint = null;
        if (this.lastCkpPath != null) {
            checkpoint = fr.getCkpState(this.lastCkpPath);
        }
        CommandsInfo[] log = null;
        if (this.logPath != null) {
            log = fr.getLogState(0, this.logPath);
        }
        int ckpLastConsensusId = fr.getCkpLastConsensusId();
        int logLastConsensusId = fr.getLogLastConsensusId();
        this.logger.info("log last consensus id: " + logLastConsensusId);
        DefaultApplicationState state = new DefaultApplicationState(log, ckpLastConsensusId, logLastConsensusId, checkpoint, fr.getCkpStateHash(), this.id);
        if (logLastConsensusId > ckpLastConsensusId) {
            super.setLastCID(logLastConsensusId);
        } else {
            super.setLastCID(ckpLastConsensusId);
        }
        super.setLastCheckpointCID(ckpLastConsensusId);
        return state;
    }
}

