/*
 * Decompiled with CFR 0.152.
 */
package bftsmart.tom.util;

import bftsmart.reconfiguration.ServerViewController;
import bftsmart.tom.core.messages.TOMMessage;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.nio.ByteBuffer;
import java.util.Random;
import org.slf4j.LoggerFactory;

public final class BatchReader {
    private ByteBuffer proposalBuffer;
    private boolean useSignatures;

    public BatchReader(byte[] batch, boolean useSignatures) {
        this.proposalBuffer = ByteBuffer.wrap(batch);
        this.useSignatures = useSignatures;
    }

    public TOMMessage[] deserialiseRequests(ServerViewController controller) {
        long timestamp = this.proposalBuffer.getLong();
        int numberOfNonces = this.proposalBuffer.getInt();
        long seed = 0L;
        Random rnd = null;
        if (numberOfNonces > 0) {
            seed = this.proposalBuffer.getLong();
            rnd = new Random(seed);
        } else {
            numberOfNonces = 0;
        }
        int numberOfMessages = this.proposalBuffer.getInt();
        TOMMessage[] requests = new TOMMessage[numberOfMessages];
        for (int i = 0; i < numberOfMessages; ++i) {
            byte[] nonces;
            int sigSize;
            int messageSize = this.proposalBuffer.getInt();
            byte[] message = new byte[messageSize];
            this.proposalBuffer.get(message);
            byte[] signature = null;
            if (this.useSignatures && (sigSize = this.proposalBuffer.getInt()) > 0) {
                signature = new byte[sigSize];
                this.proposalBuffer.get(signature);
            }
            if ((nonces = new byte[numberOfNonces]).length > 0) {
                rnd.nextBytes(nonces);
            }
            try {
                DataInputStream ois = new DataInputStream(new ByteArrayInputStream(message));
                TOMMessage tm = new TOMMessage();
                tm.rExternal(ois);
                tm.serializedMessage = message;
                tm.serializedMessageSignature = signature;
                tm.numOfNonces = numberOfNonces;
                tm.seed = seed;
                tm.timestamp = timestamp;
                requests[i] = tm;
                continue;
            }
            catch (Exception e) {
                LoggerFactory.getLogger(this.getClass()).error("Failed to deserialize batch", (Throwable)e);
            }
        }
        return requests;
    }
}

