/*
 * Decompiled with CFR 0.152.
 */
package bftsmart.tom.util;

import java.util.Arrays;

public class Storage {
    private long[] values;
    private int count = 0;

    public Storage(int size) {
        this.values = new long[size];
    }

    public int getCount() {
        return this.count;
    }

    public void reset() {
        this.count = 0;
    }

    public void store(long value) {
        if (this.count < this.values.length) {
            this.values[this.count++] = value;
        }
    }

    public double getAverage(boolean limit) {
        long[] values = Arrays.copyOfRange(this.values, 0, this.count);
        return this.computeAverage(values, limit);
    }

    public double getDP(boolean limit) {
        long[] values = Arrays.copyOfRange(this.values, 0, this.count);
        return this.computeDP(values, limit);
    }

    public long[] getValues() {
        return this.values;
    }

    public long getMax(boolean limit) {
        long[] values = Arrays.copyOfRange(this.values, 0, this.count);
        return this.computeMax(values, limit);
    }

    private double computeAverage(long[] values, boolean percent) {
        Arrays.sort(values);
        int limit = 0;
        if (percent) {
            limit = values.length / 10;
        }
        long count = 0L;
        for (int i = limit; i < values.length - limit; ++i) {
            count += values[i];
        }
        return (double)count / (double)(values.length - 2 * limit);
    }

    private long computeMax(long[] values, boolean percent) {
        Arrays.sort(values);
        int limit = 0;
        if (percent) {
            limit = values.length / 10;
        }
        long max = 0L;
        for (int i = limit; i < values.length - limit; ++i) {
            if (values[i] <= max) continue;
            max = values[i];
        }
        return max;
    }

    private double computeDP(long[] values, boolean percent) {
        if (values.length <= 1) {
            return 0.0;
        }
        Arrays.sort(values);
        int limit = 0;
        if (percent) {
            limit = values.length / 10;
        }
        long num = 0L;
        double med = this.computeAverage(values, percent);
        long quad = 0L;
        for (int i = limit; i < values.length - limit; ++i) {
            ++num;
            quad += values[i] * values[i];
        }
        double var = ((double)quad - (double)num * (med * med)) / (double)(num - 1L);
        return Math.sqrt(var);
    }

    public long getPercentile(double percentile) {
        long[] values = Arrays.copyOfRange(this.values, 0, this.count);
        Arrays.sort(values);
        int index = (int)(percentile * (double)values.length);
        return values[index];
    }
}

