/*
 * Decompiled with CFR 0.152.
 */
package bftsmart.tom.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Security;
import java.security.Signature;
import java.security.SignatureException;
import java.util.Arrays;
import java.util.Random;
import javax.crypto.Mac;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TOMUtil {
    private static Logger logger = LoggerFactory.getLogger(TOMUtil.class);
    public static final int RR_REQUEST = 0;
    public static final int RR_REPLY = 1;
    public static final int RR_DELIVERED = 2;
    public static final int STOP = 3;
    public static final int STOPDATA = 4;
    public static final int SYNC = 5;
    public static final int SM_REQUEST = 6;
    public static final int SM_REPLY = 7;
    public static final int SM_ASK_INITIAL = 11;
    public static final int SM_REPLY_INITIAL = 12;
    public static final int TRIGGER_LC_LOCALLY = 8;
    public static final int TRIGGER_SM_LOCALLY = 9;
    private static int signatureSize = -1;
    private static boolean init = false;
    private static String hmacAlgorithm = "HmacSHA512";
    private static String secretAlgorithm = "PBKDF2WithHmacSHA1";
    private static String sigAlgorithm = "SHA512withRSA";
    private static String hashAlgorithm = "SHA-512";
    private static String hmacAlgorithmProvider = "SunJCE";
    private static String secretAlgorithmProvider = "SunJCE";
    private static String sigAlgorithmProvider = "SunRsaSign";
    private static String hashAlgorithmProvider = "SUN";
    private static final int SALT_SEED = 509;
    private static final int SALT_BYTE_SIZE = 64;
    private static final int HASH_BYTE_SIZE = 64;
    private static final int PBE_ITERATIONS = 1000;

    public static void init(String hmacAlgorithm, String secretAlgorithm, String sigAlgorithm, String hashAlgorithm, String hmacAlgorithmProvider, String secretAlgorithmProvider, String sigAlgorithmProvider, String hashAlgorithmProvider) {
        if (!init) {
            TOMUtil.hmacAlgorithm = hmacAlgorithm;
            TOMUtil.sigAlgorithm = sigAlgorithm;
            TOMUtil.secretAlgorithm = secretAlgorithm;
            TOMUtil.hashAlgorithm = hashAlgorithm;
            TOMUtil.hmacAlgorithmProvider = hmacAlgorithmProvider;
            TOMUtil.sigAlgorithmProvider = sigAlgorithmProvider;
            TOMUtil.secretAlgorithmProvider = secretAlgorithmProvider;
            TOMUtil.hashAlgorithmProvider = hashAlgorithmProvider;
            init = true;
        }
    }

    public static byte[] getBytes(Object o) {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        ObjectOutputStream obOut = null;
        try {
            obOut = new ObjectOutputStream(bOut);
            obOut.writeObject(o);
            obOut.flush();
            bOut.flush();
            obOut.close();
            bOut.close();
        }
        catch (IOException ex) {
            logger.error("Failed to serialize object", (Throwable)ex);
            return null;
        }
        return bOut.toByteArray();
    }

    public static Object getObject(byte[] b) {
        if (b == null) {
            return null;
        }
        ByteArrayInputStream bInp = new ByteArrayInputStream(b);
        try {
            ObjectInputStream obInp = new ObjectInputStream(bInp);
            Object ret = obInp.readObject();
            obInp.close();
            bInp.close();
            return ret;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static byte[] signMessage(PrivateKey key, byte[] message) {
        byte[] result = null;
        try {
            Signature signatureEngine = TOMUtil.getSigEngine();
            signatureEngine.initSign(key);
            signatureEngine.update(message);
            result = signatureEngine.sign();
        }
        catch (Exception e) {
            logger.error("Failed to sign message", (Throwable)e);
        }
        return result;
    }

    public static boolean verifySignature(PublicKey key, byte[] message, byte[] signature) {
        boolean result = false;
        try {
            Signature signatureEngine = TOMUtil.getSigEngine();
            signatureEngine.initVerify(key);
            result = TOMUtil.verifySignature(signatureEngine, message, signature);
        }
        catch (Exception e) {
            logger.error("Failed to verify signature", (Throwable)e);
        }
        return result;
    }

    public static boolean verifySignature(Signature initializedSignatureEngine, byte[] message, byte[] signature) throws SignatureException {
        initializedSignatureEngine.update(message);
        return initializedSignatureEngine.verify(signature);
    }

    public static String byteArrayToString(byte[] b) {
        String s = "";
        for (int i = 0; i < b.length; ++i) {
            s = s + b[i];
        }
        return s;
    }

    public static boolean equalsHash(byte[] h1, byte[] h2) {
        return Arrays.equals(h2, h2);
    }

    public static final byte[] computeHash(byte[] data) {
        byte[] result = null;
        try {
            MessageDigest md = TOMUtil.getHashEngine();
            result = md.digest(data);
        }
        catch (NoSuchAlgorithmException e) {
            logger.error("Failed to compute hash", (Throwable)e);
        }
        return result;
    }

    public static Signature getSigEngine() throws NoSuchAlgorithmException {
        return Signature.getInstance(sigAlgorithm, Security.getProvider(sigAlgorithmProvider));
    }

    public static MessageDigest getHashEngine() throws NoSuchAlgorithmException {
        return MessageDigest.getInstance(hashAlgorithm, Security.getProvider(hashAlgorithmProvider));
    }

    public static SecretKeyFactory getSecretFactory() throws NoSuchAlgorithmException {
        return SecretKeyFactory.getInstance(secretAlgorithm, Security.getProvider(secretAlgorithmProvider));
    }

    public static Mac getMacFactory() throws NoSuchAlgorithmException {
        return Mac.getInstance(hmacAlgorithm, Security.getProvider(hmacAlgorithmProvider));
    }

    public static PBEKeySpec generateKeySpec(char[] password) throws NoSuchAlgorithmException {
        Random random = new Random(509L);
        byte[] salt = new byte[64];
        random.nextBytes(salt);
        return new PBEKeySpec(password, salt, 1000, 64);
    }
}

