/*
 * Decompiled with CFR 0.152.
 */
package bftsmart.demo.map;

import bftsmart.demo.map.MapRequestType;
import bftsmart.tom.MessageContext;
import bftsmart.tom.ServiceReplica;
import bftsmart.tom.server.Executable;
import bftsmart.tom.server.Recoverable;
import bftsmart.tom.server.defaultservices.DefaultSingleRecoverable;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MapServer<K, V>
extends DefaultSingleRecoverable {
    private Map<K, V> replicaMap = new TreeMap();
    private Logger logger = Logger.getLogger(MapServer.class.getName());

    public MapServer(int id) {
        new ServiceReplica(id, (Executable)this, (Recoverable)this);
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            System.out.println("Usage: demo.map.MapServer <server id>");
            System.exit(-1);
        }
        new MapServer(Integer.parseInt(args[0]));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] appExecuteOrdered(byte[] command, MessageContext msgCtx) {
        byte[] reply = null;
        Object key = null;
        Object value = null;
        boolean hasReply = false;
        try {
            Throwable throwable = null;
            Object var8_10 = null;
            try {
                ByteArrayInputStream byteIn = new ByteArrayInputStream(command);
                try {
                    block35: {
                        ObjectInputStream objIn = new ObjectInputStream(byteIn);
                        try {
                            block34: {
                                ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
                                try {
                                    try (ObjectOutputStream objOut = new ObjectOutputStream(byteOut);){
                                        MapRequestType reqType = (MapRequestType)((Object)objIn.readObject());
                                        switch (reqType) {
                                            case PUT: {
                                                key = objIn.readObject();
                                                value = objIn.readObject();
                                                Object oldValue = this.replicaMap.put(key, value);
                                                if (oldValue == null) break;
                                                objOut.writeObject(oldValue);
                                                hasReply = true;
                                                break;
                                            }
                                            case GET: {
                                                key = objIn.readObject();
                                                value = this.replicaMap.get(key);
                                                if (value == null) break;
                                                objOut.writeObject(value);
                                                hasReply = true;
                                                break;
                                            }
                                            case REMOVE: {
                                                key = objIn.readObject();
                                                value = this.replicaMap.remove(key);
                                                if (value == null) break;
                                                objOut.writeObject(value);
                                                hasReply = true;
                                                break;
                                            }
                                            case SIZE: {
                                                int size = this.replicaMap.size();
                                                objOut.writeInt(size);
                                                hasReply = true;
                                                break;
                                            }
                                            case KEYSET: {
                                                this.keySet(objOut);
                                                hasReply = true;
                                                break;
                                            }
                                        }
                                        if (hasReply) {
                                            objOut.flush();
                                            byteOut.flush();
                                            reply = byteOut.toByteArray();
                                        } else {
                                            reply = new byte[]{};
                                        }
                                    }
                                    if (byteOut == null) break block34;
                                }
                                catch (Throwable throwable2) {
                                    if (throwable == null) {
                                        throwable = throwable2;
                                    } else if (throwable != throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                    if (byteOut == null) throw throwable;
                                    byteOut.close();
                                    throw throwable;
                                }
                                byteOut.close();
                            }
                            if (objIn == null) break block35;
                        }
                        catch (Throwable throwable3) {
                            if (throwable == null) {
                                throwable = throwable3;
                            } else if (throwable != throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            if (objIn == null) throw throwable;
                            objIn.close();
                            throw throwable;
                        }
                        objIn.close();
                    }
                    if (byteIn == null) return reply;
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    if (byteIn == null) throw throwable;
                    byteIn.close();
                    throw throwable;
                }
                byteIn.close();
                return reply;
            }
            catch (Throwable throwable5) {
                if (throwable == null) {
                    throwable = throwable5;
                    throw throwable;
                }
                if (throwable == throwable5) throw throwable;
                throwable.addSuppressed(throwable5);
                throw throwable;
            }
        }
        catch (IOException | ClassNotFoundException e) {
            this.logger.log(Level.SEVERE, "Ocurred during map operation execution", e);
        }
        return reply;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] appExecuteUnordered(byte[] command, MessageContext msgCtx) {
        byte[] reply = null;
        Object key = null;
        Object value = null;
        boolean hasReply = false;
        try {
            Throwable throwable = null;
            Object var8_10 = null;
            try {
                ByteArrayInputStream byteIn = new ByteArrayInputStream(command);
                try {
                    block33: {
                        ObjectInputStream objIn = new ObjectInputStream(byteIn);
                        try {
                            block32: {
                                ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
                                try {
                                    try (ObjectOutputStream objOut = new ObjectOutputStream(byteOut);){
                                        MapRequestType reqType = (MapRequestType)((Object)objIn.readObject());
                                        switch (reqType) {
                                            case GET: {
                                                key = objIn.readObject();
                                                value = this.replicaMap.get(key);
                                                if (value == null) break;
                                                objOut.writeObject(value);
                                                hasReply = true;
                                                break;
                                            }
                                            case SIZE: {
                                                int size = this.replicaMap.size();
                                                objOut.writeInt(size);
                                                hasReply = true;
                                                break;
                                            }
                                            case KEYSET: {
                                                this.keySet(objOut);
                                                hasReply = true;
                                                break;
                                            }
                                            default: {
                                                this.logger.log(Level.WARNING, "in appExecuteUnordered only read operations are supported");
                                            }
                                        }
                                        if (hasReply) {
                                            objOut.flush();
                                            byteOut.flush();
                                            reply = byteOut.toByteArray();
                                        } else {
                                            reply = new byte[]{};
                                        }
                                    }
                                    if (byteOut == null) break block32;
                                }
                                catch (Throwable throwable2) {
                                    if (throwable == null) {
                                        throwable = throwable2;
                                    } else if (throwable != throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                    if (byteOut == null) throw throwable;
                                    byteOut.close();
                                    throw throwable;
                                }
                                byteOut.close();
                            }
                            if (objIn == null) break block33;
                        }
                        catch (Throwable throwable3) {
                            if (throwable == null) {
                                throwable = throwable3;
                            } else if (throwable != throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            if (objIn == null) throw throwable;
                            objIn.close();
                            throw throwable;
                        }
                        objIn.close();
                    }
                    if (byteIn == null) return reply;
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    if (byteIn == null) throw throwable;
                    byteIn.close();
                    throw throwable;
                }
                byteIn.close();
                return reply;
            }
            catch (Throwable throwable5) {
                if (throwable == null) {
                    throwable = throwable5;
                    throw throwable;
                }
                if (throwable == throwable5) throw throwable;
                throwable.addSuppressed(throwable5);
                throw throwable;
            }
        }
        catch (IOException | ClassNotFoundException e) {
            this.logger.log(Level.SEVERE, "Ocurred during map operation execution", e);
        }
        return reply;
    }

    private void keySet(ObjectOutput out) throws IOException, ClassNotFoundException {
        Set<K> keySet = this.replicaMap.keySet();
        int size = this.replicaMap.size();
        out.writeInt(size);
        for (K key : keySet) {
            out.writeObject(key);
        }
    }

    /*
     * Loose catch block
     */
    public byte[] getSnapshot() {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try {
                byte[] byArray;
                ObjectOutputStream objOut;
                ByteArrayOutputStream byteOut;
                block18: {
                    block17: {
                        byteOut = new ByteArrayOutputStream();
                        objOut = new ObjectOutputStream(byteOut);
                        objOut.writeObject(this.replicaMap);
                        byArray = byteOut.toByteArray();
                        if (objOut == null) break block17;
                        objOut.close();
                    }
                    if (byteOut == null) break block18;
                    byteOut.close();
                }
                return byArray;
                {
                    catch (Throwable throwable2) {
                        try {
                            if (objOut != null) {
                                objOut.close();
                            }
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (throwable == null) {
                                throwable = throwable3;
                            } else if (throwable != throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            if (byteOut != null) {
                                byteOut.close();
                            }
                            throw throwable;
                        }
                    }
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            this.logger.log(Level.SEVERE, "Error while taking snapshot", e);
            return new byte[0];
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void installSnapshot(byte[] state) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try {
                ByteArrayInputStream byteIn = new ByteArrayInputStream(state);
                try {
                    try (ObjectInputStream objIn = new ObjectInputStream(byteIn);){
                        this.replicaMap = (Map)objIn.readObject();
                    }
                    if (byteIn == null) return;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (byteIn == null) throw throwable;
                    byteIn.close();
                    throw throwable;
                }
                byteIn.close();
                return;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (IOException | ClassNotFoundException e) {
            this.logger.log(Level.SEVERE, "Error while installing snapshot", e);
        }
    }
}

