/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.codegen;

import com.squareup.javapoet.ArrayTypeName;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import java.io.IOException;
import java.lang.reflect.Type;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.List;
import javax.lang.model.element.Modifier;
import org.web3j.abi.datatypes.Bytes;
import org.web3j.abi.datatypes.Int;
import org.web3j.abi.datatypes.StaticArray;
import org.web3j.abi.datatypes.Uint;
import org.web3j.codegen.Generator;

public class AbiTypesGenerator
extends Generator {
    private static final String CODEGEN_WARNING = AbiTypesGenerator.buildWarning(AbiTypesGenerator.class);
    private static final String DEFAULT = "DEFAULT";

    public static void main(String[] args) throws Exception {
        AbiTypesGenerator abiTypesGenerator = new AbiTypesGenerator();
        if (args.length == 1) {
            abiTypesGenerator.generate(args[0]);
        } else {
            abiTypesGenerator.generate(System.getProperty("user.dir") + "/abi/src/main/java/");
        }
    }

    private void generate(String destinationDir) throws IOException {
        this.generateIntTypes(Int.class, destinationDir);
        this.generateIntTypes(Uint.class, destinationDir);
        this.generateBytesTypes(destinationDir);
        this.generateStaticArrayTypes(destinationDir);
    }

    private <T extends org.web3j.abi.datatypes.Type> void generateIntTypes(Class<T> superclass, String path) throws IOException {
        String packageName = AbiTypesGenerator.createPackageName(superclass);
        for (int bitSize = 8; bitSize <= 256; bitSize += 8) {
            ClassName className = ClassName.get(packageName, superclass.getSimpleName() + bitSize, new String[0]);
            MethodSpec constructorSpec = MethodSpec.constructorBuilder().addModifiers(Modifier.PUBLIC).addParameter((Type)((Object)BigInteger.class), "value", new Modifier[0]).addStatement("super($L, $N)", bitSize, "value").build();
            MethodSpec overideConstructorSpec = MethodSpec.constructorBuilder().addModifiers(Modifier.PUBLIC).addParameter(Long.TYPE, "value", new Modifier[0]).addStatement("this(BigInteger.valueOf(value))", new Object[0]).build();
            FieldSpec defaultFieldSpec = FieldSpec.builder(className, DEFAULT, Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL).initializer("new $T(BigInteger.ZERO)", className).build();
            TypeSpec intType = TypeSpec.classBuilder(className.simpleName()).addJavadoc(CODEGEN_WARNING, new Object[0]).superclass(superclass).addModifiers(Modifier.PUBLIC).addField(defaultFieldSpec).addMethods(Arrays.asList(constructorSpec, overideConstructorSpec)).build();
            this.write(packageName, intType, path);
        }
    }

    private <T extends org.web3j.abi.datatypes.Type> void generateFixedTypes(Class<T> superclass, String path) throws IOException {
        String packageName = AbiTypesGenerator.createPackageName(superclass);
        for (int mBitSize = 8; mBitSize < 256; mBitSize += 8) {
            for (int nBitSize = 8; nBitSize < 256 && mBitSize + nBitSize <= 256; nBitSize += 8) {
                MethodSpec constructorSpec1 = MethodSpec.constructorBuilder().addModifiers(Modifier.PUBLIC).addParameter((Type)((Object)BigInteger.class), "value", new Modifier[0]).addStatement("super($L, $L, $N)", mBitSize, nBitSize, "value").build();
                MethodSpec constructorSpec2 = MethodSpec.constructorBuilder().addModifiers(Modifier.PUBLIC).addParameter(Integer.TYPE, "mBitSize", new Modifier[0]).addParameter(Integer.TYPE, "nBitSize", new Modifier[0]).addParameter((Type)((Object)BigInteger.class), "m", new Modifier[0]).addParameter((Type)((Object)BigInteger.class), "n", new Modifier[0]).addStatement("super($L, $L, $N, $N)", mBitSize, nBitSize, "m", "n").build();
                ClassName className = ClassName.get(packageName, superclass.getSimpleName() + mBitSize + "x" + nBitSize, new String[0]);
                FieldSpec defaultFieldSpec = FieldSpec.builder(className, DEFAULT, Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL).initializer("new $T(BigInteger.ZERO)", className).build();
                TypeSpec fixedType = TypeSpec.classBuilder(className.simpleName()).addJavadoc(CODEGEN_WARNING, new Object[0]).superclass(superclass).addModifiers(Modifier.PUBLIC).addField(defaultFieldSpec).addMethod(constructorSpec1).addMethod(constructorSpec2).build();
                this.write(packageName, fixedType, path);
            }
        }
    }

    private <T extends org.web3j.abi.datatypes.Type> void generateBytesTypes(String path) throws IOException {
        String packageName = AbiTypesGenerator.createPackageName(Bytes.class);
        for (int byteSize = 1; byteSize <= 32; ++byteSize) {
            MethodSpec constructorSpec = MethodSpec.constructorBuilder().addModifiers(Modifier.PUBLIC).addParameter((Type)((Object)byte[].class), "value", new Modifier[0]).addStatement("super($L, $N)", byteSize, "value").build();
            ClassName className = ClassName.get(packageName, Bytes.class.getSimpleName() + byteSize, new String[0]);
            FieldSpec defaultFieldSpec = FieldSpec.builder(className, DEFAULT, Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL).initializer("new $T(new byte[$L])", className, byteSize).build();
            TypeSpec bytesType = TypeSpec.classBuilder(className.simpleName()).addJavadoc(CODEGEN_WARNING, new Object[0]).superclass((Type)((Object)Bytes.class)).addModifiers(Modifier.PUBLIC).addField(defaultFieldSpec).addMethod(constructorSpec).build();
            this.write(packageName, bytesType, path);
        }
    }

    private <T extends org.web3j.abi.datatypes.Type> void generateStaticArrayTypes(String path) throws IOException {
        String packageName = AbiTypesGenerator.createPackageName(StaticArray.class);
        for (int length = 1; length <= 32; ++length) {
            TypeVariableName typeVariableName = TypeVariableName.get("T").withBounds(new Type[]{org.web3j.abi.datatypes.Type.class});
            MethodSpec oldConstructorSpec = MethodSpec.constructorBuilder().addAnnotation(Deprecated.class).addModifiers(Modifier.PUBLIC).addParameter(ParameterizedTypeName.get(ClassName.get(List.class), typeVariableName), "values", new Modifier[0]).addStatement("super($L, $N)", length, "values").build();
            MethodSpec oldArrayOverloadConstructorSpec = MethodSpec.constructorBuilder().addAnnotation(Deprecated.class).addAnnotation(SafeVarargs.class).addModifiers(Modifier.PUBLIC).addParameter(ArrayTypeName.of(typeVariableName), "values", new Modifier[0]).varargs().addStatement("super($L, $N)", length, "values").build();
            MethodSpec constructorSpec = MethodSpec.constructorBuilder().addModifiers(Modifier.PUBLIC).addParameter(ParameterizedTypeName.get(ClassName.get(Class.class), typeVariableName), "type", new Modifier[0]).addParameter(ParameterizedTypeName.get(ClassName.get(List.class), typeVariableName), "values", new Modifier[0]).addStatement("super(type, $L, values)", length).build();
            MethodSpec arrayOverloadConstructorSpec = MethodSpec.constructorBuilder().addAnnotation(SafeVarargs.class).addModifiers(Modifier.PUBLIC).addParameter(ParameterizedTypeName.get(ClassName.get(Class.class), typeVariableName), "type", new Modifier[0]).addParameter(ArrayTypeName.of(typeVariableName), "values", new Modifier[0]).varargs().addStatement("super(type, $L, values)", length).build();
            ClassName className = ClassName.get(packageName, StaticArray.class.getSimpleName() + length, new String[0]);
            TypeSpec bytesType = TypeSpec.classBuilder(className.simpleName()).addTypeVariable(typeVariableName).addJavadoc(CODEGEN_WARNING, new Object[0]).superclass(ParameterizedTypeName.get(ClassName.get(StaticArray.class), typeVariableName)).addModifiers(Modifier.PUBLIC).addMethods(Arrays.asList(oldConstructorSpec, oldArrayOverloadConstructorSpec)).addMethods(Arrays.asList(constructorSpec, arrayOverloadConstructorSpec)).build();
            this.write(packageName, bytesType, path);
        }
    }

    static String createPackageName(Class<?> cls) {
        return AbiTypesGenerator.getPackageName(cls) + ".generated";
    }

    static String getPackageName(Class<?> cls) {
        return cls.getPackage().getName();
    }
}

