/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.console;

import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.web3j.codegen.Console;
import org.web3j.console.WalletManager;
import org.web3j.crypto.Credentials;
import org.web3j.crypto.WalletUtils;
import org.web3j.ens.EnsResolver;
import org.web3j.protocol.Web3j;
import org.web3j.protocol.core.methods.response.TransactionReceipt;
import org.web3j.protocol.core.methods.response.Web3ClientVersion;
import org.web3j.protocol.exceptions.TransactionException;
import org.web3j.protocol.http.HttpService;
import org.web3j.protocol.infura.InfuraHttpService;
import org.web3j.tx.Transfer;
import org.web3j.utils.Convert;

public class WalletSendFunds
extends WalletManager {
    private static final String USAGE = "send <walletfile> <destination-address>";

    public static void main(String[] args) {
        if (args.length != 2) {
            Console.exitError(USAGE);
        } else {
            new WalletSendFunds().run(args[0], args[1]);
        }
    }

    private void run(String walletFileLocation, String destinationAddress) {
        File walletFile = new File(walletFileLocation);
        Credentials credentials = this.getCredentials(walletFile);
        this.console.printf("Wallet for address " + credentials.getAddress() + " loaded\n", new Object[0]);
        if (!WalletUtils.isValidAddress(destinationAddress) && !EnsResolver.isValidEnsName(destinationAddress)) {
            Console.exitError("Invalid destination address specified");
        }
        Web3j web3j = this.getEthereumClient();
        BigDecimal amountToTransfer = this.getAmountToTransfer();
        Convert.Unit transferUnit = this.getTransferUnit();
        BigDecimal amountInWei = Convert.toWei(amountToTransfer, transferUnit);
        this.confirmTransfer(amountToTransfer, transferUnit, amountInWei, destinationAddress);
        TransactionReceipt transactionReceipt = this.performTransfer(web3j, destinationAddress, credentials, amountInWei);
        this.console.printf("Funds have been successfully transferred from %s to %s%nTransaction hash: %s%nMined block number: %s%n", credentials.getAddress(), destinationAddress, transactionReceipt.getTransactionHash(), transactionReceipt.getBlockNumber());
    }

    private BigDecimal getAmountToTransfer() {
        String amount = this.console.readLine("What amound would you like to transfer (please enter a numeric value): ", new Object[0]).trim();
        try {
            return new BigDecimal(amount);
        }
        catch (NumberFormatException e) {
            Console.exitError("Invalid amount specified");
            throw new RuntimeException("Application exit failure");
        }
    }

    private Convert.Unit getTransferUnit() {
        String unit = this.console.readLine("Please specify the unit (ether, wei, ...) [ether]: ", new Object[0]).trim();
        Convert.Unit transferUnit = unit.equals("") ? Convert.Unit.ETHER : Convert.Unit.fromString(unit.toLowerCase());
        return transferUnit;
    }

    private void confirmTransfer(BigDecimal amountToTransfer, Convert.Unit transferUnit, BigDecimal amountInWei, String destinationAddress) {
        this.console.printf("Please confim that you wish to transfer %s %s (%s %s) to address %s%n", new Object[]{amountToTransfer.stripTrailingZeros().toPlainString(), transferUnit, amountInWei.stripTrailingZeros().toPlainString(), Convert.Unit.WEI, destinationAddress});
        String confirm = this.console.readLine("Please type 'yes' to proceed: ", new Object[0]).trim();
        if (!confirm.toLowerCase().equals("yes")) {
            Console.exitError("OK, some other time perhaps...");
        }
    }

    private TransactionReceipt performTransfer(Web3j web3j, String destinationAddress, Credentials credentials, BigDecimal amountInWei) {
        this.console.printf("Commencing transfer (this may take a few minutes) ", new Object[0]);
        try {
            CompletableFuture<TransactionReceipt> future = Transfer.sendFunds(web3j, credentials, destinationAddress, amountInWei, Convert.Unit.WEI).sendAsync();
            while (!future.isDone()) {
                this.console.printf(".", new Object[0]);
                Thread.sleep(500L);
            }
            this.console.printf("$%n%n", new Object[0]);
            return (TransactionReceipt)future.get();
        }
        catch (IOException | InterruptedException | ExecutionException | TransactionException e) {
            Console.exitError("Problem encountered transferring funds: \n" + e.getMessage());
            throw new RuntimeException("Application exit failure");
        }
    }

    private Web3j getEthereumClient() {
        String clientAddress = this.console.readLine("Please confirm address of running Ethereum client you wish to send the transfer request to [http://localhost:8545/]: ", new Object[0]).trim();
        Web3j web3j = clientAddress.equals("") ? Web3j.build(new HttpService()) : (clientAddress.contains("infura.io") ? Web3j.build(new InfuraHttpService(clientAddress)) : Web3j.build(new HttpService(clientAddress)));
        try {
            Web3ClientVersion web3ClientVersion = web3j.web3ClientVersion().sendAsync().get();
            if (!web3ClientVersion.hasError()) {
                this.console.printf("Connected successfully to client: %s%n", web3ClientVersion.getWeb3ClientVersion());
                return web3j;
            }
            Console.exitError("Unable to process response from client: " + web3ClientVersion.getError());
        }
        catch (InterruptedException | ExecutionException e) {
            Console.exitError("Problem encountered verifying client: " + e.getMessage());
        }
        throw new RuntimeException("Application exit failure");
    }
}

