/*
 * Decompiled with CFR 0.152.
 */
package picocli;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.LineNumberReader;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StreamTokenizer;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.NetworkInterface;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.text.BreakIterator;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Currency;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.SortedSet;
import java.util.Stack;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandLine {
    public static final String VERSION = "3.0.0";
    private final Tracer tracer = new Tracer();
    private final Model.CommandSpec commandSpec;
    private final Interpreter interpreter;
    private final IFactory factory;

    public CommandLine(Object command) {
        this(command, new DefaultFactory());
    }

    public CommandLine(Object command, IFactory factory) {
        this.factory = Assert.notNull(factory, "factory");
        this.interpreter = new Interpreter();
        this.commandSpec = Model.CommandSpec.forAnnotatedObject(command, factory);
        this.commandSpec.commandLine(this);
        this.commandSpec.validate();
        if (this.commandSpec.unmatchedArgsBindings().size() > 0) {
            this.setUnmatchedArgumentsAllowed(true);
        }
    }

    public Model.CommandSpec getCommandSpec() {
        return this.commandSpec;
    }

    public CommandLine addMixin(String name, Object mixin) {
        this.getCommandSpec().addMixin(name, Model.CommandSpec.forAnnotatedObject(mixin, this.factory));
        return this;
    }

    public Map<String, Object> getMixins() {
        Map<String, Model.CommandSpec> mixins = this.getCommandSpec().mixins();
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        for (String name : mixins.keySet()) {
            result.put(name, mixins.get(name).userObject);
        }
        return result;
    }

    public CommandLine addSubcommand(String name, Object command) {
        CommandLine subcommandLine = CommandLine.toCommandLine(command, this.factory);
        this.getCommandSpec().addSubcommand(name, subcommandLine);
        Model.CommandReflection.initParentCommand(subcommandLine.getCommandSpec().userObject(), this.getCommandSpec().userObject());
        return this;
    }

    public Map<String, CommandLine> getSubcommands() {
        return new LinkedHashMap<String, CommandLine>(this.getCommandSpec().subcommands());
    }

    public CommandLine getParent() {
        Model.CommandSpec parent = this.getCommandSpec().parent();
        return parent == null ? null : parent.commandLine();
    }

    public <T> T getCommand() {
        return (T)this.getCommandSpec().userObject();
    }

    public boolean isUsageHelpRequested() {
        return this.interpreter.parseResult != null && this.interpreter.parseResult.usageHelpRequested;
    }

    public boolean isVersionHelpRequested() {
        return this.interpreter.parseResult != null && this.interpreter.parseResult.versionHelpRequested;
    }

    public boolean isToggleBooleanFlags() {
        return this.getCommandSpec().parser().toggleBooleanFlags();
    }

    public CommandLine setToggleBooleanFlags(boolean newValue) {
        this.getCommandSpec().parser().toggleBooleanFlags(newValue);
        for (CommandLine command : this.getCommandSpec().subcommands().values()) {
            command.setToggleBooleanFlags(newValue);
        }
        return this;
    }

    public boolean isOverwrittenOptionsAllowed() {
        return this.getCommandSpec().parser().overwrittenOptionsAllowed();
    }

    public CommandLine setOverwrittenOptionsAllowed(boolean newValue) {
        this.getCommandSpec().parser().overwrittenOptionsAllowed(newValue);
        for (CommandLine command : this.getCommandSpec().subcommands().values()) {
            command.setOverwrittenOptionsAllowed(newValue);
        }
        return this;
    }

    public boolean isPosixClusteredShortOptionsAllowed() {
        return this.getCommandSpec().parser().posixClusteredShortOptionsAllowed();
    }

    public CommandLine setPosixClusteredShortOptionsAllowed(boolean newValue) {
        this.getCommandSpec().parser().posixClusteredShortOptionsAllowed(newValue);
        for (CommandLine command : this.getCommandSpec().subcommands().values()) {
            command.setPosixClusteredShortOptionsAllowed(newValue);
        }
        return this;
    }

    public boolean isStopAtPositional() {
        return this.getCommandSpec().parser().stopAtPositional();
    }

    public CommandLine setStopAtPositional(boolean newValue) {
        this.getCommandSpec().parser().stopAtPositional(newValue);
        for (CommandLine command : this.getCommandSpec().subcommands().values()) {
            command.setStopAtPositional(newValue);
        }
        return this;
    }

    public boolean isStopAtUnmatched() {
        return this.getCommandSpec().parser().stopAtUnmatched();
    }

    public CommandLine setStopAtUnmatched(boolean newValue) {
        this.getCommandSpec().parser().stopAtUnmatched(newValue);
        for (CommandLine command : this.getCommandSpec().subcommands().values()) {
            command.setStopAtUnmatched(newValue);
        }
        if (newValue) {
            this.setUnmatchedArgumentsAllowed(true);
        }
        return this;
    }

    public boolean isUnmatchedOptionsArePositionalParams() {
        return this.getCommandSpec().parser().unmatchedOptionsArePositionalParams();
    }

    public CommandLine setUnmatchedOptionsArePositionalParams(boolean newValue) {
        this.getCommandSpec().parser().unmatchedOptionsArePositionalParams(newValue);
        for (CommandLine command : this.getCommandSpec().subcommands().values()) {
            command.setUnmatchedOptionsArePositionalParams(newValue);
        }
        return this;
    }

    public boolean isUnmatchedArgumentsAllowed() {
        return this.getCommandSpec().parser().unmatchedArgumentsAllowed();
    }

    public CommandLine setUnmatchedArgumentsAllowed(boolean newValue) {
        this.getCommandSpec().parser().unmatchedArgumentsAllowed(newValue);
        for (CommandLine command : this.getCommandSpec().subcommands().values()) {
            command.setUnmatchedArgumentsAllowed(newValue);
        }
        return this;
    }

    public List<String> getUnmatchedArguments() {
        return this.interpreter.parseResult == null ? Collections.emptyList() : Collections.unmodifiableList(this.interpreter.parseResult.unmatched);
    }

    public static <T> T populateCommand(T command, String ... args) {
        CommandLine cli = CommandLine.toCommandLine(command, new DefaultFactory());
        cli.parse(args);
        return command;
    }

    public List<CommandLine> parse(String ... args) {
        return this.interpreter.parse(args);
    }

    public ParseResult parseArgs(String ... args) {
        this.interpreter.parse(args);
        return this.interpreter.parseResult.build();
    }

    public ParseResult getParseResult() {
        return this.interpreter.parseResult == null ? null : this.interpreter.parseResult.build();
    }

    public static DefaultExceptionHandler<List<Object>> defaultExceptionHandler() {
        return new DefaultExceptionHandler<List<Object>>();
    }

    @Deprecated
    public static boolean printHelpIfRequested(List<CommandLine> parsedCommands, PrintStream out, Help.Ansi ansi) {
        return CommandLine.printHelpIfRequested(parsedCommands, out, out, ansi);
    }

    public static boolean printHelpIfRequested(ParseResult parseResult) {
        return CommandLine.printHelpIfRequested(parseResult.asCommandLineList(), System.out, System.err, Help.Ansi.AUTO);
    }

    public static boolean printHelpIfRequested(List<CommandLine> parsedCommands, PrintStream out, PrintStream err, Help.Ansi ansi) {
        for (int i = 0; i < parsedCommands.size(); ++i) {
            CommandLine parsed = parsedCommands.get(i);
            if (parsed.isUsageHelpRequested()) {
                parsed.usage(out, ansi);
                return true;
            }
            if (parsed.isVersionHelpRequested()) {
                parsed.printVersionHelp(out, ansi);
                return true;
            }
            if (!parsed.getCommandSpec().helpCommand()) continue;
            if (parsed.getCommand() instanceof IHelpCommandInitializable) {
                ((IHelpCommandInitializable)parsed.getCommand()).init(parsed, ansi, out, err);
            }
            CommandLine.execute(parsed, new ArrayList<Object>());
            return true;
        }
        return false;
    }

    private static List<Object> execute(CommandLine parsed, List<Object> executionResult) {
        Object command = parsed.getCommand();
        if (command instanceof Runnable) {
            try {
                ((Runnable)command).run();
                executionResult.add(null);
                return executionResult;
            }
            catch (ParameterException ex) {
                throw ex;
            }
            catch (ExecutionException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new ExecutionException(parsed, "Error while running command (" + command + "): " + ex, ex);
            }
        }
        if (command instanceof Callable) {
            try {
                Callable callable = (Callable)command;
                executionResult.add(callable.call());
                return executionResult;
            }
            catch (ParameterException ex) {
                throw ex;
            }
            catch (ExecutionException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new ExecutionException(parsed, "Error while calling command (" + command + "): " + ex, ex);
            }
        }
        throw new ExecutionException(parsed, "Parsed command (" + command + ") is not Runnable or Callable");
    }

    @Deprecated
    public List<Object> parseWithHandler(IParseResultHandler handler, PrintStream out, String ... args) {
        return this.parseWithHandlers(handler, out, Help.Ansi.AUTO, new DefaultExceptionHandler(), args);
    }

    public <R> R parseWithHandler(IParseResultHandler2<R> handler, String[] args) {
        return this.parseWithHandlers(handler, new DefaultExceptionHandler(), args);
    }

    @Deprecated
    public List<Object> parseWithHandlers(IParseResultHandler handler, PrintStream out, Help.Ansi ansi, IExceptionHandler exceptionHandler, String ... args) {
        try {
            List<CommandLine> result = this.parse(args);
            return handler.handleParseResult(result, out, ansi);
        }
        catch (ParameterException ex) {
            return exceptionHandler.handleException(ex, out, ansi, args);
        }
    }

    public <R> R parseWithHandlers(IParseResultHandler2<R> handler, IExceptionHandler2<R> exceptionHandler, String ... args) {
        ParseResult parseResult = null;
        try {
            parseResult = this.parseArgs(args);
            return handler.handleParseResult(parseResult);
        }
        catch (ParameterException ex) {
            return exceptionHandler.handleParseException(ex, args);
        }
        catch (ExecutionException ex) {
            return exceptionHandler.handleExecutionException(ex, parseResult);
        }
    }

    public static void usage(Object command, PrintStream out) {
        CommandLine.toCommandLine(command, new DefaultFactory()).usage(out);
    }

    public static void usage(Object command, PrintStream out, Help.Ansi ansi) {
        CommandLine.toCommandLine(command, new DefaultFactory()).usage(out, ansi);
    }

    public static void usage(Object command, PrintStream out, Help.ColorScheme colorScheme) {
        CommandLine.toCommandLine(command, new DefaultFactory()).usage(out, colorScheme);
    }

    public void usage(PrintStream out) {
        this.usage(out, Help.Ansi.AUTO);
    }

    public void usage(PrintWriter writer) {
        this.usage(writer, Help.Ansi.AUTO);
    }

    public void usage(PrintStream out, Help.Ansi ansi) {
        this.usage(out, Help.defaultColorScheme(ansi));
    }

    public void usage(PrintWriter writer, Help.Ansi ansi) {
        this.usage(writer, Help.defaultColorScheme(ansi));
    }

    public void usage(PrintStream out, Help.ColorScheme colorScheme) {
        out.print(CommandLine.usage(new StringBuilder(), new Help(this.getCommandSpec(), colorScheme)));
    }

    public void usage(PrintWriter writer, Help.ColorScheme colorScheme) {
        writer.print(CommandLine.usage(new StringBuilder(), new Help(this.getCommandSpec(), colorScheme)));
    }

    private static StringBuilder usage(StringBuilder sb, Help help) {
        return sb.append(help.headerHeading(new Object[0])).append(help.header(new Object[0])).append(help.synopsisHeading(new Object[0])).append(help.synopsis(help.synopsisHeadingLength())).append(help.descriptionHeading(new Object[0])).append(help.description(new Object[0])).append(help.parameterListHeading(new Object[0])).append(help.parameterList()).append(help.optionListHeading(new Object[0])).append(help.optionList()).append(help.commandListHeading(new Object[0])).append(help.commandList()).append(help.footerHeading(new Object[0])).append(help.footer(new Object[0]));
    }

    public void printVersionHelp(PrintStream out) {
        this.printVersionHelp(out, Help.Ansi.AUTO);
    }

    public void printVersionHelp(PrintStream out, Help.Ansi ansi) {
        for (String versionInfo : this.getCommandSpec().version()) {
            Help.Ansi ansi2 = ansi;
            ((Object)((Object)ansi2)).getClass();
            out.println(ansi2.new Help.Ansi.Text(versionInfo));
        }
    }

    public void printVersionHelp(PrintStream out, Help.Ansi ansi, Object ... params) {
        for (String versionInfo : this.getCommandSpec().version()) {
            Help.Ansi ansi2 = ansi;
            ((Object)((Object)ansi2)).getClass();
            out.println(ansi2.new Help.Ansi.Text(String.format(versionInfo, params)));
        }
    }

    public static <C extends Callable<T>, T> T call(C callable, String ... args) {
        return CommandLine.call(callable, System.out, System.err, Help.Ansi.AUTO, args);
    }

    public static <C extends Callable<T>, T> T call(C callable, PrintStream out, String ... args) {
        return CommandLine.call(callable, out, System.err, Help.Ansi.AUTO, args);
    }

    public static <C extends Callable<T>, T> T call(C callable, PrintStream out, Help.Ansi ansi, String ... args) {
        return CommandLine.call(callable, out, System.err, ansi, args);
    }

    public static <C extends Callable<T>, T> T call(C callable, PrintStream out, PrintStream err, Help.Ansi ansi, String ... args) {
        CommandLine cmd = new CommandLine(callable);
        List results = (List)cmd.parseWithHandlers((IParseResultHandler2)((AbstractParseResultHandler)new RunLast().useOut(out)).useAnsi(ansi), (IExceptionHandler2)((DefaultExceptionHandler)new DefaultExceptionHandler().useErr(err)).useAnsi(ansi), args);
        T result = results == null || results.isEmpty() ? null : (T)results.get(0);
        return result;
    }

    public static <R extends Runnable> void run(R runnable, String ... args) {
        CommandLine.run(runnable, System.out, System.err, Help.Ansi.AUTO, args);
    }

    public static <R extends Runnable> void run(R runnable, PrintStream out, String ... args) {
        CommandLine.run(runnable, out, System.err, Help.Ansi.AUTO, args);
    }

    public static <R extends Runnable> void run(R runnable, PrintStream out, Help.Ansi ansi, String ... args) {
        CommandLine.run(runnable, out, System.err, ansi, args);
    }

    public static <R extends Runnable> void run(R runnable, PrintStream out, PrintStream err, Help.Ansi ansi, String ... args) {
        CommandLine cmd = new CommandLine(runnable);
        cmd.parseWithHandlers((IParseResultHandler2)((AbstractParseResultHandler)new RunLast().useOut(out)).useAnsi(ansi), (IExceptionHandler2)((DefaultExceptionHandler)new DefaultExceptionHandler().useErr(err)).useAnsi(ansi), args);
    }

    public <K> CommandLine registerConverter(Class<K> cls, ITypeConverter<K> converter) {
        this.interpreter.converterRegistry.put(Assert.notNull(cls, "class"), Assert.notNull(converter, "converter"));
        for (CommandLine command : this.getCommandSpec().commands.values()) {
            command.registerConverter(cls, converter);
        }
        return this;
    }

    public String getSeparator() {
        return this.getCommandSpec().parser().separator();
    }

    public CommandLine setSeparator(String separator) {
        this.getCommandSpec().parser().separator(Assert.notNull(separator, "separator"));
        for (CommandLine command : this.getCommandSpec().subcommands().values()) {
            command.setSeparator(separator);
        }
        return this;
    }

    public int getUsageHelpWidth() {
        return this.getCommandSpec().usageMessage().width();
    }

    public CommandLine setUsageHelpWidth(int width) {
        this.getCommandSpec().usageMessage().width(width);
        for (CommandLine command : this.getCommandSpec().subcommands().values()) {
            command.setUsageHelpWidth(width);
        }
        return this;
    }

    public String getCommandName() {
        return this.getCommandSpec().name();
    }

    public CommandLine setCommandName(String commandName) {
        this.getCommandSpec().name(Assert.notNull(commandName, "commandName"));
        return this;
    }

    public boolean isExpandAtFiles() {
        return this.getCommandSpec().parser().expandAtFiles();
    }

    public CommandLine setExpandAtFiles(boolean expandAtFiles) {
        this.getCommandSpec().parser().expandAtFiles(expandAtFiles);
        return this;
    }

    private static boolean empty(String str) {
        return str == null || str.trim().length() == 0;
    }

    private static boolean empty(Object[] array) {
        return array == null || array.length == 0;
    }

    private static String str(String[] arr, int i) {
        return arr == null || arr.length == 0 ? "" : arr[i];
    }

    private static boolean isBoolean(Class<?> type) {
        return type == Boolean.class || type == Boolean.TYPE;
    }

    private static CommandLine toCommandLine(Object obj, IFactory factory) {
        return obj instanceof CommandLine ? (CommandLine)obj : new CommandLine(obj, factory);
    }

    private static boolean isMultiValue(Field field) {
        return CommandLine.isMultiValue(field.getType());
    }

    private static boolean isMultiValue(Class<?> cls) {
        return cls.isArray() || Collection.class.isAssignableFrom(cls) || Map.class.isAssignableFrom(cls);
    }

    static IFactory defaultFactory() {
        return new DefaultFactory();
    }

    private static void validatePositionalParameters(List<Model.PositionalParamSpec> positionalParametersFields) {
        int min = 0;
        for (Model.PositionalParamSpec positional : positionalParametersFields) {
            Range index = positional.index();
            if (index.min > min) {
                throw new ParameterIndexGapException("Missing positional parameter with index=" + min + ". Nearest positional parameter '" + positional.paramLabel() + "' has index=" + index.min);
            }
            min = (min = Math.max(min, index.max)) == Integer.MAX_VALUE ? min : min + 1;
        }
    }

    private static Stack<String> copy(Stack<String> stack) {
        return (Stack)stack.clone();
    }

    private static <T> Stack<T> reverse(Stack<T> stack) {
        Collections.reverse(stack);
        return stack;
    }

    private static <T> List<T> reverseList(List<T> list) {
        Collections.reverse(list);
        return list;
    }

    public static class MissingTypeConverterException
    extends ParameterException {
        private static final long serialVersionUID = -6050931703233083760L;

        public MissingTypeConverterException(CommandLine commandLine, String msg) {
            super(commandLine, msg);
        }
    }

    public static class OverwrittenOptionException
    extends ParameterException {
        private static final long serialVersionUID = 1338029208271055776L;

        public OverwrittenOptionException(CommandLine commandLine, String msg) {
            super(commandLine, msg);
        }
    }

    public static class MaxValuesExceededException
    extends ParameterException {
        private static final long serialVersionUID = 6536145439570100641L;

        public MaxValuesExceededException(CommandLine commandLine, String msg) {
            super(commandLine, msg);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class UnmatchedArgumentException
    extends ParameterException {
        private static final long serialVersionUID = -8700426380701452440L;

        public UnmatchedArgumentException(CommandLine commandLine, String msg) {
            super(commandLine, msg);
        }

        public UnmatchedArgumentException(CommandLine commandLine, Stack<String> args) {
            this(commandLine, new ArrayList<String>(CommandLine.reverse(args)));
        }

        public UnmatchedArgumentException(CommandLine commandLine, List<String> args) {
            this(commandLine, "Unmatched argument" + (args.size() == 1 ? " " : "s ") + args);
        }
    }

    public static class ParameterIndexGapException
    extends InitializationException {
        private static final long serialVersionUID = -1520981133257618319L;

        public ParameterIndexGapException(String msg) {
            super(msg);
        }
    }

    public static class DuplicateOptionAnnotationsException
    extends InitializationException {
        private static final long serialVersionUID = -3355128012575075641L;

        public DuplicateOptionAnnotationsException(String msg) {
            super(msg);
        }

        private static DuplicateOptionAnnotationsException create(String name, Model.ArgSpec argSpec1, Model.ArgSpec argSpec2) {
            return new DuplicateOptionAnnotationsException("Option name '" + name + "' is used by both " + argSpec1.toString() + " and " + argSpec2.toString());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MissingParameterException
    extends ParameterException {
        private static final long serialVersionUID = 5075678535706338753L;
        private final List<Model.ArgSpec> missing;

        public MissingParameterException(CommandLine commandLine, Model.ArgSpec missing, String msg) {
            this(commandLine, Arrays.asList(missing), msg);
        }

        public MissingParameterException(CommandLine commandLine, Collection<Model.ArgSpec> missing, String msg) {
            super(commandLine, msg);
            this.missing = Collections.unmodifiableList(new ArrayList<Model.ArgSpec>(missing));
        }

        public List<Model.ArgSpec> getMissing() {
            return this.missing;
        }

        private static MissingParameterException create(CommandLine cmd, Collection<Model.ArgSpec> missing, String separator) {
            if (missing.size() == 1) {
                return new MissingParameterException(cmd, missing, "Missing required option '" + MissingParameterException.describe(missing.iterator().next(), separator) + "'");
            }
            ArrayList<String> names = new ArrayList<String>(missing.size());
            for (Model.ArgSpec argSpec : missing) {
                names.add(MissingParameterException.describe(argSpec, separator));
            }
            return new MissingParameterException(cmd, missing, "Missing required options " + ((Object)names).toString());
        }

        private static String describe(Model.ArgSpec argSpec, String separator) {
            String prefix = argSpec.isOption() ? ((Model.OptionSpec)argSpec).longestName() + separator : "params[" + ((Model.PositionalParamSpec)argSpec).index() + "]" + separator;
            return prefix + argSpec.paramLabel();
        }
    }

    public static class ParameterException
    extends PicocliException {
        private static final long serialVersionUID = 1477112829129763139L;
        private final CommandLine commandLine;

        public ParameterException(CommandLine commandLine, String msg) {
            super(msg);
            this.commandLine = Assert.notNull(commandLine, "commandLine");
        }

        public ParameterException(CommandLine commandLine, String msg, Exception ex) {
            super(msg, ex);
            this.commandLine = Assert.notNull(commandLine, "commandLine");
        }

        public CommandLine getCommandLine() {
            return this.commandLine;
        }

        private static ParameterException create(CommandLine cmd, Exception ex, String arg, int i, String[] args) {
            String msg = ex.getClass().getSimpleName() + ": " + ex.getLocalizedMessage() + " while processing argument at or before arg[" + i + "] '" + arg + "' in " + Arrays.toString(args) + ": " + ex.toString();
            return new ParameterException(cmd, msg, ex);
        }
    }

    public static class TypeConversionException
    extends PicocliException {
        private static final long serialVersionUID = 4251973913816346114L;

        public TypeConversionException(String msg) {
            super(msg);
        }
    }

    public static class ExecutionException
    extends PicocliException {
        private static final long serialVersionUID = 7764539594267007998L;
        private final CommandLine commandLine;

        public ExecutionException(CommandLine commandLine, String msg) {
            super(msg);
            this.commandLine = Assert.notNull(commandLine, "commandLine");
        }

        public ExecutionException(CommandLine commandLine, String msg, Exception ex) {
            super(msg, ex);
            this.commandLine = Assert.notNull(commandLine, "commandLine");
        }

        public CommandLine getCommandLine() {
            return this.commandLine;
        }
    }

    public static class InitializationException
    extends PicocliException {
        private static final long serialVersionUID = 8423014001666638895L;

        public InitializationException(String msg) {
            super(msg);
        }

        public InitializationException(String msg, Exception ex) {
            super(msg, ex);
        }
    }

    public static class PicocliException
    extends RuntimeException {
        private static final long serialVersionUID = -2574128880125050818L;

        public PicocliException(String msg) {
            super(msg);
        }

        public PicocliException(String msg, Exception ex) {
            super(msg, ex);
        }
    }

    private static class Tracer {
        TraceLevel level = TraceLevel.lookup(System.getProperty("picocli.trace"));
        PrintStream stream = System.err;

        private Tracer() {
        }

        void warn(String msg, Object ... params) {
            TraceLevel.WARN.print(this, msg, params);
        }

        void info(String msg, Object ... params) {
            TraceLevel.INFO.print(this, msg, params);
        }

        void debug(String msg, Object ... params) {
            TraceLevel.DEBUG.print(this, msg, params);
        }

        boolean isWarn() {
            return this.level.isEnabled(TraceLevel.WARN);
        }

        boolean isInfo() {
            return this.level.isEnabled(TraceLevel.INFO);
        }

        boolean isDebug() {
            return this.level.isEnabled(TraceLevel.DEBUG);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum TraceLevel {
        OFF,
        WARN,
        INFO,
        DEBUG;


        public boolean isEnabled(TraceLevel other) {
            return this.ordinal() >= other.ordinal();
        }

        private void print(Tracer tracer, String msg, Object ... params) {
            if (tracer.level.isEnabled(this)) {
                tracer.stream.printf(this.prefix(msg), params);
            }
        }

        private String prefix(String msg) {
            return "[picocli " + (Object)((Object)this) + "] " + msg;
        }

        static TraceLevel lookup(String key) {
            return key == null ? WARN : (CommandLine.empty(key) || "true".equalsIgnoreCase(key) ? INFO : TraceLevel.valueOf(key));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Assert {
        static <T> T notNull(T object, String description) {
            if (object == null) {
                throw new NullPointerException(description);
            }
            return object;
        }

        static boolean equals(Object obj1, Object obj2) {
            return obj1 == null ? obj2 == null : obj1.equals(obj2);
        }

        static int hashCode(Object obj) {
            return obj == null ? 0 : obj.hashCode();
        }

        static int hashCode(boolean bool) {
            return bool ? 1 : 0;
        }

        private Assert() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Help {
        protected static final String DEFAULT_COMMAND_NAME = "<main class>";
        protected static final String DEFAULT_SEPARATOR = "=";
        private static final int defaultOptionsColumnWidth = 24;
        private final Model.CommandSpec commandSpec;
        private final ColorScheme colorScheme;
        private final Map<String, Help> commands = new LinkedHashMap<String, Help>();
        private IParamLabelRenderer parameterLabelRenderer;

        public Help(Object command) {
            this(command, Ansi.AUTO);
        }

        public Help(Object command, Ansi ansi) {
            this(command, Help.defaultColorScheme(ansi));
        }

        @Deprecated
        public Help(Object command, ColorScheme colorScheme) {
            this(Model.CommandSpec.forAnnotatedObject(command, new DefaultFactory()), colorScheme);
        }

        public Help(Model.CommandSpec commandSpec, ColorScheme colorScheme) {
            this.commandSpec = Assert.notNull(commandSpec, "commandSpec");
            this.addAllSubcommands(commandSpec.subcommands());
            this.colorScheme = Assert.notNull(colorScheme, "colorScheme").applySystemProperties();
            this.parameterLabelRenderer = this.createDefaultParamLabelRenderer();
        }

        Model.CommandSpec commandSpec() {
            return this.commandSpec;
        }

        public ColorScheme colorScheme() {
            return this.colorScheme;
        }

        public IParamLabelRenderer parameterLabelRenderer() {
            return this.parameterLabelRenderer;
        }

        public Help addAllSubcommands(Map<String, CommandLine> commands) {
            if (commands != null) {
                for (Map.Entry<String, CommandLine> entry : commands.entrySet()) {
                    if (entry.getValue().getCommandSpec().usageMessage().hidden()) continue;
                    this.addSubcommand(entry.getKey(), entry.getValue());
                }
            }
            return this;
        }

        Help addSubcommand(String commandName, CommandLine commandLine) {
            this.commands.put(commandName, new Help(commandLine.commandSpec));
            return this;
        }

        @Deprecated
        public Help addSubcommand(String commandName, Object command) {
            this.commands.put(commandName, new Help(Model.CommandSpec.forAnnotatedObject(command, this.commandSpec.commandLine().factory)));
            return this;
        }

        List<Model.OptionSpec> options() {
            return this.commandSpec.options();
        }

        List<Model.PositionalParamSpec> positionalParameters() {
            return this.commandSpec.positionalParameters();
        }

        String commandName() {
            return this.commandSpec.name();
        }

        @Deprecated
        public String synopsis() {
            return this.synopsis(0);
        }

        public String synopsis(int synopsisHeadingLength) {
            if (!CommandLine.empty(this.commandSpec.usageMessage().customSynopsis())) {
                return this.customSynopsis(new Object[0]);
            }
            return this.commandSpec.usageMessage().abbreviateSynopsis() ? this.abbreviatedSynopsis() : this.detailedSynopsis(synopsisHeadingLength, Help.createShortOptionArityAndNameComparator(), true);
        }

        public String abbreviatedSynopsis() {
            StringBuilder sb = new StringBuilder();
            if (!this.commandSpec.optionsMap().isEmpty()) {
                sb.append(" [OPTIONS]");
            }
            for (Model.PositionalParamSpec positionalParam : this.commandSpec.positionalParameters()) {
                if (positionalParam.hidden()) continue;
                sb.append(' ').append(this.parameterLabelRenderer().renderParameterLabel(positionalParam, this.ansi(), this.colorScheme.parameterStyles));
            }
            if (!this.commandSpec.subcommands().isEmpty()) {
                sb.append(" [COMMAND]");
            }
            return this.colorScheme.commandText(this.commandSpec.name()).toString() + sb.toString() + System.getProperty("line.separator");
        }

        @Deprecated
        public String detailedSynopsis(Comparator<Model.OptionSpec> optionSort, boolean clusterBooleanOptions) {
            return this.detailedSynopsis(0, optionSort, clusterBooleanOptions);
        }

        public String detailedSynopsis(int synopsisHeadingLength, Comparator<Model.OptionSpec> optionSort, boolean clusterBooleanOptions) {
            Ansi ansi = this.ansi();
            ((Object)((Object)ansi)).getClass();
            Ansi.Text optionText = ansi.new Ansi.Text(0);
            ArrayList<Model.OptionSpec> options = new ArrayList<Model.OptionSpec>(this.commandSpec.options());
            if (optionSort != null) {
                Collections.sort(options, optionSort);
            }
            if (clusterBooleanOptions) {
                ArrayList<Model.OptionSpec> booleanOptions = new ArrayList<Model.OptionSpec>();
                StringBuilder clusteredRequired = new StringBuilder("-");
                StringBuilder clusteredOptional = new StringBuilder("-");
                for (Model.OptionSpec option : options) {
                    String shortestName;
                    if (option.hidden() || option.type() != Boolean.TYPE && option.type() != Boolean.class || (shortestName = ShortestFirst.sort(option.names())[0]).length() != 2 || !shortestName.startsWith("-")) continue;
                    booleanOptions.add(option);
                    if (option.required()) {
                        clusteredRequired.append(shortestName.substring(1));
                        continue;
                    }
                    clusteredOptional.append(shortestName.substring(1));
                }
                options.removeAll(booleanOptions);
                if (clusteredRequired.length() > 1) {
                    optionText = optionText.concat(" ").concat(this.colorScheme.optionText(clusteredRequired.toString()));
                }
                if (clusteredOptional.length() > 1) {
                    optionText = optionText.concat(" [").concat(this.colorScheme.optionText(clusteredOptional.toString())).concat("]");
                }
            }
            for (Model.OptionSpec option : options) {
                if (option.hidden()) continue;
                if (option.required()) {
                    optionText = this.appendOptionSynopsis(optionText, option, ShortestFirst.sort(option.names())[0], " ", "");
                    if (!option.isMultiValue()) continue;
                    optionText = this.appendOptionSynopsis(optionText, option, ShortestFirst.sort(option.names())[0], " [", "]...");
                    continue;
                }
                optionText = this.appendOptionSynopsis(optionText, option, ShortestFirst.sort(option.names())[0], " [", "]");
                if (!option.isMultiValue()) continue;
                optionText = optionText.concat("...");
            }
            for (Model.PositionalParamSpec positionalParam : this.commandSpec.positionalParameters()) {
                if (positionalParam.hidden()) continue;
                optionText = optionText.concat(" ");
                Ansi.Text label = this.parameterLabelRenderer().renderParameterLabel(positionalParam, this.colorScheme.ansi(), this.colorScheme.parameterStyles);
                optionText = optionText.concat(label);
            }
            if (!this.commandSpec.subcommands().isEmpty()) {
                optionText = optionText.concat(" [").concat("COMMAND").concat("]");
            }
            String commandName = this.commandSpec.name();
            int firstColumnLength = commandName.length() + synopsisHeadingLength;
            TextTable textTable = TextTable.forColumnWidths(this.ansi(), firstColumnLength, this.width() - firstColumnLength);
            textTable.indentWrappedLines = 1;
            Ansi ansi2 = Ansi.OFF;
            ((Object)((Object)ansi2)).getClass();
            Ansi.Text PADDING = ansi2.new Ansi.Text(Help.stringOf('X', synopsisHeadingLength));
            textTable.addRowValues(PADDING.concat(this.colorScheme.commandText(commandName)), optionText);
            return textTable.toString().substring(synopsisHeadingLength);
        }

        private Ansi.Text appendOptionSynopsis(Ansi.Text optionText, Model.OptionSpec option, String optionName, String prefix, String suffix) {
            Ansi.Text optionParamText = this.parameterLabelRenderer().renderParameterLabel(option, this.colorScheme.ansi(), this.colorScheme.optionParamStyles);
            return optionText.concat(prefix).concat(this.colorScheme.optionText(optionName)).concat(optionParamText).concat(suffix);
        }

        public int synopsisHeadingLength() {
            Ansi ansi = Ansi.OFF;
            ((Object)((Object)ansi)).getClass();
            String[] lines = ansi.new Ansi.Text(this.commandSpec.usageMessage().synopsisHeading()).toString().split("\\r?\\n|\\r|%n", -1);
            return lines[lines.length - 1].length();
        }

        public String optionList() {
            Comparator<Model.OptionSpec> sortOrder = this.commandSpec.usageMessage().sortOptions() ? Help.createShortOptionNameComparator() : null;
            return this.optionList(this.createLayout(this.calcLongOptionColumnWidth()), sortOrder, this.parameterLabelRenderer());
        }

        private int calcLongOptionColumnWidth() {
            int max = 0;
            DefaultOptionRenderer optionRenderer = new DefaultOptionRenderer(false, " ");
            for (Model.OptionSpec option : this.commandSpec.options()) {
                Ansi.Text[][] values = optionRenderer.render(option, this.parameterLabelRenderer(), this.colorScheme);
                int len = values[0][3].length;
                if (len >= 21) continue;
                max = Math.max(max, len);
            }
            DefaultParameterRenderer paramRenderer = new DefaultParameterRenderer(false, " ");
            for (Model.PositionalParamSpec positional : this.commandSpec.positionalParameters()) {
                Ansi.Text[][] values = paramRenderer.render(positional, this.parameterLabelRenderer(), this.colorScheme);
                int len = values[0][3].length;
                if (len >= 21) continue;
                max = Math.max(max, len);
            }
            return max + 3;
        }

        public String optionList(Layout layout, Comparator<Model.OptionSpec> optionSort, IParamLabelRenderer valueLabelRenderer) {
            ArrayList<Model.OptionSpec> options = new ArrayList<Model.OptionSpec>(this.commandSpec.options());
            if (optionSort != null) {
                Collections.sort(options, optionSort);
            }
            layout.addOptions(options, valueLabelRenderer);
            return layout.toString();
        }

        public String parameterList() {
            return this.parameterList(this.createLayout(this.calcLongOptionColumnWidth()), this.parameterLabelRenderer());
        }

        public String parameterList(Layout layout, IParamLabelRenderer paramLabelRenderer) {
            layout.addPositionalParameters(this.commandSpec.positionalParameters(), paramLabelRenderer);
            return layout.toString();
        }

        private static String heading(Ansi ansi, int usageWidth, String values, Object ... params) {
            StringBuilder sb = Help.join(ansi, usageWidth, new String[]{values}, new StringBuilder(), params);
            String result = sb.toString();
            result = result.endsWith(System.getProperty("line.separator")) ? result.substring(0, result.length() - System.getProperty("line.separator").length()) : result;
            return result + new String(Help.spaces(Help.countTrailingSpaces(values)));
        }

        private static char[] spaces(int length) {
            char[] result = new char[length];
            Arrays.fill(result, ' ');
            return result;
        }

        private static int countTrailingSpaces(String str) {
            if (str == null) {
                return 0;
            }
            int trailingSpaces = 0;
            for (int i = str.length() - 1; i >= 0 && str.charAt(i) == ' '; --i) {
                ++trailingSpaces;
            }
            return trailingSpaces;
        }

        public static StringBuilder join(Ansi ansi, int usageHelpWidth, String[] values, StringBuilder sb, Object ... params) {
            if (values != null) {
                TextTable table = TextTable.forColumnWidths(ansi, usageHelpWidth);
                table.indentWrappedLines = 0;
                for (String summaryLine : values) {
                    Ansi.Text[] lines;
                    Ansi ansi2 = ansi;
                    ((Object)((Object)ansi2)).getClass();
                    for (Ansi.Text line : lines = ansi2.new Ansi.Text(Help.format(summaryLine, params)).splitLines()) {
                        table.addRowValues(line);
                    }
                }
                table.toString(sb);
            }
            return sb;
        }

        private static String format(String formatString, Object ... params) {
            return formatString == null ? "" : String.format(formatString, params);
        }

        private int width() {
            return this.commandSpec.usageMessage().width();
        }

        public String customSynopsis(Object ... params) {
            return Help.join(this.ansi(), this.width(), this.commandSpec.usageMessage().customSynopsis(), new StringBuilder(), params).toString();
        }

        public String description(Object ... params) {
            return Help.join(this.ansi(), this.width(), this.commandSpec.usageMessage().description(), new StringBuilder(), params).toString();
        }

        public String header(Object ... params) {
            return Help.join(this.ansi(), this.width(), this.commandSpec.usageMessage().header(), new StringBuilder(), params).toString();
        }

        public String footer(Object ... params) {
            return Help.join(this.ansi(), this.width(), this.commandSpec.usageMessage().footer(), new StringBuilder(), params).toString();
        }

        public String headerHeading(Object ... params) {
            return Help.heading(this.ansi(), this.width(), this.commandSpec.usageMessage().headerHeading(), params);
        }

        public String synopsisHeading(Object ... params) {
            return Help.heading(this.ansi(), this.width(), this.commandSpec.usageMessage().synopsisHeading(), params);
        }

        public String descriptionHeading(Object ... params) {
            return CommandLine.empty(this.commandSpec.usageMessage().descriptionHeading()) ? "" : Help.heading(this.ansi(), this.width(), this.commandSpec.usageMessage().descriptionHeading(), params);
        }

        public String parameterListHeading(Object ... params) {
            return this.commandSpec.positionalParameters().isEmpty() ? "" : Help.heading(this.ansi(), this.width(), this.commandSpec.usageMessage().parameterListHeading(), params);
        }

        public String optionListHeading(Object ... params) {
            return this.commandSpec.optionsMap().isEmpty() ? "" : Help.heading(this.ansi(), this.width(), this.commandSpec.usageMessage().optionListHeading(), params);
        }

        public String commandListHeading(Object ... params) {
            return this.commands.isEmpty() ? "" : Help.heading(this.ansi(), this.width(), this.commandSpec.usageMessage().commandListHeading(), params);
        }

        public String footerHeading(Object ... params) {
            return Help.heading(this.ansi(), this.width(), this.commandSpec.usageMessage().footerHeading(), params);
        }

        public String commandList() {
            if (this.commands.isEmpty()) {
                return "";
            }
            int commandLength = Help.maxLength(this.commands.keySet());
            TextTable textTable = TextTable.forColumns(this.ansi(), new Column(commandLength + 2, 2, Column.Overflow.SPAN), new Column(this.width() - (commandLength + 2), 2, Column.Overflow.WRAP));
            for (Map.Entry<String, Help> entry : this.commands.entrySet()) {
                Help help = entry.getValue();
                Model.CommandSpec command = help.commandSpec;
                String header = command.usageMessage().header() != null && command.usageMessage().header().length > 0 ? command.usageMessage().header()[0] : (command.usageMessage().description() != null && command.usageMessage().description().length > 0 ? command.usageMessage().description()[0] : "");
                Ansi.Text[] textArray = new Ansi.Text[2];
                textArray[0] = this.colorScheme.commandText(entry.getKey());
                Ansi ansi = this.ansi();
                ((Object)((Object)ansi)).getClass();
                textArray[1] = ansi.new Ansi.Text(header);
                textTable.addRowValues(textArray);
            }
            return textTable.toString();
        }

        private static int maxLength(Collection<String> any) {
            ArrayList<String> strings = new ArrayList<String>(any);
            Collections.sort(strings, Collections.reverseOrder(Help.shortestFirst()));
            return ((String)strings.get(0)).length();
        }

        private static String join(String[] names, int offset, int length, String separator) {
            if (names == null) {
                return "";
            }
            StringBuilder result = new StringBuilder();
            for (int i = offset; i < offset + length; ++i) {
                result.append(i > offset ? separator : "").append(names[i]);
            }
            return result.toString();
        }

        private static String stringOf(char chr, int length) {
            char[] buff = new char[length];
            Arrays.fill(buff, chr);
            return new String(buff);
        }

        public Layout createDefaultLayout() {
            return this.createLayout(24);
        }

        private Layout createLayout(int longOptionsColumnWidth) {
            return new Layout(this.colorScheme, TextTable.forDefaultColumns(this.colorScheme.ansi(), longOptionsColumnWidth, this.width()), this.createDefaultOptionRenderer(), this.createDefaultParameterRenderer());
        }

        public IOptionRenderer createDefaultOptionRenderer() {
            return new DefaultOptionRenderer(this.commandSpec.usageMessage.showDefaultValues(), "" + this.commandSpec.usageMessage().requiredOptionMarker());
        }

        public static IOptionRenderer createMinimalOptionRenderer() {
            return new MinimalOptionRenderer();
        }

        public IParameterRenderer createDefaultParameterRenderer() {
            return new DefaultParameterRenderer(this.commandSpec.usageMessage.showDefaultValues(), "" + this.commandSpec.usageMessage().requiredOptionMarker());
        }

        public static IParameterRenderer createMinimalParameterRenderer() {
            return new MinimalParameterRenderer();
        }

        public static IParamLabelRenderer createMinimalParamLabelRenderer() {
            return new IParamLabelRenderer(){

                @Override
                public Ansi.Text renderParameterLabel(Model.ArgSpec argSpec, Ansi ansi, List<Ansi.IStyle> styles) {
                    return ansi.apply(argSpec.paramLabel(), styles);
                }

                @Override
                public String separator() {
                    return "";
                }
            };
        }

        public IParamLabelRenderer createDefaultParamLabelRenderer() {
            return new DefaultParamLabelRenderer(this.commandSpec);
        }

        public static Comparator<Model.OptionSpec> createShortOptionNameComparator() {
            return new SortByShortestOptionNameAlphabetically();
        }

        public static Comparator<Model.OptionSpec> createShortOptionArityAndNameComparator() {
            return new SortByOptionArityAndNameAlphabetically();
        }

        public static Comparator<String> shortestFirst() {
            return new ShortestFirst();
        }

        public Ansi ansi() {
            return this.colorScheme.ansi;
        }

        private static void addTrailingDefaultLine(List<Ansi.Text[]> result, Model.ArgSpec arg, ColorScheme scheme) {
            Object defaultValue;
            Ansi.Text EMPTY = Ansi.EMPTY_TEXT;
            Object object = defaultValue = arg.defaultValue() == null ? arg.initialValue() : arg.defaultValue();
            if (defaultValue != null && defaultValue.getClass().isArray()) {
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < Array.getLength(defaultValue); ++i) {
                    sb.append(i > 0 ? ", " : "").append(Array.get(defaultValue, i));
                }
                defaultValue = sb.insert(0, "[").append("]").toString();
            }
            Ansi.Text[] textArray = new Ansi.Text[5];
            textArray[0] = EMPTY;
            textArray[1] = EMPTY;
            textArray[2] = EMPTY;
            textArray[3] = EMPTY;
            Ansi ansi = scheme.ansi();
            ((Object)((Object)ansi)).getClass();
            textArray[4] = ansi.new Ansi.Text("  Default: " + defaultValue);
            result.add(textArray);
        }

        private static Ansi.Text[] createDescriptionFirstLines(ColorScheme scheme, Model.ArgSpec arg, boolean[] showDefault) {
            Ansi ansi = scheme.ansi();
            ((Object)((Object)ansi)).getClass();
            Ansi.Text[] result = ansi.new Ansi.Text(CommandLine.str(arg.description(), 0)).splitLines();
            if (result.length == 0 || result.length == 1 && result[0].plain.length() == 0) {
                if (showDefault[0]) {
                    Object defaultValue = arg.defaultValue() == null ? arg.initialValue() : arg.defaultValue();
                    Ansi.Text[] textArray = new Ansi.Text[1];
                    Ansi ansi2 = scheme.ansi();
                    ((Object)((Object)ansi2)).getClass();
                    textArray[0] = ansi2.new Ansi.Text("  Default: " + defaultValue);
                    result = textArray;
                    showDefault[0] = false;
                } else {
                    result = new Ansi.Text[]{Ansi.EMPTY_TEXT};
                }
            }
            return result;
        }

        public static ColorScheme defaultColorScheme(Ansi ansi) {
            return new ColorScheme(ansi).commands(Ansi.Style.bold).options(Ansi.Style.fg_yellow).parameters(Ansi.Style.fg_yellow).optionParams(Ansi.Style.italic);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Ansi {
            AUTO,
            ON,
            OFF;

            static Text EMPTY_TEXT;
            static final boolean isWindows;
            static final boolean isXterm;
            static final boolean ISATTY;

            static final boolean calcTTY() {
                if (isWindows && isXterm) {
                    return true;
                }
                try {
                    return System.class.getDeclaredMethod("console", new Class[0]).invoke(null, new Object[0]) != null;
                }
                catch (Throwable reflectionFailed) {
                    return true;
                }
            }

            private static boolean ansiPossible() {
                return ISATTY && (!isWindows || isXterm);
            }

            public boolean enabled() {
                if (this == ON) {
                    return true;
                }
                if (this == OFF) {
                    return false;
                }
                return System.getProperty("picocli.ansi") == null ? Ansi.ansiPossible() : Boolean.getBoolean("picocli.ansi");
            }

            public Text apply(String plainText, List<IStyle> styles) {
                if (plainText.length() == 0) {
                    return new Text(0);
                }
                Text result = new Text(plainText.length());
                IStyle[] all = styles.toArray(new IStyle[styles.size()]);
                result.sections.add(new StyledSection(0, plainText.length(), Style.on(all), Style.off(Ansi.reverse(all)) + Style.reset.off()));
                result.plain.append(plainText);
                result.length = result.plain.length();
                return result;
            }

            private static <T> T[] reverse(T[] all) {
                for (int i = 0; i < all.length / 2; ++i) {
                    T temp = all[i];
                    all[i] = all[all.length - i - 1];
                    all[all.length - i - 1] = temp;
                }
                return all;
            }

            static {
                Ansi ansi = OFF;
                ((Object)((Object)ansi)).getClass();
                EMPTY_TEXT = ansi.new Text(0);
                isWindows = System.getProperty("os.name").startsWith("Windows");
                isXterm = System.getenv("TERM") != null && System.getenv("TERM").startsWith("xterm");
                ISATTY = Ansi.calcTTY();
            }

            public class Text
            implements Cloneable {
                private final int maxLength;
                private int from;
                private int length;
                private StringBuilder plain = new StringBuilder();
                private List<StyledSection> sections = new ArrayList<StyledSection>();

                public Text(int maxLength) {
                    this.maxLength = maxLength;
                }

                public Text(String input) {
                    this.maxLength = -1;
                    this.plain.setLength(0);
                    int i = 0;
                    while (true) {
                        int j;
                        if ((j = input.indexOf("@|", i)) == -1) {
                            if (i == 0) {
                                this.plain.append(input);
                                this.length = this.plain.length();
                                return;
                            }
                            this.plain.append(input.substring(i, input.length()));
                            this.length = this.plain.length();
                            return;
                        }
                        this.plain.append(input.substring(i, j));
                        int k = input.indexOf("|@", j);
                        if (k == -1) {
                            this.plain.append(input);
                            this.length = this.plain.length();
                            return;
                        }
                        String spec = input.substring(j += 2, k);
                        String[] items = spec.split(" ", 2);
                        if (items.length == 1) {
                            this.plain.append(input);
                            this.length = this.plain.length();
                            return;
                        }
                        Object[] styles = Style.parse(items[0]);
                        this.addStyledSection(this.plain.length(), items[1].length(), Style.on((IStyle[])styles), Style.off((IStyle[])Ansi.reverse(styles)) + Style.reset.off());
                        this.plain.append(items[1]);
                        i = k + 2;
                    }
                }

                private void addStyledSection(int start, int length, String startStyle, String endStyle) {
                    this.sections.add(new StyledSection(start, length, startStyle, endStyle));
                }

                public Object clone() {
                    try {
                        return super.clone();
                    }
                    catch (CloneNotSupportedException e) {
                        throw new IllegalStateException(e);
                    }
                }

                public Text[] splitLines() {
                    ArrayList<Text> result = new ArrayList<Text>();
                    boolean trailingEmptyString = this.plain.length() == 0;
                    int start = 0;
                    int end = 0;
                    int i = 0;
                    while (i < this.plain.length()) {
                        char c = this.plain.charAt(i);
                        boolean eol = c == '\n';
                        eol |= c == '\r' && i + 1 < this.plain.length() && this.plain.charAt(i + 1) == '\n' && ++i > 0;
                        if (eol |= c == '\r') {
                            result.add(this.substring(start, end));
                            trailingEmptyString = i == this.plain.length() - 1;
                            start = i + 1;
                        }
                        end = ++i;
                    }
                    if (start < this.plain.length() || trailingEmptyString) {
                        result.add(this.substring(start, this.plain.length()));
                    }
                    return result.toArray(new Text[result.size()]);
                }

                public Text substring(int start) {
                    return this.substring(start, this.length);
                }

                public Text substring(int start, int end) {
                    Text result = (Text)this.clone();
                    result.from = this.from + start;
                    result.length = end - start;
                    return result;
                }

                @Deprecated
                public Text append(String string) {
                    return this.concat(string);
                }

                @Deprecated
                public Text append(Text text) {
                    return this.concat(text);
                }

                public Text concat(String string) {
                    return this.concat(new Text(string));
                }

                public Text concat(Text other) {
                    Text result = (Text)this.clone();
                    result.plain = new StringBuilder(this.plain.toString().substring(this.from, this.from + this.length));
                    result.from = 0;
                    result.sections = new ArrayList<StyledSection>();
                    for (StyledSection section : this.sections) {
                        result.sections.add(section.withStartIndex(section.startIndex - this.from));
                    }
                    result.plain.append(other.plain.toString().substring(other.from, other.from + other.length));
                    for (StyledSection section : other.sections) {
                        int index = result.length + section.startIndex - other.from;
                        result.sections.add(section.withStartIndex(index));
                    }
                    result.length = result.plain.length();
                    return result;
                }

                public void getStyledChars(int from, int length, Text destination, int offset) {
                    if (destination.length < offset) {
                        for (int i = destination.length; i < offset; ++i) {
                            destination.plain.append(' ');
                        }
                        destination.length = offset;
                    }
                    for (StyledSection section : this.sections) {
                        destination.sections.add(section.withStartIndex(section.startIndex - from + destination.length));
                    }
                    destination.plain.append(this.plain.toString().substring(from, from + length));
                    destination.length = destination.plain.length();
                }

                public String plainString() {
                    return this.plain.toString().substring(this.from, this.from + this.length);
                }

                public boolean equals(Object obj) {
                    return this.toString().equals(String.valueOf(obj));
                }

                public int hashCode() {
                    return this.toString().hashCode();
                }

                public String toString() {
                    if (!Ansi.this.enabled()) {
                        return this.plain.toString().substring(this.from, this.from + this.length);
                    }
                    if (this.length == 0) {
                        return "";
                    }
                    StringBuilder sb = new StringBuilder(this.plain.length() + 20 * this.sections.size());
                    StyledSection current = null;
                    int end = Math.min(this.from + this.length, this.plain.length());
                    for (int i = this.from; i < end; ++i) {
                        StyledSection section = this.findSectionContaining(i);
                        if (section != current) {
                            if (current != null) {
                                sb.append(current.endStyles);
                            }
                            if (section != null) {
                                sb.append(section.startStyles);
                            }
                            current = section;
                        }
                        sb.append(this.plain.charAt(i));
                    }
                    if (current != null) {
                        sb.append(current.endStyles);
                    }
                    return sb.toString();
                }

                private StyledSection findSectionContaining(int index) {
                    for (StyledSection section : this.sections) {
                        if (index < section.startIndex || index >= section.startIndex + section.length) continue;
                        return section;
                    }
                    return null;
                }
            }

            private static class StyledSection {
                int startIndex;
                int length;
                String startStyles;
                String endStyles;

                StyledSection(int start, int len, String style1, String style2) {
                    this.startIndex = start;
                    this.length = len;
                    this.startStyles = style1;
                    this.endStyles = style2;
                }

                StyledSection withStartIndex(int newStart) {
                    return new StyledSection(newStart, this.length, this.startStyles, this.endStyles);
                }
            }

            static class Palette256Color
            implements IStyle {
                private final int fgbg;
                private final int color;

                Palette256Color(boolean foreground, String color) {
                    this.fgbg = foreground ? 38 : 48;
                    String[] rgb = color.split(";");
                    this.color = rgb.length == 3 ? 16 + 36 * Integer.decode(rgb[0]) + 6 * Integer.decode(rgb[1]) + Integer.decode(rgb[2]) : Integer.decode(color);
                }

                public String on() {
                    return String.format("\u001b[%d;5;%dm", this.fgbg, this.color);
                }

                public String off() {
                    return "\u001b[" + (this.fgbg + 1) + "m";
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public static enum Style implements IStyle
            {
                reset(0, 0),
                bold(1, 21),
                faint(2, 22),
                italic(3, 23),
                underline(4, 24),
                blink(5, 25),
                reverse(7, 27),
                fg_black(30, 39),
                fg_red(31, 39),
                fg_green(32, 39),
                fg_yellow(33, 39),
                fg_blue(34, 39),
                fg_magenta(35, 39),
                fg_cyan(36, 39),
                fg_white(37, 39),
                bg_black(40, 49),
                bg_red(41, 49),
                bg_green(42, 49),
                bg_yellow(43, 49),
                bg_blue(44, 49),
                bg_magenta(45, 49),
                bg_cyan(46, 49),
                bg_white(47, 49);

                private final int startCode;
                private final int endCode;

                private Style(int startCode, int endCode) {
                    this.startCode = startCode;
                    this.endCode = endCode;
                }

                @Override
                public String on() {
                    return "\u001b[" + this.startCode + "m";
                }

                @Override
                public String off() {
                    return "\u001b[" + this.endCode + "m";
                }

                public static String on(IStyle ... styles) {
                    StringBuilder result = new StringBuilder();
                    for (IStyle style : styles) {
                        result.append(style.on());
                    }
                    return result.toString();
                }

                public static String off(IStyle ... styles) {
                    StringBuilder result = new StringBuilder();
                    for (IStyle style : styles) {
                        result.append(style.off());
                    }
                    return result.toString();
                }

                public static IStyle fg(String str) {
                    try {
                        return Style.valueOf(str.toLowerCase(Locale.ENGLISH));
                    }
                    catch (Exception exception) {
                        try {
                            return Style.valueOf("fg_" + str.toLowerCase(Locale.ENGLISH));
                        }
                        catch (Exception exception2) {
                            return new Palette256Color(true, str);
                        }
                    }
                }

                public static IStyle bg(String str) {
                    try {
                        return Style.valueOf(str.toLowerCase(Locale.ENGLISH));
                    }
                    catch (Exception exception) {
                        try {
                            return Style.valueOf("bg_" + str.toLowerCase(Locale.ENGLISH));
                        }
                        catch (Exception exception2) {
                            return new Palette256Color(false, str);
                        }
                    }
                }

                public static IStyle[] parse(String commaSeparatedCodes) {
                    String[] codes = commaSeparatedCodes.split(",");
                    IStyle[] styles = new IStyle[codes.length];
                    for (int i = 0; i < codes.length; ++i) {
                        int end;
                        if (codes[i].toLowerCase(Locale.ENGLISH).startsWith("fg(")) {
                            end = codes[i].indexOf(41);
                            styles[i] = Style.fg(codes[i].substring(3, end < 0 ? codes[i].length() : end));
                            continue;
                        }
                        if (codes[i].toLowerCase(Locale.ENGLISH).startsWith("bg(")) {
                            end = codes[i].indexOf(41);
                            styles[i] = Style.bg(codes[i].substring(3, end < 0 ? codes[i].length() : end));
                            continue;
                        }
                        styles[i] = Style.fg(codes[i]);
                    }
                    return styles;
                }
            }

            public static interface IStyle {
                public static final String CSI = "\u001b[";

                public String on();

                public String off();
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class ColorScheme {
            public final List<Ansi.IStyle> commandStyles = new ArrayList<Ansi.IStyle>();
            public final List<Ansi.IStyle> optionStyles = new ArrayList<Ansi.IStyle>();
            public final List<Ansi.IStyle> parameterStyles = new ArrayList<Ansi.IStyle>();
            public final List<Ansi.IStyle> optionParamStyles = new ArrayList<Ansi.IStyle>();
            private final Ansi ansi;

            public ColorScheme() {
                this(Ansi.AUTO);
            }

            public ColorScheme(Ansi ansi) {
                this.ansi = Assert.notNull(ansi, "ansi");
            }

            public ColorScheme commands(Ansi.IStyle ... styles) {
                return this.addAll(this.commandStyles, styles);
            }

            public ColorScheme options(Ansi.IStyle ... styles) {
                return this.addAll(this.optionStyles, styles);
            }

            public ColorScheme parameters(Ansi.IStyle ... styles) {
                return this.addAll(this.parameterStyles, styles);
            }

            public ColorScheme optionParams(Ansi.IStyle ... styles) {
                return this.addAll(this.optionParamStyles, styles);
            }

            public Ansi.Text commandText(String command) {
                return this.ansi().apply(command, this.commandStyles);
            }

            public Ansi.Text optionText(String option) {
                return this.ansi().apply(option, this.optionStyles);
            }

            public Ansi.Text parameterText(String parameter) {
                return this.ansi().apply(parameter, this.parameterStyles);
            }

            public Ansi.Text optionParamText(String optionParam) {
                return this.ansi().apply(optionParam, this.optionParamStyles);
            }

            public ColorScheme applySystemProperties() {
                this.replace(this.commandStyles, System.getProperty("picocli.color.commands"));
                this.replace(this.optionStyles, System.getProperty("picocli.color.options"));
                this.replace(this.parameterStyles, System.getProperty("picocli.color.parameters"));
                this.replace(this.optionParamStyles, System.getProperty("picocli.color.optionParams"));
                return this;
            }

            private void replace(List<Ansi.IStyle> styles, String property) {
                if (property != null) {
                    styles.clear();
                    this.addAll(styles, Ansi.Style.parse(property));
                }
            }

            private ColorScheme addAll(List<Ansi.IStyle> styles, Ansi.IStyle ... add) {
                styles.addAll(Arrays.asList(add));
                return this;
            }

            public Ansi ansi() {
                return this.ansi;
            }
        }

        public static class Column {
            public final int width;
            public final int indent;
            public final Overflow overflow;

            public Column(int width, int indent, Overflow overflow) {
                this.width = width;
                this.indent = indent;
                this.overflow = Assert.notNull(overflow, "overflow");
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public static enum Overflow {
                TRUNCATE,
                SPAN,
                WRAP;

            }
        }

        public static class TextTable {
            private final Column[] columns;
            protected final List<Ansi.Text> columnValues = new ArrayList<Ansi.Text>();
            public int indentWrappedLines = 2;
            private final Ansi ansi;
            private final int tableWidth;

            public static TextTable forDefaultColumns(Ansi ansi, int usageHelpWidth) {
                return TextTable.forDefaultColumns(ansi, 24, usageHelpWidth);
            }

            public static TextTable forDefaultColumns(Ansi ansi, int longOptionsColumnWidth, int usageHelpWidth) {
                return TextTable.forColumns(ansi, new Column(2, 0, Column.Overflow.TRUNCATE), new Column(2, 0, Column.Overflow.TRUNCATE), new Column(1, 0, Column.Overflow.TRUNCATE), new Column(longOptionsColumnWidth, 1, Column.Overflow.SPAN), new Column(usageHelpWidth - longOptionsColumnWidth, 1, Column.Overflow.WRAP));
            }

            public static TextTable forColumnWidths(Ansi ansi, int ... columnWidths) {
                Column[] columns = new Column[columnWidths.length];
                for (int i = 0; i < columnWidths.length; ++i) {
                    columns[i] = new Column(columnWidths[i], 0, i == columnWidths.length - 1 ? Column.Overflow.WRAP : Column.Overflow.SPAN);
                }
                return new TextTable(ansi, columns);
            }

            public static TextTable forColumns(Ansi ansi, Column ... columns) {
                return new TextTable(ansi, columns);
            }

            protected TextTable(Ansi ansi, Column[] columns) {
                this.ansi = Assert.notNull(ansi, "ansi");
                this.columns = (Column[])Assert.notNull(columns, "columns").clone();
                if (columns.length == 0) {
                    throw new IllegalArgumentException("At least one column is required");
                }
                int totalWidth = 0;
                for (Column col : columns) {
                    totalWidth += col.width;
                }
                this.tableWidth = totalWidth;
            }

            public Column[] columns() {
                return (Column[])this.columns.clone();
            }

            public Ansi.Text textAt(int row, int col) {
                return this.columnValues.get(col + row * this.columns.length);
            }

            @Deprecated
            public Ansi.Text cellAt(int row, int col) {
                return this.textAt(row, col);
            }

            public int rowCount() {
                return this.columnValues.size() / this.columns.length;
            }

            public void addEmptyRow() {
                for (int i = 0; i < this.columns.length; ++i) {
                    Ansi ansi = this.ansi;
                    ((Object)((Object)ansi)).getClass();
                    this.columnValues.add(ansi.new Ansi.Text(this.columns[i].width));
                }
            }

            public void addRowValues(String ... values) {
                Ansi.Text[] array = new Ansi.Text[values.length];
                for (int i = 0; i < array.length; ++i) {
                    Ansi.Text text;
                    if (values[i] == null) {
                        text = Ansi.EMPTY_TEXT;
                    } else {
                        Ansi ansi = this.ansi;
                        ((Object)((Object)ansi)).getClass();
                        text = ansi.new Ansi.Text(values[i]);
                    }
                    array[i] = text;
                }
                this.addRowValues(array);
            }

            public void addRowValues(Ansi.Text ... values) {
                if (values.length > this.columns.length) {
                    throw new IllegalArgumentException(values.length + " values don't fit in " + this.columns.length + " columns");
                }
                this.addEmptyRow();
                for (int col = 0; col < values.length; ++col) {
                    int row = this.rowCount() - 1;
                    Cell cell = this.putValue(row, col, values[col]);
                    if (cell.row == row && cell.column == col || col == values.length - 1) continue;
                    this.addEmptyRow();
                }
            }

            public Cell putValue(int row, int col, Ansi.Text value) {
                if (row > this.rowCount() - 1) {
                    throw new IllegalArgumentException("Cannot write to row " + row + ": rowCount=" + this.rowCount());
                }
                if (value == null || value.plain.length() == 0) {
                    return new Cell(col, row);
                }
                Column column = this.columns[col];
                int indent = column.indent;
                switch (column.overflow) {
                    case TRUNCATE: {
                        TextTable.copy(value, this.textAt(row, col), indent);
                        return new Cell(col, row);
                    }
                    case SPAN: {
                        int startColumn = col;
                        do {
                            boolean lastColumn = col == this.columns.length - 1;
                            int charsWritten = lastColumn ? this.copy(BreakIterator.getLineInstance(), value, this.textAt(row, col), indent) : TextTable.copy(value, this.textAt(row, col), indent);
                            value = value.substring(charsWritten);
                            indent = 0;
                            if (value.length > 0) {
                                ++col;
                            }
                            if (value.length <= 0 || col < this.columns.length) continue;
                            this.addEmptyRow();
                            ++row;
                            col = startColumn;
                            indent = column.indent + this.indentWrappedLines;
                        } while (value.length > 0);
                        return new Cell(col, row);
                    }
                    case WRAP: {
                        BreakIterator lineBreakIterator = BreakIterator.getLineInstance();
                        do {
                            int charsWritten = this.copy(lineBreakIterator, value, this.textAt(row, col), indent);
                            value = value.substring(charsWritten);
                            indent = column.indent + this.indentWrappedLines;
                            if (value.length <= 0) continue;
                            ++row;
                            this.addEmptyRow();
                        } while (value.length > 0);
                        return new Cell(col, row);
                    }
                }
                throw new IllegalStateException(column.overflow.toString());
            }

            private static int length(Ansi.Text str) {
                return str.length;
            }

            private int copy(BreakIterator line, Ansi.Text text, Ansi.Text columnValue, int offset) {
                line.setText(text.plainString().replace("-", "\u00ff"));
                int done = 0;
                int start = line.first();
                int end = line.next();
                while (end != -1) {
                    Ansi.Text word = text.substring(start, end);
                    if (columnValue.maxLength < offset + done + TextTable.length(word)) break;
                    done += TextTable.copy(word, columnValue, offset + done);
                    start = end;
                    end = line.next();
                }
                if (done == 0 && TextTable.length(text) > columnValue.maxLength) {
                    done = TextTable.copy(text, columnValue, offset);
                }
                return done;
            }

            private static int copy(Ansi.Text value, Ansi.Text destination, int offset) {
                int length = Math.min(value.length, destination.maxLength - offset);
                value.getStyledChars(value.from, length, destination, offset);
                return length;
            }

            public StringBuilder toString(StringBuilder text) {
                int columnCount = this.columns.length;
                StringBuilder row = new StringBuilder(this.tableWidth);
                for (int i = 0; i < this.columnValues.size(); ++i) {
                    int lastChar;
                    Ansi.Text column = this.columnValues.get(i);
                    row.append(column.toString());
                    row.append(new String(Help.spaces(this.columns[i % columnCount].width - column.length)));
                    if (i % columnCount != columnCount - 1) continue;
                    for (lastChar = row.length() - 1; lastChar >= 0 && row.charAt(lastChar) == ' '; --lastChar) {
                    }
                    row.setLength(lastChar + 1);
                    text.append(row.toString()).append(System.getProperty("line.separator"));
                    row.setLength(0);
                }
                return text;
            }

            public String toString() {
                return this.toString(new StringBuilder()).toString();
            }

            public static class Cell {
                public final int column;
                public final int row;

                public Cell(int column, int row) {
                    this.column = column;
                    this.row = row;
                }
            }
        }

        static class SortByOptionArityAndNameAlphabetically
        extends SortByShortestOptionNameAlphabetically {
            SortByOptionArityAndNameAlphabetically() {
            }

            public int compare(Model.OptionSpec o1, Model.OptionSpec o2) {
                Range arity1 = o1.arity();
                Range arity2 = o2.arity();
                int result = arity1.max - arity2.max;
                if (result == 0) {
                    result = arity1.min - arity2.min;
                }
                if (result == 0) {
                    if (o1.isMultiValue() && !o2.isMultiValue()) {
                        result = 1;
                    }
                    if (!o1.isMultiValue() && o2.isMultiValue()) {
                        result = -1;
                    }
                }
                return result == 0 ? super.compare(o1, o2) : result;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class SortByShortestOptionNameAlphabetically
        implements Comparator<Model.OptionSpec> {
            SortByShortestOptionNameAlphabetically() {
            }

            @Override
            public int compare(Model.OptionSpec o1, Model.OptionSpec o2) {
                if (o1 == null) {
                    return 1;
                }
                if (o2 == null) {
                    return -1;
                }
                String[] names1 = ShortestFirst.sort(o1.names());
                String[] names2 = ShortestFirst.sort(o2.names());
                int result = names1[0].toUpperCase().compareTo(names2[0].toUpperCase());
                int n = result = result == 0 ? -names1[0].compareTo(names2[0]) : result;
                return o1.help() == o2.help() ? result : (o2.help() ? -1 : 1);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class ShortestFirst
        implements Comparator<String> {
            ShortestFirst() {
            }

            @Override
            public int compare(String o1, String o2) {
                return o1.length() - o2.length();
            }

            public static String[] sort(String[] names) {
                Arrays.sort(names, new ShortestFirst());
                return names;
            }

            public static String[] longestFirst(String[] names) {
                Arrays.sort(names, Collections.reverseOrder(new ShortestFirst()));
                return names;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class Layout {
            protected final ColorScheme colorScheme;
            protected final TextTable table;
            protected IOptionRenderer optionRenderer;
            protected IParameterRenderer parameterRenderer;

            public Layout(ColorScheme colorScheme, int tableWidth) {
                this(colorScheme, TextTable.forDefaultColumns(colorScheme.ansi(), tableWidth));
            }

            public Layout(ColorScheme colorScheme, TextTable textTable) {
                this(colorScheme, textTable, new DefaultOptionRenderer(false, " "), new DefaultParameterRenderer(false, " "));
            }

            public Layout(ColorScheme colorScheme, TextTable textTable, IOptionRenderer optionRenderer, IParameterRenderer parameterRenderer) {
                this.colorScheme = Assert.notNull(colorScheme, "colorScheme");
                this.table = Assert.notNull(textTable, "textTable");
                this.optionRenderer = Assert.notNull(optionRenderer, "optionRenderer");
                this.parameterRenderer = Assert.notNull(parameterRenderer, "parameterRenderer");
            }

            public void layout(Model.ArgSpec argSpec, Ansi.Text[][] cellValues) {
                for (Ansi.Text[] oneRow : cellValues) {
                    this.table.addRowValues(oneRow);
                }
            }

            public void addOptions(List<Model.OptionSpec> options, IParamLabelRenderer paramLabelRenderer) {
                for (Model.OptionSpec option : options) {
                    if (option.hidden()) continue;
                    this.addOption(option, paramLabelRenderer);
                }
            }

            public void addOption(Model.OptionSpec option, IParamLabelRenderer paramLabelRenderer) {
                Ansi.Text[][] values = this.optionRenderer.render(option, paramLabelRenderer, this.colorScheme);
                this.layout(option, values);
            }

            public void addPositionalParameters(List<Model.PositionalParamSpec> params, IParamLabelRenderer paramLabelRenderer) {
                for (Model.PositionalParamSpec param : params) {
                    if (param.hidden()) continue;
                    this.addPositionalParameter(param, paramLabelRenderer);
                }
            }

            public void addPositionalParameter(Model.PositionalParamSpec param, IParamLabelRenderer paramLabelRenderer) {
                Ansi.Text[][] values = this.parameterRenderer.render(param, paramLabelRenderer, this.colorScheme);
                this.layout(param, values);
            }

            public String toString() {
                return this.table.toString();
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class DefaultParamLabelRenderer
        implements IParamLabelRenderer {
            private final Model.CommandSpec commandSpec;

            public DefaultParamLabelRenderer(Model.CommandSpec commandSpec) {
                this.commandSpec = Assert.notNull(commandSpec, "commandSpec");
            }

            @Override
            public String separator() {
                return this.commandSpec.parser().separator();
            }

            @Override
            public Ansi.Text renderParameterLabel(Model.ArgSpec argSpec, Ansi ansi, List<Ansi.IStyle> styles) {
                String optionSeparator;
                boolean effectivelyVariable;
                Range capacity;
                Ansi.Text paramName = ansi.apply(argSpec.paramLabel(), styles);
                Range range = capacity = argSpec.isOption() ? argSpec.arity() : ((Model.PositionalParamSpec)argSpec).capacity();
                if (capacity.max == 0) {
                    Ansi ansi2 = ansi;
                    ((Object)((Object)ansi2)).getClass();
                    return ansi2.new Ansi.Text("");
                }
                String split = argSpec.splitRegex();
                String mandatorySep = CommandLine.empty(split) ? " " : split;
                String optionalSep = CommandLine.empty(split) ? " [" : "[" + split;
                boolean unlimitedSplit = !CommandLine.empty(split) && !this.commandSpec.parser().limitSplit();
                boolean limitedSplit = !CommandLine.empty(split) && this.commandSpec.parser().limitSplit();
                Ansi.Text repeating = paramName;
                int paramCount = 1;
                if (unlimitedSplit) {
                    repeating = paramName.concat("[" + split).concat(paramName).concat("...]");
                    ++paramCount;
                    mandatorySep = " ";
                    optionalSep = " [";
                }
                Ansi.Text result = repeating;
                for (int done = 1; done < capacity.min; ++done) {
                    result = result.concat(mandatorySep).concat(repeating);
                    paramCount += paramCount;
                }
                if (!capacity.isVariable) {
                    int i;
                    for (i = done; i < capacity.max; ++i) {
                        result = result.concat(optionalSep).concat(paramName);
                        ++paramCount;
                    }
                    for (i = done; i < capacity.max; ++i) {
                        result = result.concat("]");
                    }
                }
                boolean bl = effectivelyVariable = capacity.isVariable || limitedSplit && paramCount == 1;
                if (limitedSplit && effectivelyVariable && paramCount == 1) {
                    result = result.concat(optionalSep).concat(repeating).concat("]");
                }
                if (effectivelyVariable) {
                    if (!argSpec.arity().isVariable && argSpec.arity().min > 1) {
                        Ansi ansi3 = ansi;
                        ((Object)((Object)ansi3)).getClass();
                        result = ansi3.new Ansi.Text("(").concat(result).concat(")");
                    }
                    result = result.concat("...");
                }
                String string = optionSeparator = argSpec.isOption() ? this.separator() : "";
                if (capacity.min == 0) {
                    String sep2 = CommandLine.empty(optionSeparator.trim()) ? optionSeparator + "[" : "[" + optionSeparator;
                    Ansi ansi4 = ansi;
                    ((Object)((Object)ansi4)).getClass();
                    result = ansi4.new Ansi.Text(sep2).concat(result).concat("]");
                } else {
                    Ansi ansi5 = ansi;
                    ((Object)((Object)ansi5)).getClass();
                    result = ansi5.new Ansi.Text(optionSeparator).concat(result);
                }
                return result;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static interface IParamLabelRenderer {
            public Ansi.Text renderParameterLabel(Model.ArgSpec var1, Ansi var2, List<Ansi.IStyle> var3);

            public String separator();
        }

        static class DefaultParameterRenderer
        implements IParameterRenderer {
            private String requiredMarker = " ";
            private boolean showDefaultValues;

            public DefaultParameterRenderer(boolean showDefaultValues, String requiredMarker) {
                this.showDefaultValues = showDefaultValues;
                this.requiredMarker = Assert.notNull(requiredMarker, "requiredMarker");
            }

            public Ansi.Text[][] render(Model.PositionalParamSpec param, IParamLabelRenderer paramLabelRenderer, ColorScheme scheme) {
                int i;
                Ansi.Text label = paramLabelRenderer.renderParameterLabel(param, scheme.ansi(), scheme.parameterStyles);
                Ansi.Text requiredParameter = scheme.parameterText(param.arity().min > 0 ? this.requiredMarker : "");
                Ansi.Text EMPTY = Ansi.EMPTY_TEXT;
                boolean[] showDefault = new boolean[]{param.internalShowDefaultValue(this.showDefaultValues)};
                ArrayList<Ansi.Text[]> result = new ArrayList<Ansi.Text[]>();
                Ansi.Text[] descriptionFirstLines = Help.createDescriptionFirstLines(scheme, param, showDefault);
                result.add(new Ansi.Text[]{requiredParameter, EMPTY, EMPTY, label, descriptionFirstLines[0]});
                for (i = 1; i < descriptionFirstLines.length; ++i) {
                    result.add(new Ansi.Text[]{EMPTY, EMPTY, EMPTY, EMPTY, descriptionFirstLines[i]});
                }
                for (i = 1; i < param.description().length; ++i) {
                    Ansi.Text[] descriptionNextLines;
                    Ansi ansi = scheme.ansi();
                    ((Object)((Object)ansi)).getClass();
                    for (Ansi.Text line : descriptionNextLines = ansi.new Ansi.Text(param.description()[i]).splitLines()) {
                        result.add(new Ansi.Text[]{EMPTY, EMPTY, EMPTY, EMPTY, line});
                    }
                }
                if (showDefault[0]) {
                    Help.addTrailingDefaultLine(result, param, scheme);
                }
                return (Ansi.Text[][])result.toArray((T[])new Ansi.Text[result.size()][]);
            }
        }

        public static interface IParameterRenderer {
            public Ansi.Text[][] render(Model.PositionalParamSpec var1, IParamLabelRenderer var2, ColorScheme var3);
        }

        static class MinimalParameterRenderer
        implements IParameterRenderer {
            MinimalParameterRenderer() {
            }

            public Ansi.Text[][] render(Model.PositionalParamSpec param, IParamLabelRenderer parameterLabelRenderer, ColorScheme scheme) {
                Ansi.Text[][] textArray = new Ansi.Text[1][];
                Ansi.Text[] textArray2 = new Ansi.Text[2];
                textArray2[0] = parameterLabelRenderer.renderParameterLabel(param, scheme.ansi(), scheme.parameterStyles);
                Ansi ansi = scheme.ansi();
                ((Object)((Object)ansi)).getClass();
                textArray2[1] = ansi.new Ansi.Text(param.description().length == 0 ? "" : param.description()[0]);
                textArray[0] = textArray2;
                return textArray;
            }
        }

        static class MinimalOptionRenderer
        implements IOptionRenderer {
            MinimalOptionRenderer() {
            }

            public Ansi.Text[][] render(Model.OptionSpec option, IParamLabelRenderer parameterLabelRenderer, ColorScheme scheme) {
                Ansi.Text optionText = scheme.optionText(option.names()[0]);
                Ansi.Text paramLabelText = parameterLabelRenderer.renderParameterLabel(option, scheme.ansi(), scheme.optionParamStyles);
                optionText = optionText.concat(paramLabelText);
                Ansi.Text[][] textArray = new Ansi.Text[1][];
                Ansi.Text[] textArray2 = new Ansi.Text[2];
                textArray2[0] = optionText;
                Ansi ansi = scheme.ansi();
                ((Object)((Object)ansi)).getClass();
                textArray2[1] = ansi.new Ansi.Text(option.description().length == 0 ? "" : option.description()[0]);
                textArray[0] = textArray2;
                return textArray;
            }
        }

        static class DefaultOptionRenderer
        implements IOptionRenderer {
            private String requiredMarker = " ";
            private boolean showDefaultValues;
            private String sep;

            public DefaultOptionRenderer(boolean showDefaultValues, String requiredMarker) {
                this.showDefaultValues = showDefaultValues;
                this.requiredMarker = Assert.notNull(requiredMarker, "requiredMarker");
            }

            public Ansi.Text[][] render(Model.OptionSpec option, IParamLabelRenderer paramLabelRenderer, ColorScheme scheme) {
                String[] names = ShortestFirst.sort(option.names());
                int shortOptionCount = names[0].length() == 2 ? 1 : 0;
                String shortOption = shortOptionCount > 0 ? names[0] : "";
                this.sep = shortOptionCount > 0 && names.length > 1 ? "," : "";
                String longOption = Help.join(names, shortOptionCount, names.length - shortOptionCount, ", ");
                Ansi.Text longOptionText = this.createLongOptionText(option, paramLabelRenderer, scheme, longOption);
                String requiredOption = option.required() ? this.requiredMarker : "";
                return this.renderDescriptionLines(option, scheme, requiredOption, shortOption, longOptionText);
            }

            private Ansi.Text createLongOptionText(Model.OptionSpec option, IParamLabelRenderer renderer, ColorScheme scheme, String longOption) {
                Ansi.Text paramLabelText = renderer.renderParameterLabel(option, scheme.ansi(), scheme.optionParamStyles);
                if (paramLabelText.length > 0 && longOption.length() == 0) {
                    this.sep = renderer.separator();
                    int sepStart = paramLabelText.plainString().indexOf(this.sep);
                    Ansi.Text prefix = paramLabelText.substring(0, sepStart);
                    paramLabelText = prefix.concat(paramLabelText.substring(sepStart + this.sep.length()));
                }
                Ansi.Text longOptionText = scheme.optionText(longOption);
                longOptionText = longOptionText.concat(paramLabelText);
                return longOptionText;
            }

            private Ansi.Text[][] renderDescriptionLines(Model.OptionSpec option, ColorScheme scheme, String requiredOption, String shortOption, Ansi.Text longOptionText) {
                int i;
                Ansi.Text EMPTY = Ansi.EMPTY_TEXT;
                boolean[] showDefault = new boolean[]{option.internalShowDefaultValue(this.showDefaultValues)};
                ArrayList<Ansi.Text[]> result = new ArrayList<Ansi.Text[]>();
                Ansi.Text[] descriptionFirstLines = Help.createDescriptionFirstLines(scheme, option, showDefault);
                Ansi.Text[] textArray = new Ansi.Text[5];
                textArray[0] = scheme.optionText(requiredOption);
                textArray[1] = scheme.optionText(shortOption);
                Ansi ansi = scheme.ansi();
                ((Object)((Object)ansi)).getClass();
                textArray[2] = ansi.new Ansi.Text(this.sep);
                textArray[3] = longOptionText;
                textArray[4] = descriptionFirstLines[0];
                result.add(textArray);
                for (i = 1; i < descriptionFirstLines.length; ++i) {
                    result.add(new Ansi.Text[]{EMPTY, EMPTY, EMPTY, EMPTY, descriptionFirstLines[i]});
                }
                for (i = 1; i < option.description().length; ++i) {
                    Ansi.Text[] descriptionNextLines;
                    Ansi ansi2 = scheme.ansi();
                    ((Object)((Object)ansi2)).getClass();
                    for (Ansi.Text line : descriptionNextLines = ansi2.new Ansi.Text(option.description()[i]).splitLines()) {
                        result.add(new Ansi.Text[]{EMPTY, EMPTY, EMPTY, EMPTY, line});
                    }
                }
                if (showDefault[0]) {
                    Help.addTrailingDefaultLine(result, option, scheme);
                }
                return (Ansi.Text[][])result.toArray((T[])new Ansi.Text[result.size()][]);
            }
        }

        public static interface IOptionRenderer {
            public Ansi.Text[][] render(Model.OptionSpec var1, IParamLabelRenderer var2, ColorScheme var3);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Visibility {
            ALWAYS,
            NEVER,
            ON_DEMAND;

        }
    }

    public static interface IHelpCommandInitializable {
        public void init(CommandLine var1, Help.Ansi var2, PrintStream var3, PrintStream var4);
    }

    @Command(name="help", header={"Displays help information about the specified command"}, synopsisHeading="%nUsage: ", helpCommand=true, description={"%nWhen no COMMAND is given, the usage help for the main command is displayed.", "If a COMMAND is specified, the help for that command is shown.%n"})
    public static final class HelpCommand
    implements IHelpCommandInitializable,
    Runnable {
        @Option(names={"-h", "--help"}, usageHelp=true, description={"Show usage help for the help command and exit."})
        private boolean helpRequested;
        @Parameters(paramLabel="COMMAND", description={"The COMMAND to display the usage help message for."})
        private String[] commands = new String[0];
        private CommandLine self;
        private PrintStream out;
        private PrintStream err;
        private Help.Ansi ansi;

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void run() {
            CommandLine parent;
            if (this.self == null) {
                return;
            }
            CommandLine commandLine = parent = this.self.getParent();
            if (parent == null) {
                return;
            }
            if (this.commands.length > 0) {
                CommandLine subcommand = parent.getSubcommands().get(this.commands[0]);
                if (subcommand == null) throw new ParameterException(parent, "Unknown subcommand '" + this.commands[0] + "'.");
                subcommand.usage(this.out, this.ansi);
                return;
            } else {
                parent.usage(this.out, this.ansi);
            }
        }

        public void init(CommandLine helpCommandLine, Help.Ansi ansi, PrintStream out, PrintStream err) {
            this.self = Assert.notNull(helpCommandLine, "helpCommandLine");
            this.ansi = Assert.notNull(ansi, "ansi");
            this.out = Assert.notNull(out, "out");
            this.err = Assert.notNull(err, "err");
        }
    }

    static class AutoHelpMixin {
        private static final String KEY = "mixinStandardHelpOptions";
        @Option(names={"-h", "--help"}, usageHelp=true, description={"Show this help message and exit."})
        private boolean helpRequested;
        @Option(names={"-V", "--version"}, versionHelp=true, description={"Print version information and exit."})
        private boolean versionRequested;

        AutoHelpMixin() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BuiltIn {
        static Set<String> traced = new HashSet<String>();

        static void registerIfAvailable(Map<Class<?>, ITypeConverter<?>> registry, Tracer tracer, String fqcn, String factoryMethodName, Class<?> ... paramTypes) {
            BuiltIn.registerIfAvailable(registry, tracer, fqcn, fqcn, factoryMethodName, paramTypes);
        }

        static void registerIfAvailable(Map<Class<?>, ITypeConverter<?>> registry, Tracer tracer, String fqcn, String factoryClass, String factoryMethodName, Class<?> ... paramTypes) {
            try {
                Class<?> cls = Class.forName(fqcn);
                Class<?> factory = Class.forName(factoryClass);
                Method method = factory.getDeclaredMethod(factoryMethodName, paramTypes);
                registry.put(cls, new ReflectionConverter(method, paramTypes));
            }
            catch (Exception e) {
                if (!traced.contains(fqcn)) {
                    tracer.debug("Could not register converter for %s: %s%n", fqcn, e.toString());
                }
                traced.add(fqcn);
            }
        }

        private BuiltIn() {
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class ReflectionConverter
        implements ITypeConverter<Object> {
            private final Method method;
            private Class<?>[] paramTypes;

            public ReflectionConverter(Method method, Class<?> ... paramTypes) {
                this.method = Assert.notNull(method, "method");
                this.paramTypes = Assert.notNull(paramTypes, "paramTypes");
            }

            @Override
            public Object convert(String s) {
                try {
                    if (this.paramTypes.length > 1) {
                        return this.method.invoke(null, s, new String[0]);
                    }
                    return this.method.invoke(null, s);
                }
                catch (InvocationTargetException e) {
                    throw new TypeConversionException("Unable to convert '" + s + "' to " + this.method.getReturnType() + ": " + e.getTargetException().toString());
                }
                catch (Exception e) {
                    throw new TypeConversionException("Unable to convert '" + s + "' to " + this.method.getReturnType() + ": " + e.toString());
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class NetworkInterfaceConverter
        implements ITypeConverter<NetworkInterface> {
            NetworkInterfaceConverter() {
            }

            @Override
            public NetworkInterface convert(String s) throws Exception {
                try {
                    InetAddress addr = new InetAddressConverter().convert(s);
                    return NetworkInterface.getByInetAddress(addr);
                }
                catch (Exception ex) {
                    try {
                        return NetworkInterface.getByName(s);
                    }
                    catch (Exception ex2) {
                        throw new TypeConversionException("'" + s + "' is not an InetAddress or NetworkInterface name");
                    }
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class ClassConverter
        implements ITypeConverter<Class<?>> {
            ClassConverter() {
            }

            @Override
            public Class<?> convert(String s) throws Exception {
                return Class.forName(s);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class ByteOrderConverter
        implements ITypeConverter<ByteOrder> {
            ByteOrderConverter() {
            }

            @Override
            public ByteOrder convert(String s) throws Exception {
                if (s.equalsIgnoreCase(ByteOrder.BIG_ENDIAN.toString())) {
                    return ByteOrder.BIG_ENDIAN;
                }
                if (s.equalsIgnoreCase(ByteOrder.LITTLE_ENDIAN.toString())) {
                    return ByteOrder.LITTLE_ENDIAN;
                }
                throw new TypeConversionException("'" + s + "' is not a valid ByteOrder");
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class TimeZoneConverter
        implements ITypeConverter<TimeZone> {
            TimeZoneConverter() {
            }

            @Override
            public TimeZone convert(String s) throws Exception {
                return TimeZone.getTimeZone(s);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class CurrencyConverter
        implements ITypeConverter<Currency> {
            CurrencyConverter() {
            }

            @Override
            public Currency convert(String s) throws Exception {
                return Currency.getInstance(s);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class UUIDConverter
        implements ITypeConverter<UUID> {
            UUIDConverter() {
            }

            @Override
            public UUID convert(String s) throws Exception {
                return UUID.fromString(s);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class PatternConverter
        implements ITypeConverter<Pattern> {
            PatternConverter() {
            }

            @Override
            public Pattern convert(String s) {
                return Pattern.compile(s);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class InetAddressConverter
        implements ITypeConverter<InetAddress> {
            InetAddressConverter() {
            }

            @Override
            public InetAddress convert(String s) throws Exception {
                return InetAddress.getByName(s);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class CharsetConverter
        implements ITypeConverter<Charset> {
            CharsetConverter() {
            }

            @Override
            public Charset convert(String s) {
                return Charset.forName(s);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class BigIntegerConverter
        implements ITypeConverter<BigInteger> {
            BigIntegerConverter() {
            }

            @Override
            public BigInteger convert(String value) {
                return new BigInteger(value);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class BigDecimalConverter
        implements ITypeConverter<BigDecimal> {
            BigDecimalConverter() {
            }

            @Override
            public BigDecimal convert(String value) {
                return new BigDecimal(value);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class ISO8601TimeConverter
        implements ITypeConverter<Object> {
            private static final String FQCN = "java.sql.Time";

            ISO8601TimeConverter() {
            }

            @Override
            public Object convert(String value) {
                try {
                    if (value.length() <= 5) {
                        return this.createTime(new SimpleDateFormat("HH:mm").parse(value).getTime());
                    }
                    if (value.length() <= 8) {
                        return this.createTime(new SimpleDateFormat("HH:mm:ss").parse(value).getTime());
                    }
                    if (value.length() <= 12) {
                        try {
                            return this.createTime(new SimpleDateFormat("HH:mm:ss.SSS").parse(value).getTime());
                        }
                        catch (ParseException e2) {
                            return this.createTime(new SimpleDateFormat("HH:mm:ss,SSS").parse(value).getTime());
                        }
                    }
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
                throw new TypeConversionException("'" + value + "' is not a HH:mm[:ss[.SSS]] time");
            }

            private Object createTime(long epochMillis) {
                try {
                    Class<?> timeClass = Class.forName(FQCN);
                    Constructor<?> constructor = timeClass.getDeclaredConstructor(Long.TYPE);
                    return constructor.newInstance(epochMillis);
                }
                catch (Exception e) {
                    throw new TypeConversionException("Unable to create new java.sql.Time with long value " + epochMillis + ": " + e.getMessage());
                }
            }

            public static void registerIfAvailable(Map<Class<?>, ITypeConverter<?>> registry, Tracer tracer) {
                try {
                    registry.put(Class.forName(FQCN), new ISO8601TimeConverter());
                }
                catch (Exception e) {
                    if (!traced.contains(FQCN)) {
                        tracer.debug("Could not register converter for %s: %s%n", FQCN, e.toString());
                    }
                    traced.add(FQCN);
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class ISO8601DateConverter
        implements ITypeConverter<Date> {
            ISO8601DateConverter() {
            }

            @Override
            public Date convert(String value) {
                try {
                    return new SimpleDateFormat("yyyy-MM-dd").parse(value);
                }
                catch (ParseException e) {
                    throw new TypeConversionException("'" + value + "' is not a yyyy-MM-dd date");
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class URIConverter
        implements ITypeConverter<URI> {
            URIConverter() {
            }

            @Override
            public URI convert(String value) throws URISyntaxException {
                return new URI(value);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class URLConverter
        implements ITypeConverter<URL> {
            URLConverter() {
            }

            @Override
            public URL convert(String value) throws MalformedURLException {
                return new URL(value);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class FileConverter
        implements ITypeConverter<File> {
            FileConverter() {
            }

            @Override
            public File convert(String value) {
                return new File(value);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class DoubleConverter
        implements ITypeConverter<Double> {
            DoubleConverter() {
            }

            @Override
            public Double convert(String value) {
                return Double.valueOf(value);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class FloatConverter
        implements ITypeConverter<Float> {
            FloatConverter() {
            }

            @Override
            public Float convert(String value) {
                return Float.valueOf(value);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class LongConverter
        implements ITypeConverter<Long> {
            LongConverter() {
            }

            @Override
            public Long convert(String value) {
                return Long.valueOf(value);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class IntegerConverter
        implements ITypeConverter<Integer> {
            IntegerConverter() {
            }

            @Override
            public Integer convert(String value) {
                return Integer.valueOf(value);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class ShortConverter
        implements ITypeConverter<Short> {
            ShortConverter() {
            }

            @Override
            public Short convert(String value) {
                return Short.valueOf(value);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class CharacterConverter
        implements ITypeConverter<Character> {
            CharacterConverter() {
            }

            @Override
            public Character convert(String value) {
                if (value.length() > 1) {
                    throw new TypeConversionException("'" + value + "' is not a single character");
                }
                return Character.valueOf(value.charAt(0));
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class BooleanConverter
        implements ITypeConverter<Boolean> {
            BooleanConverter() {
            }

            @Override
            public Boolean convert(String value) {
                if ("true".equalsIgnoreCase(value) || "false".equalsIgnoreCase(value)) {
                    return Boolean.parseBoolean(value);
                }
                throw new TypeConversionException("'" + value + "' is not a boolean");
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class ByteConverter
        implements ITypeConverter<Byte> {
            ByteConverter() {
            }

            @Override
            public Byte convert(String value) {
                return Byte.valueOf(value);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class CharSequenceConverter
        implements ITypeConverter<CharSequence> {
            CharSequenceConverter() {
            }

            @Override
            public String convert(String value) {
                return value;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class StringBuilderConverter
        implements ITypeConverter<StringBuilder> {
            StringBuilderConverter() {
            }

            @Override
            public StringBuilder convert(String value) {
                return new StringBuilder(value);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class StringConverter
        implements ITypeConverter<String> {
            StringConverter() {
            }

            @Override
            public String convert(String value) {
                return value;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PositionalParametersSorter
    implements Comparator<Model.ArgSpec> {
        private static final Range OPTION_INDEX = new Range(0, 0, false, true, "0");

        private PositionalParametersSorter() {
        }

        @Override
        public int compare(Model.ArgSpec p1, Model.ArgSpec p2) {
            int result = this.index(p1).compareTo(this.index(p2));
            return result == 0 ? p1.arity().compareTo(p2.arity()) : result;
        }

        private Range index(Model.ArgSpec arg) {
            return arg.isOption() ? OPTION_INDEX : ((Model.PositionalParamSpec)arg).index();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Interpreter {
        private final Map<Class<?>, ITypeConverter<?>> converterRegistry = new HashMap();
        private boolean isHelpRequested;
        private int position;
        private boolean endOfOptions;
        private ParseResult.Builder parseResult;

        Interpreter() {
            this.registerBuiltInConverters();
        }

        private void registerBuiltInConverters() {
            this.converterRegistry.put(Object.class, new BuiltIn.StringConverter());
            this.converterRegistry.put(String.class, new BuiltIn.StringConverter());
            this.converterRegistry.put(StringBuilder.class, new BuiltIn.StringBuilderConverter());
            this.converterRegistry.put(CharSequence.class, new BuiltIn.CharSequenceConverter());
            this.converterRegistry.put(Byte.class, new BuiltIn.ByteConverter());
            this.converterRegistry.put(Byte.TYPE, new BuiltIn.ByteConverter());
            this.converterRegistry.put(Boolean.class, new BuiltIn.BooleanConverter());
            this.converterRegistry.put(Boolean.TYPE, new BuiltIn.BooleanConverter());
            this.converterRegistry.put(Character.class, new BuiltIn.CharacterConverter());
            this.converterRegistry.put(Character.TYPE, new BuiltIn.CharacterConverter());
            this.converterRegistry.put(Short.class, new BuiltIn.ShortConverter());
            this.converterRegistry.put(Short.TYPE, new BuiltIn.ShortConverter());
            this.converterRegistry.put(Integer.class, new BuiltIn.IntegerConverter());
            this.converterRegistry.put(Integer.TYPE, new BuiltIn.IntegerConverter());
            this.converterRegistry.put(Long.class, new BuiltIn.LongConverter());
            this.converterRegistry.put(Long.TYPE, new BuiltIn.LongConverter());
            this.converterRegistry.put(Float.class, new BuiltIn.FloatConverter());
            this.converterRegistry.put(Float.TYPE, new BuiltIn.FloatConverter());
            this.converterRegistry.put(Double.class, new BuiltIn.DoubleConverter());
            this.converterRegistry.put(Double.TYPE, new BuiltIn.DoubleConverter());
            this.converterRegistry.put(File.class, new BuiltIn.FileConverter());
            this.converterRegistry.put(URI.class, new BuiltIn.URIConverter());
            this.converterRegistry.put(URL.class, new BuiltIn.URLConverter());
            this.converterRegistry.put(Date.class, new BuiltIn.ISO8601DateConverter());
            this.converterRegistry.put(BigDecimal.class, new BuiltIn.BigDecimalConverter());
            this.converterRegistry.put(BigInteger.class, new BuiltIn.BigIntegerConverter());
            this.converterRegistry.put(Charset.class, new BuiltIn.CharsetConverter());
            this.converterRegistry.put(InetAddress.class, new BuiltIn.InetAddressConverter());
            this.converterRegistry.put(Pattern.class, new BuiltIn.PatternConverter());
            this.converterRegistry.put(UUID.class, new BuiltIn.UUIDConverter());
            this.converterRegistry.put(Currency.class, new BuiltIn.CurrencyConverter());
            this.converterRegistry.put(TimeZone.class, new BuiltIn.TimeZoneConverter());
            this.converterRegistry.put(ByteOrder.class, new BuiltIn.ByteOrderConverter());
            this.converterRegistry.put(Class.class, new BuiltIn.ClassConverter());
            this.converterRegistry.put(NetworkInterface.class, new BuiltIn.NetworkInterfaceConverter());
            BuiltIn.ISO8601TimeConverter.registerIfAvailable(this.converterRegistry, CommandLine.this.tracer);
            BuiltIn.registerIfAvailable(this.converterRegistry, CommandLine.this.tracer, "java.sql.Connection", "java.sql.DriverManager", "getConnection", String.class);
            BuiltIn.registerIfAvailable(this.converterRegistry, CommandLine.this.tracer, "java.sql.Driver", "java.sql.DriverManager", "getDriver", String.class);
            BuiltIn.registerIfAvailable(this.converterRegistry, CommandLine.this.tracer, "java.sql.Timestamp", "java.sql.Timestamp", "valueOf", String.class);
            BuiltIn.registerIfAvailable(this.converterRegistry, CommandLine.this.tracer, "java.time.Duration", "parse", CharSequence.class);
            BuiltIn.registerIfAvailable(this.converterRegistry, CommandLine.this.tracer, "java.time.Instant", "parse", CharSequence.class);
            BuiltIn.registerIfAvailable(this.converterRegistry, CommandLine.this.tracer, "java.time.LocalDate", "parse", CharSequence.class);
            BuiltIn.registerIfAvailable(this.converterRegistry, CommandLine.this.tracer, "java.time.LocalDateTime", "parse", CharSequence.class);
            BuiltIn.registerIfAvailable(this.converterRegistry, CommandLine.this.tracer, "java.time.LocalTime", "parse", CharSequence.class);
            BuiltIn.registerIfAvailable(this.converterRegistry, CommandLine.this.tracer, "java.time.MonthDay", "parse", CharSequence.class);
            BuiltIn.registerIfAvailable(this.converterRegistry, CommandLine.this.tracer, "java.time.OffsetDateTime", "parse", CharSequence.class);
            BuiltIn.registerIfAvailable(this.converterRegistry, CommandLine.this.tracer, "java.time.OffsetTime", "parse", CharSequence.class);
            BuiltIn.registerIfAvailable(this.converterRegistry, CommandLine.this.tracer, "java.time.Period", "parse", CharSequence.class);
            BuiltIn.registerIfAvailable(this.converterRegistry, CommandLine.this.tracer, "java.time.Year", "parse", CharSequence.class);
            BuiltIn.registerIfAvailable(this.converterRegistry, CommandLine.this.tracer, "java.time.YearMonth", "parse", CharSequence.class);
            BuiltIn.registerIfAvailable(this.converterRegistry, CommandLine.this.tracer, "java.time.ZonedDateTime", "parse", CharSequence.class);
            BuiltIn.registerIfAvailable(this.converterRegistry, CommandLine.this.tracer, "java.time.ZoneId", "of", String.class);
            BuiltIn.registerIfAvailable(this.converterRegistry, CommandLine.this.tracer, "java.time.ZoneOffset", "of", String.class);
            BuiltIn.registerIfAvailable(this.converterRegistry, CommandLine.this.tracer, "java.nio.file.Path", "java.nio.file.Paths", "get", String.class, String[].class);
        }

        private Model.ParserSpec config() {
            return CommandLine.this.commandSpec.parser();
        }

        List<CommandLine> parse(String ... args) {
            Assert.notNull(args, "argument array");
            if (CommandLine.this.tracer.isInfo()) {
                CommandLine.this.tracer.info("Parsing %d command line args %s%n", args.length, Arrays.toString(args));
            }
            if (CommandLine.this.tracer.isDebug()) {
                CommandLine.this.tracer.debug("Parser configuration: %s%n", this.config());
            }
            ArrayList<String> expanded = new ArrayList<String>();
            for (String arg : args) {
                this.addOrExpand(arg, expanded, new LinkedHashSet<String>());
            }
            Stack<String> arguments = new Stack<String>();
            arguments.addAll(CommandLine.reverseList(expanded));
            ArrayList<CommandLine> result = new ArrayList<CommandLine>();
            this.parse(result, arguments, args);
            return result;
        }

        private void addOrExpand(String arg, List<String> arguments, Set<String> visited) {
            if (this.config().expandAtFiles() && !arg.equals("@") && arg.startsWith("@")) {
                if ((arg = arg.substring(1)).startsWith("@")) {
                    if (CommandLine.this.tracer.isInfo()) {
                        CommandLine.this.tracer.info("Not expanding @-escaped argument %s (trimmed leading '@' char)%n", arg);
                    }
                } else {
                    if (CommandLine.this.tracer.isInfo()) {
                        CommandLine.this.tracer.info("Expanding argument file @%s%n", arg);
                    }
                    this.expandArgumentFile(arg, arguments, visited);
                    return;
                }
            }
            arguments.add(arg);
        }

        private void expandArgumentFile(String fileName, List<String> arguments, Set<String> visited) {
            File file = new File(fileName);
            if (!file.canRead()) {
                if (CommandLine.this.tracer.isInfo()) {
                    CommandLine.this.tracer.info("File %s does not exist or cannot be read; treating argument literally%n", fileName);
                }
                arguments.add("@" + fileName);
            } else if (visited.contains(file.getAbsolutePath())) {
                if (CommandLine.this.tracer.isInfo()) {
                    CommandLine.this.tracer.info("Already visited file %s; ignoring...%n", file.getAbsolutePath());
                }
            } else {
                this.expandValidArgumentFile(fileName, file, arguments, visited);
            }
        }

        private void expandValidArgumentFile(String fileName, File file, List<String> arguments, Set<String> visited) {
            visited.add(file.getAbsolutePath());
            ArrayList<String> result = new ArrayList<String>();
            BufferedReader reader = null;
            try {
                reader = new LineNumberReader(new FileReader(file));
                StreamTokenizer tok = new StreamTokenizer(reader);
                tok.resetSyntax();
                tok.wordChars(32, 255);
                tok.whitespaceChars(0, 32);
                tok.commentChar(35);
                tok.quoteChar(34);
                tok.quoteChar(39);
                while (tok.nextToken() != -1) {
                    this.addOrExpand(tok.sval, result, visited);
                }
            }
            catch (Exception ex) {
                throw new InitializationException("Could not read argument file @" + fileName, ex);
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (Exception exception) {}
                }
            }
            if (CommandLine.this.tracer.isInfo()) {
                CommandLine.this.tracer.info("Expanded file @%s to arguments %s%n", fileName, result);
            }
            arguments.addAll(result);
        }

        private void clear() {
            this.position = 0;
            this.endOfOptions = false;
            this.isHelpRequested = false;
            this.parseResult = ParseResult.builder(CommandLine.this.getCommandSpec());
            for (Model.OptionSpec option : CommandLine.this.getCommandSpec().options()) {
                this.clear(option);
            }
            for (Model.PositionalParamSpec positional : CommandLine.this.getCommandSpec().positionalParameters()) {
                this.clear(positional);
            }
        }

        private void clear(Model.ArgSpec argSpec) {
            argSpec.resetStringValues();
            argSpec.resetOriginalStringValues();
            argSpec.typedValues.clear();
            argSpec.typedValueAtPosition.clear();
            if (argSpec.hasInitialValue()) {
                try {
                    argSpec.setter().set(argSpec.initialValue());
                    CommandLine.this.tracer.debug("Set initial value for %s of type %s to %s.%n", argSpec, argSpec.type(), String.valueOf(argSpec.initialValue()));
                }
                catch (Exception ex) {
                    CommandLine.this.tracer.warn("Could not set initial value for %s of type %s to %s: %s%n", argSpec, argSpec.type(), String.valueOf(argSpec.initialValue()), ex);
                }
            } else {
                CommandLine.this.tracer.debug("Initial value not available for %s%n", argSpec);
            }
        }

        private void parse(List<CommandLine> parsedCommands, Stack<String> argumentStack, String[] originalArgs) {
            this.clear();
            if (CommandLine.this.tracer.isDebug()) {
                CommandLine.this.tracer.debug("Initializing %s: %d options, %d positional parameters, %d required, %d subcommands.%n", CommandLine.this.commandSpec.toString(), new HashSet<Model.OptionSpec>(CommandLine.this.commandSpec.optionsMap().values()).size(), CommandLine.this.commandSpec.positionalParameters().size(), CommandLine.this.commandSpec.requiredArgs().size(), CommandLine.this.commandSpec.subcommands().size());
            }
            parsedCommands.add(CommandLine.this);
            ArrayList<Model.ArgSpec> required = new ArrayList<Model.ArgSpec>(CommandLine.this.commandSpec.requiredArgs());
            HashSet<Model.ArgSpec> initialized = new HashSet<Model.ArgSpec>();
            Collections.sort(required, new PositionalParametersSorter());
            try {
                this.applyDefaultValues(required);
                this.processArguments(parsedCommands, argumentStack, required, initialized, originalArgs);
            }
            catch (ParameterException ex) {
                throw ex;
            }
            catch (Exception ex) {
                int offendingArgIndex = originalArgs.length - argumentStack.size() - 1;
                String arg = offendingArgIndex >= 0 && offendingArgIndex < originalArgs.length ? originalArgs[offendingArgIndex] : "?";
                throw ParameterException.create(CommandLine.this, ex, arg, offendingArgIndex, originalArgs);
            }
            if (!this.isAnyHelpRequested() && !required.isEmpty()) {
                for (Model.ArgSpec missing : required) {
                    if (missing.isOption()) {
                        throw MissingParameterException.create(CommandLine.this, required, this.config().separator());
                    }
                    this.assertNoMissingParameters(missing, missing.arity(), argumentStack);
                }
            }
            if (!this.parseResult.unmatched.isEmpty()) {
                String[] unmatched = this.parseResult.unmatched.toArray(new String[0]);
                for (Model.UnmatchedArgsBinding unmatchedArgsBinding : CommandLine.this.getCommandSpec().unmatchedArgsBindings()) {
                    unmatchedArgsBinding.addAll((String[])unmatched.clone());
                }
                if (!CommandLine.this.isUnmatchedArgumentsAllowed()) {
                    throw new UnmatchedArgumentException(CommandLine.this, Collections.unmodifiableList(this.parseResult.unmatched));
                }
                if (CommandLine.this.tracer.isInfo()) {
                    CommandLine.this.tracer.info("Unmatched arguments: %s%n", this.parseResult.unmatched);
                }
            }
        }

        private void applyDefaultValues(List<Model.ArgSpec> required) throws Exception {
            this.parseResult.isInitializingDefaultValues = true;
            for (Model.OptionSpec option : CommandLine.this.commandSpec.options()) {
                this.applyDefault(option, required);
            }
            for (Model.PositionalParamSpec positional : CommandLine.this.commandSpec.positionalParameters()) {
                this.applyDefault(positional, required);
            }
            this.parseResult.isInitializingDefaultValues = false;
        }

        private void applyDefault(Model.ArgSpec arg, List<Model.ArgSpec> required) throws Exception {
            if (arg.defaultValue() == null) {
                return;
            }
            if (CommandLine.this.tracer.isDebug()) {
                CommandLine.this.tracer.debug("Applying defaultValue (%s) to %s%n", arg.defaultValue(), arg);
            }
            Range arity = arg.arity().min(Math.max(1, arg.arity().min));
            this.applyOption(arg, LookBehind.SEPARATE, arity, this.stack(arg.defaultValue()), new HashSet<Model.ArgSpec>(), arg.toString);
            required.remove(arg);
        }

        private Stack<String> stack(String value) {
            Stack<String> result = new Stack<String>();
            result.push(value);
            return result;
        }

        private void processArguments(List<CommandLine> parsedCommands, Stack<String> args, Collection<Model.ArgSpec> required, Set<Model.ArgSpec> initialized, String[] originalArgs) throws Exception {
            this.parseResult.originalArgs(originalArgs);
            String separator = this.config().separator();
            while (!args.isEmpty()) {
                if (this.endOfOptions) {
                    this.processRemainderAsPositionalParameters(required, initialized, args);
                    return;
                }
                String arg = args.pop();
                if (CommandLine.this.tracer.isDebug()) {
                    CommandLine.this.tracer.debug("Processing argument '%s'. Remainder=%s%n", arg, CommandLine.reverse(CommandLine.copy(args)));
                }
                if ("--".equals(arg)) {
                    CommandLine.this.tracer.info("Found end-of-options delimiter '--'. Treating remainder as positional parameters.%n", new Object[0]);
                    this.endOfOptions = true;
                    this.processRemainderAsPositionalParameters(required, initialized, args);
                    return;
                }
                if (CommandLine.this.commandSpec.subcommands().containsKey(arg)) {
                    CommandLine subcommand = CommandLine.this.commandSpec.subcommands().get(arg);
                    this.updateHelpRequested(subcommand.commandSpec);
                    if (!this.isAnyHelpRequested() && !required.isEmpty()) {
                        throw MissingParameterException.create(CommandLine.this, required, separator);
                    }
                    if (CommandLine.this.tracer.isDebug()) {
                        CommandLine.this.tracer.debug("Found subcommand '%s' (%s)%n", arg, subcommand.commandSpec.toString());
                    }
                    subcommand.interpreter.parse(parsedCommands, args, originalArgs);
                    this.parseResult.subcommand(((CommandLine)subcommand).interpreter.parseResult.build());
                    return;
                }
                boolean paramAttachedToOption = false;
                int separatorIndex = arg.indexOf(separator);
                if (separatorIndex > 0) {
                    String key = arg.substring(0, separatorIndex);
                    if (CommandLine.this.commandSpec.optionsMap().containsKey(key) && !CommandLine.this.commandSpec.optionsMap().containsKey(arg)) {
                        paramAttachedToOption = true;
                        String optionParam = arg.substring(separatorIndex + separator.length());
                        args.push(optionParam);
                        arg = key;
                        if (CommandLine.this.tracer.isDebug()) {
                            CommandLine.this.tracer.debug("Separated '%s' option from '%s' option parameter%n", key, optionParam);
                        }
                    } else if (CommandLine.this.tracer.isDebug()) {
                        CommandLine.this.tracer.debug("'%s' contains separator '%s' but '%s' is not a known option%n", arg, separator, key);
                    }
                } else if (CommandLine.this.tracer.isDebug()) {
                    CommandLine.this.tracer.debug("'%s' cannot be separated into <option>%s<option-parameter>%n", arg, separator);
                }
                if (this.isStandaloneOption(arg)) {
                    this.processStandaloneOption(required, initialized, arg, args, paramAttachedToOption);
                    continue;
                }
                if (this.config().posixClusteredShortOptionsAllowed() && arg.length() > 2 && arg.startsWith("-")) {
                    if (CommandLine.this.tracer.isDebug()) {
                        CommandLine.this.tracer.debug("Trying to process '%s' as clustered short options%n", arg, args);
                    }
                    this.processClusteredShortOptions(required, initialized, arg, args);
                    continue;
                }
                args.push(arg);
                if (CommandLine.this.tracer.isDebug()) {
                    CommandLine.this.tracer.debug("Could not find option '%s', deciding whether to treat as unmatched option or positional parameter...%n", arg);
                }
                if (this.resemblesOption(arg)) {
                    this.handleUnmatchedArgument(args);
                    continue;
                }
                if (CommandLine.this.tracer.isDebug()) {
                    CommandLine.this.tracer.debug("No option named '%s' found. Processing remainder as positional parameters%n", arg);
                }
                this.processPositionalParameter(required, initialized, args);
            }
        }

        private boolean isStandaloneOption(String arg) {
            return CommandLine.this.commandSpec.optionsMap().containsKey(arg);
        }

        private boolean resemblesOption(String arg) {
            boolean result;
            if (CommandLine.this.commandSpec.parser().unmatchedOptionsArePositionalParams()) {
                if (CommandLine.this.tracer.isDebug()) {
                    CommandLine.this.tracer.debug("Parser is configured to treat all unmatched options as positional parameter%n", arg);
                }
                return false;
            }
            if (CommandLine.this.commandSpec.options().isEmpty()) {
                boolean result2 = arg.startsWith("-");
                if (CommandLine.this.tracer.isDebug()) {
                    CommandLine.this.tracer.debug("%s %s an option%n", arg, result2 ? "resembles" : "doesn't resemble");
                }
                return result2;
            }
            int count = 0;
            for (String optionName : CommandLine.this.commandSpec.optionsMap().keySet()) {
                for (int i = 0; i < arg.length() && optionName.length() > i && arg.charAt(i) == optionName.charAt(i); ++i) {
                    ++count;
                }
            }
            boolean bl = result = count > 0 && count * 10 >= CommandLine.this.commandSpec.optionsMap().size() * 9;
            if (CommandLine.this.tracer.isDebug()) {
                CommandLine.this.tracer.debug("%s %s an option: %d matching prefix chars out of %d option names%n", arg, result ? "resembles" : "doesn't resemble", count, CommandLine.this.commandSpec.optionsMap().size());
            }
            return result;
        }

        private void handleUnmatchedArgument(Stack<String> args) throws Exception {
            if (!args.isEmpty()) {
                this.handleUnmatchedArgument(args.pop());
            }
            if (this.config().stopAtUnmatched()) {
                while (!args.isEmpty()) {
                    this.handleUnmatchedArgument(args.pop());
                }
            }
        }

        private void handleUnmatchedArgument(String arg) {
            this.parseResult.unmatched.add(arg);
        }

        private void processRemainderAsPositionalParameters(Collection<Model.ArgSpec> required, Set<Model.ArgSpec> initialized, Stack<String> args) throws Exception {
            while (!args.empty()) {
                this.processPositionalParameter(required, initialized, args);
            }
        }

        private void processPositionalParameter(Collection<Model.ArgSpec> required, Set<Model.ArgSpec> initialized, Stack<String> args) throws Exception {
            if (CommandLine.this.tracer.isDebug()) {
                CommandLine.this.tracer.debug("Processing next arg as a positional parameter at index=%d. Remainder=%s%n", this.position, CommandLine.reverse(CommandLine.copy(args)));
            }
            if (this.config().stopAtPositional()) {
                if (!this.endOfOptions && CommandLine.this.tracer.isDebug()) {
                    CommandLine.this.tracer.debug("Parser was configured with stopAtPositional=true, treating remaining arguments as positional parameters.%n", new Object[0]);
                }
                this.endOfOptions = true;
            }
            int consumed = 0;
            for (Model.PositionalParamSpec positionalParam : CommandLine.this.commandSpec.positionalParameters()) {
                Range indexRange = positionalParam.index();
                if (!indexRange.contains(this.position) || positionalParam.typedValueAtPosition.get(this.position) != null) continue;
                Stack argsCopy = CommandLine.copy(args);
                Range arity = positionalParam.arity();
                if (CommandLine.this.tracer.isDebug()) {
                    CommandLine.this.tracer.debug("Position %d is in index range %s. Trying to assign args to %s, arity=%s%n", this.position, indexRange, positionalParam, arity);
                }
                this.assertNoMissingParameters(positionalParam, arity, argsCopy);
                int originalSize = argsCopy.size();
                this.applyOption(positionalParam, LookBehind.SEPARATE, arity, argsCopy, initialized, "args[" + indexRange + "] at position " + this.position);
                int count = originalSize - argsCopy.size();
                if (count > 0) {
                    required.remove(positionalParam);
                }
                consumed = Math.max(consumed, count);
            }
            for (int i = 0; i < consumed; ++i) {
                args.pop();
            }
            this.position += consumed;
            if (CommandLine.this.tracer.isDebug()) {
                CommandLine.this.tracer.debug("Consumed %d arguments, moving position to index %d.%n", consumed, this.position);
            }
            if (consumed == 0 && !args.isEmpty()) {
                this.handleUnmatchedArgument(args);
            }
        }

        private void processStandaloneOption(Collection<Model.ArgSpec> required, Set<Model.ArgSpec> initialized, String arg, Stack<String> args, boolean paramAttachedToKey) throws Exception {
            LookBehind lookBehind;
            Model.ArgSpec argSpec = CommandLine.this.commandSpec.optionsMap().get(arg);
            required.remove(argSpec);
            Range arity = argSpec.arity();
            if (paramAttachedToKey) {
                arity = arity.min(Math.max(1, arity.min));
            }
            LookBehind lookBehind2 = lookBehind = paramAttachedToKey ? LookBehind.ATTACHED_WITH_SEPARATOR : LookBehind.SEPARATE;
            if (CommandLine.this.tracer.isDebug()) {
                CommandLine.this.tracer.debug("Found option named '%s': %s, arity=%s%n", arg, argSpec, arity);
            }
            this.applyOption(argSpec, lookBehind, arity, args, initialized, "option " + arg);
        }

        private void processClusteredShortOptions(Collection<Model.ArgSpec> required, Set<Model.ArgSpec> initialized, String arg, Stack<String> args) throws Exception {
            String prefix = arg.substring(0, 1);
            String cluster = arg.substring(1);
            boolean paramAttachedToOption = true;
            while (cluster.length() > 0 && CommandLine.this.commandSpec.posixOptionsMap().containsKey(Character.valueOf(cluster.charAt(0)))) {
                LookBehind lookBehind;
                Model.ArgSpec argSpec = CommandLine.this.commandSpec.posixOptionsMap().get(Character.valueOf(cluster.charAt(0)));
                Range arity = argSpec.arity();
                String argDescription = "option " + prefix + cluster.charAt(0);
                if (CommandLine.this.tracer.isDebug()) {
                    CommandLine.this.tracer.debug("Found option '%s%s' in %s: %s, arity=%s%n", prefix, Character.valueOf(cluster.charAt(0)), arg, argSpec, arity);
                }
                required.remove(argSpec);
                cluster = cluster.length() > 0 ? cluster.substring(1) : "";
                paramAttachedToOption = cluster.length() > 0;
                LookBehind lookBehind2 = lookBehind = paramAttachedToOption ? LookBehind.ATTACHED_WITH_SEPARATOR : LookBehind.SEPARATE;
                if (cluster.startsWith(this.config().separator())) {
                    lookBehind = LookBehind.ATTACHED_WITH_SEPARATOR;
                    cluster = cluster.substring(this.config().separator().length());
                    arity = arity.min(Math.max(1, arity.min));
                }
                if (arity.min > 0 && !CommandLine.empty(cluster) && CommandLine.this.tracer.isDebug()) {
                    CommandLine.this.tracer.debug("Trying to process '%s' as option parameter%n", cluster);
                }
                if (!CommandLine.empty(cluster)) {
                    args.push(cluster);
                }
                int argCount = args.size();
                int consumed = this.applyOption(argSpec, lookBehind, arity, args, initialized, argDescription);
                if (CommandLine.empty(cluster) || args.isEmpty() || args.size() < argCount) {
                    return;
                }
                cluster = args.pop();
            }
            if (cluster.length() == 0) {
                return;
            }
            if (arg.endsWith(cluster)) {
                args.push(paramAttachedToOption ? prefix + cluster : cluster);
                if (args.peek().equals(arg)) {
                    if (CommandLine.this.tracer.isDebug()) {
                        CommandLine.this.tracer.debug("Could not match any short options in %s, deciding whether to treat as unmatched option or positional parameter...%n", arg);
                    }
                    if (this.resemblesOption(arg)) {
                        this.handleUnmatchedArgument(args);
                        return;
                    }
                    this.processPositionalParameter(required, initialized, args);
                    return;
                }
                if (CommandLine.this.tracer.isDebug()) {
                    CommandLine.this.tracer.debug("No option found for %s in %s%n", cluster, arg);
                }
                this.handleUnmatchedArgument(args);
            } else {
                args.push(cluster);
                if (CommandLine.this.tracer.isDebug()) {
                    CommandLine.this.tracer.debug("%s is not an option parameter for %s%n", cluster, arg);
                }
                this.processPositionalParameter(required, initialized, args);
            }
        }

        private int applyOption(Model.ArgSpec argSpec, LookBehind lookBehind, Range arity, Stack<String> args, Set<Model.ArgSpec> initialized, String argDescription) throws Exception {
            this.updateHelpRequested(argSpec);
            boolean consumeOnlyOne = CommandLine.this.commandSpec.parser().aritySatisfiedByAttachedOptionParam() && lookBehind.isAttached();
            Stack<String> workingStack = args;
            if (consumeOnlyOne) {
                workingStack = args.isEmpty() ? args : this.stack(args.pop());
            } else {
                this.assertNoMissingParameters(argSpec, arity, args);
            }
            int result = argSpec.type().isArray() ? this.applyValuesToArrayField(argSpec, arity, workingStack, initialized, argDescription) : (Collection.class.isAssignableFrom(argSpec.type()) ? this.applyValuesToCollectionField(argSpec, arity, workingStack, initialized, argDescription) : (Map.class.isAssignableFrom(argSpec.type()) ? this.applyValuesToMapField(argSpec, arity, workingStack, initialized, argDescription) : this.applyValueToSingleValuedField(argSpec, arity, workingStack, initialized, argDescription)));
            if (workingStack != args && !workingStack.isEmpty()) {
                args.push(workingStack.pop());
                if (!workingStack.isEmpty()) {
                    throw new IllegalStateException("Working stack should be empty but was " + new ArrayList<String>(workingStack));
                }
            }
            return result;
        }

        private int applyValueToSingleValuedField(Model.ArgSpec argSpec, Range arity, Stack<String> args, Set<Model.ArgSpec> initialized, String argDescription) throws Exception {
            boolean noMoreValues = args.isEmpty();
            String value = args.isEmpty() ? null : this.trim(args.pop());
            int result = arity.min;
            Class<?> cls = argSpec.auxiliaryTypes()[0];
            if (arity.min <= 0) {
                if (cls == Boolean.class || cls == Boolean.TYPE) {
                    if (arity.max > 0 && ("true".equalsIgnoreCase(value) || "false".equalsIgnoreCase(value))) {
                        result = 1;
                    } else {
                        Boolean currentValue;
                        if (value != null) {
                            args.push(value);
                        }
                        value = CommandLine.this.commandSpec.parser().toggleBooleanFlags() ? String.valueOf((currentValue = (Boolean)argSpec.getValue()) == null || currentValue == false) : "true";
                    }
                } else if (this.isOption(value)) {
                    args.push(value);
                    value = "";
                } else if (value == null) {
                    value = "";
                }
            }
            if (noMoreValues && value == null) {
                return 0;
            }
            ITypeConverter<?> converter = this.getTypeConverter(cls, argSpec, 0);
            Object newValue = this.tryConvert(argSpec, -1, converter, value, cls);
            Object oldValue = argSpec.getValue();
            String traceMessage = "Setting %s to '%3$s' (was '%2$s') for %4$s%n";
            if (initialized != null) {
                if (initialized.contains(argSpec)) {
                    if (!CommandLine.this.isOverwrittenOptionsAllowed()) {
                        throw new OverwrittenOptionException(CommandLine.this, this.optionDescription("", argSpec, 0) + " should be specified only once");
                    }
                    traceMessage = "Overwriting %s value '%s' with '%s' for %s%n";
                }
                initialized.add(argSpec);
            }
            if (CommandLine.this.tracer.isInfo()) {
                CommandLine.this.tracer.info(traceMessage, argSpec.toString(), String.valueOf(oldValue), String.valueOf(newValue), argDescription);
            }
            argSpec.setValue(newValue);
            this.parseResult.addOriginalStringValue(argSpec, value);
            this.parseResult.addStringValue(argSpec, value);
            this.parseResult.addTypedValues(argSpec, this.position, newValue);
            this.parseResult.add(argSpec, this.position);
            return result;
        }

        private int applyValuesToMapField(Model.ArgSpec argSpec, Range arity, Stack<String> args, Set<Model.ArgSpec> initialized, String argDescription) throws Exception {
            Class<?>[] classes = argSpec.auxiliaryTypes();
            if (classes.length < 2) {
                throw new ParameterException(CommandLine.this, argSpec.toString() + " needs two types (one for the map key, one for the value) but only has " + classes.length + " types configured.");
            }
            ITypeConverter<?> keyConverter = this.getTypeConverter(classes[0], argSpec, 0);
            ITypeConverter<?> valueConverter = this.getTypeConverter(classes[1], argSpec, 1);
            Map<Object, Object> map = (Map<Object, Object>)argSpec.getValue();
            if (map == null || !map.isEmpty() && !initialized.contains(argSpec)) {
                map = this.createMap(argSpec.type());
                argSpec.setValue(map);
            }
            initialized.add(argSpec);
            int originalSize = map.size();
            this.consumeMapArguments(argSpec, arity, args, classes, keyConverter, valueConverter, map, argDescription);
            this.parseResult.add(argSpec, this.position);
            argSpec.setValue(map);
            return map.size() - originalSize;
        }

        private void consumeMapArguments(Model.ArgSpec argSpec, Range arity, Stack<String> args, Class<?>[] classes, ITypeConverter<?> keyConverter, ITypeConverter<?> valueConverter, Map<Object, Object> result, String argDescription) throws Exception {
            LinkedHashMap<Object, Object> typedValuesAtPosition;
            int currentPosition = this.position;
            int initialSize = argSpec.stringValues().size();
            int consumed = this.consumedCountMap(0, initialSize, argSpec);
            int i = 0;
            while (consumed < arity.min && !args.isEmpty()) {
                typedValuesAtPosition = new LinkedHashMap<Object, Object>();
                this.parseResult.addTypedValues(argSpec, currentPosition++, typedValuesAtPosition);
                this.assertNoMissingMandatoryParameter(argSpec, args, i, arity);
                this.consumeOneMapArgument(argSpec, arity, consumed, args.pop(), classes, keyConverter, valueConverter, typedValuesAtPosition, i, argDescription);
                result.putAll(typedValuesAtPosition);
                consumed = this.consumedCountMap(i + 1, initialSize, argSpec);
                ++i;
            }
            i = consumed;
            while (consumed < arity.max && !args.isEmpty() && this.varargCanConsumeNextValue(argSpec, args.peek())) {
                typedValuesAtPosition = new LinkedHashMap();
                this.parseResult.addTypedValues(argSpec, currentPosition++, typedValuesAtPosition);
                if (!this.canConsumeOneMapArgument(argSpec, arity, consumed, args.peek(), classes, keyConverter, valueConverter, argDescription)) break;
                this.consumeOneMapArgument(argSpec, arity, consumed, args.pop(), classes, keyConverter, valueConverter, typedValuesAtPosition, i, argDescription);
                result.putAll(typedValuesAtPosition);
                consumed = this.consumedCountMap(i + 1, initialSize, argSpec);
                ++i;
            }
        }

        private void consumeOneMapArgument(Model.ArgSpec argSpec, Range arity, int consumed, String arg, Class<?>[] classes, ITypeConverter<?> keyConverter, ITypeConverter<?> valueConverter, Map<Object, Object> result, int index, String argDescription) {
            String[] values;
            String raw = this.trim(arg);
            for (String value : values = argSpec.splitValue(raw, CommandLine.this.commandSpec.parser(), arity, consumed)) {
                String[] keyValue = this.splitKeyValue(argSpec, value);
                Object mapKey = this.tryConvert(argSpec, index, keyConverter, keyValue[0], classes[0]);
                Object mapValue = this.tryConvert(argSpec, index, valueConverter, keyValue[1], classes[1]);
                result.put(mapKey, mapValue);
                if (CommandLine.this.tracer.isInfo()) {
                    CommandLine.this.tracer.info("Putting [%s : %s] in %s<%s, %s> %s for %s%n", String.valueOf(mapKey), String.valueOf(mapValue), result.getClass().getSimpleName(), classes[0].getSimpleName(), classes[1].getSimpleName(), argSpec.toString(), argDescription);
                }
                this.parseResult.addStringValue(argSpec, keyValue[0]);
                this.parseResult.addStringValue(argSpec, keyValue[1]);
            }
            this.parseResult.addOriginalStringValue(argSpec, raw);
        }

        private boolean canConsumeOneMapArgument(Model.ArgSpec argSpec, Range arity, int consumed, String raw, Class<?>[] classes, ITypeConverter<?> keyConverter, ITypeConverter<?> valueConverter, String argDescription) {
            String[] values = argSpec.splitValue(raw, CommandLine.this.commandSpec.parser(), arity, consumed);
            try {
                for (String value : values) {
                    String[] keyValue = this.splitKeyValue(argSpec, value);
                    this.tryConvert(argSpec, -1, keyConverter, keyValue[0], classes[0]);
                    this.tryConvert(argSpec, -1, valueConverter, keyValue[1], classes[1]);
                }
                return true;
            }
            catch (PicocliException ex) {
                CommandLine.this.tracer.debug("$s cannot be assigned to %s: type conversion fails: %s.%n", raw, argDescription, ex.getMessage());
                return false;
            }
        }

        private String[] splitKeyValue(Model.ArgSpec argSpec, String value) {
            String[] keyValue = value.split("=");
            if (keyValue.length < 2) {
                String splitRegex = argSpec.splitRegex();
                if (splitRegex.length() == 0) {
                    throw new ParameterException(CommandLine.this, "Value for option " + this.optionDescription("", argSpec, 0) + " should be in KEY=VALUE format but was " + value);
                }
                throw new ParameterException(CommandLine.this, "Value for option " + this.optionDescription("", argSpec, 0) + " should be in KEY=VALUE[" + splitRegex + "KEY=VALUE]... format but was " + value);
            }
            return keyValue;
        }

        private void assertNoMissingMandatoryParameter(Model.ArgSpec argSpec, Stack<String> args, int i, Range arity) {
            if (!this.varargCanConsumeNextValue(argSpec, args.peek())) {
                String desc = arity.min > 1 ? i + 1 + " (of " + arity.min + " mandatory parameters) " : "";
                throw new MissingParameterException(CommandLine.this, argSpec, "Expected parameter " + desc + "for " + this.optionDescription("", argSpec, -1) + " but found '" + args.peek() + "'");
            }
        }

        private int applyValuesToArrayField(Model.ArgSpec argSpec, Range arity, Stack<String> args, Set<Model.ArgSpec> initialized, String argDescription) throws Exception {
            Object existing = argSpec.getValue();
            int length = existing == null ? 0 : Array.getLength(existing);
            Class<?> type = argSpec.auxiliaryTypes()[0];
            List<Object> converted = this.consumeArguments(argSpec, arity, args, type, argDescription);
            ArrayList<Object> newValues = new ArrayList<Object>();
            if (initialized.contains(argSpec)) {
                for (int i = 0; i < length; ++i) {
                    newValues.add(Array.get(existing, i));
                }
            }
            initialized.add(argSpec);
            for (Object obj : converted) {
                if (obj instanceof Collection) {
                    newValues.addAll((Collection)obj);
                    continue;
                }
                newValues.add(obj);
            }
            Object array = Array.newInstance(type, newValues.size());
            argSpec.setValue(array);
            for (int i = 0; i < newValues.size(); ++i) {
                Array.set(array, i, newValues.get(i));
            }
            this.parseResult.add(argSpec, this.position);
            return converted.size();
        }

        private int applyValuesToCollectionField(Model.ArgSpec argSpec, Range arity, Stack<String> args, Set<Model.ArgSpec> initialized, String argDescription) throws Exception {
            Collection<Object> collection = (Collection<Object>)argSpec.getValue();
            Class<?> type = argSpec.auxiliaryTypes()[0];
            List<Object> converted = this.consumeArguments(argSpec, arity, args, type, argDescription);
            if (collection == null || !collection.isEmpty() && !initialized.contains(argSpec)) {
                collection = this.createCollection(argSpec.type());
                argSpec.setValue(collection);
            }
            initialized.add(argSpec);
            for (Object element : converted) {
                if (element instanceof Collection) {
                    collection.addAll((Collection)element);
                    continue;
                }
                collection.add(element);
            }
            this.parseResult.add(argSpec, this.position);
            argSpec.setValue(collection);
            return converted.size();
        }

        private List<Object> consumeArguments(Model.ArgSpec argSpec, Range arity, Stack<String> args, Class<?> type, String argDescription) throws Exception {
            ArrayList<Object> typedValuesAtPosition;
            ArrayList<Object> result = new ArrayList<Object>();
            int currentPosition = this.position;
            int initialSize = argSpec.stringValues().size();
            int consumed = this.consumedCount(0, initialSize, argSpec);
            int i = 0;
            while (consumed < arity.min && !args.isEmpty()) {
                typedValuesAtPosition = new ArrayList<Object>();
                this.parseResult.addTypedValues(argSpec, currentPosition++, typedValuesAtPosition);
                this.assertNoMissingMandatoryParameter(argSpec, args, i, arity);
                this.consumeOneArgument(argSpec, arity, consumed, args.pop(), type, typedValuesAtPosition, i, argDescription);
                result.addAll(typedValuesAtPosition);
                consumed = this.consumedCount(i + 1, initialSize, argSpec);
                ++i;
            }
            i = consumed;
            while (consumed < arity.max && !args.isEmpty() && this.varargCanConsumeNextValue(argSpec, args.peek())) {
                typedValuesAtPosition = new ArrayList();
                this.parseResult.addTypedValues(argSpec, currentPosition++, typedValuesAtPosition);
                if (!this.canConsumeOneArgument(argSpec, arity, consumed, args.peek(), type, argDescription)) break;
                this.consumeOneArgument(argSpec, arity, consumed, args.pop(), type, typedValuesAtPosition, i, argDescription);
                result.addAll(typedValuesAtPosition);
                consumed = this.consumedCount(i + 1, initialSize, argSpec);
                ++i;
            }
            if (result.isEmpty() && arity.min == 0 && arity.max <= 1 && CommandLine.isBoolean(type)) {
                return Arrays.asList(Boolean.TRUE);
            }
            return result;
        }

        private int consumedCount(int i, int initialSize, Model.ArgSpec arg) {
            return CommandLine.this.commandSpec.parser().splitFirst() ? arg.stringValues().size() - initialSize : i;
        }

        private int consumedCountMap(int i, int initialSize, Model.ArgSpec arg) {
            return CommandLine.this.commandSpec.parser().splitFirst() ? (arg.stringValues().size() - initialSize) / 2 : i;
        }

        private int consumeOneArgument(Model.ArgSpec argSpec, Range arity, int consumed, String arg, Class<?> type, List<Object> result, int index, String argDescription) {
            String raw = this.trim(arg);
            String[] values = argSpec.splitValue(raw, CommandLine.this.commandSpec.parser(), arity, consumed);
            ITypeConverter<?> converter = this.getTypeConverter(type, argSpec, 0);
            for (int j = 0; j < values.length; ++j) {
                result.add(this.tryConvert(argSpec, index, converter, values[j], type));
                if (CommandLine.this.tracer.isInfo()) {
                    CommandLine.this.tracer.info("Adding [%s] to %s for %s%n", String.valueOf(result.get(result.size() - 1)), argSpec.toString(), argDescription);
                }
                this.parseResult.addStringValue(argSpec, values[j]);
            }
            this.parseResult.addOriginalStringValue(argSpec, raw);
            return ++index;
        }

        private boolean canConsumeOneArgument(Model.ArgSpec argSpec, Range arity, int consumed, String arg, Class<?> type, String argDescription) {
            ITypeConverter<?> converter = this.getTypeConverter(type, argSpec, 0);
            try {
                String[] values;
                for (String value : values = argSpec.splitValue(this.trim(arg), CommandLine.this.commandSpec.parser(), arity, consumed)) {
                    this.tryConvert(argSpec, -1, converter, value, type);
                }
                return true;
            }
            catch (PicocliException ex) {
                CommandLine.this.tracer.debug("$s cannot be assigned to %s: type conversion fails: %s.%n", arg, argDescription, ex.getMessage());
                return false;
            }
        }

        private boolean varargCanConsumeNextValue(Model.ArgSpec argSpec, String nextValue) {
            if (this.endOfOptions && argSpec.isPositional()) {
                return true;
            }
            boolean isCommand = CommandLine.this.commandSpec.subcommands().containsKey(nextValue);
            return !isCommand && !this.isOption(nextValue);
        }

        private boolean isOption(String arg) {
            if (arg == null) {
                return false;
            }
            if ("--".equals(arg)) {
                return true;
            }
            if (CommandLine.this.commandSpec.optionsMap().containsKey(arg)) {
                return true;
            }
            int separatorIndex = arg.indexOf(this.config().separator());
            if (separatorIndex > 0 && CommandLine.this.commandSpec.optionsMap().containsKey(arg.substring(0, separatorIndex))) {
                return true;
            }
            return arg.length() > 2 && arg.startsWith("-") && CommandLine.this.commandSpec.posixOptionsMap().containsKey(Character.valueOf(arg.charAt(1)));
        }

        private Object tryConvert(Model.ArgSpec argSpec, int index, ITypeConverter<?> converter, String value, Class<?> type) throws ParameterException {
            try {
                return converter.convert(value);
            }
            catch (TypeConversionException ex) {
                throw new ParameterException(CommandLine.this, ex.getMessage() + this.optionDescription(" for ", argSpec, index));
            }
            catch (Exception other) {
                String desc = this.optionDescription(" for ", argSpec, index) + ": " + other;
                throw new ParameterException(CommandLine.this, "Could not convert '" + value + "' to " + type.getSimpleName() + desc, other);
            }
        }

        private String optionDescription(String prefix, Model.ArgSpec argSpec, int index) {
            String desc = "";
            if (argSpec.isOption()) {
                desc = prefix + "option '" + ((Model.OptionSpec)argSpec).longestName() + "'";
                if (index >= 0) {
                    if (argSpec.arity().max > 1) {
                        desc = desc + " at index " + index;
                    }
                    desc = desc + " (" + argSpec.paramLabel() + ")";
                }
            } else {
                desc = prefix + "positional parameter at index " + ((Model.PositionalParamSpec)argSpec).index() + " (" + argSpec.paramLabel() + ")";
            }
            return desc;
        }

        private boolean isAnyHelpRequested() {
            return this.isHelpRequested || this.parseResult.versionHelpRequested || this.parseResult.usageHelpRequested;
        }

        private void updateHelpRequested(Model.CommandSpec command) {
            this.isHelpRequested |= command.helpCommand();
        }

        private void updateHelpRequested(Model.ArgSpec argSpec) {
            if (argSpec.isOption()) {
                Model.OptionSpec option = (Model.OptionSpec)argSpec;
                this.isHelpRequested |= this.is(argSpec, "help", option.help());
                this.parseResult.versionHelpRequested = (byte)(this.parseResult.versionHelpRequested | (this.is(argSpec, "versionHelp", option.versionHelp()) ? 1 : 0));
                this.parseResult.usageHelpRequested = (byte)(this.parseResult.usageHelpRequested | (this.is(argSpec, "usageHelp", option.usageHelp()) ? 1 : 0));
            }
        }

        private boolean is(Model.ArgSpec p, String attribute, boolean value) {
            if (value && CommandLine.this.tracer.isInfo()) {
                CommandLine.this.tracer.info("%s has '%s' annotation: not validating required fields%n", p.toString(), attribute);
            }
            return value;
        }

        private Collection<Object> createCollection(Class<?> collectionClass) throws Exception {
            if (collectionClass.isInterface()) {
                if (List.class.isAssignableFrom(collectionClass)) {
                    return new ArrayList<Object>();
                }
                if (SortedSet.class.isAssignableFrom(collectionClass)) {
                    return new TreeSet<Object>();
                }
                if (Set.class.isAssignableFrom(collectionClass)) {
                    return new LinkedHashSet<Object>();
                }
                if (Queue.class.isAssignableFrom(collectionClass)) {
                    return new LinkedList<Object>();
                }
                return new ArrayList<Object>();
            }
            return (Collection)collectionClass.newInstance();
        }

        private Map<Object, Object> createMap(Class<?> mapClass) throws Exception {
            try {
                return (Map)mapClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception exception) {
                return new LinkedHashMap<Object, Object>();
            }
        }

        private ITypeConverter<?> getTypeConverter(final Class<?> type, Model.ArgSpec argSpec, int index) {
            if (argSpec.converters().length > index) {
                return argSpec.converters()[index];
            }
            if (this.converterRegistry.containsKey(type)) {
                return this.converterRegistry.get(type);
            }
            if (type.isEnum()) {
                return new ITypeConverter<Object>(){

                    @Override
                    public Object convert(String value) throws Exception {
                        return Enum.valueOf(type, value);
                    }
                };
            }
            throw new MissingTypeConverterException(CommandLine.this, "No TypeConverter registered for " + type.getName() + " of " + argSpec);
        }

        private void assertNoMissingParameters(Model.ArgSpec argSpec, Range arity, Stack<String> args) {
            int available = args.size();
            if (available > 0 && CommandLine.this.commandSpec.parser().splitFirst() && argSpec.splitRegex().length() > 0) {
                available += argSpec.splitValue(args.peek(), CommandLine.this.commandSpec.parser(), arity, 0).length - 1;
            }
            if (arity.min > available) {
                if (arity.min == 1) {
                    if (argSpec.isOption()) {
                        throw new MissingParameterException(CommandLine.this, argSpec, "Missing required parameter for " + this.optionDescription("", argSpec, 0));
                    }
                    Range indexRange = ((Model.PositionalParamSpec)argSpec).index();
                    String sep = "";
                    String names = "";
                    int count = 0;
                    List<Model.PositionalParamSpec> positionalParameters = CommandLine.this.commandSpec.positionalParameters();
                    for (int i = indexRange.min; i < positionalParameters.size(); ++i) {
                        if (positionalParameters.get((int)i).arity().min <= 0) continue;
                        names = names + sep + positionalParameters.get(i).paramLabel();
                        sep = ", ";
                        ++count;
                    }
                    String msg = "Missing required parameter";
                    Range paramArity = argSpec.arity();
                    msg = paramArity.isVariable ? msg + "s at positions " + indexRange + ": " : msg + (count > 1 ? "s: " : ": ");
                    throw new MissingParameterException(CommandLine.this, argSpec, msg + names);
                }
                if (args.isEmpty()) {
                    throw new MissingParameterException(CommandLine.this, argSpec, this.optionDescription("", argSpec, 0) + " requires at least " + arity.min + " values, but none were specified.");
                }
                throw new MissingParameterException(CommandLine.this, argSpec, this.optionDescription("", argSpec, 0) + " requires at least " + arity.min + " values, but only " + available + " were specified: " + CommandLine.reverse(args));
            }
        }

        private String trim(String value) {
            return this.unquote(value);
        }

        private String unquote(String value) {
            return value == null ? null : (value.length() > 1 && value.startsWith("\"") && value.endsWith("\"") ? value.substring(1, value.length() - 1) : value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum LookBehind {
        SEPARATE,
        ATTACHED,
        ATTACHED_WITH_SEPARATOR;


        public boolean isAttached() {
            return this != SEPARATE;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ParseResult {
        private final Model.CommandSpec commandSpec;
        private final List<Model.OptionSpec> matchedOptions;
        private final List<Model.PositionalParamSpec> matchedUniquePositionals;
        private final List<String> originalArgs;
        private final List<String> unmatched;
        private final List<List<Model.PositionalParamSpec>> matchedPositionalParams;
        private final ParseResult subcommand;
        private final boolean usageHelpRequested;
        private final boolean versionHelpRequested;

        public static Builder builder(Model.CommandSpec commandSpec) {
            return new Builder(commandSpec);
        }

        private ParseResult(Builder builder) {
            this.commandSpec = builder.commandSpec;
            this.subcommand = builder.subcommand;
            this.matchedOptions = new ArrayList<Model.OptionSpec>(builder.options);
            this.unmatched = new ArrayList<String>(builder.unmatched);
            this.originalArgs = new ArrayList<String>(builder.originalArgList);
            this.matchedUniquePositionals = new ArrayList<Model.PositionalParamSpec>(builder.positionals);
            this.matchedPositionalParams = new ArrayList<List<Model.PositionalParamSpec>>(builder.positionalParams);
            this.usageHelpRequested = builder.usageHelpRequested;
            this.versionHelpRequested = builder.versionHelpRequested;
        }

        public Model.OptionSpec matchedOption(char shortName) {
            return Model.CommandSpec.findOption(shortName, this.matchedOptions);
        }

        public Model.OptionSpec matchedOption(String name) {
            return Model.CommandSpec.findOption(name, this.matchedOptions);
        }

        public Model.PositionalParamSpec matchedPositional(int position) {
            if (this.matchedPositionalParams.size() <= position || this.matchedPositionalParams.get(position).isEmpty()) {
                return null;
            }
            return this.matchedPositionalParams.get(position).get(0);
        }

        public List<Model.PositionalParamSpec> matchedPositionals(int position) {
            if (this.matchedPositionalParams.size() <= position) {
                return Collections.emptyList();
            }
            return this.matchedPositionalParams.get(position) == null ? Collections.emptyList() : this.matchedPositionalParams.get(position);
        }

        public Model.CommandSpec commandSpec() {
            return this.commandSpec;
        }

        public boolean hasMatchedOption(char shortName) {
            return this.matchedOption(shortName) != null;
        }

        public boolean hasMatchedOption(String name) {
            return this.matchedOption(name) != null;
        }

        public boolean hasMatchedOption(Model.OptionSpec option) {
            return this.matchedOptions.contains(option);
        }

        public boolean hasMatchedPositional(int position) {
            return this.matchedPositional(position) != null;
        }

        public boolean hasMatchedPositional(Model.PositionalParamSpec positional) {
            return this.matchedUniquePositionals.contains(positional);
        }

        public List<Model.OptionSpec> matchedOptions() {
            return Collections.unmodifiableList(this.matchedOptions);
        }

        public List<Model.PositionalParamSpec> matchedPositionals() {
            return Collections.unmodifiableList(this.matchedUniquePositionals);
        }

        public List<String> unmatched() {
            return Collections.unmodifiableList(this.unmatched);
        }

        public List<String> originalArgs() {
            return Collections.unmodifiableList(this.originalArgs);
        }

        public <T> T matchedOptionValue(char shortName, T defaultValue) {
            return this.matchedOptionValue(this.matchedOption(shortName), defaultValue);
        }

        public <T> T matchedOptionValue(String name, T defaultValue) {
            return this.matchedOptionValue(this.matchedOption(name), defaultValue);
        }

        private <T> T matchedOptionValue(Model.OptionSpec option, T defaultValue) {
            return option == null ? defaultValue : option.getValue();
        }

        public <T> T matchedPositionalValue(int position, T defaultValue) {
            return this.matchedPositionalValue(this.matchedPositional(position), defaultValue);
        }

        private <T> T matchedPositionalValue(Model.PositionalParamSpec positional, T defaultValue) {
            return positional == null ? defaultValue : positional.getValue();
        }

        public boolean hasSubcommand() {
            return this.subcommand != null;
        }

        public ParseResult subcommand() {
            return this.subcommand;
        }

        public boolean isUsageHelpRequested() {
            return this.usageHelpRequested;
        }

        public boolean isVersionHelpRequested() {
            return this.versionHelpRequested;
        }

        public List<CommandLine> asCommandLineList() {
            ArrayList<CommandLine> result = new ArrayList<CommandLine>();
            ParseResult pr = this;
            while (pr != null) {
                result.add(pr.commandSpec().commandLine());
                pr = pr.hasSubcommand() ? pr.subcommand() : null;
            }
            return result;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class Builder {
            private final Model.CommandSpec commandSpec;
            private final Set<Model.OptionSpec> options = new LinkedHashSet<Model.OptionSpec>();
            private final Set<Model.PositionalParamSpec> positionals = new LinkedHashSet<Model.PositionalParamSpec>();
            private final List<String> unmatched = new ArrayList<String>();
            private final List<String> originalArgList = new ArrayList<String>();
            private final List<List<Model.PositionalParamSpec>> positionalParams = new ArrayList<List<Model.PositionalParamSpec>>();
            private ParseResult subcommand;
            private boolean usageHelpRequested;
            private boolean versionHelpRequested;
            boolean isInitializingDefaultValues;

            private Builder(Model.CommandSpec spec) {
                this.commandSpec = Assert.notNull(spec, "commandSpec");
            }

            public ParseResult build() {
                return new ParseResult(this);
            }

            public Builder add(Model.ArgSpec arg, int position) {
                if (arg.isOption()) {
                    this.addOption((Model.OptionSpec)arg);
                } else {
                    this.addPositionalParam((Model.PositionalParamSpec)arg, position);
                }
                return this;
            }

            public Builder addOption(Model.OptionSpec option) {
                if (!this.isInitializingDefaultValues) {
                    this.options.add(option);
                }
                return this;
            }

            public Builder addPositionalParam(Model.PositionalParamSpec positionalParam, int position) {
                if (this.isInitializingDefaultValues) {
                    return this;
                }
                this.positionals.add(positionalParam);
                while (this.positionalParams.size() <= position) {
                    this.positionalParams.add(new ArrayList());
                }
                this.positionalParams.get(position).add(positionalParam);
                return this;
            }

            public Builder addUnmatched(String arg) {
                this.unmatched.add(arg);
                return this;
            }

            public Builder addUnmatched(Stack<String> args) {
                while (!args.isEmpty()) {
                    this.addUnmatched(args.pop());
                }
                return this;
            }

            public Builder subcommand(ParseResult subcommand) {
                this.subcommand = subcommand;
                return this;
            }

            public Builder originalArgs(String[] originalArgs) {
                this.originalArgList.addAll(Arrays.asList(originalArgs));
                return this;
            }

            void addStringValue(Model.ArgSpec argSpec, String value) {
                if (!this.isInitializingDefaultValues) {
                    argSpec.stringValues.add(value);
                }
            }

            void addOriginalStringValue(Model.ArgSpec argSpec, String value) {
                if (!this.isInitializingDefaultValues) {
                    argSpec.originalStringValues.add(value);
                }
            }

            void addTypedValues(Model.ArgSpec argSpec, int position, Object typedValue) {
                if (!this.isInitializingDefaultValues) {
                    argSpec.typedValues.add(typedValue);
                    argSpec.typedValueAtPosition.put(position, typedValue);
                }
            }
        }
    }

    public static final class Model {
        private Model() {
        }

        private static boolean initializable(Object current, Object candidate, Object defaultValue) {
            return current == null && !Assert.notNull(defaultValue, "defaultValue").equals(candidate);
        }

        private static boolean initializable(Object current, Object[] candidate, Object[] defaultValue) {
            return current == null && !Arrays.equals(Assert.notNull(defaultValue, "defaultValue"), candidate);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static class ObjectBinding
        implements IGetter,
        ISetter {
            private Object value;

            private ObjectBinding() {
            }

            @Override
            public <T> T get() {
                return (T)this.value;
            }

            @Override
            public <T> T set(T value) {
                T result = value;
                this.value = value;
                return result;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static class FieldBinding
        implements IGetter,
        ISetter {
            private final Object scope;
            private final Field field;

            FieldBinding(Object scope, Field field) {
                this.scope = scope;
                this.field = field;
            }

            @Override
            public <T> T get() throws PicocliException {
                try {
                    Object result = this.field.get(this.scope);
                    return (T)result;
                }
                catch (Exception ex) {
                    throw new PicocliException("Could not get value for field " + this.field, ex);
                }
            }

            @Override
            public <T> T set(T value) throws PicocliException {
                try {
                    Object result = this.field.get(this.scope);
                    this.field.set(this.scope, value);
                    return (T)result;
                }
                catch (Exception ex) {
                    throw new PicocliException("Could not set value for field " + this.field + " to " + value, ex);
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class ArgsReflection {
            ArgsReflection() {
            }

            static OptionSpec extractOptionSpec(Object scope, Field field, IFactory factory) {
                Option option = field.getAnnotation(Option.class);
                OptionSpec.Builder builder = OptionSpec.builder(option.names());
                ArgsReflection.initCommon(builder, scope, field);
                builder.help(option.help());
                builder.usageHelp(option.usageHelp());
                builder.versionHelp(option.versionHelp());
                builder.showDefaultValue(option.showDefaultValue());
                builder.arity(Range.optionArity(field));
                builder.required(option.required());
                builder.description(option.description());
                Class<?>[] elementTypes = ArgsReflection.inferTypes(field.getType(), option.type(), field.getGenericType());
                builder.auxiliaryTypes(elementTypes);
                builder.paramLabel(ArgsReflection.inferLabel(option.paramLabel(), field.getName(), field.getType(), elementTypes));
                builder.splitRegex(option.split());
                builder.hidden(option.hidden());
                builder.converters(DefaultFactory.createConverter(factory, option.converter()));
                return builder.build();
            }

            static PositionalParamSpec extractPositionalParamSpec(Object scope, Field field, IFactory factory) {
                PositionalParamSpec.Builder builder = PositionalParamSpec.builder();
                ArgsReflection.initCommon(builder, scope, field);
                Range arity = Range.parameterArity(field);
                builder.arity(arity);
                builder.index(Range.parameterIndex(field));
                builder.capacity(Range.parameterCapacity(field));
                builder.required(arity.min > 0);
                Parameters parameters = field.getAnnotation(Parameters.class);
                builder.description(parameters.description());
                Class<?>[] elementTypes = ArgsReflection.inferTypes(field.getType(), parameters.type(), field.getGenericType());
                builder.auxiliaryTypes(elementTypes);
                builder.paramLabel(ArgsReflection.inferLabel(parameters.paramLabel(), field.getName(), field.getType(), elementTypes));
                builder.splitRegex(parameters.split());
                builder.hidden(parameters.hidden());
                builder.converters(DefaultFactory.createConverter(factory, parameters.converter()));
                builder.showDefaultValue(parameters.showDefaultValue());
                return builder.build();
            }

            private static void initCommon(ArgSpec.Builder<?> builder, Object scope, Field field) {
                field.setAccessible(true);
                builder.type(field.getType());
                builder.initialValue(ArgsReflection.getInitialValue(scope, field));
                builder.withToString(ArgsReflection.abbreviate("field " + field.toGenericString()));
                FieldBinding binding = new FieldBinding(scope, field);
                ((ArgSpec.Builder)builder.getter(binding)).setter(binding);
            }

            static String abbreviate(String text) {
                return text.replace("field private ", "field ").replace("field protected ", "field ").replace("field public ", "field ").replace("java.lang.", "");
            }

            private static String inferLabel(String label, String fieldName, Class<?> fieldType, Class<?>[] types) {
                if (!CommandLine.empty(label)) {
                    return label.trim();
                }
                String name = fieldName;
                if (Map.class.isAssignableFrom(fieldType)) {
                    Class<?>[] paramTypes = types;
                    name = paramTypes.length < 2 || paramTypes[0] == null || paramTypes[1] == null ? "String=String" : paramTypes[0].getSimpleName() + "=" + paramTypes[1].getSimpleName();
                }
                return "<" + name + ">";
            }

            private static Class<?>[] inferTypes(Class<?> propertyType, Class<?>[] annotationTypes, Type genericType) {
                if (annotationTypes.length > 0) {
                    return annotationTypes;
                }
                if (propertyType.isArray()) {
                    return new Class[]{propertyType.getComponentType()};
                }
                if (CommandLine.isMultiValue(propertyType)) {
                    if (genericType instanceof ParameterizedType) {
                        ParameterizedType parameterizedType = (ParameterizedType)genericType;
                        Type[] paramTypes = parameterizedType.getActualTypeArguments();
                        Object[] result = new Class[paramTypes.length];
                        for (int i = 0; i < paramTypes.length; ++i) {
                            if (paramTypes[i] instanceof Class) {
                                result[i] = (Class)paramTypes[i];
                                continue;
                            }
                            if (paramTypes[i] instanceof WildcardType) {
                                WildcardType wildcardType = (WildcardType)paramTypes[i];
                                Type[] lower = wildcardType.getLowerBounds();
                                if (lower.length > 0 && lower[0] instanceof Class) {
                                    result[i] = (Class)lower[0];
                                    continue;
                                }
                                Type[] upper = wildcardType.getUpperBounds();
                                if (upper.length > 0 && upper[0] instanceof Class) {
                                    result[i] = (Class)upper[0];
                                    continue;
                                }
                            }
                            Arrays.fill(result, String.class);
                            return result;
                        }
                        return result;
                    }
                    return new Class[]{String.class, String.class};
                }
                return new Class[]{propertyType};
            }

            static Object getInitialValue(Object scope, Field field) {
                try {
                    return field.get(scope);
                }
                catch (Exception ex) {
                    return null;
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static class CommandReflection {
            private CommandReflection() {
            }

            static CommandSpec extractCommandSpec(Object command, IFactory factory, boolean annotationsAreMandatory) {
                if (command instanceof CommandSpec) {
                    return (CommandSpec)command;
                }
                CommandSpec result = CommandSpec.wrapWithoutInspection(Assert.notNull(command, "command"));
                boolean hasCommandAnnotation = false;
                for (Class<?> cls = command.getClass(); cls != null; cls = cls.getSuperclass()) {
                    hasCommandAnnotation |= CommandReflection.updateCommandAttributes(cls, result, factory);
                    hasCommandAnnotation |= CommandReflection.initFromAnnotatedFields(command, cls, result, factory);
                }
                if (annotationsAreMandatory) {
                    CommandReflection.validateCommandSpec(result, hasCommandAnnotation, command);
                }
                result.withToString(command.getClass().getName()).validate();
                return result;
            }

            private static boolean updateCommandAttributes(Class<?> cls, CommandSpec commandSpec, IFactory factory) {
                if (!cls.isAnnotationPresent(Command.class)) {
                    return false;
                }
                Command cmd = cls.getAnnotation(Command.class);
                CommandReflection.initSubcommands(cmd, commandSpec, factory);
                commandSpec.parser().initSeparator(cmd.separator());
                commandSpec.initName(cmd.name());
                commandSpec.initVersion(cmd.version());
                commandSpec.initHelpCommand(cmd.helpCommand());
                commandSpec.initVersionProvider(cmd.versionProvider(), factory);
                commandSpec.mixinStandardHelpOptions(cmd.mixinStandardHelpOptions());
                commandSpec.usageMessage().initSynopsisHeading(cmd.synopsisHeading());
                commandSpec.usageMessage().initCommandListHeading(cmd.commandListHeading());
                commandSpec.usageMessage().initRequiredOptionMarker(cmd.requiredOptionMarker());
                commandSpec.usageMessage().initCustomSynopsis(cmd.customSynopsis());
                commandSpec.usageMessage().initDescription(cmd.description());
                commandSpec.usageMessage().initDescriptionHeading(cmd.descriptionHeading());
                commandSpec.usageMessage().initHeader(cmd.header());
                commandSpec.usageMessage().initHeaderHeading(cmd.headerHeading());
                commandSpec.usageMessage().initFooter(cmd.footer());
                commandSpec.usageMessage().initFooterHeading(cmd.footerHeading());
                commandSpec.usageMessage().initParameterListHeading(cmd.parameterListHeading());
                commandSpec.usageMessage().initOptionListHeading(cmd.optionListHeading());
                commandSpec.usageMessage().initAbbreviateSynopsis(cmd.abbreviateSynopsis());
                commandSpec.usageMessage().initSortOptions(cmd.sortOptions());
                commandSpec.usageMessage().initShowDefaultValues(cmd.showDefaultValues());
                commandSpec.usageMessage().initHidden(cmd.hidden());
                return true;
            }

            private static void initSubcommands(Command cmd, CommandSpec parent, IFactory factory) {
                for (Class<?> sub : cmd.subcommands()) {
                    try {
                        if (Help.class == sub) {
                            throw new InitializationException(Help.class.getName() + " is not a valid subcommand. Did you mean " + HelpCommand.class.getName() + "?");
                        }
                        CommandLine subcommandLine = CommandLine.toCommandLine(factory.create(sub), factory);
                        parent.addSubcommand(CommandReflection.subcommandName(sub), subcommandLine);
                        CommandReflection.initParentCommand(subcommandLine.getCommandSpec().userObject(), parent.userObject());
                    }
                    catch (InitializationException ex) {
                        throw ex;
                    }
                    catch (NoSuchMethodException ex) {
                        throw new InitializationException("Cannot instantiate subcommand " + sub.getName() + ": the class has no constructor", ex);
                    }
                    catch (Exception ex) {
                        throw new InitializationException("Could not instantiate and add subcommand " + sub.getName() + ": " + ex, ex);
                    }
                }
            }

            static void initParentCommand(Object subcommand, Object parent) {
                try {
                    for (Class<?> cls = subcommand.getClass(); cls != null; cls = cls.getSuperclass()) {
                        for (Field f : cls.getDeclaredFields()) {
                            if (!f.isAnnotationPresent(ParentCommand.class)) continue;
                            f.setAccessible(true);
                            f.set(subcommand, parent);
                        }
                    }
                }
                catch (Exception ex) {
                    throw new InitializationException("Unable to initialize @ParentCommand field: " + ex, ex);
                }
            }

            private static String subcommandName(Class<?> sub) {
                Command subCommand = sub.getAnnotation(Command.class);
                if (subCommand == null || "<main class>".equals(subCommand.name())) {
                    throw new InitializationException("Subcommand " + sub.getName() + " is missing the mandatory @Command annotation with a 'name' attribute");
                }
                return subCommand.name();
            }

            private static boolean initFromAnnotatedFields(Object scope, Class<?> cls, CommandSpec receiver, IFactory factory) {
                boolean result = false;
                for (Field field : cls.getDeclaredFields()) {
                    if (CommandReflection.isMixin(field)) {
                        CommandReflection.validateMixin(field);
                        receiver.addMixin(CommandReflection.mixinName(field), CommandReflection.buildMixinForField(field, scope, factory));
                        result = true;
                    }
                    if (CommandReflection.isUnmatched(field)) {
                        CommandReflection.validateUnmatched(field);
                        receiver.addUnmatchedArgsBinding(CommandReflection.buildUnmatchedForField(field, scope));
                    }
                    if (!CommandReflection.isArgSpec(field)) continue;
                    CommandReflection.validateArgSpecField(field);
                    if (CommandReflection.isOption(field)) {
                        receiver.addOption(ArgsReflection.extractOptionSpec(scope, field, factory));
                    }
                    if (!CommandReflection.isParameter(field)) continue;
                    receiver.addPositional(ArgsReflection.extractPositionalParamSpec(scope, field, factory));
                }
                return result;
            }

            private static String mixinName(Field field) {
                String annotationName = field.getAnnotation(Mixin.class).name();
                return CommandLine.empty(annotationName) ? field.getName() : annotationName;
            }

            private static void validateMixin(Field field) {
                if (CommandReflection.isMixin(field) && (CommandReflection.isOption(field) || CommandReflection.isParameter(field))) {
                    throw new DuplicateOptionAnnotationsException("A field cannot be both a @Mixin command and an @Option or @Parameters, but '" + field + "' is both.");
                }
                if (CommandReflection.isMixin(field) && CommandReflection.isUnmatched(field)) {
                    throw new DuplicateOptionAnnotationsException("A field cannot be both a @Mixin command and an @Unmatched but '" + field + "' is both.");
                }
            }

            private static void validateUnmatched(Field field) {
                if (CommandReflection.isUnmatched(field) && (CommandReflection.isOption(field) || CommandReflection.isParameter(field))) {
                    throw new DuplicateOptionAnnotationsException("A field cannot have both @Unmatched and @Option or @Parameters annotations, but '" + field + "' has both.");
                }
            }

            private static void validateArgSpecField(Field field) {
                if (CommandReflection.isOption(field) && CommandReflection.isParameter(field)) {
                    throw new DuplicateOptionAnnotationsException("A field can be either @Option or @Parameters, but '" + field + "' is both.");
                }
                if (CommandReflection.isMixin(field) && (CommandReflection.isOption(field) || CommandReflection.isParameter(field))) {
                    throw new DuplicateOptionAnnotationsException("A field cannot be both a @Mixin command and an @Option or @Parameters, but '" + field + "' is both.");
                }
                if (Modifier.isFinal(field.getModifiers()) && (field.getType().isPrimitive() || String.class.isAssignableFrom(field.getType()))) {
                    throw new InitializationException("Constant (final) primitive and String fields like " + field + " cannot be used as " + (CommandReflection.isOption(field) ? "an @Option" : "a @Parameter") + ": compile-time constant inlining may hide new values written to it.");
                }
            }

            private static void validateCommandSpec(CommandSpec result, boolean hasCommandAnnotation, Object command) {
                if (!hasCommandAnnotation && result.positionalParameters.isEmpty() && result.optionsByNameMap.isEmpty() && result.unmatchedArgs.isEmpty()) {
                    throw new InitializationException(command.getClass().getName() + " is not a command: it has no @Command, @Option, @Parameters or @Unmatched annotations");
                }
            }

            private static CommandSpec buildMixinForField(Field field, Object scope, IFactory factory) {
                try {
                    field.setAccessible(true);
                    Object userObject = field.get(scope);
                    if (userObject == null) {
                        userObject = factory.create(field.getType());
                        field.set(scope, userObject);
                    }
                    CommandSpec result = CommandSpec.forAnnotatedObject(userObject, factory);
                    return result.withToString(ArgsReflection.abbreviate("mixin from field " + field.toGenericString()));
                }
                catch (InitializationException ex) {
                    throw ex;
                }
                catch (Exception ex) {
                    throw new InitializationException("Could not access or modify mixin field " + field + ": " + ex, ex);
                }
            }

            private static UnmatchedArgsBinding buildUnmatchedForField(final Field field, final Object scope) {
                if (!(field.getType().equals(String[].class) || List.class.isAssignableFrom(field.getType()) && field.getGenericType() instanceof ParameterizedType && ((ParameterizedType)field.getGenericType()).getActualTypeArguments()[0].equals(String.class))) {
                    throw new InitializationException("Invalid type for " + field + ": must be either String[] or List<String>");
                }
                field.setAccessible(true);
                if (field.getType().equals(String[].class)) {
                    return UnmatchedArgsBinding.forStringArrayConsumer(new FieldBinding(scope, field));
                }
                return UnmatchedArgsBinding.forStringCollectionSupplier(new IGetter(){

                    @Override
                    public <T> T get() throws Exception {
                        field.setAccessible(true);
                        ArrayList result = (ArrayList)field.get(scope);
                        if (result == null) {
                            result = new ArrayList();
                            field.set(scope, result);
                        }
                        return (T)result;
                    }
                });
            }

            static boolean isArgSpec(Field f) {
                return CommandReflection.isOption(f) || CommandReflection.isParameter(f);
            }

            static boolean isOption(Field f) {
                return f.isAnnotationPresent(Option.class);
            }

            static boolean isParameter(Field f) {
                return f.isAnnotationPresent(Parameters.class);
            }

            static boolean isMixin(Field f) {
                return f.isAnnotationPresent(Mixin.class);
            }

            static boolean isUnmatched(Field f) {
                return f.isAnnotationPresent(Unmatched.class);
            }
        }

        public static class UnmatchedArgsBinding {
            private final IGetter getter;
            private final ISetter setter;

            public static UnmatchedArgsBinding forStringArrayConsumer(ISetter setter) {
                return new UnmatchedArgsBinding(null, setter);
            }

            public static UnmatchedArgsBinding forStringCollectionSupplier(IGetter getter) {
                return new UnmatchedArgsBinding(getter, null);
            }

            private UnmatchedArgsBinding(IGetter getter, ISetter setter) {
                if (getter == null && setter == null) {
                    throw new IllegalArgumentException("Getter and setter cannot both be null");
                }
                this.setter = setter;
                this.getter = getter;
            }

            public IGetter getter() {
                return this.getter;
            }

            public ISetter setter() {
                return this.setter;
            }

            void addAll(String[] unmatched) {
                if (this.setter != null) {
                    try {
                        this.setter.set(unmatched);
                    }
                    catch (Exception ex) {
                        throw new PicocliException(String.format("Could not invoke setter (%s) with unmatched argument array '%s': %s", this.setter, Arrays.toString(unmatched), ex), ex);
                    }
                }
                if (this.getter != null) {
                    try {
                        Collection collection = (Collection)this.getter.get();
                        Assert.notNull(collection, "getter returned null Collection");
                        collection.addAll(Arrays.asList(unmatched));
                    }
                    catch (Exception ex) {
                        throw new PicocliException(String.format("Could not add unmatched argument array '%s' to collection returned by getter (%s): %s", Arrays.toString(unmatched), this.getter, ex), ex);
                    }
                }
            }
        }

        public static class PositionalParamSpec
        extends ArgSpec {
            private Range index;
            private Range capacity;

            private PositionalParamSpec(Builder builder) {
                super(builder);
                this.index = builder.index == null ? Range.valueOf("*") : builder.index;
                Range range = this.capacity = builder.capacity == null ? Range.parameterCapacity(this.arity(), this.index) : builder.capacity;
                if (this.toString == null) {
                    this.toString = "positional parameter[" + this.index() + "]";
                }
            }

            public Builder toBuilder() {
                return new Builder(this);
            }

            public boolean isOption() {
                return false;
            }

            public boolean isPositional() {
                return true;
            }

            public Range index() {
                return this.index;
            }

            private Range capacity() {
                return this.capacity;
            }

            public static Builder builder() {
                return new Builder();
            }

            public int hashCode() {
                return super.hashCodeImpl() + 37 * Assert.hashCode(this.capacity) + 37 * Assert.hashCode(this.index);
            }

            public boolean equals(Object obj) {
                if (obj == this) {
                    return true;
                }
                if (!(obj instanceof PositionalParamSpec)) {
                    return false;
                }
                PositionalParamSpec other = (PositionalParamSpec)obj;
                return super.equalsImpl(other) && Assert.equals(this.capacity, other.capacity) && Assert.equals(this.index, other.index);
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public static class Builder
            extends ArgSpec.Builder<Builder> {
                private Range capacity;
                private Range index;

                private Builder() {
                }

                private Builder(PositionalParamSpec original) {
                    super(original);
                    this.index = original.index;
                    this.capacity = original.capacity;
                }

                @Override
                public PositionalParamSpec build() {
                    return new PositionalParamSpec(this);
                }

                @Override
                protected Builder self() {
                    return this;
                }

                public Range index() {
                    return this.index;
                }

                public Builder index(String range) {
                    return this.index(Range.valueOf(range));
                }

                public Builder index(Range index) {
                    this.index = index;
                    return this.self();
                }

                Builder capacity(Range capacity) {
                    this.capacity = capacity;
                    return this.self();
                }
            }
        }

        public static class OptionSpec
        extends ArgSpec {
            private String[] names;
            private boolean help;
            private boolean usageHelp;
            private boolean versionHelp;

            public static Builder builder(String name, String ... names) {
                String[] copy = new String[Assert.notNull(names, "names").length + 1];
                copy[0] = Assert.notNull(name, "name");
                System.arraycopy(names, 0, copy, 1, names.length);
                return new Builder(copy);
            }

            public static Builder builder(String[] names) {
                return new Builder(names);
            }

            private OptionSpec(Builder builder) {
                super(builder);
                this.names = builder.names;
                this.help = builder.help;
                this.usageHelp = builder.usageHelp;
                this.versionHelp = builder.versionHelp;
                if (this.names == null || this.names.length == 0 || Arrays.asList(this.names).contains("")) {
                    throw new InitializationException("Invalid names: " + Arrays.toString(this.names));
                }
                if (this.toString() == null) {
                    this.toString = "option " + this.longestName();
                }
            }

            public Builder toBuilder() {
                return new Builder(this);
            }

            public boolean isOption() {
                return true;
            }

            public boolean isPositional() {
                return false;
            }

            protected boolean internalShowDefaultValue(boolean usageMessageShowDefaults) {
                return super.internalShowDefaultValue(usageMessageShowDefaults) && !this.help() && !this.versionHelp() && !this.usageHelp();
            }

            public String[] names() {
                return (String[])this.names.clone();
            }

            public String longestName() {
                return Help.ShortestFirst.longestFirst((String[])this.names.clone())[0];
            }

            @Deprecated
            public boolean help() {
                return this.help;
            }

            public boolean usageHelp() {
                return this.usageHelp;
            }

            public boolean versionHelp() {
                return this.versionHelp;
            }

            public boolean equals(Object obj) {
                if (obj == this) {
                    return true;
                }
                if (!(obj instanceof OptionSpec)) {
                    return false;
                }
                OptionSpec other = (OptionSpec)obj;
                boolean result = super.equalsImpl(other) && this.help == other.help && this.usageHelp == other.usageHelp && this.versionHelp == other.versionHelp && new HashSet<String>(Arrays.asList(this.names)).equals(new HashSet<String>(Arrays.asList(other.names)));
                return result;
            }

            public int hashCode() {
                return super.hashCodeImpl() + 37 * Assert.hashCode(this.help) + 37 * Assert.hashCode(this.usageHelp) + 37 * Assert.hashCode(this.versionHelp) + 37 * Arrays.hashCode(this.names);
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public static class Builder
            extends ArgSpec.Builder<Builder> {
                private String[] names;
                private boolean help;
                private boolean usageHelp;
                private boolean versionHelp;

                private Builder(String[] names) {
                    this.names = (String[])names.clone();
                }

                private Builder(OptionSpec original) {
                    super(original);
                    this.names = original.names;
                    this.help = original.help;
                    this.usageHelp = original.usageHelp;
                    this.versionHelp = original.versionHelp;
                }

                @Override
                public OptionSpec build() {
                    return new OptionSpec(this);
                }

                @Override
                protected Builder self() {
                    return this;
                }

                public String[] names() {
                    return this.names;
                }

                @Deprecated
                public boolean help() {
                    return this.help;
                }

                public boolean usageHelp() {
                    return this.usageHelp;
                }

                public boolean versionHelp() {
                    return this.versionHelp;
                }

                public Builder names(String ... names) {
                    this.names = (String[])Assert.notNull(names, "names").clone();
                    return this.self();
                }

                public Builder help(boolean help) {
                    this.help = help;
                    return this.self();
                }

                public Builder usageHelp(boolean usageHelp) {
                    this.usageHelp = usageHelp;
                    return this.self();
                }

                public Builder versionHelp(boolean versionHelp) {
                    this.versionHelp = versionHelp;
                    return this.self();
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static abstract class ArgSpec {
            private final boolean hidden;
            private final String paramLabel;
            private final String[] description;
            private final Help.Visibility showDefaultValue;
            private final boolean required;
            private final String splitRegex;
            private final Class<?> type;
            private final Class<?>[] auxiliaryTypes;
            private final ITypeConverter<?>[] converters;
            private final String defaultValue;
            private final Object initialValue;
            private final boolean hasInitialValue;
            private final IGetter getter;
            private final ISetter setter;
            private final Range arity;
            private List<String> stringValues = new ArrayList<String>();
            private List<String> originalStringValues = new ArrayList<String>();
            protected String toString;
            private List<Object> typedValues = new ArrayList<Object>();
            Map<Integer, Object> typedValueAtPosition = new TreeMap<Integer, Object>();

            private ArgSpec(Builder builder) {
                this.description = builder.description == null ? new String[]{} : builder.description;
                this.splitRegex = builder.splitRegex == null ? "" : builder.splitRegex;
                this.paramLabel = CommandLine.empty(builder.paramLabel) ? "PARAM" : builder.paramLabel;
                this.converters = builder.converters == null ? new ITypeConverter[]{} : builder.converters;
                this.showDefaultValue = builder.showDefaultValue == null ? Help.Visibility.ON_DEMAND : builder.showDefaultValue;
                this.hidden = builder.hidden;
                this.required = builder.required && builder.defaultValue == null;
                this.defaultValue = builder.defaultValue;
                this.initialValue = builder.initialValue;
                this.hasInitialValue = builder.hasInitialValue;
                this.toString = builder.toString;
                this.getter = builder.getter;
                this.setter = builder.setter;
                Range tempArity = builder.arity;
                if (tempArity == null) {
                    tempArity = this.isOption() ? (builder.type == null || CommandLine.isBoolean(builder.type) ? Range.valueOf("0") : Range.valueOf("1")) : Range.valueOf("1");
                }
                this.arity = tempArity;
                this.type = builder.type == null ? (builder.auxiliaryTypes == null || builder.auxiliaryTypes.length == 0 ? (this.arity.isVariable || this.arity.max > 1 ? String[].class : (this.arity.max == 1 ? String.class : (this.isOption() ? Boolean.TYPE : String.class))) : builder.auxiliaryTypes[0]) : builder.type;
                this.auxiliaryTypes = builder.auxiliaryTypes == null || builder.auxiliaryTypes.length == 0 ? (this.type.isArray() ? new Class[]{this.type.getComponentType()} : (Collection.class.isAssignableFrom(this.type) ? new Class[]{String.class} : (Map.class.isAssignableFrom(this.type) ? new Class[]{String.class, String.class} : new Class[]{this.type}))) : builder.auxiliaryTypes;
            }

            public boolean required() {
                return this.required;
            }

            public String[] description() {
                return (String[])this.description.clone();
            }

            public Range arity() {
                return this.arity;
            }

            public String paramLabel() {
                return this.paramLabel;
            }

            public Class<?>[] auxiliaryTypes() {
                return (Class[])this.auxiliaryTypes.clone();
            }

            public ITypeConverter<?>[] converters() {
                return (ITypeConverter[])this.converters.clone();
            }

            public String splitRegex() {
                return this.splitRegex;
            }

            public boolean hidden() {
                return this.hidden;
            }

            public Class<?> type() {
                return this.type;
            }

            public String defaultValue() {
                return this.defaultValue;
            }

            public Object initialValue() {
                return this.initialValue;
            }

            public boolean hasInitialValue() {
                return this.hasInitialValue;
            }

            public Help.Visibility showDefaultValue() {
                return this.showDefaultValue;
            }

            public IGetter getter() {
                return this.getter;
            }

            public ISetter setter() {
                return this.setter;
            }

            public <T> T getValue() throws PicocliException {
                try {
                    return this.getter.get();
                }
                catch (PicocliException ex) {
                    throw ex;
                }
                catch (Exception ex) {
                    throw new PicocliException("Could not get value for " + this + ": " + ex, ex);
                }
            }

            public <T> T setValue(T newValue) throws PicocliException {
                try {
                    return this.setter.set(newValue);
                }
                catch (PicocliException ex) {
                    throw ex;
                }
                catch (Exception ex) {
                    throw new PicocliException("Could not set value (" + newValue + ") for " + this + ": " + ex, ex);
                }
            }

            public boolean isMultiValue() {
                return CommandLine.isMultiValue(this.type());
            }

            public abstract boolean isOption();

            public abstract boolean isPositional();

            public List<String> stringValues() {
                return Collections.unmodifiableList(this.stringValues);
            }

            public List<Object> typedValues() {
                return Collections.unmodifiableList(this.typedValues);
            }

            protected void resetStringValues() {
                this.stringValues = new ArrayList<String>();
            }

            public List<String> originalStringValues() {
                return Collections.unmodifiableList(this.originalStringValues);
            }

            protected void resetOriginalStringValues() {
                this.originalStringValues = new ArrayList<String>();
            }

            protected boolean internalShowDefaultValue(boolean usageHelpShowDefaults) {
                if (this.showDefaultValue() == Help.Visibility.ALWAYS) {
                    return true;
                }
                if (this.showDefaultValue() == Help.Visibility.NEVER) {
                    return false;
                }
                if (this.initialValue == null && this.defaultValue() == null) {
                    return false;
                }
                return usageHelpShowDefaults && !CommandLine.isBoolean(this.type());
            }

            public String toString() {
                return this.toString;
            }

            private String[] splitValue(String value, ParserSpec parser, Range arity, int consumed) {
                if (this.splitRegex().length() == 0) {
                    return new String[]{value};
                }
                int limit = parser.limitSplit() ? Math.max(arity.max - consumed, 0) : 0;
                return value.split(this.splitRegex(), limit);
            }

            protected boolean equalsImpl(ArgSpec other) {
                if (other == this) {
                    return true;
                }
                boolean result = Assert.equals(this.defaultValue, other.defaultValue) && Assert.equals(this.type, other.type) && Assert.equals(this.arity, other.arity) && Assert.equals(this.hidden, other.hidden) && Assert.equals(this.paramLabel, other.paramLabel) && Assert.equals(this.required, other.required) && Assert.equals(this.splitRegex, other.splitRegex) && Arrays.equals(this.description, other.description) && Arrays.equals(this.auxiliaryTypes, other.auxiliaryTypes);
                return result;
            }

            protected int hashCodeImpl() {
                return 17 + 37 * Assert.hashCode(this.defaultValue) + 37 * Assert.hashCode(this.type) + 37 * Assert.hashCode(this.arity) + 37 * Assert.hashCode(this.hidden) + 37 * Assert.hashCode(this.paramLabel) + 37 * Assert.hashCode(this.required) + 37 * Assert.hashCode(this.splitRegex) + 37 * Arrays.hashCode(this.description) + 37 * Arrays.hashCode(this.auxiliaryTypes);
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            static abstract class Builder<T extends Builder<T>> {
                private Range arity;
                private String[] description;
                private boolean required;
                private String paramLabel;
                private String splitRegex;
                private boolean hidden;
                private Class<?> type;
                private Class<?>[] auxiliaryTypes;
                private ITypeConverter<?>[] converters;
                private String defaultValue;
                private Object initialValue;
                private boolean hasInitialValue = true;
                private Help.Visibility showDefaultValue;
                private String toString;
                private IGetter getter = new ObjectBinding();
                private ISetter setter = (ISetter)((Object)this.getter);

                Builder() {
                }

                Builder(ArgSpec original) {
                    this.arity = original.arity;
                    this.auxiliaryTypes = original.auxiliaryTypes;
                    this.converters = original.converters;
                    this.defaultValue = original.defaultValue;
                    this.description = original.description;
                    this.getter = original.getter;
                    this.setter = original.setter;
                    this.hidden = original.hidden;
                    this.paramLabel = original.paramLabel;
                    this.required = original.required;
                    this.showDefaultValue = original.showDefaultValue;
                    this.splitRegex = original.splitRegex;
                    this.toString = original.toString;
                    this.type = original.type;
                }

                public abstract ArgSpec build();

                protected abstract T self();

                public boolean required() {
                    return this.required;
                }

                public String[] description() {
                    return this.description;
                }

                public Range arity() {
                    return this.arity;
                }

                public String paramLabel() {
                    return this.paramLabel;
                }

                public Class<?>[] auxiliaryTypes() {
                    return this.auxiliaryTypes;
                }

                public ITypeConverter<?>[] converters() {
                    return this.converters;
                }

                public String splitRegex() {
                    return this.splitRegex;
                }

                public boolean hidden() {
                    return this.hidden;
                }

                public Class<?> type() {
                    return this.type;
                }

                public String defaultValue() {
                    return this.defaultValue;
                }

                public Object initialValue() {
                    return this.initialValue;
                }

                public boolean hasInitialValue() {
                    return this.hasInitialValue;
                }

                public Help.Visibility showDefaultValue() {
                    return this.showDefaultValue;
                }

                public IGetter getter() {
                    return this.getter;
                }

                public ISetter setter() {
                    return this.setter;
                }

                public String toString() {
                    return this.toString;
                }

                public T required(boolean required) {
                    this.required = required;
                    return this.self();
                }

                public T description(String ... description) {
                    this.description = (String[])Assert.notNull(description, "description").clone();
                    return this.self();
                }

                public T arity(String range) {
                    return this.arity(Range.valueOf(range));
                }

                public T arity(Range arity) {
                    this.arity = Assert.notNull(arity, "arity");
                    return this.self();
                }

                public T paramLabel(String paramLabel) {
                    this.paramLabel = Assert.notNull(paramLabel, "paramLabel");
                    return this.self();
                }

                public T auxiliaryTypes(Class<?> ... types) {
                    this.auxiliaryTypes = (Class[])Assert.notNull(types, "types").clone();
                    return this.self();
                }

                public T converters(ITypeConverter<?> ... cs) {
                    this.converters = (ITypeConverter[])Assert.notNull(cs, "type converters").clone();
                    return this.self();
                }

                public T splitRegex(String splitRegex) {
                    this.splitRegex = Assert.notNull(splitRegex, "splitRegex");
                    return this.self();
                }

                public T showDefaultValue(Help.Visibility visibility) {
                    this.showDefaultValue = Assert.notNull(visibility, "visibility");
                    return this.self();
                }

                public T hidden(boolean hidden) {
                    this.hidden = hidden;
                    return this.self();
                }

                public T type(Class<?> propertyType) {
                    this.type = Assert.notNull(propertyType, "type");
                    return this.self();
                }

                public T defaultValue(String defaultValue) {
                    this.defaultValue = defaultValue;
                    return this.self();
                }

                public T initialValue(Object initialValue) {
                    this.initialValue = initialValue;
                    return this.self();
                }

                public T hasInitialValue(boolean hasInitialValue) {
                    this.hasInitialValue = hasInitialValue;
                    return this.self();
                }

                public T getter(IGetter getter) {
                    this.getter = getter;
                    return this.self();
                }

                public T setter(ISetter setter) {
                    this.setter = setter;
                    return this.self();
                }

                public T withToString(String toString) {
                    this.toString = toString;
                    return this.self();
                }
            }
        }

        public static class ParserSpec {
            static final String DEFAULT_SEPARATOR = "=";
            private String separator;
            private boolean stopAtUnmatched = false;
            private boolean stopAtPositional = false;
            private boolean toggleBooleanFlags = true;
            private boolean overwrittenOptionsAllowed = false;
            private boolean unmatchedArgumentsAllowed = false;
            private boolean expandAtFiles = true;
            private boolean posixClusteredShortOptionsAllowed = true;
            private boolean unmatchedOptionsArePositionalParams = false;
            private boolean limitSplit = false;
            private boolean aritySatisfiedByAttachedOptionParam = false;

            public String separator() {
                return this.separator == null ? DEFAULT_SEPARATOR : this.separator;
            }

            public boolean stopAtUnmatched() {
                return this.stopAtUnmatched;
            }

            public boolean stopAtPositional() {
                return this.stopAtPositional;
            }

            public boolean toggleBooleanFlags() {
                return this.toggleBooleanFlags;
            }

            public boolean overwrittenOptionsAllowed() {
                return this.overwrittenOptionsAllowed;
            }

            public boolean unmatchedArgumentsAllowed() {
                return this.unmatchedArgumentsAllowed;
            }

            public boolean expandAtFiles() {
                return this.expandAtFiles;
            }

            public boolean posixClusteredShortOptionsAllowed() {
                return this.posixClusteredShortOptionsAllowed;
            }

            public boolean unmatchedOptionsArePositionalParams() {
                return this.unmatchedOptionsArePositionalParams;
            }

            private boolean splitFirst() {
                return this.limitSplit();
            }

            public boolean limitSplit() {
                return this.limitSplit;
            }

            public boolean aritySatisfiedByAttachedOptionParam() {
                return this.aritySatisfiedByAttachedOptionParam;
            }

            public ParserSpec separator(String separator) {
                this.separator = separator;
                return this;
            }

            public ParserSpec stopAtUnmatched(boolean stopAtUnmatched) {
                this.stopAtUnmatched = stopAtUnmatched;
                return this;
            }

            public ParserSpec stopAtPositional(boolean stopAtPositional) {
                this.stopAtPositional = stopAtPositional;
                return this;
            }

            public ParserSpec toggleBooleanFlags(boolean toggleBooleanFlags) {
                this.toggleBooleanFlags = toggleBooleanFlags;
                return this;
            }

            public ParserSpec overwrittenOptionsAllowed(boolean overwrittenOptionsAllowed) {
                this.overwrittenOptionsAllowed = overwrittenOptionsAllowed;
                return this;
            }

            public ParserSpec unmatchedArgumentsAllowed(boolean unmatchedArgumentsAllowed) {
                this.unmatchedArgumentsAllowed = unmatchedArgumentsAllowed;
                return this;
            }

            public ParserSpec expandAtFiles(boolean expandAtFiles) {
                this.expandAtFiles = expandAtFiles;
                return this;
            }

            public ParserSpec posixClusteredShortOptionsAllowed(boolean posixClusteredShortOptionsAllowed) {
                this.posixClusteredShortOptionsAllowed = posixClusteredShortOptionsAllowed;
                return this;
            }

            public ParserSpec unmatchedOptionsArePositionalParams(boolean unmatchedOptionsArePositionalParams) {
                this.unmatchedOptionsArePositionalParams = unmatchedOptionsArePositionalParams;
                return this;
            }

            public ParserSpec aritySatisfiedByAttachedOptionParam(boolean newValue) {
                this.aritySatisfiedByAttachedOptionParam = newValue;
                return this;
            }

            public ParserSpec limitSplit(boolean limitSplit) {
                this.limitSplit = limitSplit;
                return this;
            }

            void initSeparator(String value) {
                if (Model.initializable(this.separator, value, DEFAULT_SEPARATOR)) {
                    this.separator = value;
                }
            }

            public String toString() {
                return String.format("posixClusteredShortOptionsAllowed=%s, stopAtPositional=%s, stopAtUnmatched=%s, separator=%s, overwrittenOptionsAllowed=%s, unmatchedArgumentsAllowed=%s, expandAtFiles=%s, limitSplit=%s, aritySatisfiedByAttachedOptionParam=%s", this.posixClusteredShortOptionsAllowed, this.stopAtPositional, this.stopAtUnmatched, this.separator, this.overwrittenOptionsAllowed, this.unmatchedArgumentsAllowed, this.expandAtFiles, this.limitSplit, this.aritySatisfiedByAttachedOptionParam);
            }

            void initFrom(ParserSpec settings) {
                this.separator = settings.separator;
                this.stopAtUnmatched = settings.stopAtUnmatched;
                this.stopAtPositional = settings.stopAtPositional;
                this.toggleBooleanFlags = settings.toggleBooleanFlags;
                this.overwrittenOptionsAllowed = settings.overwrittenOptionsAllowed;
                this.unmatchedArgumentsAllowed = settings.unmatchedArgumentsAllowed;
                this.expandAtFiles = settings.expandAtFiles;
                this.posixClusteredShortOptionsAllowed = settings.posixClusteredShortOptionsAllowed;
                this.unmatchedOptionsArePositionalParams = settings.unmatchedOptionsArePositionalParams;
                this.limitSplit = settings.limitSplit;
                this.aritySatisfiedByAttachedOptionParam = settings.aritySatisfiedByAttachedOptionParam;
            }
        }

        public static class UsageMessageSpec {
            public static final int DEFAULT_USAGE_WIDTH = 80;
            private static final int MINIMUM_USAGE_WIDTH = 55;
            static final String DEFAULT_SYNOPSIS_HEADING = "Usage: ";
            static final String DEFAULT_COMMAND_LIST_HEADING = "Commands:%n";
            static final char DEFAULT_REQUIRED_OPTION_MARKER = ' ';
            static final Boolean DEFAULT_ABBREVIATE_SYNOPSIS = Boolean.FALSE;
            static final Boolean DEFAULT_SORT_OPTIONS = Boolean.TRUE;
            static final Boolean DEFAULT_SHOW_DEFAULT_VALUES = Boolean.FALSE;
            static final Boolean DEFAULT_HIDDEN = Boolean.FALSE;
            static final String DEFAULT_SINGLE_VALUE = "";
            static final String[] DEFAULT_MULTI_LINE = new String[0];
            private String[] description;
            private String[] customSynopsis;
            private String[] header;
            private String[] footer;
            private Boolean abbreviateSynopsis;
            private Boolean sortOptions;
            private Boolean showDefaultValues;
            private Boolean hidden;
            private Character requiredOptionMarker;
            private String headerHeading;
            private String synopsisHeading;
            private String descriptionHeading;
            private String parameterListHeading;
            private String optionListHeading;
            private String commandListHeading;
            private String footerHeading;
            private int width = 80;

            private static int getSysPropertyWidthOrDefault(int defaultWidth) {
                String userValue = System.getProperty("picocli.usage.width");
                if (userValue == null) {
                    return defaultWidth;
                }
                try {
                    int width = Integer.parseInt(userValue);
                    if (width < 55) {
                        new Tracer().warn("Invalid picocli.usage.width value %d. Using minimum usage width %d.%n", width, 55);
                        return 55;
                    }
                    return width;
                }
                catch (NumberFormatException ex) {
                    new Tracer().warn("Invalid picocli.usage.width value '%s'. Using usage width %d.%n", userValue, defaultWidth);
                    return defaultWidth;
                }
            }

            public int width() {
                return UsageMessageSpec.getSysPropertyWidthOrDefault(this.width);
            }

            public UsageMessageSpec width(int newValue) {
                if (newValue < 55) {
                    throw new IllegalArgumentException("Invalid usage message width " + newValue + ". Minimum value is " + 55);
                }
                this.width = newValue;
                return this;
            }

            public String headerHeading() {
                return this.headerHeading == null ? DEFAULT_SINGLE_VALUE : this.headerHeading;
            }

            public String[] header() {
                return this.header == null ? DEFAULT_MULTI_LINE : (String[])this.header.clone();
            }

            public String synopsisHeading() {
                return this.synopsisHeading == null ? DEFAULT_SYNOPSIS_HEADING : this.synopsisHeading;
            }

            public boolean abbreviateSynopsis() {
                return this.abbreviateSynopsis == null ? DEFAULT_ABBREVIATE_SYNOPSIS : this.abbreviateSynopsis;
            }

            public String[] customSynopsis() {
                return this.customSynopsis == null ? DEFAULT_MULTI_LINE : (String[])this.customSynopsis.clone();
            }

            public String descriptionHeading() {
                return this.descriptionHeading == null ? DEFAULT_SINGLE_VALUE : this.descriptionHeading;
            }

            public String[] description() {
                return this.description == null ? DEFAULT_MULTI_LINE : (String[])this.description.clone();
            }

            public String parameterListHeading() {
                return this.parameterListHeading == null ? DEFAULT_SINGLE_VALUE : this.parameterListHeading;
            }

            public String optionListHeading() {
                return this.optionListHeading == null ? DEFAULT_SINGLE_VALUE : this.optionListHeading;
            }

            public boolean sortOptions() {
                return this.sortOptions == null ? DEFAULT_SORT_OPTIONS : this.sortOptions;
            }

            public char requiredOptionMarker() {
                return this.requiredOptionMarker == null ? (char)' ' : this.requiredOptionMarker.charValue();
            }

            public boolean showDefaultValues() {
                return this.showDefaultValues == null ? DEFAULT_SHOW_DEFAULT_VALUES : this.showDefaultValues;
            }

            public boolean hidden() {
                return this.hidden == null ? DEFAULT_HIDDEN : this.hidden;
            }

            public String commandListHeading() {
                return this.commandListHeading == null ? DEFAULT_COMMAND_LIST_HEADING : this.commandListHeading;
            }

            public String footerHeading() {
                return this.footerHeading == null ? DEFAULT_SINGLE_VALUE : this.footerHeading;
            }

            public String[] footer() {
                return this.footer == null ? DEFAULT_MULTI_LINE : (String[])this.footer.clone();
            }

            public UsageMessageSpec headerHeading(String headerHeading) {
                this.headerHeading = headerHeading;
                return this;
            }

            public UsageMessageSpec header(String ... header) {
                this.header = header;
                return this;
            }

            public UsageMessageSpec synopsisHeading(String newValue) {
                this.synopsisHeading = newValue;
                return this;
            }

            public UsageMessageSpec abbreviateSynopsis(boolean newValue) {
                this.abbreviateSynopsis = newValue;
                return this;
            }

            public UsageMessageSpec customSynopsis(String ... customSynopsis) {
                this.customSynopsis = customSynopsis;
                return this;
            }

            public UsageMessageSpec descriptionHeading(String newValue) {
                this.descriptionHeading = newValue;
                return this;
            }

            public UsageMessageSpec description(String ... description) {
                this.description = description;
                return this;
            }

            public UsageMessageSpec parameterListHeading(String newValue) {
                this.parameterListHeading = newValue;
                return this;
            }

            public UsageMessageSpec optionListHeading(String newValue) {
                this.optionListHeading = newValue;
                return this;
            }

            public UsageMessageSpec sortOptions(boolean newValue) {
                this.sortOptions = newValue;
                return this;
            }

            public UsageMessageSpec requiredOptionMarker(char newValue) {
                this.requiredOptionMarker = Character.valueOf(newValue);
                return this;
            }

            public UsageMessageSpec showDefaultValues(boolean newValue) {
                this.showDefaultValues = newValue;
                return this;
            }

            public UsageMessageSpec hidden(boolean value) {
                this.hidden = value;
                return this;
            }

            public UsageMessageSpec commandListHeading(String newValue) {
                this.commandListHeading = newValue;
                return this;
            }

            public UsageMessageSpec footerHeading(String newValue) {
                this.footerHeading = newValue;
                return this;
            }

            public UsageMessageSpec footer(String ... footer) {
                this.footer = footer;
                return this;
            }

            void initSynopsisHeading(String value) {
                if (Model.initializable(this.synopsisHeading, value, DEFAULT_SYNOPSIS_HEADING)) {
                    this.synopsisHeading = value;
                }
            }

            void initCommandListHeading(String value) {
                if (Model.initializable(this.commandListHeading, value, DEFAULT_COMMAND_LIST_HEADING)) {
                    this.commandListHeading = value;
                }
            }

            void initRequiredOptionMarker(char value) {
                if (Model.initializable(this.requiredOptionMarker, Character.valueOf(value), Character.valueOf(' '))) {
                    this.requiredOptionMarker = Character.valueOf(value);
                }
            }

            void initAbbreviateSynopsis(boolean value) {
                if (Model.initializable(this.abbreviateSynopsis, value, UsageMessageSpec.DEFAULT_ABBREVIATE_SYNOPSIS)) {
                    this.abbreviateSynopsis = value;
                }
            }

            void initSortOptions(boolean value) {
                if (Model.initializable(this.sortOptions, value, UsageMessageSpec.DEFAULT_SORT_OPTIONS)) {
                    this.sortOptions = value;
                }
            }

            void initShowDefaultValues(boolean value) {
                if (Model.initializable(this.showDefaultValues, value, UsageMessageSpec.DEFAULT_SHOW_DEFAULT_VALUES)) {
                    this.showDefaultValues = value;
                }
            }

            void initHidden(boolean value) {
                if (Model.initializable(this.hidden, value, UsageMessageSpec.DEFAULT_HIDDEN)) {
                    this.hidden = value;
                }
            }

            void initCustomSynopsis(String[] value) {
                if (Model.initializable(this.customSynopsis, value, UsageMessageSpec.DEFAULT_MULTI_LINE)) {
                    this.customSynopsis = (String[])value.clone();
                }
            }

            void initDescription(String[] value) {
                if (Model.initializable(this.description, value, UsageMessageSpec.DEFAULT_MULTI_LINE)) {
                    this.description = (String[])value.clone();
                }
            }

            void initDescriptionHeading(String value) {
                if (Model.initializable(this.descriptionHeading, value, DEFAULT_SINGLE_VALUE)) {
                    this.descriptionHeading = value;
                }
            }

            void initHeader(String[] value) {
                if (Model.initializable(this.header, value, UsageMessageSpec.DEFAULT_MULTI_LINE)) {
                    this.header = (String[])value.clone();
                }
            }

            void initHeaderHeading(String value) {
                if (Model.initializable(this.headerHeading, value, DEFAULT_SINGLE_VALUE)) {
                    this.headerHeading = value;
                }
            }

            void initFooter(String[] value) {
                if (Model.initializable(this.footer, value, UsageMessageSpec.DEFAULT_MULTI_LINE)) {
                    this.footer = (String[])value.clone();
                }
            }

            void initFooterHeading(String value) {
                if (Model.initializable(this.footerHeading, value, DEFAULT_SINGLE_VALUE)) {
                    this.footerHeading = value;
                }
            }

            void initParameterListHeading(String value) {
                if (Model.initializable(this.parameterListHeading, value, DEFAULT_SINGLE_VALUE)) {
                    this.parameterListHeading = value;
                }
            }

            void initOptionListHeading(String value) {
                if (Model.initializable(this.optionListHeading, value, DEFAULT_SINGLE_VALUE)) {
                    this.optionListHeading = value;
                }
            }

            void initFrom(UsageMessageSpec settings) {
                this.description = settings.description;
                this.customSynopsis = settings.customSynopsis;
                this.header = settings.header;
                this.footer = settings.footer;
                this.abbreviateSynopsis = settings.abbreviateSynopsis;
                this.sortOptions = settings.sortOptions;
                this.showDefaultValues = settings.showDefaultValues;
                this.hidden = settings.hidden;
                this.requiredOptionMarker = settings.requiredOptionMarker;
                this.headerHeading = settings.headerHeading;
                this.synopsisHeading = settings.synopsisHeading;
                this.descriptionHeading = settings.descriptionHeading;
                this.parameterListHeading = settings.parameterListHeading;
                this.optionListHeading = settings.optionListHeading;
                this.commandListHeading = settings.commandListHeading;
                this.footerHeading = settings.footerHeading;
                this.width = settings.width;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class CommandSpec {
            static final String DEFAULT_COMMAND_NAME = "<main class>";
            static final Boolean DEFAULT_IS_HELP_COMMAND = Boolean.FALSE;
            private final Map<String, CommandLine> commands = new LinkedHashMap<String, CommandLine>();
            private final Map<String, OptionSpec> optionsByNameMap = new LinkedHashMap<String, OptionSpec>();
            private final Map<Character, OptionSpec> posixOptionsByKeyMap = new LinkedHashMap<Character, OptionSpec>();
            private final Map<String, CommandSpec> mixins = new LinkedHashMap<String, CommandSpec>();
            private final List<ArgSpec> requiredArgs = new ArrayList<ArgSpec>();
            private final List<OptionSpec> options = new ArrayList<OptionSpec>();
            private final List<PositionalParamSpec> positionalParameters = new ArrayList<PositionalParamSpec>();
            private final List<UnmatchedArgsBinding> unmatchedArgs = new ArrayList<UnmatchedArgsBinding>();
            private final ParserSpec parser = new ParserSpec();
            private final UsageMessageSpec usageMessage = new UsageMessageSpec();
            private final Object userObject;
            private CommandLine commandLine;
            private CommandSpec parent;
            private String name;
            private Boolean isHelpCommand;
            private IVersionProvider versionProvider;
            private String[] version;
            private String toString;

            private CommandSpec(Object userObject) {
                this.userObject = userObject;
            }

            public static CommandSpec create() {
                return CommandSpec.wrapWithoutInspection(null);
            }

            public static CommandSpec wrapWithoutInspection(Object userObject) {
                return new CommandSpec(userObject);
            }

            public static CommandSpec forAnnotatedObject(Object userObject) {
                return CommandSpec.forAnnotatedObject(userObject, new DefaultFactory());
            }

            public static CommandSpec forAnnotatedObject(Object userObject, IFactory factory) {
                return CommandReflection.extractCommandSpec(userObject, factory, true);
            }

            public static CommandSpec forAnnotatedObjectLenient(Object userObject) {
                return CommandSpec.forAnnotatedObjectLenient(userObject, new DefaultFactory());
            }

            public static CommandSpec forAnnotatedObjectLenient(Object userObject, IFactory factory) {
                return CommandReflection.extractCommandSpec(userObject, factory, false);
            }

            void validate() {
                Collections.sort(this.positionalParameters, new PositionalParametersSorter());
                CommandLine.validatePositionalParameters(this.positionalParameters);
                ArrayList<String> wrongUsageHelpAttr = new ArrayList<String>();
                ArrayList<String> wrongVersionHelpAttr = new ArrayList<String>();
                ArrayList<String> usageHelpAttr = new ArrayList<String>();
                ArrayList<String> versionHelpAttr = new ArrayList<String>();
                for (OptionSpec option : this.options()) {
                    if (option.usageHelp()) {
                        usageHelpAttr.add(option.longestName());
                        if (!CommandLine.isBoolean(option.type())) {
                            wrongUsageHelpAttr.add(option.longestName());
                        }
                    }
                    if (!option.versionHelp()) continue;
                    versionHelpAttr.add(option.longestName());
                    if (CommandLine.isBoolean(option.type())) continue;
                    wrongVersionHelpAttr.add(option.longestName());
                }
                String wrongType = "Non-boolean options like %s should not be marked as '%s=true'. Usually a command has one %s boolean flag that triggers display of the %s. Alternatively, consider using @Command(mixinStandardHelpOptions = true) on your command instead.";
                String multiple = "Multiple options %s are marked as '%s=true'. Usually a command has only one %s option that triggers display of the %s. Alternatively, consider using @Command(mixinStandardHelpOptions = true) on your command instead.%n";
                if (!wrongUsageHelpAttr.isEmpty()) {
                    throw new InitializationException(String.format(wrongType, wrongUsageHelpAttr, "usageHelp", "--help", "usage help message"));
                }
                if (!wrongVersionHelpAttr.isEmpty()) {
                    throw new InitializationException(String.format(wrongType, wrongVersionHelpAttr, "versionHelp", "--version", "version information"));
                }
                if (usageHelpAttr.size() > 1) {
                    new Tracer().warn(multiple, usageHelpAttr, "usageHelp", "--help", "usage help message");
                }
                if (versionHelpAttr.size() > 1) {
                    new Tracer().warn(multiple, versionHelpAttr, "versionHelp", "--version", "version information");
                }
            }

            public Object userObject() {
                return this.userObject;
            }

            public CommandLine commandLine() {
                return this.commandLine;
            }

            protected CommandSpec commandLine(CommandLine commandLine) {
                this.commandLine = commandLine;
                for (CommandLine sub : this.commands.values()) {
                    sub.getCommandSpec().parent(this);
                }
                return this;
            }

            public ParserSpec parser() {
                return this.parser;
            }

            public CommandSpec parser(ParserSpec settings) {
                this.parser.initFrom(settings);
                return this;
            }

            public UsageMessageSpec usageMessage() {
                return this.usageMessage;
            }

            public CommandSpec usageMessage(UsageMessageSpec settings) {
                this.usageMessage.initFrom(settings);
                return this;
            }

            public Map<String, CommandLine> subcommands() {
                return Collections.unmodifiableMap(this.commands);
            }

            public CommandSpec addSubcommand(String name, CommandSpec subcommand) {
                return this.addSubcommand(name, new CommandLine(subcommand));
            }

            public CommandSpec addSubcommand(String name, CommandLine commandLine) {
                this.commands.put(name, commandLine);
                commandLine.getCommandSpec().parent(this);
                return this;
            }

            public CommandSpec parent() {
                return this.parent;
            }

            public CommandSpec parent(CommandSpec parent) {
                this.parent = parent;
                return this;
            }

            public CommandSpec add(ArgSpec arg) {
                return arg.isOption() ? this.addOption((OptionSpec)arg) : this.addPositional((PositionalParamSpec)arg);
            }

            public CommandSpec addOption(OptionSpec option) {
                this.options.add(option);
                for (String name : option.names()) {
                    OptionSpec existing = this.optionsByNameMap.put(name, option);
                    if (existing != null && !existing.equals(option)) {
                        throw DuplicateOptionAnnotationsException.create(name, option, existing);
                    }
                    if (name.length() != 2 || !name.startsWith("-")) continue;
                    this.posixOptionsByKeyMap.put(Character.valueOf(name.charAt(1)), option);
                }
                if (option.required()) {
                    this.requiredArgs.add(option);
                }
                return this;
            }

            public CommandSpec addPositional(PositionalParamSpec positional) {
                this.positionalParameters.add(positional);
                if (positional.required()) {
                    this.requiredArgs.add(positional);
                }
                return this;
            }

            public CommandSpec addMixin(String name, CommandSpec mixin) {
                this.mixins.put(name, mixin);
                this.parser.initSeparator(mixin.parser.separator());
                this.initName(mixin.name());
                this.initVersion(mixin.version());
                this.initHelpCommand(mixin.helpCommand());
                this.initVersionProvider(mixin.versionProvider());
                this.usageMessage.initSynopsisHeading(mixin.usageMessage.synopsisHeading());
                this.usageMessage.initCommandListHeading(mixin.usageMessage.commandListHeading());
                this.usageMessage.initRequiredOptionMarker(mixin.usageMessage.requiredOptionMarker());
                this.usageMessage.initCustomSynopsis(mixin.usageMessage.customSynopsis());
                this.usageMessage.initDescription(mixin.usageMessage.description());
                this.usageMessage.initDescriptionHeading(mixin.usageMessage.descriptionHeading());
                this.usageMessage.initHeader(mixin.usageMessage.header());
                this.usageMessage.initHeaderHeading(mixin.usageMessage.headerHeading());
                this.usageMessage.initFooter(mixin.usageMessage.footer());
                this.usageMessage.initFooterHeading(mixin.usageMessage.footerHeading());
                this.usageMessage.initParameterListHeading(mixin.usageMessage.parameterListHeading());
                this.usageMessage.initOptionListHeading(mixin.usageMessage.optionListHeading());
                this.usageMessage.initAbbreviateSynopsis(mixin.usageMessage.abbreviateSynopsis());
                this.usageMessage.initSortOptions(mixin.usageMessage.sortOptions());
                this.usageMessage.initShowDefaultValues(mixin.usageMessage.showDefaultValues());
                this.usageMessage.initHidden(mixin.usageMessage.hidden());
                for (Map.Entry<String, CommandLine> entry : mixin.subcommands().entrySet()) {
                    this.addSubcommand(entry.getKey(), entry.getValue());
                }
                for (OptionSpec optionSpec : mixin.options()) {
                    this.addOption(optionSpec);
                }
                for (PositionalParamSpec paramSpec : mixin.positionalParameters()) {
                    this.addPositional(paramSpec);
                }
                return this;
            }

            public CommandSpec addUnmatchedArgsBinding(UnmatchedArgsBinding spec) {
                this.unmatchedArgs.add(spec);
                this.parser().unmatchedArgumentsAllowed(true);
                return this;
            }

            public Map<String, CommandSpec> mixins() {
                return Collections.unmodifiableMap(this.mixins);
            }

            public List<OptionSpec> options() {
                return Collections.unmodifiableList(this.options);
            }

            public List<PositionalParamSpec> positionalParameters() {
                return Collections.unmodifiableList(this.positionalParameters);
            }

            public Map<String, OptionSpec> optionsMap() {
                return Collections.unmodifiableMap(this.optionsByNameMap);
            }

            public Map<Character, OptionSpec> posixOptionsMap() {
                return Collections.unmodifiableMap(this.posixOptionsByKeyMap);
            }

            public List<ArgSpec> requiredArgs() {
                return Collections.unmodifiableList(this.requiredArgs);
            }

            public List<UnmatchedArgsBinding> unmatchedArgsBindings() {
                return Collections.unmodifiableList(this.unmatchedArgs);
            }

            public String name() {
                return this.name == null ? DEFAULT_COMMAND_NAME : this.name;
            }

            public String[] version() {
                if (this.versionProvider != null) {
                    try {
                        return this.versionProvider.getVersion();
                    }
                    catch (Exception ex) {
                        String msg = "Could not get version info from " + this.versionProvider + ": " + ex;
                        throw new ExecutionException(this.commandLine, msg, ex);
                    }
                }
                return this.version == null ? UsageMessageSpec.DEFAULT_MULTI_LINE : this.version;
            }

            public IVersionProvider versionProvider() {
                return this.versionProvider;
            }

            public boolean helpCommand() {
                return this.isHelpCommand == null ? DEFAULT_IS_HELP_COMMAND : this.isHelpCommand;
            }

            public boolean mixinStandardHelpOptions() {
                return this.mixins.containsKey("mixinStandardHelpOptions");
            }

            public String toString() {
                return this.toString;
            }

            public CommandSpec name(String name) {
                this.name = name;
                return this;
            }

            public CommandSpec version(String ... version) {
                this.version = version;
                return this;
            }

            public CommandSpec versionProvider(IVersionProvider versionProvider) {
                this.versionProvider = versionProvider;
                return this;
            }

            public CommandSpec helpCommand(boolean newValue) {
                this.isHelpCommand = newValue;
                return this;
            }

            public CommandSpec mixinStandardHelpOptions(boolean newValue) {
                if (newValue) {
                    this.addMixin("mixinStandardHelpOptions", CommandSpec.forAnnotatedObject(new AutoHelpMixin(), new DefaultFactory()));
                } else {
                    CommandSpec helpMixin = this.mixins.remove("mixinStandardHelpOptions");
                    if (helpMixin != null) {
                        this.options.removeAll(helpMixin.options);
                        for (OptionSpec option : helpMixin.options()) {
                            for (String name : option.names) {
                                this.optionsByNameMap.remove(name);
                                if (name.length() != 2 || !name.startsWith("-")) continue;
                                this.posixOptionsByKeyMap.remove(Character.valueOf(name.charAt(1)));
                            }
                        }
                    }
                }
                return this;
            }

            public CommandSpec withToString(String newValue) {
                this.toString = newValue;
                return this;
            }

            void initName(String value) {
                if (Model.initializable(this.name, value, DEFAULT_COMMAND_NAME)) {
                    this.name = value;
                }
            }

            void initHelpCommand(boolean value) {
                if (Model.initializable(this.isHelpCommand, value, CommandSpec.DEFAULT_IS_HELP_COMMAND)) {
                    this.isHelpCommand = value;
                }
            }

            void initVersion(String[] value) {
                if (Model.initializable(this.version, value, UsageMessageSpec.DEFAULT_MULTI_LINE)) {
                    this.version = (String[])value.clone();
                }
            }

            void initVersionProvider(IVersionProvider value) {
                if (this.versionProvider == null) {
                    this.versionProvider = value;
                }
            }

            void initVersionProvider(Class<? extends IVersionProvider> value, IFactory factory) {
                if (Model.initializable(this.versionProvider, value, NoVersionProvider.class)) {
                    this.versionProvider = DefaultFactory.createVersionProvider(factory, value);
                }
            }

            public OptionSpec findOption(char shortName) {
                return CommandSpec.findOption(shortName, this.options());
            }

            public OptionSpec findOption(String name) {
                return CommandSpec.findOption(name, this.options());
            }

            static OptionSpec findOption(char shortName, Iterable<OptionSpec> options) {
                for (OptionSpec option : options) {
                    for (String name : option.names()) {
                        if (name.length() == 2 && name.charAt(0) == '-' && name.charAt(1) == shortName) {
                            return option;
                        }
                        if (name.length() != 1 || name.charAt(0) != shortName) continue;
                        return option;
                    }
                }
                return null;
            }

            static OptionSpec findOption(String name, List<OptionSpec> options) {
                for (OptionSpec option : options) {
                    for (String prefixed : option.names()) {
                        if (!prefixed.equals(name) && !CommandSpec.stripPrefix(prefixed).equals(name)) continue;
                        return option;
                    }
                }
                return null;
            }

            private static String stripPrefix(String prefixed) {
                for (int i = 0; i < prefixed.length(); ++i) {
                    if (!Character.isJavaIdentifierPart(prefixed.charAt(i))) continue;
                    return prefixed.substring(i);
                }
                return prefixed;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static interface ISetter {
            public <T> T set(T var1) throws Exception;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static interface IGetter {
            public <T> T get() throws Exception;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Range
    implements Comparable<Range> {
        public final int min;
        public final int max;
        public final boolean isVariable;
        private final boolean isUnspecified;
        private final String originalValue;

        public Range(int min, int max, boolean variable, boolean unspecified, String originalValue) {
            if (min < 0 || max < 0) {
                throw new InitializationException("Invalid negative range (min=" + min + ", max=" + max + ")");
            }
            if (min > max) {
                throw new InitializationException("Invalid range (min=" + min + ", max=" + max + ")");
            }
            this.min = min;
            this.max = max;
            this.isVariable = variable;
            this.isUnspecified = unspecified;
            this.originalValue = originalValue;
        }

        public static Range optionArity(Field field) {
            return field.isAnnotationPresent(Option.class) ? Range.adjustForType(Range.valueOf(field.getAnnotation(Option.class).arity()), field) : new Range(0, 0, false, true, "0");
        }

        public static Range parameterArity(Field field) {
            return field.isAnnotationPresent(Parameters.class) ? Range.adjustForType(Range.valueOf(field.getAnnotation(Parameters.class).arity()), field) : new Range(0, 0, false, true, "0");
        }

        public static Range parameterIndex(Field field) {
            return field.isAnnotationPresent(Parameters.class) ? Range.valueOf(field.getAnnotation(Parameters.class).index()) : new Range(0, 0, false, true, "0");
        }

        static Range adjustForType(Range result, Field field) {
            return result.isUnspecified ? Range.defaultArity(field) : result;
        }

        public static Range defaultArity(Field field) {
            Class<?> type = field.getType();
            if (field.isAnnotationPresent(Option.class)) {
                Class[] typeAttribute = Model.ArgsReflection.inferTypes(type, field.getAnnotation(Option.class).type(), field.getGenericType());
                boolean zeroArgs = CommandLine.isBoolean(type) || CommandLine.isMultiValue(type) && CommandLine.isBoolean(typeAttribute[0]);
                return zeroArgs ? Range.valueOf("0") : Range.valueOf("1");
            }
            if (CommandLine.isMultiValue(type)) {
                return Range.valueOf("0..1");
            }
            return Range.valueOf("1");
        }

        @Deprecated
        public static Range defaultArity(Class<?> type) {
            return CommandLine.isBoolean(type) ? Range.valueOf("0") : Range.valueOf("1");
        }

        private int size() {
            return 1 + this.max - this.min;
        }

        static Range parameterCapacity(Field field) {
            Range arity = Range.parameterArity(field);
            if (!CommandLine.isMultiValue(field)) {
                return arity;
            }
            Range index = Range.parameterIndex(field);
            return Range.parameterCapacity(arity, index);
        }

        private static Range parameterCapacity(Range arity, Range index) {
            if (arity.max == 0) {
                return arity;
            }
            if (index.size() == 1) {
                return arity;
            }
            if (index.isVariable) {
                return Range.valueOf(arity.min + "..*");
            }
            if (arity.size() == 1) {
                return Range.valueOf(arity.min * index.size() + "");
            }
            if (arity.isVariable) {
                return Range.valueOf(arity.min * index.size() + "..*");
            }
            return Range.valueOf(arity.min * index.size() + ".." + arity.max * index.size());
        }

        public static Range valueOf(String range) {
            boolean unspecified = (range = range.trim()).length() == 0 || range.startsWith("..");
            int min = -1;
            int max = -1;
            boolean variable = false;
            int dots = -1;
            dots = range.indexOf("..");
            if (dots >= 0) {
                min = Range.parseInt(range.substring(0, dots), 0);
                max = Range.parseInt(range.substring(dots + 2), Integer.MAX_VALUE);
                variable = max == Integer.MAX_VALUE;
            } else {
                max = Range.parseInt(range, Integer.MAX_VALUE);
                variable = max == Integer.MAX_VALUE;
                min = variable ? 0 : max;
            }
            Range result = new Range(min, max, variable, unspecified, range);
            return result;
        }

        private static int parseInt(String str, int defaultValue) {
            try {
                return Integer.parseInt(str);
            }
            catch (Exception ex) {
                return defaultValue;
            }
        }

        public Range min(int newMin) {
            return new Range(newMin, Math.max(newMin, this.max), this.isVariable, this.isUnspecified, this.originalValue);
        }

        public Range max(int newMax) {
            return new Range(Math.min(this.min, newMax), newMax, this.isVariable, this.isUnspecified, this.originalValue);
        }

        public boolean contains(int value) {
            return this.min <= value && this.max >= value;
        }

        public boolean equals(Object object) {
            if (!(object instanceof Range)) {
                return false;
            }
            Range other = (Range)object;
            return other.max == this.max && other.min == this.min && other.isVariable == this.isVariable;
        }

        public int hashCode() {
            return ((629 + this.max) * 37 + this.min) * 37 + (this.isVariable ? 1 : 0);
        }

        public String toString() {
            return this.min == this.max ? String.valueOf(this.min) : this.min + ".." + (this.isVariable ? "*" : Integer.valueOf(this.max));
        }

        @Override
        public int compareTo(Range other) {
            int result = this.min - other.min;
            return result == 0 ? this.max - other.max : result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DefaultFactory
    implements IFactory {
        private DefaultFactory() {
        }

        public <T> T create(Class<T> cls) throws Exception {
            try {
                return cls.newInstance();
            }
            catch (Exception ex) {
                Constructor<T> constructor = cls.getDeclaredConstructor(new Class[0]);
                constructor.setAccessible(true);
                return constructor.newInstance(new Object[0]);
            }
        }

        private static ITypeConverter<?>[] createConverter(IFactory factory, Class<? extends ITypeConverter<?>>[] classes) {
            ITypeConverter[] result = new ITypeConverter[classes.length];
            for (int i = 0; i < classes.length; ++i) {
                try {
                    result[i] = factory.create(classes[i]);
                    continue;
                }
                catch (Exception ex) {
                    throw new InitializationException("Could not instantiate " + classes[i] + ": " + ex, ex);
                }
            }
            return result;
        }

        public static IVersionProvider createVersionProvider(IFactory factory, Class<? extends IVersionProvider> cls) {
            try {
                return factory.create(cls);
            }
            catch (Exception ex) {
                throw new InitializationException("Could not instantiate " + cls + ": " + ex, ex);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface IFactory {
        public <K> K create(Class<K> var1) throws Exception;
    }

    private static class NoVersionProvider
    implements IVersionProvider {
        private NoVersionProvider() {
        }

        public String[] getVersion() throws Exception {
            throw new UnsupportedOperationException();
        }
    }

    public static interface IVersionProvider {
        public String[] getVersion() throws Exception;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ITypeConverter<K> {
        public K convert(String var1) throws Exception;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE, ElementType.LOCAL_VARIABLE, ElementType.PACKAGE})
    public static @interface Command {
        public String name() default "<main class>";

        public Class<?>[] subcommands() default {};

        public String separator() default "=";

        public String[] version() default {};

        public Class<? extends IVersionProvider> versionProvider() default NoVersionProvider.class;

        public boolean mixinStandardHelpOptions() default false;

        public boolean helpCommand() default false;

        public String headerHeading() default "";

        public String[] header() default {};

        public String synopsisHeading() default "Usage: ";

        public boolean abbreviateSynopsis() default false;

        public String[] customSynopsis() default {};

        public String descriptionHeading() default "";

        public String[] description() default {};

        public String parameterListHeading() default "";

        public String optionListHeading() default "";

        public boolean sortOptions() default true;

        public char requiredOptionMarker() default 32;

        public boolean showDefaultValues() default false;

        public String commandListHeading() default "Commands:%n";

        public String footerHeading() default "";

        public String[] footer() default {};

        public boolean hidden() default false;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Mixin {
        public String name() default "";
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Unmatched {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface ParentCommand {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Parameters {
        public String index() default "*";

        public String[] description() default {};

        public String arity() default "";

        public String paramLabel() default "";

        public Class<?>[] type() default {};

        public Class<? extends ITypeConverter<?>>[] converter() default {};

        public String split() default "";

        public boolean hidden() default false;

        public Help.Visibility showDefaultValue() default Help.Visibility.ON_DEMAND;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Option {
        public String[] names();

        public boolean required() default false;

        @Deprecated
        public boolean help() default false;

        public boolean usageHelp() default false;

        public boolean versionHelp() default false;

        public String[] description() default {};

        public String arity() default "";

        public String paramLabel() default "";

        public Class<?>[] type() default {};

        public Class<? extends ITypeConverter<?>>[] converter() default {};

        public String split() default "";

        public boolean hidden() default false;

        public Help.Visibility showDefaultValue() default Help.Visibility.ON_DEMAND;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RunAll
    extends AbstractParseResultHandler<List<Object>>
    implements IParseResultHandler {
        @Override
        public List<Object> handleParseResult(List<CommandLine> parsedCommands, PrintStream out, Help.Ansi ansi) {
            if (CommandLine.printHelpIfRequested(parsedCommands, out, this.err(), ansi)) {
                return this.returnResultOrExit(Collections.emptyList());
            }
            ArrayList result = new ArrayList();
            for (CommandLine parsed : parsedCommands) {
                CommandLine.execute(parsed, result);
            }
            return this.returnResultOrExit(result);
        }

        @Override
        protected List<Object> handle(ParseResult parseResult) throws ExecutionException {
            ArrayList prototypeResult = new ArrayList();
            CommandLine.execute(parseResult.commandSpec().commandLine(), prototypeResult);
            while (parseResult.hasSubcommand()) {
                parseResult = parseResult.subcommand();
                CommandLine.execute(parseResult.commandSpec().commandLine(), prototypeResult);
            }
            return this.returnResultOrExit(prototypeResult);
        }

        @Override
        protected RunAll self() {
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RunLast
    extends AbstractParseResultHandler<List<Object>>
    implements IParseResultHandler {
        @Override
        public List<Object> handleParseResult(List<CommandLine> parsedCommands, PrintStream out, Help.Ansi ansi) {
            if (CommandLine.printHelpIfRequested(parsedCommands, out, this.err(), ansi)) {
                return this.returnResultOrExit(Collections.emptyList());
            }
            return this.returnResultOrExit(CommandLine.execute(parsedCommands.get(parsedCommands.size() - 1), new ArrayList()));
        }

        @Override
        protected List<Object> handle(ParseResult parseResult) throws ExecutionException {
            List<CommandLine> parsedCommands = parseResult.asCommandLineList();
            return CommandLine.execute(parsedCommands.get(parsedCommands.size() - 1), new ArrayList());
        }

        @Override
        protected RunLast self() {
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RunFirst
    extends AbstractParseResultHandler<List<Object>>
    implements IParseResultHandler {
        @Override
        public List<Object> handleParseResult(List<CommandLine> parsedCommands, PrintStream out, Help.Ansi ansi) {
            if (CommandLine.printHelpIfRequested(parsedCommands, out, this.err(), ansi)) {
                return this.returnResultOrExit(Collections.emptyList());
            }
            return this.returnResultOrExit(CommandLine.execute(parsedCommands.get(0), new ArrayList()));
        }

        @Override
        protected List<Object> handle(ParseResult parseResult) throws ExecutionException {
            return CommandLine.execute(parseResult.commandSpec().commandLine(), new ArrayList());
        }

        @Override
        protected RunFirst self() {
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class AbstractParseResultHandler<R>
    extends AbstractHandler<R, AbstractParseResultHandler<R>>
    implements IParseResultHandler2<R> {
        @Override
        public R handleParseResult(ParseResult parseResult) throws ExecutionException {
            if (CommandLine.printHelpIfRequested(parseResult.asCommandLineList(), this.out(), this.err(), this.ansi())) {
                return this.returnResultOrExit(null);
            }
            return this.returnResultOrExit(this.handle(parseResult));
        }

        protected abstract R handle(ParseResult var1) throws ExecutionException;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DefaultExceptionHandler<R>
    extends AbstractHandler<R, DefaultExceptionHandler<R>>
    implements IExceptionHandler,
    IExceptionHandler2<R> {
        @Override
        public List<Object> handleException(ParameterException ex, PrintStream out, Help.Ansi ansi, String ... args) {
            this.internalHandleParseException(ex, out, ansi, args);
            return Collections.emptyList();
        }

        @Override
        public R handleParseException(ParameterException ex, String[] args) {
            this.internalHandleParseException(ex, this.err(), this.ansi(), args);
            return this.returnResultOrExit(null);
        }

        private void internalHandleParseException(ParameterException ex, PrintStream out, Help.Ansi ansi, String[] args) {
            out.println(ex.getMessage());
            ex.getCommandLine().usage(out, ansi);
        }

        @Override
        public R handleExecutionException(ExecutionException ex, ParseResult parseResult) {
            throw ex;
        }

        @Override
        protected DefaultExceptionHandler<R> self() {
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class AbstractHandler<R, T extends AbstractHandler<R, T>> {
        private Help.Ansi ansi = Help.Ansi.AUTO;
        private Integer exitCode;
        private PrintStream out = System.out;
        private PrintStream err = System.err;

        public PrintStream out() {
            return this.out;
        }

        public PrintStream err() {
            return this.err;
        }

        public Help.Ansi ansi() {
            return this.ansi;
        }

        public Integer exitCode() {
            return this.exitCode;
        }

        public boolean hasExitCode() {
            return this.exitCode != null;
        }

        protected R returnResultOrExit(R result) {
            if (this.hasExitCode()) {
                System.exit(this.exitCode());
            }
            return result;
        }

        protected abstract T self();

        public T useOut(PrintStream out) {
            this.out = Assert.notNull(out, "out");
            return this.self();
        }

        public T useErr(PrintStream err) {
            this.err = Assert.notNull(err, "err");
            return this.self();
        }

        public T useAnsi(Help.Ansi ansi) {
            this.ansi = Assert.notNull(ansi, "ansi");
            return this.self();
        }

        public T andExit(int exitCode) {
            this.exitCode = exitCode;
            return this.self();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface IExceptionHandler2<R> {
        public R handleParseException(ParameterException var1, String[] var2);

        public R handleExecutionException(ExecutionException var1, ParseResult var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Deprecated
    public static interface IExceptionHandler {
        public List<Object> handleException(ParameterException var1, PrintStream var2, Help.Ansi var3, String ... var4);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface IParseResultHandler2<R> {
        public R handleParseResult(ParseResult var1) throws ExecutionException;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Deprecated
    public static interface IParseResultHandler {
        public List<Object> handleParseResult(List<CommandLine> var1, PrintStream var2, Help.Ansi var3) throws ExecutionException;
    }
}

