/*
 * Decompiled with CFR 0.152.
 */
package BFTSmartBlockchain;

import BFTSmartBlockchain.Block;
import BFTSmartBlockchain.BlockchainReplyType;
import BFTSmartBlockchain.BlockchainRequestType;
import BFTSmartBlockchain.Transaction;
import bftsmart.tom.MessageContext;
import bftsmart.tom.ServiceReplica;
import bftsmart.tom.server.Executable;
import bftsmart.tom.server.Recoverable;
import bftsmart.tom.server.defaultservices.DefaultSingleRecoverable;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.codec.binary.Hex;

public class BlockchainServer
extends DefaultSingleRecoverable {
    private static final int blockSize = 3;
    private TreeMap<String, Block> blocksByHash = new TreeMap();
    private TreeSet<Transaction> txPool = new TreeSet();
    private Block head = null;
    private int nodeId;

    public static void main(String[] args) {
        new BlockchainServer(Integer.parseInt(args[0]));
    }

    public BlockchainServer(int id) {
        this.nodeId = id;
        new ServiceReplica(id, (Executable)this, (Recoverable)this);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] appExecuteOrdered(byte[] command, MessageContext msgCtx) {
        byte[] reply = null;
        Transaction tx = null;
        Block newBlock = null;
        byte[] blockHash = null;
        boolean hasReply = false;
        try {
            Throwable throwable = null;
            Object var9_11 = null;
            try {
                ByteArrayInputStream byteIn = new ByteArrayInputStream(command);
                try {
                    block36: {
                        ObjectInputStream objIn = new ObjectInputStream(byteIn);
                        try {
                            block35: {
                                ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
                                try {
                                    try (ObjectOutputStream objOut = new ObjectOutputStream(byteOut);){
                                        BlockchainRequestType reqType = (BlockchainRequestType)((Object)objIn.readObject());
                                        switch (reqType) {
                                            case ADD_TRANSACTION: {
                                                tx = (Transaction)objIn.readObject();
                                                if (this.txPool.add(tx)) {
                                                    if (this.txPool.size() == 3) {
                                                        newBlock = this.head != null ? new Block((TreeSet)this.txPool.clone(), this.head.blockHash) : new Block((TreeSet)this.txPool.clone(), null);
                                                        this.blocksByHash.put(Hex.encodeHexString((byte[])newBlock.blockHash), newBlock);
                                                        this.head = newBlock;
                                                        this.txPool.clear();
                                                        objOut.writeObject((Object)BlockchainReplyType.BLOCK);
                                                    }
                                                    objOut.writeObject((Object)BlockchainReplyType.OK);
                                                } else {
                                                    objOut.writeObject((Object)BlockchainReplyType.DUPLICATE);
                                                }
                                                hasReply = true;
                                                System.out.println(this.toString());
                                                break;
                                            }
                                            case GET_HEAD: {
                                                if (this.head == null) break;
                                                objOut.writeObject(this.head);
                                                hasReply = true;
                                                break;
                                            }
                                            case GET_BLOCK: {
                                                blockHash = (byte[])objIn.readObject();
                                                if (!this.blocksByHash.containsKey(Hex.encodeHexString((byte[])blockHash))) break;
                                                objOut.writeObject(this.blocksByHash.get(Hex.encodeHexString((byte[])blockHash)));
                                                hasReply = true;
                                                break;
                                            }
                                        }
                                        if (hasReply) {
                                            objOut.flush();
                                            byteOut.flush();
                                            reply = byteOut.toByteArray();
                                        } else {
                                            reply = new byte[]{};
                                        }
                                    }
                                    if (byteOut == null) break block35;
                                }
                                catch (Throwable throwable2) {
                                    if (throwable == null) {
                                        throwable = throwable2;
                                    } else if (throwable != throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                    if (byteOut == null) throw throwable;
                                    byteOut.close();
                                    throw throwable;
                                }
                                byteOut.close();
                            }
                            if (objIn == null) break block36;
                        }
                        catch (Throwable throwable3) {
                            if (throwable == null) {
                                throwable = throwable3;
                            } else if (throwable != throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            if (objIn == null) throw throwable;
                            objIn.close();
                            throw throwable;
                        }
                        objIn.close();
                    }
                    if (byteIn == null) return reply;
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    if (byteIn == null) throw throwable;
                    byteIn.close();
                    throw throwable;
                }
                byteIn.close();
                return reply;
            }
            catch (Throwable throwable5) {
                if (throwable == null) {
                    throwable = throwable5;
                    throw throwable;
                }
                if (throwable == throwable5) throw throwable;
                throwable.addSuppressed(throwable5);
                throw throwable;
            }
        }
        catch (IOException | ClassNotFoundException e) {
            System.out.println(e);
        }
        return reply;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] appExecuteUnordered(byte[] command, MessageContext msgCtx) {
        byte[] reply = null;
        byte[] blockHash = null;
        boolean hasReply = false;
        try {
            Throwable throwable = null;
            Object var7_9 = null;
            try {
                ByteArrayInputStream byteIn = new ByteArrayInputStream(command);
                try {
                    block32: {
                        ObjectInputStream objIn = new ObjectInputStream(byteIn);
                        try {
                            block31: {
                                ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
                                try {
                                    try (ObjectOutputStream objOut = new ObjectOutputStream(byteOut);){
                                        BlockchainRequestType reqType = (BlockchainRequestType)((Object)objIn.readObject());
                                        switch (reqType) {
                                            case GET_HEAD: {
                                                if (this.head == null) break;
                                                objOut.writeObject(this.head);
                                                hasReply = true;
                                                break;
                                            }
                                            case GET_BLOCK: {
                                                blockHash = (byte[])objIn.readObject();
                                                if (!this.blocksByHash.containsKey(Hex.encodeHexString((byte[])blockHash))) break;
                                                objOut.writeObject(this.blocksByHash.get(Hex.encodeHexString((byte[])blockHash)));
                                                hasReply = true;
                                                break;
                                            }
                                            default: {
                                                System.err.println("Only GET_HEAD and GET_BLOCK are allowed unordered!");
                                            }
                                        }
                                        if (hasReply) {
                                            objOut.flush();
                                            byteOut.flush();
                                            reply = byteOut.toByteArray();
                                        } else {
                                            reply = new byte[]{};
                                        }
                                    }
                                    if (byteOut == null) break block31;
                                }
                                catch (Throwable throwable2) {
                                    if (throwable == null) {
                                        throwable = throwable2;
                                    } else if (throwable != throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                    if (byteOut == null) throw throwable;
                                    byteOut.close();
                                    throw throwable;
                                }
                                byteOut.close();
                            }
                            if (objIn == null) break block32;
                        }
                        catch (Throwable throwable3) {
                            if (throwable == null) {
                                throwable = throwable3;
                            } else if (throwable != throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            if (objIn == null) throw throwable;
                            objIn.close();
                            throw throwable;
                        }
                        objIn.close();
                    }
                    if (byteIn == null) return reply;
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    if (byteIn == null) throw throwable;
                    byteIn.close();
                    throw throwable;
                }
                byteIn.close();
                return reply;
            }
            catch (Throwable throwable5) {
                if (throwable == null) {
                    throwable = throwable5;
                    throw throwable;
                }
                if (throwable == throwable5) throw throwable;
                throwable.addSuppressed(throwable5);
                throw throwable;
            }
        }
        catch (IOException | ClassNotFoundException e) {
            System.out.println(e);
        }
        return reply;
    }

    /*
     * Loose catch block
     */
    public byte[] getSnapshot() {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try {
                byte[] byArray;
                ObjectOutputStream objOut;
                ByteArrayOutputStream byteOut;
                block18: {
                    block17: {
                        byteOut = new ByteArrayOutputStream();
                        objOut = new ObjectOutputStream(byteOut);
                        objOut.writeObject(this.blocksByHash);
                        objOut.writeObject(this.txPool);
                        objOut.writeObject(this.head);
                        byArray = byteOut.toByteArray();
                        if (objOut == null) break block17;
                        objOut.close();
                    }
                    if (byteOut == null) break block18;
                    byteOut.close();
                }
                return byArray;
                {
                    catch (Throwable throwable2) {
                        try {
                            if (objOut != null) {
                                objOut.close();
                            }
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (throwable == null) {
                                throwable = throwable3;
                            } else if (throwable != throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            if (byteOut != null) {
                                byteOut.close();
                            }
                            throw throwable;
                        }
                    }
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            System.err.println("Exception while getting snapshot: " + e);
            return new byte[0];
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void installSnapshot(byte[] state) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try {
                ByteArrayInputStream byteIn = new ByteArrayInputStream(state);
                try {
                    try (ObjectInputStream objIn = new ObjectInputStream(byteIn);){
                        this.blocksByHash = (TreeMap)objIn.readObject();
                        this.txPool = (TreeSet)objIn.readObject();
                        this.head = (Block)objIn.readObject();
                    }
                    if (byteIn == null) return;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (byteIn == null) throw throwable;
                    byteIn.close();
                    throw throwable;
                }
                byteIn.close();
                return;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (IOException | ClassNotFoundException e) {
            System.err.println("Exception while installing snapshot: " + e);
        }
    }

    public String toString() {
        String r = "Node : " + Integer.toString(this.nodeId) + "\n";
        for (Block b : this.blocksByHash.values()) {
            r = String.valueOf(r) + b.toString() + "\n";
        }
        if (this.head != null) {
            r = String.valueOf(r) + "Head: " + this.head.toString();
        }
        for (Transaction tx : this.txPool) {
            r = String.valueOf(r) + tx.toString() + "\n";
        }
        return r;
    }
}

