/*
 * Decompiled with CFR 0.152.
 */
package BFTSmartBlockchain;

import java.io.ByteArrayOutputStream;
import java.io.Serializable;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.interfaces.ECPublicKey;
import java.util.Arrays;
import org.apache.commons.codec.binary.Hex;

public class Transaction
implements Serializable,
Comparable<Transaction> {
    private static final long serialVersionUID = 1L;
    public byte[] content;
    public ECPublicKey senderPublicKey;
    public byte[] signature;

    public Transaction(byte[] content, ECPublicKey senderPublicKey) {
        this.content = content;
        this.senderPublicKey = senderPublicKey;
    }

    public Transaction Sign(PrivateKey key) {
        try {
            Signature ECDSA = Signature.getInstance("SHA1withECDSA");
            ECDSA.initSign(key);
            ECDSA.update(this.contentBytes());
            this.signature = ECDSA.sign();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this;
    }

    public boolean Verify() {
        try {
            Signature ECDSA = Signature.getInstance("SHA1withECDSA");
            ECDSA.initVerify(this.senderPublicKey);
            ECDSA.update(this.contentBytes());
            return ECDSA.verify(this.signature);
        }
        catch (Exception e) {
            return false;
        }
    }

    public byte[] contentBytes() {
        try {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            stream.write(this.content);
            stream.write(this.senderPublicKey.getEncoded());
            return stream.toByteArray();
        }
        catch (Exception e) {
            return null;
        }
    }

    public byte[] asByteArray() {
        try {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            stream.write(this.content);
            stream.write(this.senderPublicKey.getEncoded());
            stream.write(this.signature);
            return stream.toByteArray();
        }
        catch (Exception e) {
            return null;
        }
    }

    public String toString() {
        return "Transaction \n From: " + Hex.encodeHexString((byte[])this.senderPublicKey.getEncoded()) + "\n With signature: " + Hex.encodeHexString((byte[])this.signature) + "\n And content: " + Hex.encodeHexString((byte[])this.content);
    }

    @Override
    public int compareTo(Transaction other) {
        return Arrays.compare(this.asByteArray(), other.asByteArray());
    }
}

