/*
 * Decompiled with CFR 0.152.
 */
package bftsmart.clientsmanagement;

import bftsmart.clientsmanagement.ClientData;
import bftsmart.clientsmanagement.RequestList;
import bftsmart.communication.ServerCommunicationSystem;
import bftsmart.reconfiguration.ServerViewController;
import bftsmart.tom.core.messages.TOMMessage;
import bftsmart.tom.leaderchange.RequestsTimer;
import bftsmart.tom.server.RequestVerifier;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientsManager {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private ServerViewController controller;
    private RequestsTimer timer;
    private HashMap<Integer, ClientData> clientsData = new HashMap();
    private RequestVerifier verifier;
    private ReentrantLock clientsLock = new ReentrantLock();

    public ClientsManager(ServerViewController controller, RequestsTimer timer, RequestVerifier verifier) {
        this.controller = controller;
        this.timer = timer;
        this.verifier = verifier;
    }

    public ClientData getClientData(int clientId) {
        this.clientsLock.lock();
        ClientData clientData = this.clientsData.get(clientId);
        if (clientData == null) {
            this.logger.debug("Creating new client data, client id=" + clientId);
            clientData = new ClientData(clientId, this.controller.getStaticConf().getUseSignatures() == 1 ? this.controller.getStaticConf().getPublicKey(clientId) : null);
            this.clientsData.put(clientId, clientData);
        }
        this.clientsLock.unlock();
        return clientData;
    }

    public RequestList getPendingRequests() {
        RequestList allReq = new RequestList();
        this.clientsLock.lock();
        Set<Map.Entry<Integer, ClientData>> clientsEntrySet = this.clientsData.entrySet();
        int i = 0;
        while (true) {
            Iterator<Map.Entry<Integer, ClientData>> it = clientsEntrySet.iterator();
            int noMoreMessages = 0;
            while (it.hasNext() && allReq.size() < this.controller.getStaticConf().getMaxBatchSize() && noMoreMessages < clientsEntrySet.size()) {
                ClientData clientData = it.next().getValue();
                RequestList clientPendingRequests = clientData.getPendingRequests();
                clientData.clientLock.lock();
                TOMMessage request = clientPendingRequests.size() > i ? (TOMMessage)clientPendingRequests.get(i) : null;
                clientData.clientLock.unlock();
                if (request != null) {
                    if (request.alreadyProposed) continue;
                    request.alreadyProposed = true;
                    allReq.addLast(request);
                    continue;
                }
                ++noMoreMessages;
            }
            if (allReq.size() == this.controller.getStaticConf().getMaxBatchSize() || noMoreMessages == clientsEntrySet.size()) break;
            ++i;
        }
        this.clientsLock.unlock();
        return allReq;
    }

    public boolean havePendingRequests() {
        boolean havePending = false;
        this.clientsLock.lock();
        Iterator<Map.Entry<Integer, ClientData>> it = this.clientsData.entrySet().iterator();
        while (it.hasNext() && !havePending) {
            ClientData clientData = it.next().getValue();
            clientData.clientLock.lock();
            RequestList reqs = clientData.getPendingRequests();
            if (!reqs.isEmpty()) {
                for (TOMMessage msg : reqs) {
                    if (msg.alreadyProposed) continue;
                    havePending = true;
                    break;
                }
            }
            clientData.clientLock.unlock();
        }
        this.clientsLock.unlock();
        return havePending;
    }

    public boolean isPending(int reqId) {
        return this.getPending(reqId) != null;
    }

    public TOMMessage getPending(int reqId) {
        ClientData clientData = this.getClientData(TOMMessage.getSenderFromId(reqId));
        clientData.clientLock.lock();
        TOMMessage pendingMessage = clientData.getPendingRequests().getById(reqId);
        clientData.clientLock.unlock();
        return pendingMessage;
    }

    public boolean requestReceived(TOMMessage request, boolean fromClient) {
        return this.requestReceived(request, fromClient, null);
    }

    public boolean requestReceived(TOMMessage request, boolean fromClient, ServerCommunicationSystem cs) {
        long receptionTime = System.nanoTime();
        long receptionTimestamp = System.currentTimeMillis();
        int clientId = request.getSender();
        boolean accounted = false;
        ClientData clientData = this.getClientData(clientId);
        clientData.clientLock.lock();
        if (!fromClient && clientData.getSession() == request.getSession() && clientData.getLastMessageDelivered() >= request.getSequence()) {
            clientData.clientLock.unlock();
            this.logger.warn("Detected a leader replay attack, rejecting request");
            return false;
        }
        request.receptionTime = receptionTime;
        request.receptionTimestamp = receptionTimestamp;
        if (fromClient && this.controller.getStaticConf().getUseControlFlow() != 0 && clientData.getPendingRequests().size() > this.controller.getStaticConf().getUseControlFlow()) {
            clientData.setLastMessageReceived(request.getSequence());
            clientData.setLastMessageReceivedTime(request.receptionTime);
            clientData.clientLock.unlock();
            return false;
        }
        if (clientData.getSession() != request.getSession()) {
            clientData.setSession(request.getSession());
            clientData.setLastMessageReceived(-1);
            clientData.setLastMessageDelivered(-1);
            clientData.getOrderedRequests().clear();
            clientData.getPendingRequests().clear();
        }
        if (clientData.getLastMessageReceived() == -1 || clientData.getLastMessageReceived() + 1 == request.getSequence() || request.getSequence() > clientData.getLastMessageReceived() && !fromClient) {
            boolean isValid;
            boolean bl = isValid = !this.controller.getStaticConf().isBFT() || this.verifier.isValidRequest(request);
            if (isValid && (!request.signed || clientData.verifySignature(request.serializedMessage, request.serializedMessageSignature))) {
                request.recvFromClient = fromClient;
                clientData.getPendingRequests().add(request);
                clientData.setLastMessageReceived(request.getSequence());
                clientData.setLastMessageReceivedTime(request.receptionTime);
                if (this.timer != null) {
                    this.timer.watch(request);
                }
                accounted = true;
            }
        } else if (clientData.getLastMessageReceived() >= request.getSequence()) {
            TOMMessage reply = clientData.getReply(request.getSequence());
            if (reply != null && cs != null) {
                if (reply.recvFromClient && fromClient) {
                    this.logger.info("[CACHE] re-send reply [Sender: " + reply.getSender() + ", sequence: " + reply.getSequence() + ", session: " + reply.getSession() + "]");
                    cs.send(new int[]{request.getSender()}, reply);
                } else if (!reply.recvFromClient && fromClient) {
                    reply.recvFromClient = true;
                }
            }
            accounted = true;
        } else {
            accounted = false;
        }
        clientData.clientLock.unlock();
        return accounted;
    }

    public void requestsOrdered(TOMMessage[] requests) {
        this.clientsLock.lock();
        this.logger.debug("Updating client manager");
        for (TOMMessage request : requests) {
            this.requestOrdered(request);
        }
        this.logger.debug("Finished updating client manager");
        this.clientsLock.unlock();
    }

    private void requestOrdered(TOMMessage request) {
        if (this.timer != null) {
            this.timer.unwatch(request);
        }
        ClientData clientData = this.getClientData(request.getSender());
        clientData.clientLock.lock();
        if (!clientData.removeOrderedRequest(request)) {
            this.logger.debug("Request " + request + " does not exist in pending requests");
        }
        clientData.setLastMessageDelivered(request.getSequence());
        clientData.clientLock.unlock();
    }

    public ReentrantLock getClientsLock() {
        return this.clientsLock;
    }

    public void clear() {
        this.clientsLock.lock();
        this.clientsData.clear();
        this.clientsLock.unlock();
        this.logger.info("ClientsManager cleared.");
    }
}

