/*
 * Decompiled with CFR 0.152.
 */
package bftsmart.clientsmanagement;

import bftsmart.tom.core.messages.TOMMessage;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.ListIterator;

public class RequestList
extends LinkedList<TOMMessage> {
    private static final long serialVersionUID = -3639222602426147629L;
    private int maxSize = Integer.MAX_VALUE;

    public RequestList() {
    }

    public RequestList(int maxSize) {
        this.maxSize = maxSize;
    }

    @Override
    public void addLast(TOMMessage msg) {
        super.addLast(msg);
        if (this.size() > this.maxSize) {
            super.removeFirst();
        }
    }

    public TOMMessage remove(byte[] serializedMessage) {
        ListIterator li = this.listIterator();
        while (li.hasNext()) {
            TOMMessage msg = (TOMMessage)li.next();
            if (!Arrays.equals(serializedMessage, msg.serializedMessage)) continue;
            li.remove();
            return msg;
        }
        return null;
    }

    public TOMMessage removeById(int id) {
        ListIterator li = this.listIterator();
        while (li.hasNext()) {
            TOMMessage msg = (TOMMessage)li.next();
            if (msg.getId() != id) continue;
            li.remove();
            return msg;
        }
        return null;
    }

    public int[] getIds() {
        int[] ids = new int[this.size()];
        for (int i = 0; i < ids.length; ++i) {
            ids[i] = ((TOMMessage)this.get(i)).getId();
        }
        return ids;
    }

    public TOMMessage get(byte[] serializedMessage) {
        ListIterator li = this.listIterator();
        while (li.hasNext()) {
            TOMMessage msg = (TOMMessage)li.next();
            if (!Arrays.equals(serializedMessage, msg.serializedMessage)) continue;
            return msg;
        }
        return null;
    }

    public TOMMessage getById(int id) {
        ListIterator li = this.listIterator();
        while (li.hasNext()) {
            TOMMessage msg = (TOMMessage)li.next();
            if (msg.getId() != id) continue;
            return msg;
        }
        return null;
    }

    public TOMMessage getBySequence(int sequence) {
        ListIterator li = this.listIterator();
        while (li.hasNext()) {
            TOMMessage msg = (TOMMessage)li.next();
            if (msg.getSequence() != sequence) continue;
            return msg;
        }
        return null;
    }

    public boolean contains(int id) {
        ListIterator li = this.listIterator();
        while (li.hasNext()) {
            TOMMessage msg = (TOMMessage)li.next();
            if (msg.getId() != id) continue;
            return true;
        }
        return false;
    }
}

