/*
 * Decompiled with CFR 0.152.
 */
package bftsmart.communication.client.netty;

import bftsmart.communication.client.CommunicationSystemClientSide;
import bftsmart.communication.client.ReplyReceiver;
import bftsmart.communication.client.netty.NettyClientPipelineFactory;
import bftsmart.communication.client.netty.NettyClientServerSession;
import bftsmart.reconfiguration.ClientViewController;
import bftsmart.tom.core.messages.TOMMessage;
import bftsmart.tom.util.TOMUtil;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoop;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.ConnectException;
import java.nio.channels.ClosedChannelException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.spec.InvalidKeySpecException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class NettyClientServerCommunicationSystemClientSide
extends SimpleChannelInboundHandler<TOMMessage>
implements CommunicationSystemClientSide {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private int clientId;
    protected ReplyReceiver trr;
    private ClientViewController controller;
    private Map<Integer, NettyClientServerSession> sessionTable = new HashMap<Integer, NettyClientServerSession>();
    private ReentrantReadWriteLock rl;
    private Signature signatureEngine;
    private boolean closed = false;
    private EventLoopGroup workerGroup;
    private SyncListener listener;

    public NettyClientServerCommunicationSystemClientSide(int clientId, ClientViewController controller) {
        this.clientId = clientId;
        this.workerGroup = new NioEventLoopGroup();
        try {
            SecretKeyFactory fac = TOMUtil.getSecretFactory();
            this.controller = controller;
            this.listener = new SyncListener();
            this.rl = new ReentrantReadWriteLock();
            ChannelFuture future = null;
            int[] currV = controller.getCurrentViewProcesses();
            for (int i = 0; i < currV.length; ++i) {
                try {
                    String str = this.clientId + ":" + currV[i];
                    PBEKeySpec spec = TOMUtil.generateKeySpec(str.toCharArray());
                    SecretKey authKey = fac.generateSecret(spec);
                    Bootstrap b = new Bootstrap();
                    b.group(this.workerGroup);
                    b.channel(NioSocketChannel.class);
                    b.option(ChannelOption.SO_KEEPALIVE, (Object)true);
                    b.option(ChannelOption.TCP_NODELAY, (Object)true);
                    b.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)10000);
                    b.handler((ChannelHandler)this.getChannelInitializer());
                    future = b.connect(controller.getRemoteAddress(currV[i]));
                    Mac macSend = TOMUtil.getMacFactory();
                    macSend.init(authKey);
                    Mac macReceive = TOMUtil.getMacFactory();
                    macReceive.init(authKey);
                    NettyClientServerSession cs = new NettyClientServerSession(future.channel(), macSend, macReceive, currV[i]);
                    this.sessionTable.put(currV[i], cs);
                    this.logger.info("Connecting to replica " + currV[i] + " at " + controller.getRemoteAddress(currV[i]));
                    future.awaitUninterruptibly();
                    if (future.isSuccess()) continue;
                    this.logger.error("Impossible to connect to " + currV[i]);
                    continue;
                }
                catch (NullPointerException ex) {
                    this.logger.debug("Should fix the problem, and I think it has no other implications :-), but we must make the servers store the view in a different place.");
                    continue;
                }
                catch (InvalidKeyException ex) {
                    this.logger.error("Failed to initialize MAC engine", (Throwable)ex);
                    continue;
                }
                catch (Exception ex) {
                    this.logger.error("Failed to initialize MAC engine", (Throwable)ex);
                }
            }
        }
        catch (NoSuchAlgorithmException ex) {
            this.logger.error("Failed to initialize secret key factory", (Throwable)ex);
        }
    }

    @Override
    public void updateConnections() {
        int[] currV = this.controller.getCurrentViewProcesses();
        try {
            for (int i = 0; i < currV.length; ++i) {
                this.rl.readLock().lock();
                if (this.sessionTable.get(currV[i]) == null) {
                    this.rl.readLock().unlock();
                    this.rl.writeLock().lock();
                    SecretKeyFactory fac = TOMUtil.getSecretFactory();
                    try {
                        if (this.workerGroup == null) {
                            this.workerGroup = new NioEventLoopGroup();
                        }
                        Bootstrap b = new Bootstrap();
                        b.group(this.workerGroup);
                        b.channel(NioSocketChannel.class);
                        b.option(ChannelOption.SO_KEEPALIVE, (Object)true);
                        b.option(ChannelOption.TCP_NODELAY, (Object)true);
                        b.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)10000);
                        b.handler((ChannelHandler)this.getChannelInitializer());
                        ChannelFuture future = b.connect(this.controller.getRemoteAddress(currV[i]));
                        String str = this.clientId + ":" + currV[i];
                        PBEKeySpec spec = TOMUtil.generateKeySpec(str.toCharArray());
                        SecretKey authKey = fac.generateSecret(spec);
                        Mac macSend = TOMUtil.getMacFactory();
                        macSend.init(authKey);
                        Mac macReceive = TOMUtil.getMacFactory();
                        macReceive.init(authKey);
                        NettyClientServerSession cs = new NettyClientServerSession(future.channel(), macSend, macReceive, currV[i]);
                        this.sessionTable.put(currV[i], cs);
                        this.logger.info("Connecting to replica " + currV[i] + " at " + this.controller.getRemoteAddress(currV[i]));
                        future.awaitUninterruptibly();
                        if (!future.isSuccess()) {
                            this.logger.error("Impossible to connect to " + currV[i]);
                        }
                    }
                    catch (InvalidKeyException | InvalidKeySpecException ex) {
                        this.logger.error("Failed to initialize MAC engine", (Throwable)ex);
                    }
                    this.rl.writeLock().unlock();
                    continue;
                }
                this.rl.readLock().unlock();
            }
        }
        catch (NoSuchAlgorithmException ex) {
            this.logger.error("Failed to initialzie secret key factory", (Throwable)ex);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (cause instanceof ClosedChannelException) {
            this.logger.error("Connection with replica closed.", cause);
        } else if (cause instanceof ConnectException) {
            this.logger.error("Impossible to connect to replica.", cause);
        } else {
            this.logger.error("Replica disconnected.", cause);
        }
    }

    public void channelRead0(ChannelHandlerContext ctx, TOMMessage sm) throws Exception {
        if (this.closed) {
            this.closeChannelAndEventLoop(ctx.channel());
            return;
        }
        this.trr.replyReceived(sm);
    }

    public void channelActive(ChannelHandlerContext ctx) {
        if (this.closed) {
            this.closeChannelAndEventLoop(ctx.channel());
            return;
        }
        this.logger.info("Channel active");
    }

    public void reconnect(ChannelHandlerContext ctx) {
        this.rl.writeLock().lock();
        this.logger.debug("try to reconnect");
        ArrayList<NettyClientServerSession> sessions = new ArrayList<NettyClientServerSession>(this.sessionTable.values());
        for (NettyClientServerSession ncss : sessions) {
            if (ncss.getChannel() != ctx.channel()) continue;
            try {
                if (this.workerGroup == null) {
                    this.workerGroup = new NioEventLoopGroup();
                }
                Bootstrap b = new Bootstrap();
                b.group(this.workerGroup);
                b.channel(NioSocketChannel.class);
                b.option(ChannelOption.SO_KEEPALIVE, (Object)true);
                b.option(ChannelOption.TCP_NODELAY, (Object)true);
                b.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)10000);
                b.handler((ChannelHandler)this.getChannelInitializer());
                if (this.controller.getRemoteAddress(ncss.getReplicaId()) != null) {
                    ChannelFuture future = b.connect(this.controller.getRemoteAddress(ncss.getReplicaId()));
                    Mac macSend = ncss.getMacSend();
                    Mac macReceive = ncss.getMacReceive();
                    NettyClientServerSession cs = new NettyClientServerSession(future.channel(), macSend, macReceive, ncss.getReplicaId());
                    this.sessionTable.remove(ncss.getReplicaId());
                    this.sessionTable.put(ncss.getReplicaId(), cs);
                    this.logger.info("re-connecting to replica " + ncss.getReplicaId() + " at " + this.controller.getRemoteAddress(ncss.getReplicaId()));
                    continue;
                }
                this.sessionTable.remove(ncss.getReplicaId());
            }
            catch (NoSuchAlgorithmException ex) {
                this.logger.error("Failed to reconnect to replica", (Throwable)ex);
            }
        }
        this.rl.writeLock().unlock();
    }

    @Override
    public void setReplyReceiver(ReplyReceiver trr) {
        this.trr = trr;
    }

    @Override
    public void send(boolean sign, int[] targets, TOMMessage sm) {
        int quorum = this.controller.getStaticConf().isBFT() ? (int)Math.ceil((this.controller.getCurrentViewN() + this.controller.getCurrentViewF()) / 2) + 1 : (int)Math.ceil(this.controller.getCurrentViewN() / 2) + 1;
        this.listener.waitForChannels(quorum);
        this.logger.debug("Sending request from " + sm.getSender() + " with sequence number " + sm.getSequence() + " to " + Arrays.toString(targets));
        if (sm.serializedMessage == null) {
            DataOutputStream dos = null;
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                dos = new DataOutputStream(baos);
                sm.wExternal(dos);
                dos.flush();
                sm.serializedMessage = baos.toByteArray();
            }
            catch (IOException ex) {
                this.logger.debug("Impossible to serialize message: " + sm);
            }
        }
        if (sign && sm.serializedMessageSignature == null) {
            sm.serializedMessageSignature = this.signMessage(this.controller.getStaticConf().getPrivateKey(), sm.serializedMessage);
        }
        int sent = 0;
        for (int i = targets.length - 1; i >= 0; --i) {
            try {
                sm = (TOMMessage)sm.clone();
            }
            catch (CloneNotSupportedException e) {
                this.logger.error("Failed to clone TOMMessage", (Throwable)e);
                continue;
            }
            sm.destination = targets[i];
            this.rl.readLock().lock();
            Channel channel = this.sessionTable.get(targets[i]).getChannel();
            this.rl.readLock().unlock();
            if (channel.isActive()) {
                sm.signed = sign;
                ChannelFuture f = channel.writeAndFlush((Object)sm);
                f.addListener((GenericFutureListener)this.listener);
                ++sent;
                continue;
            }
            this.logger.debug("Channel to " + targets[i] + " is not connected");
        }
        if (targets.length > this.controller.getCurrentViewF() && sent < this.controller.getCurrentViewF() + 1) {
            throw new RuntimeException("Impossible to connect to servers!");
        }
        if (targets.length == 1 && sent == 0) {
            throw new RuntimeException("Server not connected");
        }
    }

    @Override
    public void sign(TOMMessage sm) {
        DataOutputStream dos = null;
        byte[] data = null;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            dos = new DataOutputStream(baos);
            sm.wExternal(dos);
            dos.flush();
            data = baos.toByteArray();
            sm.serializedMessage = data;
        }
        catch (IOException ex) {
            this.logger.error("Failed to sign TOMMessage", (Throwable)ex);
        }
        byte[] data2 = this.signMessage(this.controller.getStaticConf().getPrivateKey(), data);
        sm.serializedMessageSignature = data2;
    }

    public byte[] signMessage(PrivateKey key, byte[] message) {
        try {
            if (this.signatureEngine == null) {
                this.signatureEngine = TOMUtil.getSigEngine();
            }
            byte[] result = null;
            this.signatureEngine.initSign(key);
            this.signatureEngine.update(message);
            result = this.signatureEngine.sign();
            return result;
        }
        catch (Exception e) {
            this.logger.error("Failed to sign message", (Throwable)e);
            return null;
        }
    }

    @Override
    public void close() {
        this.closed = true;
        this.rl.readLock().lock();
        ArrayList<NettyClientServerSession> sessions = new ArrayList<NettyClientServerSession>(this.sessionTable.values());
        this.rl.readLock().unlock();
        for (NettyClientServerSession ncss : sessions) {
            Channel c = ncss.getChannel();
            this.closeChannelAndEventLoop(c);
        }
    }

    private ChannelInitializer getChannelInitializer() throws NoSuchAlgorithmException {
        Mac macDummy = TOMUtil.getMacFactory();
        final NettyClientPipelineFactory nettyClientPipelineFactory = new NettyClientPipelineFactory(this, this.sessionTable, this.controller, this.rl);
        ChannelInitializer<SocketChannel> channelInitializer = new ChannelInitializer<SocketChannel>(){

            public void initChannel(SocketChannel ch) throws Exception {
                ch.pipeline().addLast(new ChannelHandler[]{nettyClientPipelineFactory.getDecoder()});
                ch.pipeline().addLast(new ChannelHandler[]{nettyClientPipelineFactory.getEncoder()});
                ch.pipeline().addLast(new ChannelHandler[]{nettyClientPipelineFactory.getHandler()});
            }
        };
        return channelInitializer;
    }

    public void channelUnregistered(ChannelHandlerContext ctx) throws Exception {
        this.scheduleReconnect(ctx, 10);
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        this.scheduleReconnect(ctx, 10);
    }

    private void closeChannelAndEventLoop(Channel c) {
        c.close();
        if (c.parent() != null) {
            c.parent().close();
        }
        this.workerGroup.shutdownGracefully();
    }

    private void scheduleReconnect(final ChannelHandlerContext ctx, int time) {
        if (this.closed) {
            this.closeChannelAndEventLoop(ctx.channel());
            return;
        }
        EventLoop loop = ctx.channel().eventLoop();
        loop.schedule(new Runnable(){

            @Override
            public void run() {
                NettyClientServerCommunicationSystemClientSide.this.reconnect(ctx);
            }
        }, (long)time, TimeUnit.SECONDS);
    }

    private class SyncListener
    implements GenericFutureListener<ChannelFuture> {
        private int remainingFutures = 0;
        private final Lock futureLock = new ReentrantLock();
        private final Condition enoughCompleted = this.futureLock.newCondition();

        public void operationComplete(ChannelFuture f) {
            this.futureLock.lock();
            --this.remainingFutures;
            if (this.remainingFutures <= 0) {
                this.enoughCompleted.signalAll();
            }
            NettyClientServerCommunicationSystemClientSide.this.logger.debug(this.remainingFutures + " channel operations remaining to complete");
            this.futureLock.unlock();
        }

        public void waitForChannels(int n) {
            this.futureLock.lock();
            if (this.remainingFutures > 0) {
                NettyClientServerCommunicationSystemClientSide.this.logger.debug("There are still " + this.remainingFutures + " channel operations pending, waiting to complete");
                try {
                    this.enoughCompleted.await(1000L, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException ex) {
                    NettyClientServerCommunicationSystemClientSide.this.logger.error("Interruption while waiting on condition", (Throwable)ex);
                }
            }
            NettyClientServerCommunicationSystemClientSide.this.logger.debug("All channel operations completed or timed out");
            this.remainingFutures = n;
            this.futureLock.unlock();
        }
    }
}

