/*
 * Decompiled with CFR 0.152.
 */
package bftsmart.communication.client.netty;

import bftsmart.communication.client.netty.NettyClientServerSession;
import bftsmart.reconfiguration.ViewController;
import bftsmart.tom.core.messages.TOMMessage;
import bftsmart.tom.util.TOMUtil;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyTOMMessageDecoder
extends ByteToMessageDecoder {
    private Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private boolean isClient;
    private Map sessionTable;
    private ViewController controller;
    private boolean firstTime;
    private ReentrantReadWriteLock rl;
    private boolean useMAC;

    public NettyTOMMessageDecoder(boolean isClient, Map sessionTable, ViewController controller, ReentrantReadWriteLock rl, boolean useMAC) {
        this.isClient = isClient;
        this.sessionTable = sessionTable;
        this.controller = controller;
        this.firstTime = true;
        this.rl = rl;
        this.useMAC = useMAC;
        this.logger.debug("new NettyTOMMessageDecoder!!, isClient=" + isClient);
    }

    protected void decode(ChannelHandlerContext context, ByteBuf buffer, List<Object> list) throws Exception {
        if (buffer.readableBytes() < 4) {
            return;
        }
        int dataLength = buffer.getInt(buffer.readerIndex());
        if (buffer.readableBytes() < dataLength + 4) {
            return;
        }
        buffer.skipBytes(4);
        int size = buffer.readInt();
        byte[] data = new byte[size];
        buffer.readBytes(data);
        byte[] digest = null;
        if (this.useMAC) {
            size = buffer.readInt();
            digest = new byte[size];
            buffer.readBytes(digest);
        }
        byte[] signature = null;
        size = buffer.readInt();
        if (size > 0) {
            signature = new byte[size];
            buffer.readBytes(signature);
        }
        DataInputStream dis = null;
        TOMMessage sm = null;
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(data);
            dis = new DataInputStream(bais);
            sm = new TOMMessage();
            sm.rExternal(dis);
            sm.serializedMessage = data;
            if (signature != null) {
                sm.serializedMessageSignature = signature;
                sm.signed = true;
            }
            if (this.useMAC) {
                sm.serializedMessageMAC = digest;
            }
            if (this.isClient) {
                if (this.useMAC && !this.verifyMAC(sm.getSender(), data, digest)) {
                    this.logger.error("MAC error: message discarded");
                    return;
                }
            } else {
                this.rl.readLock().lock();
                if (this.sessionTable.containsKey(sm.getSender())) {
                    this.rl.readLock().unlock();
                    if (this.useMAC && !this.verifyMAC(sm.getSender(), data, digest)) {
                        this.logger.debug("MAC error: message discarded");
                        return;
                    }
                } else {
                    this.logger.debug("Creating MAC/public key stuff, first message from client" + sm.getSender());
                    this.logger.debug("sessionTable size=" + this.sessionTable.size());
                    this.rl.readLock().unlock();
                    SecretKeyFactory fac = TOMUtil.getSecretFactory();
                    String str = sm.getSender() + ":" + this.controller.getStaticConf().getProcessId();
                    PBEKeySpec spec = TOMUtil.generateKeySpec(str.toCharArray());
                    SecretKey authKey = fac.generateSecret(spec);
                    Mac macSend = TOMUtil.getMacFactory();
                    macSend.init(authKey);
                    Mac macReceive = TOMUtil.getMacFactory();
                    macReceive.init(authKey);
                    NettyClientServerSession cs = new NettyClientServerSession(context.channel(), macSend, macReceive, sm.getSender());
                    this.rl.writeLock().lock();
                    this.sessionTable.put(sm.getSender(), cs);
                    this.logger.debug("active clients " + this.sessionTable.size());
                    this.rl.writeLock().unlock();
                    if (this.useMAC && !this.verifyMAC(sm.getSender(), data, digest)) {
                        this.logger.debug("MAC error: message discarded");
                        return;
                    }
                }
            }
            this.logger.debug("Decoded reply from " + sm.getSender() + " with sequence number " + sm.getSequence());
            list.add(sm);
        }
        catch (Exception ex) {
            this.logger.error("Failed to decode TOMMessage", (Throwable)ex);
        }
    }

    boolean verifyMAC(int id, byte[] data, byte[] digest) {
        this.rl.readLock().lock();
        Mac macReceive = ((NettyClientServerSession)this.sessionTable.get(id)).getMacReceive();
        this.rl.readLock().unlock();
        boolean result = Arrays.equals(macReceive.doFinal(data), digest);
        return result;
    }
}

