/*
 * Decompiled with CFR 0.152.
 */
package bftsmart.communication.client.netty;

import bftsmart.communication.client.netty.NettyClientServerSession;
import bftsmart.tom.core.messages.TOMMessage;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToByteEncoder;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.crypto.Mac;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyTOMMessageEncoder
extends MessageToByteEncoder<TOMMessage> {
    private Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private boolean isClient;
    private Map sessionTable;
    private ReentrantReadWriteLock rl;
    private boolean useMAC;

    public NettyTOMMessageEncoder(boolean isClient, Map sessionTable, ReentrantReadWriteLock rl, boolean useMAC) {
        this.isClient = isClient;
        this.sessionTable = sessionTable;
        this.rl = rl;
        this.useMAC = useMAC;
    }

    protected void encode(ChannelHandlerContext context, TOMMessage sm, ByteBuf buffer) throws Exception {
        byte[] macData = null;
        byte[] signatureData = null;
        byte[] msgData = sm.serializedMessage;
        if (sm.signed) {
            signatureData = sm.serializedMessageSignature;
        }
        if (this.useMAC && (macData = this.produceMAC(sm.destination, msgData, sm.getSender())) == null) {
            this.logger.warn("Uses MAC and the returned MAC is null. Won't write to channel");
            return;
        }
        int dataLength = 4 + msgData.length + (this.useMAC ? macData.length + 4 : 0) + 4 + (signatureData != null ? signatureData.length : 0);
        buffer.writeInt(dataLength);
        buffer.writeInt(msgData.length);
        buffer.writeBytes(msgData);
        if (this.useMAC) {
            buffer.writeInt(macData.length);
            buffer.writeBytes(macData);
        }
        if (signatureData != null) {
            buffer.writeInt(signatureData.length);
            buffer.writeBytes(signatureData);
        } else {
            buffer.writeInt(0);
        }
        context.flush();
    }

    byte[] produceMAC(int id, byte[] data, int me) {
        NettyClientServerSession session = (NettyClientServerSession)this.sessionTable.get(id);
        if (session == null) {
            this.logger.warn("Session for client " + id + " is null");
            return null;
        }
        Mac macSend = session.getMacSend();
        return macSend.doFinal(data);
    }
}

