/*
 * Decompiled with CFR 0.152.
 */
package bftsmart.consensus;

import bftsmart.consensus.Decision;
import bftsmart.consensus.Epoch;
import bftsmart.consensus.TimestampValuePair;
import bftsmart.reconfiguration.ServerViewController;
import bftsmart.tom.core.ExecutionManager;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Consensus {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private ExecutionManager manager;
    private Decision decision;
    private HashMap<Integer, Epoch> epochs = new HashMap(2);
    private ReentrantLock epochsLock = new ReentrantLock();
    private ReentrantLock writeSetLock = new ReentrantLock();
    private boolean decided;
    private int decisionEpoch = -1;
    private int ets = 0;
    private TimestampValuePair quorumWrites = null;
    private HashSet<TimestampValuePair> writeSet = new HashSet();
    public ReentrantLock lock = new ReentrantLock();

    public Consensus(ExecutionManager manager, Decision decision) {
        this.manager = manager;
        this.decision = decision;
    }

    public int getId() {
        return this.decision.getConsensusId();
    }

    public ExecutionManager getManager() {
        return this.manager;
    }

    public Decision getDecision() {
        return this.decision;
    }

    public Epoch getEpoch(int timestamp, ServerViewController controller) {
        return this.getEpoch(timestamp, true, controller);
    }

    public Epoch getEpoch(int timestamp, boolean create, ServerViewController controller) {
        this.epochsLock.lock();
        Epoch epoch = this.epochs.get(timestamp);
        if (epoch == null && create) {
            epoch = new Epoch(controller, this, timestamp);
            this.epochs.put(timestamp, epoch);
        }
        this.epochsLock.unlock();
        return epoch;
    }

    public void incEts() {
        ++this.ets;
    }

    public void setETS(int ets) {
        if (ets > this.ets) {
            this.ets = ets;
        }
    }

    public int getEts() {
        return this.ets;
    }

    public void setQuorumWrites(byte[] value) {
        this.quorumWrites = new TimestampValuePair(this.ets, value);
    }

    public TimestampValuePair getQuorumWrites() {
        return this.quorumWrites;
    }

    public void addWritten(byte[] value) {
        this.writeSetLock.lock();
        this.writeSet.add(new TimestampValuePair(this.ets, value));
        this.writeSetLock.unlock();
    }

    public void removeWritten(byte[] value) {
        this.writeSetLock.lock();
        HashSet temp = (HashSet)this.writeSet.clone();
        for (TimestampValuePair rv : temp) {
            if (!Arrays.equals(rv.getValue(), value)) continue;
            this.writeSet.remove(rv);
        }
        this.writeSetLock.unlock();
    }

    public HashSet<TimestampValuePair> getWriteSet() {
        return (HashSet)this.writeSet.clone();
    }

    public Epoch createEpoch(int timestamp, ServerViewController recManager) {
        this.epochsLock.lock();
        Epoch epoch = new Epoch(recManager, this, timestamp);
        this.epochs.put(timestamp, epoch);
        this.epochsLock.unlock();
        return epoch;
    }

    public Epoch createEpoch(ServerViewController recManager) {
        this.epochsLock.lock();
        Set<Integer> keys = this.epochs.keySet();
        int max = -1;
        for (int k : keys) {
            if (k <= max) continue;
            max = k;
        }
        Epoch epoch = new Epoch(recManager, this, ++max);
        this.epochs.put(max, epoch);
        this.epochsLock.unlock();
        return epoch;
    }

    public void removeEpochs(int limit) {
        this.epochsLock.lock();
        for (Integer key : this.epochs.keySet().toArray(new Integer[0])) {
            if (key <= limit) continue;
            Epoch epoch = this.epochs.remove(key);
            epoch.setRemoved();
        }
        this.epochsLock.unlock();
    }

    public Epoch getDecisionEpoch() {
        this.epochsLock.lock();
        Epoch e = this.epochs.get(this.decisionEpoch);
        this.epochsLock.unlock();
        return e;
    }

    public Epoch getLastEpoch() {
        this.epochsLock.lock();
        if (this.epochs.isEmpty()) {
            this.epochsLock.unlock();
            return null;
        }
        Epoch epoch = this.epochs.get(this.ets);
        this.epochsLock.unlock();
        return epoch;
    }

    public boolean isDecided() {
        return this.decided;
    }

    public void decided(Epoch epoch, boolean deliver) {
        if (!this.decided) {
            this.decided = true;
            this.decisionEpoch = epoch.getTimestamp();
            this.decision.setDecisionEpoch(epoch);
            if (deliver) {
                this.logger.debug("Delivering decision from consensus " + this.getId() + " to the TOMLayer/DeliveryThread");
                this.manager.getTOMLayer().decided(this.decision);
            }
        }
    }
}

