/*
 * Decompiled with CFR 0.152.
 */
package bftsmart.consensus;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.math.BigInteger;
import java.util.Arrays;
import org.apache.commons.codec.binary.Base64;

public class TimestampValuePair
implements Externalizable {
    private int timestamp;
    private byte[] value;
    private byte[] hashedValue;

    public TimestampValuePair(int timestamp, byte[] value) {
        this.timestamp = timestamp;
        this.value = value;
        this.hashedValue = new byte[0];
    }

    public TimestampValuePair() {
        this.timestamp = -1;
        this.value = new byte[0];
        this.hashedValue = new byte[0];
    }

    public void setHashedValue(byte[] hashedValue) {
        this.hashedValue = hashedValue;
    }

    public byte[] getHashedValue() {
        return this.hashedValue;
    }

    public int getTimestamp() {
        return this.timestamp;
    }

    public byte[] getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (o instanceof TimestampValuePair) {
            return ((TimestampValuePair)o).timestamp == this.timestamp && Arrays.equals(((TimestampValuePair)o).value, this.value);
        }
        return false;
    }

    public int hashCode() {
        int hash = 1;
        hash = hash * 17 + this.timestamp;
        hash = hash * 31 + new BigInteger(this.value).intValue();
        return hash;
    }

    public String toString() {
        if (this.value == null || this.value.length == 0) {
            return this.timestamp + " :: []";
        }
        return this.timestamp + " :: " + (this.hashedValue != null && this.hashedValue.length > 0 ? this.str(this.hashedValue) : this.str(this.value));
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.timestamp);
        out.writeObject(this.value);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.timestamp = in.readInt();
        this.value = (byte[])in.readObject();
    }

    private String str(byte[] obj) {
        if (obj == null) {
            return "null";
        }
        return Base64.encodeBase64String((byte[])obj);
    }
}

