/*
 * Decompiled with CFR 0.152.
 */
package bftsmart.demo.map;

import bftsmart.demo.map.MapRequestType;
import bftsmart.tom.MessageContext;
import bftsmart.tom.ServiceReplica;
import bftsmart.tom.server.defaultservices.DefaultSingleRecoverable;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MapServer<K, V>
extends DefaultSingleRecoverable {
    private Map<K, V> replicaMap = new TreeMap();
    private Logger logger = Logger.getLogger(MapServer.class.getName());

    public MapServer(int id) {
        new ServiceReplica(id, this, this);
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            System.out.println("Usage: demo.map.MapServer <server id>");
            System.exit(-1);
        }
        new MapServer(Integer.parseInt(args[0]));
    }

    @Override
    public byte[] appExecuteOrdered(byte[] command, MessageContext msgCtx) {
        byte[] reply = null;
        Object key = null;
        Object value = null;
        boolean hasReply = false;
        try (ByteArrayInputStream byteIn = new ByteArrayInputStream(command);
             ObjectInputStream objIn = new ObjectInputStream(byteIn);
             ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
             ObjectOutputStream objOut = new ObjectOutputStream(byteOut);){
            MapRequestType reqType = (MapRequestType)((Object)objIn.readObject());
            switch (reqType) {
                case PUT: {
                    key = objIn.readObject();
                    value = objIn.readObject();
                    Object oldValue = this.replicaMap.put(key, value);
                    if (oldValue == null) break;
                    objOut.writeObject(oldValue);
                    hasReply = true;
                    break;
                }
                case GET: {
                    key = objIn.readObject();
                    value = this.replicaMap.get(key);
                    if (value == null) break;
                    objOut.writeObject(value);
                    hasReply = true;
                    break;
                }
                case REMOVE: {
                    key = objIn.readObject();
                    value = this.replicaMap.remove(key);
                    if (value == null) break;
                    objOut.writeObject(value);
                    hasReply = true;
                    break;
                }
                case SIZE: {
                    int size = this.replicaMap.size();
                    objOut.writeInt(size);
                    hasReply = true;
                    break;
                }
                case KEYSET: {
                    this.keySet(objOut);
                    hasReply = true;
                }
            }
            if (hasReply) {
                objOut.flush();
                byteOut.flush();
                reply = byteOut.toByteArray();
            } else {
                reply = new byte[]{};
            }
        }
        catch (IOException | ClassNotFoundException e) {
            this.logger.log(Level.SEVERE, "Ocurred during map operation execution", e);
        }
        return reply;
    }

    @Override
    public byte[] appExecuteUnordered(byte[] command, MessageContext msgCtx) {
        byte[] reply = null;
        Object key = null;
        Object value = null;
        boolean hasReply = false;
        try (ByteArrayInputStream byteIn = new ByteArrayInputStream(command);
             ObjectInputStream objIn = new ObjectInputStream(byteIn);
             ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
             ObjectOutputStream objOut = new ObjectOutputStream(byteOut);){
            MapRequestType reqType = (MapRequestType)((Object)objIn.readObject());
            switch (reqType) {
                case GET: {
                    key = objIn.readObject();
                    value = this.replicaMap.get(key);
                    if (value == null) break;
                    objOut.writeObject(value);
                    hasReply = true;
                    break;
                }
                case SIZE: {
                    int size = this.replicaMap.size();
                    objOut.writeInt(size);
                    hasReply = true;
                    break;
                }
                case KEYSET: {
                    this.keySet(objOut);
                    hasReply = true;
                    break;
                }
                default: {
                    this.logger.log(Level.WARNING, "in appExecuteUnordered only read operations are supported");
                }
            }
            if (hasReply) {
                objOut.flush();
                byteOut.flush();
                reply = byteOut.toByteArray();
            } else {
                reply = new byte[]{};
            }
        }
        catch (IOException | ClassNotFoundException e) {
            this.logger.log(Level.SEVERE, "Ocurred during map operation execution", e);
        }
        return reply;
    }

    private void keySet(ObjectOutput out) throws IOException, ClassNotFoundException {
        Set<K> keySet = this.replicaMap.keySet();
        int size = this.replicaMap.size();
        out.writeInt(size);
        for (K key : keySet) {
            out.writeObject(key);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public byte[] getSnapshot() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void installSnapshot(byte[] state) {
        try (ByteArrayInputStream byteIn = new ByteArrayInputStream(state);
             ObjectInputStream objIn = new ObjectInputStream(byteIn);){
            this.replicaMap = (Map)objIn.readObject();
        }
        catch (IOException | ClassNotFoundException e) {
            this.logger.log(Level.SEVERE, "Error while installing snapshot", e);
        }
    }
}

