/*
 * Decompiled with CFR 0.152.
 */
package bftsmart.demo.microbenchmarks;

import bftsmart.communication.client.ReplyListener;
import bftsmart.tom.AsynchServiceProxy;
import bftsmart.tom.RequestContext;
import bftsmart.tom.core.messages.TOMMessage;
import bftsmart.tom.core.messages.TOMMessageType;
import bftsmart.tom.util.Storage;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class AsyncLatencyClient {
    static int initId;

    public static void main(String[] args) throws IOException {
        if (args.length < 7) {
            System.out.println("Usage: java ...AsyncLatencyClient <initial client id> <number of clients> <number of operations> <request size> <interval (ms)> <read only?> <verbose?>");
            System.exit(-1);
        }
        initId = Integer.parseInt(args[0]);
        int numThreads = Integer.parseInt(args[1]);
        int numberOfOps = Integer.parseInt(args[2]);
        int requestSize = Integer.parseInt(args[3]);
        int interval = Integer.parseInt(args[4]);
        boolean readOnly = Boolean.parseBoolean(args[5]);
        boolean verbose = Boolean.parseBoolean(args[6]);
        Client[] clients = new Client[numThreads];
        for (int i = 0; i < numThreads; ++i) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
            System.out.println("Launching client " + (initId + i));
            clients[i] = new Client(initId + i, numberOfOps, requestSize, interval, readOnly, verbose);
        }
        ExecutorService exec = Executors.newFixedThreadPool(clients.length);
        LinkedList tasks = new LinkedList();
        for (Client c : clients) {
            tasks.add(exec.submit(c));
        }
        for (Future future : tasks) {
            try {
                future.get();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        exec.shutdown();
        System.out.println("All clients done.");
    }

    static class Client
    extends Thread {
        int id;
        AsynchServiceProxy serviceProxy;
        int numberOfOps;
        int interval;
        byte[] request;
        TOMMessageType reqType;
        boolean verbose;

        public Client(int id, int numberOfOps, int requestSize, int interval, boolean readOnly, boolean verbose) {
            this.id = id;
            this.serviceProxy = new AsynchServiceProxy(id);
            this.numberOfOps = numberOfOps;
            this.interval = interval;
            this.request = new byte[requestSize];
            this.reqType = readOnly ? TOMMessageType.UNORDERED_REQUEST : TOMMessageType.ORDERED_REQUEST;
            this.verbose = verbose;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                Storage st = new Storage(this.numberOfOps / 2);
                if (this.verbose) {
                    System.out.println("Executing experiment for " + this.numberOfOps + " ops");
                }
                for (int i = 0; i < this.numberOfOps; ++i) {
                    long last_send_instant = System.nanoTime();
                    this.serviceProxy.invokeAsynchRequest(this.request, new ReplyListener(){
                        private int replies = 0;

                        @Override
                        public void reset() {
                            if (verbose) {
                                System.out.println("[RequestContext] The proxy is re-issuing the request to the replicas");
                            }
                            this.replies = 0;
                        }

                        @Override
                        public void replyReceived(RequestContext context, TOMMessage reply) {
                            StringBuilder builder = new StringBuilder();
                            builder.append("[RequestContext] id: " + context.getReqId() + " type: " + (Object)((Object)context.getRequestType()));
                            builder.append("[TOMMessage reply] sender id: " + reply.getSender() + " Hash content: " + Arrays.toString(reply.getContent()));
                            if (verbose) {
                                System.out.println(builder.toString());
                            }
                            ++this.replies;
                            double q = Math.ceil((double)(serviceProxy.getViewManager().getCurrentViewN() + serviceProxy.getViewManager().getCurrentViewF() + 1) / 2.0);
                            if ((double)this.replies >= q) {
                                if (verbose) {
                                    System.out.println("[RequestContext] clean request context id: " + context.getReqId());
                                }
                                serviceProxy.cleanAsynchRequest(context.getOperationId());
                            }
                        }
                    }, this.reqType);
                    if (i > this.numberOfOps / 2) {
                        st.store(System.nanoTime() - last_send_instant);
                    }
                    if (this.interval > 0) {
                        Thread.sleep(this.interval);
                    }
                    if (!this.verbose) continue;
                    System.out.println("Sending " + (i + 1) + "th op");
                }
                Thread.sleep(100L);
                if (this.id == initId) {
                    System.out.println(this.id + " // Average time for " + this.numberOfOps / 2 + " executions (-10%) = " + st.getAverage(true) / 1000.0 + " us ");
                    System.out.println(this.id + " // Standard desviation for " + this.numberOfOps / 2 + " executions (-10%) = " + st.getDP(true) / 1000.0 + " us ");
                    System.out.println(this.id + " // Average time for " + this.numberOfOps / 2 + " executions (all samples) = " + st.getAverage(false) / 1000.0 + " us ");
                    System.out.println(this.id + " // Standard desviation for " + this.numberOfOps / 2 + " executions (all samples) = " + st.getDP(false) / 1000.0 + " us ");
                    System.out.println(this.id + " // Maximum time for " + this.numberOfOps / 2 + " executions (all samples) = " + st.getMax(false) / 1000L + " us ");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                this.serviceProxy.close();
            }
        }
    }
}

