/*
 * Decompiled with CFR 0.152.
 */
package bftsmart.demo.ycsb;

import bftsmart.demo.ycsb.YCSBMessage;
import bftsmart.tom.ServiceProxy;
import com.yahoo.ycsb.ByteIterator;
import com.yahoo.ycsb.DB;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicInteger;

public class YCSBClient
extends DB {
    private static AtomicInteger counter = new AtomicInteger();
    private ServiceProxy proxy = null;
    private int myId;

    public void init() {
        Properties props = this.getProperties();
        int initId = Integer.valueOf((String)props.get("smart-initkey"));
        this.myId = initId + counter.addAndGet(1);
        this.proxy = new ServiceProxy(this.myId);
        System.out.println("YCSBKVClient. Initiated client id: " + this.myId);
    }

    public int delete(String arg0, String arg1) {
        throw new UnsupportedOperationException();
    }

    public int insert(String table, String key, HashMap<String, ByteIterator> values) {
        Iterator<String> keys = values.keySet().iterator();
        HashMap<String, byte[]> map = new HashMap<String, byte[]>();
        while (keys.hasNext()) {
            String field = keys.next();
            map.put(field, values.get(field).toArray());
        }
        YCSBMessage msg = YCSBMessage.newInsertRequest(table, key, map);
        byte[] reply = this.proxy.invokeOrdered(msg.getBytes());
        YCSBMessage replyMsg = YCSBMessage.getObject(reply);
        return replyMsg.getResult();
    }

    public int read(String table, String key, Set<String> fields, HashMap<String, ByteIterator> result) {
        HashMap<String, byte[]> results = new HashMap<String, byte[]>();
        YCSBMessage request = YCSBMessage.newReadRequest(table, key, fields, results);
        byte[] reply = this.proxy.invokeUnordered(request.getBytes());
        YCSBMessage replyMsg = YCSBMessage.getObject(reply);
        return replyMsg.getResult();
    }

    public int scan(String arg0, String arg1, int arg2, Set<String> arg3, Vector<HashMap<String, ByteIterator>> arg4) {
        throw new UnsupportedOperationException();
    }

    public int update(String table, String key, HashMap<String, ByteIterator> values) {
        Iterator<String> keys = values.keySet().iterator();
        HashMap<String, byte[]> map = new HashMap<String, byte[]>();
        while (keys.hasNext()) {
            String field = keys.next();
            map.put(field, values.get(field).toArray());
        }
        YCSBMessage msg = YCSBMessage.newUpdateRequest(table, key, map);
        byte[] reply = this.proxy.invokeOrdered(msg.getBytes());
        YCSBMessage replyMsg = YCSBMessage.getObject(reply);
        return replyMsg.getResult();
    }
}

