/*
 * Decompiled with CFR 0.152.
 */
package bftsmart.demo.ycsb;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Set;

public class YCSBMessage
implements Serializable {
    private static final long serialVersionUID = 6198684730704708506L;
    private Type type;
    private Entity entity;
    private String table;
    private String key;
    private Set<String> fields;
    private HashMap<String, byte[]> values;
    private int result = -1;
    private HashMap<String, byte[]> results;
    private String errorMsg;

    private YCSBMessage() {
    }

    public static YCSBMessage newInsertRequest(String table, String key, HashMap<String, byte[]> values) {
        YCSBMessage message = new YCSBMessage();
        message.type = Type.CREATE;
        message.entity = Entity.RECORD;
        message.table = table;
        message.key = key;
        message.values = values;
        return message;
    }

    public static YCSBMessage newUpdateRequest(String table, String key, HashMap<String, byte[]> values) {
        YCSBMessage message = new YCSBMessage();
        message.type = Type.UPDATE;
        message.entity = Entity.RECORD;
        message.table = table;
        message.key = key;
        message.values = values;
        return message;
    }

    public static YCSBMessage newReadRequest(String table, String key, Set<String> fields, HashMap<String, byte[]> results) {
        YCSBMessage message = new YCSBMessage();
        message.type = Type.READ;
        message.entity = Entity.RECORD;
        message.table = table;
        message.key = key;
        message.fields = fields;
        message.results = results;
        return message;
    }

    public static YCSBMessage newInsertResponse(int result) {
        YCSBMessage message = new YCSBMessage();
        message.result = result;
        return message;
    }

    public static YCSBMessage newUpdateResponse(int result) {
        YCSBMessage message = new YCSBMessage();
        message.result = result;
        return message;
    }

    public static YCSBMessage newReadResponse(HashMap<String, byte[]> results, int result) {
        YCSBMessage message = new YCSBMessage();
        message.result = result;
        message.results = results;
        return message;
    }

    public static YCSBMessage newErrorMessage(String errorMsg) {
        YCSBMessage message = new YCSBMessage();
        message.errorMsg = errorMsg;
        return message;
    }

    public byte[] getBytes() {
        try {
            byte[] aArray = null;
            ByteArrayOutputStream aBaos = new ByteArrayOutputStream();
            ObjectOutputStream aOos = new ObjectOutputStream(aBaos);
            aOos.writeObject(this);
            aOos.flush();
            aBaos.flush();
            aArray = aBaos.toByteArray();
            aOos.close();
            aBaos.close();
            return aArray;
        }
        catch (IOException ex) {
            return null;
        }
    }

    public static YCSBMessage getObject(byte[] theBytes) {
        try {
            ByteArrayInputStream aBais = new ByteArrayInputStream(theBytes);
            ObjectInputStream aOis = new ObjectInputStream(aBais);
            YCSBMessage aMessage = (YCSBMessage)aOis.readObject();
            aOis.close();
            aBais.close();
            return aMessage;
        }
        catch (IOException | ClassNotFoundException ex) {
            return null;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(").append((Object)this.type).append(",").append((Object)this.entity).append(",");
        sb.append(this.table).append(",").append(this.key).append(",").append(this.values).append(")");
        return sb.toString();
    }

    public int getResult() {
        return this.result;
    }

    public HashMap<String, byte[]> getResults() {
        return this.results;
    }

    public Type getType() {
        return this.type;
    }

    public Entity getEntity() {
        return this.entity;
    }

    public String getTable() {
        return this.table;
    }

    public String getKey() {
        return this.key;
    }

    public Set<String> getFields() {
        return this.fields;
    }

    public HashMap<String, byte[]> getValues() {
        return this.values;
    }

    public String getErrorMsg() {
        return this.errorMsg;
    }

    public static enum Entity {
        TABLE,
        RECORD,
        FIELD;

    }

    public static enum Type {
        CREATE,
        READ,
        SCAN,
        UPDATE,
        DELETE,
        SIZE,
        ERROR;

    }
}

