/*
 * Decompiled with CFR 0.152.
 */
package bftsmart.reconfiguration;

import bftsmart.reconfiguration.ReconfigureReply;
import bftsmart.reconfiguration.ReconfigureRequest;
import bftsmart.reconfiguration.ViewController;
import bftsmart.reconfiguration.views.View;
import bftsmart.tom.core.TOMLayer;
import bftsmart.tom.core.messages.TOMMessage;
import bftsmart.tom.util.KeyLoader;
import bftsmart.tom.util.TOMUtil;
import java.net.InetSocketAddress;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerViewController
extends ViewController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final int ADD_SERVER = 0;
    public static final int REMOVE_SERVER = 1;
    public static final int CHANGE_F = 2;
    private int quorumBFT;
    private int quorumCFT;
    private int[] otherProcesses;
    private int[] lastJoinStet;
    private List<TOMMessage> updates = new LinkedList<TOMMessage>();
    private TOMLayer tomLayer;

    public ServerViewController(int procId, KeyLoader loader) {
        this(procId, "", loader);
    }

    public ServerViewController(int procId, String configHome, KeyLoader loader) {
        super(procId, configHome, loader);
        View cv = this.getViewStore().readView();
        if (cv == null) {
            this.logger.info("Creating current view from configuration file");
            this.reconfigureTo(new View(0, this.getStaticConf().getInitialView(), this.getStaticConf().getF(), this.getInitAdddresses()));
        } else {
            this.logger.info("Using view stored on disk");
            this.reconfigureTo(cv);
        }
    }

    private InetSocketAddress[] getInitAdddresses() {
        int[] nextV = this.getStaticConf().getInitialView();
        InetSocketAddress[] addresses = new InetSocketAddress[nextV.length];
        for (int i = 0; i < nextV.length; ++i) {
            addresses[i] = this.getStaticConf().getRemoteAddress(nextV[i]);
        }
        return addresses;
    }

    public void setTomLayer(TOMLayer tomLayer) {
        this.tomLayer = tomLayer;
    }

    public boolean isInCurrentView() {
        return this.currentView.isMember(this.getStaticConf().getProcessId());
    }

    public int[] getCurrentViewOtherAcceptors() {
        return this.otherProcesses;
    }

    public int[] getCurrentViewAcceptors() {
        return this.currentView.getProcesses();
    }

    public boolean hasUpdates() {
        return !this.updates.isEmpty();
    }

    public void enqueueUpdate(TOMMessage up) {
        ReconfigureRequest request = (ReconfigureRequest)TOMUtil.getObject(up.getContent());
        if (TOMUtil.verifySignature(this.getStaticConf().getPublicKey(request.getSender()), request.toString().getBytes(), request.getSignature())) {
            if (request.getSender() == this.getStaticConf().getTTPId()) {
                this.updates.add(up);
            } else {
                boolean add = true;
                for (int key : request.getProperties().keySet()) {
                    String value = request.getProperties().get(key);
                    if (key == 0) {
                        StringTokenizer str = new StringTokenizer(value, ":");
                        if (str.countTokens() > 2) {
                            int id = Integer.parseInt(str.nextToken());
                            if (id == request.getSender()) continue;
                            add = false;
                            continue;
                        }
                        add = false;
                        continue;
                    }
                    if (key == 1) {
                        if (this.isCurrentViewMember(Integer.parseInt(value))) {
                            if (Integer.parseInt(value) == request.getSender()) continue;
                            add = false;
                            continue;
                        }
                        add = false;
                        continue;
                    }
                    if (key != 2) continue;
                    add = false;
                }
                if (add) {
                    this.updates.add(up);
                }
            }
        }
    }

    public byte[] executeUpdates(int cid) {
        LinkedList<Integer> jSet = new LinkedList<Integer>();
        LinkedList<Integer> rSet = new LinkedList<Integer>();
        int f = -1;
        LinkedList<String> jSetInfo = new LinkedList<String>();
        for (int i = 0; i < this.updates.size(); ++i) {
            ReconfigureRequest request = (ReconfigureRequest)TOMUtil.getObject(this.updates.get(i).getContent());
            for (int key : request.getProperties().keySet()) {
                String value = request.getProperties().get(key);
                if (key == 0) {
                    int id;
                    StringTokenizer str = new StringTokenizer(value, ":");
                    if (str.countTokens() <= 2 || this.isCurrentViewMember(id = Integer.parseInt(str.nextToken())) || this.contains(id, jSet)) continue;
                    jSetInfo.add(value);
                    jSet.add(id);
                    String host = str.nextToken();
                    int port = Integer.valueOf(str.nextToken());
                    this.getStaticConf().addHostInfo(id, host, port);
                    continue;
                }
                if (key == 1) {
                    if (!this.isCurrentViewMember(Integer.parseInt(value))) continue;
                    rSet.add(Integer.parseInt(value));
                    continue;
                }
                if (key != 2) continue;
                f = Integer.parseInt(value);
            }
        }
        return this.reconfigure(jSetInfo, jSet, rSet, f, cid);
    }

    private boolean contains(int id, List<Integer> list) {
        for (int i = 0; i < list.size(); ++i) {
            if (list.get(i) != id) continue;
            return true;
        }
        return false;
    }

    private byte[] reconfigure(List<String> jSetInfo, List<Integer> jSet, List<Integer> rSet, int f, int cid) {
        int i;
        this.lastJoinStet = new int[jSet.size()];
        int[] nextV = new int[this.currentView.getN() + jSet.size() - rSet.size()];
        int p = 0;
        boolean forceLC = false;
        for (i = 0; i < jSet.size(); ++i) {
            this.lastJoinStet[i] = jSet.get(i);
            nextV[p++] = jSet.get(i);
        }
        for (i = 0; i < this.currentView.getProcesses().length; ++i) {
            if (!this.contains(this.currentView.getProcesses()[i], rSet)) {
                nextV[p++] = this.currentView.getProcesses()[i];
                continue;
            }
            if (this.tomLayer.execManager.getCurrentLeader() != this.currentView.getProcesses()[i]) continue;
            forceLC = true;
        }
        if (f < 0) {
            f = this.currentView.getF();
        }
        InetSocketAddress[] addresses = new InetSocketAddress[nextV.length];
        for (int i2 = 0; i2 < nextV.length; ++i2) {
            addresses[i2] = this.getStaticConf().getRemoteAddress(nextV[i2]);
        }
        View newV = new View(this.currentView.getId() + 1, nextV, f, addresses);
        this.logger.info("New view: " + newV);
        this.logger.info("Installed on CID: " + cid);
        this.logger.info("lastJoinSet: " + jSet);
        this.reconfigureTo(newV);
        if (forceLC) {
            this.logger.info("Shortening LC timeout");
            this.tomLayer.requestsTimer.stopTimer();
            this.tomLayer.requestsTimer.setShortTimeout(3000L);
            this.tomLayer.requestsTimer.startTimer();
        }
        return TOMUtil.getBytes(new ReconfigureReply(newV, jSetInfo.toArray(new String[0]), cid, this.tomLayer.execManager.getCurrentLeader()));
    }

    public TOMMessage[] clearUpdates() {
        TOMMessage[] ret = new TOMMessage[this.updates.size()];
        for (int i = 0; i < this.updates.size(); ++i) {
            ret[i] = this.updates.get(i);
        }
        this.updates.clear();
        return ret;
    }

    public boolean isInLastJoinSet(int id) {
        if (this.lastJoinStet != null) {
            for (int i = 0; i < this.lastJoinStet.length; ++i) {
                if (this.lastJoinStet[i] != id) continue;
                return true;
            }
        }
        return false;
    }

    public void processJoinResult(ReconfigureReply r) {
        this.reconfigureTo(r.getView());
        String[] s = r.getJoinSet();
        this.lastJoinStet = new int[s.length];
        for (int i = 0; i < s.length; ++i) {
            int id;
            StringTokenizer str = new StringTokenizer(s[i], ":");
            this.lastJoinStet[i] = id = Integer.parseInt(str.nextToken());
            String host = str.nextToken();
            int port = Integer.valueOf(str.nextToken());
            this.getStaticConf().addHostInfo(id, host, port);
        }
    }

    @Override
    public final void reconfigureTo(View newView) {
        this.currentView = newView;
        this.getViewStore().storeView(this.currentView);
        if (newView.isMember(this.getStaticConf().getProcessId())) {
            this.otherProcesses = new int[this.currentView.getProcesses().length - 1];
            int c = 0;
            for (int i = 0; i < this.currentView.getProcesses().length; ++i) {
                if (this.currentView.getProcesses()[i] == this.getStaticConf().getProcessId()) continue;
                this.otherProcesses[c++] = this.currentView.getProcesses()[i];
            }
            this.quorumBFT = (int)Math.ceil((this.currentView.getN() + this.currentView.getF()) / 2);
            this.quorumCFT = (int)Math.ceil(this.currentView.getN() / 2);
        } else if (this.currentView == null || this.currentView.isMember(this.getStaticConf().getProcessId())) {
            // empty if block
        }
    }

    public int getQuorum() {
        return this.getStaticConf().isBFT() ? this.quorumBFT : this.quorumCFT;
    }
}

