/*
 * Decompiled with CFR 0.152.
 */
package bftsmart.statemanagement.strategy;

import bftsmart.consensus.Consensus;
import bftsmart.consensus.Epoch;
import bftsmart.consensus.messages.ConsensusMessage;
import bftsmart.reconfiguration.views.View;
import bftsmart.statemanagement.ApplicationState;
import bftsmart.statemanagement.SMMessage;
import bftsmart.statemanagement.strategy.BaseStateManager;
import bftsmart.statemanagement.strategy.StandardSMMessage;
import bftsmart.tom.core.DeliveryThread;
import bftsmart.tom.core.ExecutionManager;
import bftsmart.tom.core.TOMLayer;
import bftsmart.tom.leaderchange.CertifiedDecision;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Queue;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardStateManager
extends BaseStateManager {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private int replica;
    private ReentrantLock lockTimer = new ReentrantLock();
    private Timer stateTimer = null;
    private static final long INIT_TIMEOUT = 40000L;
    private long timeout = 40000L;
    private ExecutionManager execManager;

    @Override
    public void init(TOMLayer tomLayer, DeliveryThread dt) {
        this.SVController = tomLayer.controller;
        this.tomLayer = tomLayer;
        this.dt = dt;
        this.execManager = tomLayer.execManager;
        this.changeReplica();
        this.state = null;
        this.lastCID = -1;
        this.waitingCID = -1;
        this.appStateOnly = false;
    }

    private void changeReplica() {
        int[] processes = this.SVController.getCurrentViewOtherAcceptors();
        Random r = new Random();
        do {
            if (processes == null || processes.length <= 1) {
                this.replica = 0;
                break;
            }
            int pos = r.nextInt(processes.length);
            this.replica = processes[pos];
        } while (this.replica == this.SVController.getStaticConf().getProcessId());
    }

    @Override
    protected void requestState() {
        if (this.tomLayer.requestsTimer != null) {
            this.tomLayer.requestsTimer.clearAll();
        }
        this.changeReplica();
        StandardSMMessage smsg = new StandardSMMessage(this.SVController.getStaticConf().getProcessId(), this.waitingCID, 6, this.replica, null, null, -1, -1);
        this.tomLayer.getCommunication().send(this.SVController.getCurrentViewOtherAcceptors(), smsg);
        this.logger.info("I just sent a request to the other replicas for the state up to CID " + this.waitingCID);
        TimerTask stateTask = new TimerTask(){

            @Override
            public void run() {
                StandardStateManager.this.logger.info("Timeout to retrieve state");
                int[] myself = new int[]{StandardStateManager.this.SVController.getStaticConf().getProcessId()};
                StandardStateManager.this.tomLayer.getCommunication().send(myself, new StandardSMMessage(-1, StandardStateManager.this.waitingCID, 9, -1, null, null, -1, -1));
            }
        };
        this.stateTimer = new Timer("state timer");
        this.timeout *= 2L;
        this.stateTimer.schedule(stateTask, this.timeout);
    }

    @Override
    public void stateTimeout() {
        this.lockTimer.lock();
        this.logger.debug("Timeout for the replica that was supposed to send the complete state. Changing desired replica.");
        if (this.stateTimer != null) {
            this.stateTimer.cancel();
        }
        this.changeReplica();
        this.reset();
        this.requestState();
        this.lockTimer.unlock();
    }

    @Override
    public void SMRequestDeliver(SMMessage msg, boolean isBFT) {
        if (this.SVController.getStaticConf().isStateTransferEnabled() && this.dt.getRecoverer() != null) {
            StandardSMMessage stdMsg = (StandardSMMessage)msg;
            boolean sendState = stdMsg.getReplica() == this.SVController.getStaticConf().getProcessId();
            ApplicationState thisState = this.dt.getRecoverer().getState(msg.getCID(), sendState);
            if (thisState == null) {
                this.logger.warn("For some reason, I am sending a void state");
                thisState = this.dt.getRecoverer().getState(-1, sendState);
            }
            int[] targets = new int[]{msg.getSender()};
            StandardSMMessage smsg = new StandardSMMessage(this.SVController.getStaticConf().getProcessId(), msg.getCID(), 7, -1, thisState, this.SVController.getCurrentView(), this.tomLayer.getSynchronizer().getLCManager().getLastReg(), this.tomLayer.execManager.getCurrentLeader());
            this.logger.info("Sending state...");
            this.tomLayer.getCommunication().send(targets, smsg);
            this.logger.info("Sent");
        }
    }

    @Override
    public void SMReplyDeliver(SMMessage msg, boolean isBFT) {
        this.lockTimer.lock();
        if (this.SVController.getStaticConf().isStateTransferEnabled() && this.waitingCID != -1 && msg.getCID() == this.waitingCID) {
            int currentRegency = -1;
            int currentLeader = -1;
            View currentView = null;
            CertifiedDecision currentProof = null;
            if (!this.appStateOnly) {
                this.senderRegencies.put(msg.getSender(), msg.getRegency());
                this.senderLeaders.put(msg.getSender(), msg.getLeader());
                this.senderViews.put(msg.getSender(), msg.getView());
                this.senderProofs.put(msg.getSender(), msg.getState().getCertifiedDecision(this.SVController));
                if (this.enoughRegencies(msg.getRegency())) {
                    currentRegency = msg.getRegency();
                }
                if (this.enoughLeaders(msg.getLeader())) {
                    currentLeader = msg.getLeader();
                }
                if (this.enoughViews(msg.getView())) {
                    currentView = msg.getView();
                }
                if (this.enoughProofs(this.waitingCID, this.tomLayer.getSynchronizer().getLCManager())) {
                    currentProof = msg.getState().getCertifiedDecision(this.SVController);
                }
            } else {
                currentLeader = this.tomLayer.execManager.getCurrentLeader();
                currentRegency = this.tomLayer.getSynchronizer().getLCManager().getLastReg();
                currentView = this.SVController.getCurrentView();
            }
            if (msg.getSender() == this.replica && msg.getState().getSerializedState() != null) {
                this.logger.debug("Expected replica sent state. Setting it to state");
                this.state = msg.getState();
                if (this.stateTimer != null) {
                    this.stateTimer.cancel();
                }
            }
            this.senderStates.put(msg.getSender(), msg.getState());
            this.logger.debug("Verifying more than F replies");
            if (this.enoughReplies()) {
                this.logger.debug("More than F confirmed");
                ApplicationState otherReplicaState = this.getOtherReplicaState();
                int haveState = 0;
                if (this.state != null) {
                    byte[] hash = null;
                    hash = this.tomLayer.computeHash(this.state.getSerializedState());
                    if (otherReplicaState != null) {
                        if (Arrays.equals(hash, otherReplicaState.getStateHash())) {
                            haveState = 1;
                        } else if (this.getNumEqualStates() > this.SVController.getCurrentViewF()) {
                            haveState = -1;
                        }
                    }
                }
                if (otherReplicaState != null && haveState == 1 && currentRegency > -1 && currentLeader > -1 && currentView != null && (!isBFT || currentProof != null || this.appStateOnly)) {
                    this.logger.info("Received state. Will install it");
                    this.tomLayer.getSynchronizer().getLCManager().setLastReg(currentRegency);
                    this.tomLayer.getSynchronizer().getLCManager().setNextReg(currentRegency);
                    this.tomLayer.getSynchronizer().getLCManager().setNewLeader(currentLeader);
                    this.tomLayer.execManager.setNewLeader(currentLeader);
                    if (currentProof != null && !this.appStateOnly) {
                        this.logger.debug("Installing proof for consensus " + this.waitingCID);
                        Consensus cons = this.execManager.getConsensus(this.waitingCID);
                        Epoch e = null;
                        for (ConsensusMessage cm : currentProof.getConsMessages()) {
                            e = cons.getEpoch(cm.getEpoch(), true, this.SVController);
                            if (e.getTimestamp() != cm.getEpoch()) {
                                this.logger.warn("Strange... proof contains messages from more than just one epoch");
                                e = cons.getEpoch(cm.getEpoch(), true, this.SVController);
                            }
                            e.addToProof(cm);
                            if (cm.getType() == 44783) {
                                e.setAccept(cm.getSender(), cm.getValue());
                                continue;
                            }
                            if (cm.getType() != 44782) continue;
                            e.setWrite(cm.getSender(), cm.getValue());
                        }
                        if (e != null) {
                            byte[] hash = this.tomLayer.computeHash(currentProof.getDecision());
                            e.propValueHash = hash;
                            e.propValue = currentProof.getDecision();
                            e.deserializedPropValue = this.tomLayer.checkProposedValue(currentProof.getDecision(), false);
                            cons.decided(e, false);
                            this.logger.info("Successfully installed proof for consensus " + this.waitingCID);
                        } else {
                            this.logger.error("Failed to install proof for consensus " + this.waitingCID);
                        }
                    }
                    if (currentRegency > 0) {
                        this.tomLayer.getSynchronizer().removeSTOPretransmissions(currentRegency - 1);
                    }
                    this.dt.deliverLock();
                    this.waitingCID = -1;
                    this.dt.update(this.state);
                    if (!this.appStateOnly && this.execManager.stopped()) {
                        Queue<ConsensusMessage> stoppedMsgs = this.execManager.getStoppedMsgs();
                        for (ConsensusMessage stopped : stoppedMsgs) {
                            if (stopped.getNumber() <= this.state.getLastCID()) continue;
                            this.execManager.addOutOfContextMessage(stopped);
                        }
                        this.execManager.clearStopped();
                        this.execManager.restart();
                    }
                    this.tomLayer.processOutOfContext();
                    if (this.SVController.getCurrentViewId() != currentView.getId()) {
                        this.logger.info("Installing current view!");
                        this.SVController.reconfigureTo(currentView);
                    }
                    this.isInitializing = false;
                    this.dt.canDeliver();
                    this.dt.deliverUnlock();
                    this.reset();
                    this.logger.info("I updated the state!");
                    this.tomLayer.requestsTimer.Enabled(true);
                    this.tomLayer.requestsTimer.startTimer();
                    if (this.stateTimer != null) {
                        this.stateTimer.cancel();
                    }
                    if (this.appStateOnly) {
                        this.appStateOnly = false;
                        this.tomLayer.getSynchronizer().resumeLC();
                    }
                } else if (otherReplicaState == null && this.SVController.getCurrentViewN() / 2 < this.getReplies()) {
                    this.waitingCID = -1;
                    this.reset();
                    if (this.stateTimer != null) {
                        this.stateTimer.cancel();
                    }
                    if (this.appStateOnly) {
                        this.requestState();
                    }
                } else if (haveState == -1) {
                    this.logger.debug("The replica from which I expected the state, sent one which doesn't match the hash of the others, or it never sent it at all");
                    this.changeReplica();
                    this.reset();
                    this.requestState();
                    if (this.stateTimer != null) {
                        this.stateTimer.cancel();
                    }
                } else if (haveState == 0 && this.SVController.getCurrentViewN() - this.SVController.getCurrentViewF() <= this.getReplies()) {
                    this.logger.debug("Could not obtain the state, retrying");
                    this.reset();
                    if (this.stateTimer != null) {
                        this.stateTimer.cancel();
                    }
                    this.waitingCID = -1;
                } else {
                    this.logger.debug("State transfer not yet finished");
                }
            }
        }
        this.lockTimer.unlock();
    }

    private ApplicationState getOtherReplicaState() {
        int[] processes;
        for (int process : processes = this.SVController.getCurrentViewProcesses()) {
            ApplicationState otherState;
            if (process == this.replica || (otherState = (ApplicationState)this.senderStates.get(process)) == null) continue;
            return otherState;
        }
        return null;
    }

    private int getNumEqualStates() {
        ArrayList<ApplicationState> states = new ArrayList<ApplicationState>(this.receivedStates());
        int match = 0;
        for (ApplicationState st1 : states) {
            int count = 0;
            for (ApplicationState st2 : states) {
                if (st1 == null || !st1.equals(st2)) continue;
                ++count;
            }
            if (count <= match) continue;
            match = count;
        }
        return match;
    }

    @Override
    public void currentConsensusIdAsked(int sender) {
        int me = this.SVController.getStaticConf().getProcessId();
        int lastConsensusId = this.tomLayer.getLastExec();
        StandardSMMessage currentCID = new StandardSMMessage(me, lastConsensusId, 12, 0, null, null, 0, 0);
        this.tomLayer.getCommunication().send(new int[]{sender}, currentCID);
    }
}

