/*
 * Decompiled with CFR 0.152.
 */
package bftsmart.statemanagement.strategy.durability;

import bftsmart.statemanagement.ApplicationState;
import bftsmart.statemanagement.strategy.durability.CSTRequest;
import bftsmart.statemanagement.strategy.durability.StateSender;
import bftsmart.tom.server.Recoverable;
import bftsmart.tom.server.defaultservices.durability.DurabilityCoordinator;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StateSenderServer
implements Runnable {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private ServerSocket server;
    private ApplicationState state;
    private Recoverable recoverable;
    private DurabilityCoordinator coordinator;
    private CSTRequest request;

    public void setState(ApplicationState state) {
        this.state = state;
    }

    public void setRecoverable(Recoverable recoverable) {
        this.recoverable = recoverable;
        this.coordinator = (DurabilityCoordinator)recoverable;
    }

    public void setRequest(CSTRequest request) {
        this.request = request;
    }

    public StateSenderServer(int port) {
        try {
            this.server = new ServerSocket(port);
        }
        catch (IOException e) {
            this.logger.error("Could not open server socket", (Throwable)e);
        }
    }

    @Override
    public void run() {
        try {
            Socket socket = this.server.accept();
            StateSender sender = new StateSender(socket);
            this.state = this.coordinator.getState(this.request);
            sender.setState(this.state);
            new Thread(sender).start();
        }
        catch (IOException e) {
            this.logger.error("Problem executing StateSenderServer thread", (Throwable)e);
        }
    }
}

