/*
 * Decompiled with CFR 0.152.
 */
package bftsmart.tom.core;

import bftsmart.consensus.Consensus;
import bftsmart.consensus.Decision;
import bftsmart.consensus.Epoch;
import bftsmart.consensus.messages.ConsensusMessage;
import bftsmart.consensus.roles.Acceptor;
import bftsmart.consensus.roles.Proposer;
import bftsmart.reconfiguration.ServerViewController;
import bftsmart.tom.core.TOMLayer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.TreeMap;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ExecutionManager {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private ServerViewController controller;
    private Acceptor acceptor;
    private Proposer proposer;
    private Map<Integer, Consensus> consensuses = new TreeMap<Integer, Consensus>();
    private ReentrantLock consensusesLock = new ReentrantLock();
    private Map<Integer, List<ConsensusMessage>> outOfContext = new HashMap<Integer, List<ConsensusMessage>>();
    private Map<Integer, ConsensusMessage> outOfContextProposes = new HashMap<Integer, ConsensusMessage>();
    private ReentrantLock outOfContextLock = new ReentrantLock();
    private boolean stopped = false;
    private Queue<ConsensusMessage> stoppedMsgs = new LinkedList<ConsensusMessage>();
    private Epoch stoppedEpoch = null;
    private ReentrantLock stoppedMsgsLock = new ReentrantLock();
    private TOMLayer tomLayer;
    private int paxosHighMark;
    private int revivalHighMark;
    private int timeoutHighMark;
    private int lastRemovedCID = 0;
    private int currentLeader;

    public ExecutionManager(ServerViewController controller, Acceptor acceptor, Proposer proposer, int me) {
        this.controller = controller;
        this.acceptor = acceptor;
        this.proposer = proposer;
        this.paxosHighMark = this.controller.getStaticConf().getPaxosHighMark();
        this.revivalHighMark = this.controller.getStaticConf().getRevivalHighMark();
        this.timeoutHighMark = this.controller.getStaticConf().getTimeoutHighMark();
        this.currentLeader = controller.getCurrentViewAcceptors().length > 0 ? controller.getCurrentViewAcceptors()[0] : 0;
    }

    public void setNewLeader(int leader) {
        this.currentLeader = leader;
    }

    public int getCurrentLeader() {
        return this.currentLeader;
    }

    public void setTOMLayer(TOMLayer tom) {
        this.tomLayer = tom;
    }

    public TOMLayer getTOMLayer() {
        return this.tomLayer;
    }

    public Acceptor getAcceptor() {
        return this.acceptor;
    }

    public Proposer getProposer() {
        return this.proposer;
    }

    public boolean stopped() {
        return this.stopped;
    }

    public boolean hasMsgs() {
        return !this.stoppedMsgs.isEmpty();
    }

    public Queue<ConsensusMessage> getStoppedMsgs() {
        return this.stoppedMsgs;
    }

    public void clearStopped() {
        this.stoppedMsgs.clear();
    }

    public void stop() {
        this.logger.debug("Stopping execution manager");
        this.stoppedMsgsLock.lock();
        this.stopped = true;
        if (this.tomLayer.getInExec() != -1) {
            this.stoppedEpoch = this.getConsensus(this.tomLayer.getInExec()).getLastEpoch();
            if (this.stoppedEpoch != null) {
                this.logger.debug("Stopping epoch " + this.stoppedEpoch.getTimestamp() + " of consensus " + this.tomLayer.getInExec());
            }
        }
        this.stoppedMsgsLock.unlock();
    }

    public void restart() {
        this.logger.debug("Starting execution manager");
        this.stoppedMsgsLock.lock();
        this.stopped = false;
        while (!this.stoppedMsgs.isEmpty()) {
            ConsensusMessage pm = this.stoppedMsgs.remove();
            if (pm.getNumber() <= this.tomLayer.getLastExec()) continue;
            this.acceptor.processMessage(pm);
        }
        this.stoppedMsgsLock.unlock();
        this.logger.debug("Finished stopped messages processing");
    }

    public final boolean checkLimits(ConsensusMessage msg) {
        this.outOfContextLock.lock();
        int lastConsId = this.tomLayer.getLastExec();
        int inExec = this.tomLayer.getInExec();
        this.logger.debug("Received message  " + msg);
        this.logger.debug("I'm at consensus " + inExec + " and my last consensus is " + lastConsId);
        boolean isRetrievingState = this.tomLayer.isRetrievingState();
        if (isRetrievingState) {
            this.logger.debug("I'm waiting for a state");
        }
        boolean canProcessTheMessage = false;
        if (isRetrievingState || (lastConsId != -1 || msg.getNumber() < lastConsId + this.revivalHighMark) && msg.getNumber() > lastConsId && msg.getNumber() < lastConsId + this.paxosHighMark && (!this.stopped || msg.getNumber() < lastConsId + this.timeoutHighMark)) {
            if (this.stopped) {
                this.stoppedMsgsLock.lock();
                if (this.stopped) {
                    this.logger.debug("Adding message for consensus " + msg.getNumber() + " to stoopped");
                    this.stoppedMsgs.add(msg);
                }
                this.stoppedMsgsLock.unlock();
            } else if (isRetrievingState || msg.getNumber() > lastConsId + 1 || inExec != -1 && inExec < msg.getNumber() || inExec == -1 && msg.getType() != 44781) {
                this.logger.debug("Message for consensus " + msg.getNumber() + " is out of context, adding it to out of context set");
                this.addOutOfContextMessage(msg);
            } else {
                this.logger.debug("Message for consensus " + msg.getNumber() + " can be processed");
                canProcessTheMessage = true;
            }
        } else if (lastConsId == -1 && msg.getNumber() >= lastConsId + this.revivalHighMark || msg.getNumber() >= lastConsId + this.paxosHighMark || this.stopped && msg.getNumber() >= lastConsId + this.timeoutHighMark) {
            this.logger.debug("Message for consensus " + msg.getNumber() + " is beyond the paxos highmark, adding it to out of context set");
            this.addOutOfContextMessage(msg);
            if (this.controller.getStaticConf().isStateTransferEnabled()) {
                this.tomLayer.getStateManager().analyzeState(msg.getNumber());
            } else {
                this.logger.warn("##################################################################################");
                this.logger.warn("- Ahead-of-time message discarded");
                this.logger.warn("- If many messages of the same consensus are discarded, the replica can halt!");
                this.logger.warn("- Try to increase the 'system.paxos.highMarc' configuration parameter.");
                this.logger.warn("- Last consensus executed: " + lastConsId);
                this.logger.warn("##################################################################################");
            }
        }
        this.outOfContextLock.unlock();
        return canProcessTheMessage;
    }

    public boolean receivedOutOfContextPropose(int cid) {
        this.outOfContextLock.lock();
        boolean result = this.outOfContextProposes.get(cid) != null;
        this.outOfContextLock.unlock();
        return result;
    }

    public Consensus removeConsensus(int id) {
        this.consensusesLock.lock();
        Consensus consensus = this.consensuses.remove(id);
        for (int i = this.lastRemovedCID; i < id; ++i) {
            this.consensuses.remove(i);
        }
        this.lastRemovedCID = id;
        this.consensusesLock.unlock();
        this.outOfContextLock.lock();
        this.outOfContextProposes.remove(id);
        this.outOfContext.remove(id);
        this.outOfContextLock.unlock();
        return consensus;
    }

    public void removeOutOfContexts(int id) {
        int i;
        this.outOfContextLock.lock();
        Integer[] keys = new Integer[this.outOfContextProposes.keySet().size()];
        this.outOfContextProposes.keySet().toArray(keys);
        for (i = 0; i < keys.length; ++i) {
            if (keys[i] > id) continue;
            this.outOfContextProposes.remove(keys[i]);
        }
        keys = new Integer[this.outOfContext.keySet().size()];
        this.outOfContext.keySet().toArray(keys);
        for (i = 0; i < keys.length; ++i) {
            if (keys[i] > id) continue;
            this.outOfContext.remove(keys[i]);
        }
        this.outOfContextLock.unlock();
    }

    public Consensus getConsensus(int cid) {
        this.consensusesLock.lock();
        Consensus consensus = this.consensuses.get(cid);
        if (consensus == null) {
            Decision dec = new Decision(cid);
            consensus = new Consensus(this, dec);
            this.consensuses.put(cid, consensus);
        }
        this.consensusesLock.unlock();
        return consensus;
    }

    public boolean isDecidable(int cid) {
        if (this.receivedOutOfContextPropose(cid)) {
            Consensus cons = this.getConsensus(cid);
            ConsensusMessage prop = this.outOfContextProposes.get(cons.getId());
            Epoch epoch = cons.getEpoch(prop.getEpoch(), this.controller);
            byte[] propHash = this.tomLayer.computeHash(prop.getValue());
            List<ConsensusMessage> msgs = this.outOfContext.get(cid);
            int countWrites = 0;
            int countAccepts = 0;
            if (msgs != null) {
                for (ConsensusMessage msg : msgs) {
                    if (msg.getEpoch() != epoch.getTimestamp() || !Arrays.equals(propHash, msg.getValue())) continue;
                    if (msg.getType() == 44782) {
                        ++countWrites;
                        continue;
                    }
                    if (msg.getType() != 44783) continue;
                    ++countAccepts;
                }
            }
            if (this.controller.getStaticConf().isBFT()) {
                return countWrites > 2 * this.controller.getCurrentViewF() && countAccepts > 2 * this.controller.getCurrentViewF();
            }
            return countAccepts > this.controller.getQuorum();
        }
        return false;
    }

    public void processOutOfContextPropose(Consensus consensus) {
        this.outOfContextLock.lock();
        ConsensusMessage prop = this.outOfContextProposes.remove(consensus.getId());
        if (prop != null) {
            this.logger.debug("[Consensus " + consensus.getId() + "] Processing out of context propose");
            this.acceptor.processMessage(prop);
        }
        this.outOfContextLock.unlock();
    }

    public void processOutOfContext(Consensus consensus) {
        this.outOfContextLock.lock();
        List<ConsensusMessage> messages = this.outOfContext.remove(consensus.getId());
        if (messages != null) {
            this.logger.debug("[Consensus " + consensus.getId() + "] Processing other " + messages.size() + " out of context messages.");
            Iterator<ConsensusMessage> i = messages.iterator();
            while (i.hasNext()) {
                this.acceptor.processMessage(i.next());
                if (!consensus.isDecided()) continue;
                this.logger.debug("Consensus " + consensus.getId() + " decided.");
                break;
            }
            this.logger.debug("[Consensus " + consensus.getId() + "] Finished out of context processing");
        }
        this.outOfContextLock.unlock();
    }

    public void addOutOfContextMessage(ConsensusMessage m) {
        this.outOfContextLock.lock();
        if (m.getType() == 44781) {
            this.logger.debug("Adding " + m);
            this.outOfContextProposes.put(m.getNumber(), m);
        } else {
            List<ConsensusMessage> messages = this.outOfContext.get(m.getNumber());
            if (messages == null) {
                messages = new LinkedList<ConsensusMessage>();
                this.outOfContext.put(m.getNumber(), messages);
            }
            this.logger.debug("Adding " + m);
            messages.add(m);
        }
        this.outOfContextLock.unlock();
    }

    public String toString() {
        return this.stoppedMsgs.toString();
    }
}

