/*
 * Decompiled with CFR 0.152.
 */
package bftsmart.tom.core;

import bftsmart.communication.ServerCommunicationSystem;
import bftsmart.consensus.Consensus;
import bftsmart.consensus.Decision;
import bftsmart.consensus.Epoch;
import bftsmart.consensus.TimestampValuePair;
import bftsmart.consensus.messages.ConsensusMessage;
import bftsmart.consensus.roles.Acceptor;
import bftsmart.reconfiguration.ServerViewController;
import bftsmart.statemanagement.StateManager;
import bftsmart.tom.core.ExecutionManager;
import bftsmart.tom.core.TOMLayer;
import bftsmart.tom.core.messages.TOMMessage;
import bftsmart.tom.leaderchange.CertifiedDecision;
import bftsmart.tom.leaderchange.CollectData;
import bftsmart.tom.leaderchange.LCManager;
import bftsmart.tom.leaderchange.LCMessage;
import bftsmart.tom.leaderchange.RequestsTimer;
import bftsmart.tom.util.BatchBuilder;
import bftsmart.tom.util.BatchReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.MessageDigest;
import java.security.SignedObject;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Synchronizer {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private final HashSet<LCMessage> outOfContextLC;
    private final LCManager lcManager;
    private final TOMLayer tom;
    private final RequestsTimer requestsTimer;
    private final ExecutionManager execManager;
    private final ServerViewController controller;
    private final BatchBuilder bb;
    private final ServerCommunicationSystem communication;
    private final StateManager stateManager;
    private final Acceptor acceptor;
    private final MessageDigest md;
    private int tempRegency = -1;
    private CertifiedDecision tempLastHighestCID = null;
    private HashSet<SignedObject> tempSignedCollects = null;
    private byte[] tempPropose = null;
    private int tempBatchSize = -1;
    private boolean tempIAmLeader = false;

    public Synchronizer(TOMLayer tom) {
        this.tom = tom;
        this.requestsTimer = this.tom.requestsTimer;
        this.execManager = this.tom.execManager;
        this.controller = this.tom.controller;
        this.bb = this.tom.bb;
        this.communication = this.tom.getCommunication();
        this.stateManager = this.tom.stateManager;
        this.acceptor = this.tom.acceptor;
        this.md = this.tom.md;
        this.outOfContextLC = new HashSet();
        this.lcManager = new LCManager(this.tom, this.controller, this.md);
    }

    public LCManager getLCManager() {
        return this.lcManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void triggerTimeout(List<TOMMessage> requestList) {
        ObjectOutputStream out = null;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        int regency = this.lcManager.getNextReg();
        this.requestsTimer.stopTimer();
        this.requestsTimer.Enabled(false);
        if (this.lcManager.getNextReg() == this.lcManager.getLastReg()) {
            this.lcManager.setNextReg(this.lcManager.getLastReg() + 1);
            regency = this.lcManager.getNextReg();
            this.lcManager.setCurrentRequestTimedOut(requestList);
            this.lcManager.addStop(regency, this.controller.getStaticConf().getProcessId());
            this.addSTOPedRequestsToClientManager();
            List<TOMMessage> messages = this.getRequestsToRelay();
            try {
                out = new ObjectOutputStream(bos);
                if (messages != null && messages.size() > 0) {
                    byte[] serialized = this.bb.makeBatch(messages, 0, 0L, this.controller.getStaticConf().getUseSignatures() == 1);
                    out.writeBoolean(true);
                    out.writeObject(serialized);
                } else {
                    out.writeBoolean(false);
                    this.logger.warn("Strange... did not include any request in my STOP message for regency " + regency);
                }
                out.flush();
                bos.flush();
                byte[] payload = bos.toByteArray();
                out.close();
                bos.close();
                this.logger.info("Sending STOP message to install regency " + regency + " with " + (messages != null ? messages.size() : 0) + " request(s) to relay");
                LCMessage stop = new LCMessage(this.controller.getStaticConf().getProcessId(), 3, regency, payload);
                this.requestsTimer.setSTOP(regency, stop);
                this.communication.send(this.controller.getCurrentViewOtherAcceptors(), stop);
            }
            catch (IOException ex) {
                this.logger.error("Could not serialize STOP message", (Throwable)ex);
            }
            finally {
                try {
                    out.close();
                    bos.close();
                }
                catch (IOException ex) {
                    this.logger.error("Could not serialize STOP message", (Throwable)ex);
                }
            }
        }
        this.processOutOfContextSTOPs(regency);
        this.startSynchronization(regency);
    }

    private void processOutOfContextSTOPs(int regency) {
        this.logger.debug("Checking if there are out of context STOPs for regency " + regency);
        Set<LCMessage> stops = this.getOutOfContextLC(3, regency);
        if (stops.size() > 0) {
            this.logger.info("Processing " + stops.size() + " out of context STOPs for regency " + regency);
        } else {
            this.logger.debug("No out of context STOPs for regency " + regency);
        }
        for (LCMessage m : stops) {
            TOMMessage[] requests = this.deserializeTOMMessages(m.getPayload());
            this.lcManager.addRequestsFromSTOP(requests);
            this.lcManager.addStop(regency, m.getSender());
        }
    }

    private void processSTOPDATA(LCMessage msg, int regency) {
        CertifiedDecision lastData = null;
        SignedObject signedCollect = null;
        int last = -1;
        byte[] lastValue = null;
        Set proof = null;
        try {
            boolean conditionCFT;
            ByteArrayInputStream bis = new ByteArrayInputStream(msg.getPayload());
            ObjectInputStream ois = new ObjectInputStream(bis);
            if (ois.readBoolean()) {
                last = ois.readInt();
                lastValue = (byte[])ois.readObject();
                proof = (Set)ois.readObject();
            }
            lastData = new CertifiedDecision(msg.getSender(), last, lastValue, proof);
            this.lcManager.addLastCID(regency, lastData);
            signedCollect = (SignedObject)ois.readObject();
            ois.close();
            bis.close();
            this.lcManager.addCollect(regency, signedCollect);
            int bizantineQuorum = (this.controller.getCurrentViewN() + this.controller.getCurrentViewF()) / 2;
            int cftQuorum = this.controller.getCurrentViewN() / 2;
            boolean conditionBFT = this.controller.getStaticConf().isBFT() && this.lcManager.getLastCIDsSize(regency) > bizantineQuorum && this.lcManager.getCollectsSize(regency) > bizantineQuorum;
            boolean bl = conditionCFT = this.lcManager.getLastCIDsSize(regency) > cftQuorum && this.lcManager.getCollectsSize(regency) > cftQuorum;
            if (conditionBFT || conditionCFT) {
                this.catch_up(regency);
            }
        }
        catch (IOException | ClassNotFoundException ex) {
            this.logger.error("Could not deserialize STOPDATA message", (Throwable)ex);
        }
    }

    private void processSYNC(byte[] payload, int regency) {
        CertifiedDecision lastHighestCID = null;
        int currentCID = -1;
        HashSet signedCollects = null;
        byte[] propose = null;
        int batchSize = -1;
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(payload);
            ObjectInputStream ois = new ObjectInputStream(bis);
            lastHighestCID = (CertifiedDecision)ois.readObject();
            signedCollects = (HashSet)ois.readObject();
            propose = (byte[])ois.readObject();
            batchSize = ois.readInt();
            this.lcManager.setCollects(regency, signedCollects);
            currentCID = lastHighestCID.getCID() + 1;
            if (this.lcManager.sound(this.lcManager.selectCollects(regency, currentCID)) && (!this.controller.getStaticConf().isBFT() || this.lcManager.hasValidProof(lastHighestCID))) {
                this.finalise(regency, lastHighestCID, signedCollects, propose, batchSize, false);
            }
            ois.close();
            bis.close();
        }
        catch (IOException | ClassNotFoundException ex) {
            this.logger.error("Could not deserialize SYNC message", (Throwable)ex);
        }
    }

    private Set<LCMessage> getOutOfContextLC(int type, int regency) {
        HashSet<LCMessage> result = new HashSet<LCMessage>();
        for (LCMessage m : this.outOfContextLC) {
            if (m.getType() != type || m.getReg() != regency) continue;
            result.add(m);
        }
        this.outOfContextLC.removeAll(result);
        return result;
    }

    private TOMMessage[] deserializeTOMMessages(byte[] playload) {
        TOMMessage[] requests = null;
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(playload);
            ObjectInputStream ois = new ObjectInputStream(bis);
            boolean hasReqs = ois.readBoolean();
            if (hasReqs) {
                byte[] temp = (byte[])ois.readObject();
                BatchReader batchReader = new BatchReader(temp, this.controller.getStaticConf().getUseSignatures() == 1);
                requests = batchReader.deserialiseRequests(this.controller);
            } else {
                requests = new TOMMessage[]{};
            }
            ois.close();
            bis.close();
        }
        catch (IOException | ClassNotFoundException ex) {
            this.logger.error("Could not serialize requests", (Throwable)ex);
        }
        return requests;
    }

    private List<TOMMessage> getRequestsToRelay() {
        List<TOMMessage> messagesFromSTOP;
        List<TOMMessage> messages = this.lcManager.getCurrentRequestTimedOut();
        if (messages == null) {
            messages = new LinkedList<TOMMessage>();
        }
        if ((messagesFromSTOP = this.lcManager.getRequestsFromSTOP()) != null) {
            for (TOMMessage m : messagesFromSTOP) {
                if (messages.contains(m)) continue;
                messages.add(m);
            }
        }
        this.logger.debug("I need to relay " + messages.size() + " requests");
        return messages;
    }

    private void addSTOPedRequestsToClientManager() {
        List<TOMMessage> messagesFromSTOP = this.lcManager.getRequestsFromSTOP();
        if (messagesFromSTOP != null) {
            this.logger.debug("Adding to client manager the requests contained in STOP messages");
            for (TOMMessage m : messagesFromSTOP) {
                this.tom.requestReceived(m);
            }
        }
    }

    public void removeSTOPretransmissions(int regency) {
        Set<Integer> timers = this.requestsTimer.getTimers();
        for (int t : timers) {
            if (t > regency) continue;
            this.requestsTimer.stopSTOP(t);
        }
    }

    private void startSynchronization(int nextReg) {
        block46: {
            int regency;
            boolean condition;
            ObjectOutputStream out = null;
            ByteArrayOutputStream bos = null;
            if (this.controller.getStaticConf().isBFT()) {
                condition = this.lcManager.getStopsSize(nextReg) > this.controller.getCurrentViewF();
            } else {
                boolean bl = condition = this.lcManager.getStopsSize(nextReg) > 0;
            }
            if (condition && this.lcManager.getNextReg() == this.lcManager.getLastReg()) {
                this.logger.debug("Initialize synch phase");
                this.requestsTimer.Enabled(false);
                this.requestsTimer.stopTimer();
                this.lcManager.setNextReg(this.lcManager.getLastReg() + 1);
                regency = this.lcManager.getNextReg();
                this.lcManager.addStop(regency, this.controller.getStaticConf().getProcessId());
                this.addSTOPedRequestsToClientManager();
                List<TOMMessage> messages = this.getRequestsToRelay();
                try {
                    bos = new ByteArrayOutputStream();
                    out = new ObjectOutputStream(bos);
                    if (messages != null && messages.size() > 0) {
                        out.writeBoolean(true);
                        byte[] serialized = this.bb.makeBatch(messages, 0, 0L, this.controller.getStaticConf().getUseSignatures() == 1);
                        out.writeObject(serialized);
                    } else {
                        out.writeBoolean(false);
                        this.logger.warn("Strange... did not include any request in my STOP message for regency " + regency);
                    }
                    out.flush();
                    bos.flush();
                    byte[] payload = bos.toByteArray();
                    out.close();
                    bos.close();
                    this.logger.info("Sending STOP message to install regency " + regency + " with " + (messages != null ? messages.size() : 0) + " request(s) to relay");
                    LCMessage stop = new LCMessage(this.controller.getStaticConf().getProcessId(), 3, regency, payload);
                    this.requestsTimer.setSTOP(regency, stop);
                    this.communication.send(this.controller.getCurrentViewOtherAcceptors(), stop);
                }
                catch (IOException ex) {
                    this.logger.error("Could not deserialize STOP message", (Throwable)ex);
                }
            }
            if (this.controller.getStaticConf().isBFT()) {
                condition = this.lcManager.getStopsSize(nextReg) > 2 * this.controller.getCurrentViewF();
            } else {
                boolean bl = condition = this.lcManager.getStopsSize(nextReg) > this.controller.getCurrentViewF();
            }
            if (!condition || this.lcManager.getNextReg() <= this.lcManager.getLastReg()) break block46;
            if (!this.execManager.stopped()) {
                this.execManager.stop();
            }
            this.logger.debug("Installing regency " + this.lcManager.getNextReg());
            this.lcManager.setLastReg(this.lcManager.getNextReg());
            regency = this.lcManager.getLastReg();
            this.lcManager.removeStops(nextReg);
            this.lcManager.clearCurrentRequestTimedOut();
            this.lcManager.clearRequestsFromSTOP();
            this.requestsTimer.Enabled(true);
            this.requestsTimer.setShortTimeout(-1L);
            this.requestsTimer.startTimer();
            int leader = this.lcManager.getNewLeader();
            int in = this.tom.getInExec();
            int last = this.tom.getLastExec();
            this.execManager.setNewLeader(leader);
            if (leader != this.controller.getStaticConf().getProcessId()) {
                try {
                    bos = new ByteArrayOutputStream();
                    out = new ObjectOutputStream(bos);
                    Consensus cons = null;
                    if (last > -1) {
                        cons = this.execManager.getConsensus(last);
                    }
                    if (cons != null && cons.getDecisionEpoch() != null && cons.getDecisionEpoch().propValue != null) {
                        out.writeBoolean(true);
                        out.writeInt(last);
                        byte[] decision = cons.getDecisionEpoch().propValue;
                        Set<ConsensusMessage> proof = cons.getDecisionEpoch().getProof();
                        out.writeObject(decision);
                        out.writeObject(proof);
                    } else {
                        out.writeBoolean(false);
                        if (last > -1) {
                            this.logger.debug("[DEBUG INFO FOR LAST CID #1]");
                            if (cons == null) {
                                if (last > -1) {
                                    this.logger.debug("No consensus instance for cid " + last);
                                }
                            } else if (cons.getDecisionEpoch() == null) {
                                this.logger.debug("No decision epoch for cid " + last);
                            } else {
                                this.logger.debug("epoch for cid: " + last + ": " + cons.getDecisionEpoch().toString());
                                if (cons.getDecisionEpoch().propValue == null) {
                                    this.logger.debug("No propose for cid " + last);
                                } else {
                                    this.logger.debug("Propose hash for cid " + last + ": " + Base64.encodeBase64String((byte[])this.tom.computeHash(cons.getDecisionEpoch().propValue)));
                                }
                            }
                        }
                    }
                    if (in > -1) {
                        cons = this.execManager.getConsensus(in);
                        cons.setETS(regency);
                        cons.createEpoch(regency, this.controller);
                        this.logger.debug("Incrementing ets of consensus " + cons.getId() + " to " + regency);
                        TimestampValuePair quorumWrites = cons.getQuorumWrites() != null ? cons.getQuorumWrites() : new TimestampValuePair(0, new byte[0]);
                        HashSet<TimestampValuePair> writeSet = cons.getWriteSet();
                        CollectData collect = new CollectData(this.controller.getStaticConf().getProcessId(), in, regency, quorumWrites, writeSet);
                        SignedObject signedCollect = this.tom.sign(collect);
                        out.writeObject(signedCollect);
                    } else {
                        cons = this.execManager.getConsensus(last + 1);
                        cons.setETS(regency);
                        cons.createEpoch(regency, this.controller);
                        this.logger.debug("Incrementing ets of consensus " + cons.getId() + " to " + regency);
                        CollectData collect = new CollectData(this.controller.getStaticConf().getProcessId(), last + 1, regency, new TimestampValuePair(0, new byte[0]), new HashSet<TimestampValuePair>());
                        SignedObject signedCollect = this.tom.sign(collect);
                        out.writeObject(signedCollect);
                    }
                    out.flush();
                    bos.flush();
                    Object payload = bos.toByteArray();
                    out.close();
                    bos.close();
                    int[] b = new int[]{leader};
                    this.logger.info("Sending STOPDATA of regency " + regency);
                    this.communication.send(b, new LCMessage(this.controller.getStaticConf().getProcessId(), 4, regency, (byte[])payload));
                }
                catch (IOException ex) {
                    this.logger.error("Could not deserialize STOPDATA message", (Throwable)ex);
                }
                Set<LCMessage> sync = this.getOutOfContextLC(5, regency);
                this.logger.debug("Checking if there are out of context SYNC for regency " + regency);
                if (sync.size() > 0) {
                    this.logger.info("Processing out of context SYNC for regency " + regency);
                } else {
                    this.logger.info("No out of context SYNC for regency " + regency);
                }
                for (LCMessage m : sync) {
                    if (m.getSender() != this.execManager.getCurrentLeader()) continue;
                    this.processSYNC(m.getPayload(), regency);
                    return;
                }
            } else {
                this.logger.debug("I'm the leader for this new regency");
                CertifiedDecision lastDec = null;
                CollectData collect = null;
                Consensus cons = null;
                if (last > -1) {
                    cons = this.execManager.getConsensus(last);
                }
                if (cons != null && cons.getDecisionEpoch() != null && cons.getDecisionEpoch().propValue != null) {
                    byte[] decision = cons.getDecisionEpoch().propValue;
                    Set<ConsensusMessage> proof = cons.getDecisionEpoch().getProof();
                    lastDec = new CertifiedDecision(this.controller.getStaticConf().getProcessId(), last, decision, proof);
                } else {
                    lastDec = new CertifiedDecision(this.controller.getStaticConf().getProcessId(), last, null, null);
                    if (last > -1) {
                        this.logger.debug("[DEBUG INFO FOR LAST CID #2]");
                        if (cons == null) {
                            if (last > -1) {
                                this.logger.debug("No consensus instance for cid " + last);
                            }
                        } else if (cons.getDecisionEpoch() == null) {
                            this.logger.debug("No decision epoch for cid " + last);
                        } else {
                            this.logger.debug("epoch for cid: " + last + ": " + cons.getDecisionEpoch().toString());
                        }
                        if (cons.getDecisionEpoch().propValue == null) {
                            this.logger.debug("No propose for cid " + last);
                        } else {
                            this.logger.debug("Propose hash for cid " + last + ": " + Base64.encodeBase64String((byte[])this.tom.computeHash(cons.getDecisionEpoch().propValue)));
                        }
                    }
                }
                this.lcManager.addLastCID(regency, lastDec);
                if (in > -1) {
                    cons = this.execManager.getConsensus(in);
                    cons.setETS(regency);
                    cons.createEpoch(regency, this.controller);
                    this.logger.debug("Incrementing ets of consensus " + cons.getId() + " to " + regency);
                    TimestampValuePair quorumWrites = cons.getQuorumWrites() != null ? cons.getQuorumWrites() : new TimestampValuePair(0, new byte[0]);
                    HashSet<TimestampValuePair> writeSet = cons.getWriteSet();
                    collect = new CollectData(this.controller.getStaticConf().getProcessId(), in, regency, quorumWrites, writeSet);
                } else {
                    cons = this.execManager.getConsensus(last + 1);
                    cons.setETS(regency);
                    cons.createEpoch(regency, this.controller);
                    this.logger.debug("Incrementing ets of consensus " + cons.getId() + " to " + regency);
                    collect = new CollectData(this.controller.getStaticConf().getProcessId(), last + 1, regency, new TimestampValuePair(0, new byte[0]), new HashSet<TimestampValuePair>());
                }
                SignedObject signedCollect = this.tom.sign(collect);
                this.lcManager.addCollect(regency, signedCollect);
                Set<LCMessage> stopdatas = this.getOutOfContextLC(4, regency);
                this.logger.debug("Checking if there are out of context STOPDATAs for regency " + regency);
                if (stopdatas.size() > 0) {
                    this.logger.debug("Processing " + stopdatas.size() + " out of context STOPDATAs for regency " + regency);
                } else {
                    this.logger.debug("No out of context STOPDATAs for regency " + regency);
                }
                for (LCMessage m : stopdatas) {
                    this.processSTOPDATA(m, regency);
                }
            }
        }
    }

    public void deliverTimeoutRequest(LCMessage msg) {
        switch (msg.getType()) {
            case 3: {
                this.logger.info("Last regency: " + this.lcManager.getLastReg() + ", next regency: " + this.lcManager.getNextReg());
                if (msg.getReg() == this.lcManager.getLastReg() + 1) {
                    this.logger.debug("Received regency change request");
                    TOMMessage[] requests = this.deserializeTOMMessages(msg.getPayload());
                    this.lcManager.addRequestsFromSTOP(requests);
                    this.lcManager.addStop(msg.getReg(), msg.getSender());
                    this.processOutOfContextSTOPs(msg.getReg());
                    this.startSynchronization(msg.getReg());
                    break;
                }
                if (msg.getReg() > this.lcManager.getLastReg()) {
                    this.logger.debug("Keeping STOP message as out of context for regency " + msg.getReg());
                    this.outOfContextLC.add(msg);
                    break;
                }
                this.logger.debug("Discarding STOP message");
                break;
            }
            case 4: {
                int regency = msg.getReg();
                this.logger.info("Last regency: " + this.lcManager.getLastReg() + ", next regency: " + this.lcManager.getNextReg());
                if (regency == this.lcManager.getLastReg() && this.controller.getStaticConf().getProcessId() == this.execManager.getCurrentLeader()) {
                    this.logger.debug("I'm the new leader and I received a STOPDATA");
                    this.processSTOPDATA(msg, regency);
                    break;
                }
                if (msg.getReg() > this.lcManager.getLastReg()) {
                    this.logger.debug("Keeping STOPDATA message as out of context for regency " + msg.getReg());
                    this.outOfContextLC.add(msg);
                    break;
                }
                this.logger.debug("Discarding STOPDATA message");
                break;
            }
            case 5: {
                boolean sentStopdata;
                int regency = msg.getReg();
                this.logger.info("Last regency: " + this.lcManager.getLastReg() + ", next regency: " + this.lcManager.getNextReg());
                boolean isExpectedSync = regency == this.lcManager.getLastReg() && regency == this.lcManager.getNextReg();
                boolean islateSync = regency == this.lcManager.getLastReg() && regency == this.lcManager.getNextReg() - 1;
                boolean bl = sentStopdata = this.lcManager.getStopsSize(this.lcManager.getNextReg()) == 0;
                if ((isExpectedSync || islateSync && !sentStopdata) && msg.getSender() == this.execManager.getCurrentLeader()) {
                    this.processSYNC(msg.getPayload(), regency);
                    break;
                }
                if (msg.getReg() > this.lcManager.getLastReg()) {
                    this.logger.debug("Keeping SYNC message as out of context for regency " + msg.getReg());
                    this.outOfContextLC.add(msg);
                    break;
                }
                this.logger.debug("Discarding SYNC message");
            }
        }
    }

    private void catch_up(int regency) {
        this.logger.debug("Verifying STOPDATA info");
        ObjectOutputStream out = null;
        ByteArrayOutputStream bos = null;
        CertifiedDecision lastHighestCID = this.lcManager.getHighestLastCID(regency);
        int currentCID = lastHighestCID.getCID() + 1;
        HashSet<SignedObject> signedCollects = null;
        byte[] propose = null;
        int batchSize = -1;
        if (this.lcManager.sound(this.lcManager.selectCollects(regency, currentCID))) {
            this.logger.debug("Sound predicate is true");
            signedCollects = this.lcManager.getCollects(regency);
            Decision dec = new Decision(-1);
            propose = this.tom.createPropose(dec);
            batchSize = dec.batchSize;
            try {
                bos = new ByteArrayOutputStream();
                out = new ObjectOutputStream(bos);
                out.writeObject(lastHighestCID);
                out.writeObject(signedCollects);
                out.writeObject(propose);
                out.writeInt(batchSize);
                out.flush();
                bos.flush();
                byte[] payload = bos.toByteArray();
                out.close();
                bos.close();
                this.logger.info("Sending SYNC message for regency " + regency);
                this.communication.send(this.controller.getCurrentViewOtherAcceptors(), new LCMessage(this.controller.getStaticConf().getProcessId(), 5, regency, payload));
                this.finalise(regency, lastHighestCID, signedCollects, propose, batchSize, true);
            }
            catch (IOException ex) {
                this.logger.error("Could not serialize message", (Throwable)ex);
            }
        }
    }

    public void resumeLC() {
        Consensus cons = this.execManager.getConsensus(this.tempLastHighestCID.getCID());
        Epoch e = cons.getLastEpoch();
        int ets = cons.getEts();
        if (e == null || e.getTimestamp() != ets) {
            e = cons.createEpoch(ets, this.controller);
        } else {
            e.clear();
        }
        byte[] hash = this.tom.computeHash(this.tempLastHighestCID.getDecision());
        e.propValueHash = hash;
        e.propValue = this.tempLastHighestCID.getDecision();
        e.deserializedPropValue = this.tom.checkProposedValue(this.tempLastHighestCID.getDecision(), false);
        this.finalise(this.tempRegency, this.tempLastHighestCID, this.tempSignedCollects, this.tempPropose, this.tempBatchSize, this.tempIAmLeader);
    }

    private void finalise(int regency, CertifiedDecision lastHighestCID, HashSet<SignedObject> signedCollects, byte[] propose, int batchSize, boolean iAmLeader) {
        int currentCID = lastHighestCID.getCID() + 1;
        this.logger.debug("Final stage of LC protocol");
        int me = this.controller.getStaticConf().getProcessId();
        Consensus cons = null;
        Epoch e = null;
        if (this.tom.getLastExec() + 1 < lastHighestCID.getCID()) {
            this.logger.info("NEEDING TO USE STATE TRANSFER!! (" + lastHighestCID.getCID() + ")");
            this.tempRegency = regency;
            this.tempLastHighestCID = lastHighestCID;
            this.tempSignedCollects = signedCollects;
            this.tempPropose = propose;
            this.tempBatchSize = batchSize;
            this.tempIAmLeader = iAmLeader;
            this.execManager.getStoppedMsgs().add(this.acceptor.getFactory().createPropose(currentCID, 0, propose));
            this.stateManager.requestAppState(lastHighestCID.getCID());
            return;
        }
        cons = this.execManager.getConsensus(lastHighestCID.getCID());
        e = null;
        Set<ConsensusMessage> consMsgs = lastHighestCID.getConsMessages();
        if (consMsgs == null) {
            consMsgs = new HashSet<ConsensusMessage>();
        }
        for (ConsensusMessage cm : consMsgs) {
            if (e == null) {
                e = cons.getEpoch(cm.getEpoch(), true, this.controller);
            }
            if (e.getTimestamp() != cm.getEpoch()) {
                this.logger.warn("Strange... proof of last decided consensus contains messages from more than just one epoch");
                e = cons.getEpoch(cm.getEpoch(), true, this.controller);
            }
            e.addToProof(cm);
            if (cm.getType() == 44783) {
                e.setAccept(cm.getSender(), cm.getValue());
                continue;
            }
            if (cm.getType() != 44782) continue;
            e.setWrite(cm.getSender(), cm.getValue());
        }
        if (e != null) {
            this.logger.info("Installed proof of last decided consensus " + lastHighestCID.getCID());
            byte[] hash = this.tom.computeHash(lastHighestCID.getDecision());
            e.propValueHash = hash;
            e.propValue = lastHighestCID.getDecision();
            e.deserializedPropValue = this.tom.checkProposedValue(lastHighestCID.getDecision(), false);
            if (this.tom.getLastExec() + 1 == lastHighestCID.getCID()) {
                this.logger.info("I'm still at the CID before the most recent one!!! (" + lastHighestCID.getCID() + ")");
                cons.decided(e, true);
            } else {
                cons.decided(e, false);
            }
        } else {
            this.logger.info("I did not install any proof of last decided consensus " + lastHighestCID.getCID());
        }
        cons = null;
        e = null;
        byte[] tmpval = null;
        HashSet<CollectData> selectedColls = this.lcManager.selectCollects(signedCollects, currentCID, regency);
        tmpval = this.lcManager.getBindValue(selectedColls);
        this.logger.debug("Trying to find a binded value");
        if (tmpval == null && this.lcManager.unbound(selectedColls)) {
            this.logger.debug("Did not found a value that might have already been decided");
            tmpval = propose;
        } else {
            this.logger.debug("Found a value that might have been decided");
        }
        if (tmpval != null) {
            this.logger.debug("Resuming normal phase");
            this.lcManager.removeCollects(regency);
            this.removeSTOPretransmissions(regency);
            cons = this.execManager.getConsensus(currentCID);
            e = cons.getLastEpoch();
            int ets = cons.getEts();
            if (regency > ets) {
                this.logger.debug("Updating consensus' ETS after SYNC (from " + ets + " to " + regency + ")");
                cons.setETS(regency);
                cons.createEpoch(regency, this.controller);
                e = cons.getLastEpoch();
            }
            if (e == null || e.getTimestamp() != regency) {
                e = cons.createEpoch(regency, this.controller);
            } else {
                e.clear();
            }
            cons.removeWritten(tmpval);
            cons.addWritten(tmpval);
            byte[] hash = this.tom.computeHash(tmpval);
            e.propValueHash = hash;
            e.propValue = tmpval;
            e.deserializedPropValue = this.tom.checkProposedValue(tmpval, false);
            if (cons.getDecision().firstMessageProposed == null) {
                cons.getDecision().firstMessageProposed = e.deserializedPropValue != null && e.deserializedPropValue.length > 0 ? e.deserializedPropValue[0] : new TOMMessage();
            }
            if (this.controller.getStaticConf().isBFT()) {
                e.setWrite(me, hash);
            } else {
                e.setAccept(me, hash);
                this.logger.debug("[CFT Mode] Setting consensus " + currentCID + " QuorumWrite tiemstamp to " + e.getConsensus().getEts() + " and value " + Arrays.toString(hash));
                e.getConsensus().setQuorumWrites(hash);
            }
            this.execManager.restart();
            this.tom.setInExec(currentCID);
            if (iAmLeader) {
                this.logger.debug("Waking up proposer thread");
                this.tom.imAmTheLeader();
            }
            if (this.controller.getStaticConf().isBFT()) {
                this.logger.info("Sending WRITE message for CID " + currentCID + ", timestamp " + e.getTimestamp() + ", value " + Arrays.toString(e.propValueHash));
                this.communication.send(this.controller.getCurrentViewOtherAcceptors(), this.acceptor.getFactory().createWrite(currentCID, e.getTimestamp(), e.propValueHash));
            } else {
                this.logger.info("Sending ACCEPT message for CID " + currentCID + ", timestamp " + e.getTimestamp() + ", value " + Arrays.toString(e.propValueHash));
                this.communication.send(this.controller.getCurrentViewOtherAcceptors(), this.acceptor.getFactory().createAccept(currentCID, e.getTimestamp(), e.propValueHash));
            }
        } else {
            this.logger.warn("Sync phase failed for regency" + regency);
        }
    }
}

