/*
 * Decompiled with CFR 0.152.
 */
package bftsmart.tom.core;

import bftsmart.communication.client.CommunicationSystemClientSide;
import bftsmart.communication.client.CommunicationSystemClientSideFactory;
import bftsmart.communication.client.ReplyReceiver;
import bftsmart.reconfiguration.ClientViewController;
import bftsmart.tom.core.messages.TOMMessage;
import bftsmart.tom.core.messages.TOMMessageType;
import bftsmart.tom.util.KeyLoader;
import java.io.Closeable;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public abstract class TOMSender
implements ReplyReceiver,
Closeable,
AutoCloseable {
    private int me;
    private ClientViewController viewController;
    private int session = 0;
    private int sequence = 0;
    private int unorderedMessageSequence = 0;
    private CommunicationSystemClientSide cs;
    private Lock lock = new ReentrantLock();
    private boolean useSignatures = false;
    private AtomicInteger opCounter = new AtomicInteger(0);

    @Override
    public void close() {
        this.cs.close();
    }

    public CommunicationSystemClientSide getCommunicationSystem() {
        return this.cs;
    }

    public ClientViewController getViewManager() {
        return this.viewController;
    }

    public void init(int processId, KeyLoader loader) {
        this.viewController = new ClientViewController(processId, loader);
        this.startsCS(processId);
    }

    public void init(int processId, String configHome, KeyLoader loader) {
        this.viewController = new ClientViewController(processId, configHome, loader);
        this.startsCS(processId);
    }

    private void startsCS(int clientId) {
        this.cs = CommunicationSystemClientSideFactory.getCommunicationSystemClientSide(clientId, this.viewController);
        this.cs.setReplyReceiver(this);
        this.me = this.viewController.getStaticConf().getProcessId();
        this.useSignatures = this.viewController.getStaticConf().getUseSignatures() == 1;
        this.session = new Random().nextInt();
    }

    public int getProcessId() {
        return this.me;
    }

    public int generateRequestId(TOMMessageType type) {
        this.lock.lock();
        int id = type == TOMMessageType.ORDERED_REQUEST ? this.sequence++ : this.unorderedMessageSequence++;
        this.lock.unlock();
        return id;
    }

    public int generateOperationId() {
        return this.opCounter.getAndIncrement();
    }

    public void TOMulticast(TOMMessage sm) {
        this.cs.send(this.useSignatures, this.viewController.getCurrentViewProcesses(), sm);
    }

    public void TOMulticast(byte[] m, int reqId, int operationId, TOMMessageType reqType) {
        this.cs.send(this.useSignatures, this.viewController.getCurrentViewProcesses(), new TOMMessage(this.me, this.session, reqId, operationId, m, this.viewController.getCurrentViewId(), reqType));
    }

    public void sendMessageToTargets(byte[] m, int reqId, int operationId, int[] targets, TOMMessageType type) {
        if (this.getViewManager().getStaticConf().isTheTTP()) {
            type = TOMMessageType.ASK_STATUS;
        }
        this.cs.send(this.useSignatures, targets, new TOMMessage(this.me, this.session, reqId, operationId, m, this.viewController.getCurrentViewId(), type));
    }

    public int getSession() {
        return this.session;
    }
}

