/*
 * Decompiled with CFR 0.152.
 */
package bftsmart.tom.server.defaultservices;

import bftsmart.consensus.messages.ConsensusMessage;
import bftsmart.reconfiguration.ServerViewController;
import bftsmart.statemanagement.ApplicationState;
import bftsmart.tom.core.messages.TOMMessage;
import bftsmart.tom.leaderchange.CertifiedDecision;
import bftsmart.tom.server.defaultservices.CommandsInfo;
import bftsmart.tom.util.BatchBuilder;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Set;

public class DefaultApplicationState
implements ApplicationState {
    private static final long serialVersionUID = 6771081456095596363L;
    protected byte[] state;
    protected byte[] stateHash;
    protected int lastCID = -1;
    protected boolean hasState;
    private CommandsInfo[] messageBatches;
    private int lastCheckpointCID;
    private byte[] logHash;
    private int pid;

    public DefaultApplicationState(CommandsInfo[] messageBatches, int lastCheckpointCID, int lastCID, byte[] state, byte[] stateHash, int pid) {
        this.messageBatches = messageBatches;
        this.lastCheckpointCID = lastCheckpointCID;
        this.lastCID = lastCID;
        this.state = state;
        this.stateHash = stateHash;
        this.hasState = true;
        this.pid = pid;
    }

    public DefaultApplicationState(CommandsInfo[] messageBatches, byte[] logHash, int lastCheckpointCID, int lastCID, byte[] state, byte[] stateHash, int pid) {
        this(messageBatches, lastCheckpointCID, lastCID, state, stateHash, pid);
        this.logHash = logHash;
    }

    public DefaultApplicationState() {
        this.messageBatches = null;
        this.lastCheckpointCID = -1;
        this.lastCID = -1;
        this.state = null;
        this.stateHash = null;
        this.hasState = false;
        this.pid = -1;
    }

    @Override
    public void setSerializedState(byte[] state) {
        this.state = state;
    }

    @Override
    public byte[] getSerializedState() {
        return this.state;
    }

    @Override
    public boolean hasState() {
        return this.hasState;
    }

    @Override
    public int getLastCID() {
        return this.lastCID;
    }

    @Override
    public CertifiedDecision getCertifiedDecision(ServerViewController controller) {
        CommandsInfo ci = this.getMessageBatch(this.getLastCID());
        if (ci != null && ci.msgCtx[0].getProof() != null) {
            Set<ConsensusMessage> proof = ci.msgCtx[0].getProof();
            LinkedList<TOMMessage> requests = new LinkedList<TOMMessage>();
            for (int i = 0; i < ci.commands.length; ++i) {
                requests.add(ci.msgCtx[i].recreateTOMMessage(ci.commands[i]));
            }
            BatchBuilder bb = new BatchBuilder(0L);
            byte[] value = bb.makeBatch(requests, ci.msgCtx[0].getNumOfNonces(), ci.msgCtx[0].getSeed(), ci.msgCtx[0].getTimestamp(), controller.getStaticConf().getUseSignatures() == 1);
            return new CertifiedDecision(this.pid, this.getLastCID(), value, proof);
        }
        return null;
    }

    public byte[] getState() {
        return this.state;
    }

    @Override
    public byte[] getStateHash() {
        return this.stateHash;
    }

    public void setState(byte[] state) {
        this.state = state;
    }

    public CommandsInfo[] getMessageBatches() {
        return this.messageBatches;
    }

    public void setMessageBatches(CommandsInfo[] messageBatches) {
        this.messageBatches = messageBatches;
    }

    public CommandsInfo getMessageBatch(int cid) {
        if (this.messageBatches != null && cid >= this.lastCheckpointCID && cid <= this.lastCID) {
            return this.messageBatches[cid - this.lastCheckpointCID - 1];
        }
        return null;
    }

    public int getLastCheckpointCID() {
        return this.lastCheckpointCID;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof DefaultApplicationState) {
            DefaultApplicationState tState = (DefaultApplicationState)obj;
            if (this.messageBatches != null && tState.messageBatches == null || this.messageBatches == null && tState.messageBatches != null) {
                return false;
            }
            if (this.messageBatches != null && tState.messageBatches != null) {
                if (this.messageBatches.length != tState.messageBatches.length) {
                    return false;
                }
                for (int i = 0; i < this.messageBatches.length; ++i) {
                    if (this.messageBatches[i] == null && tState.messageBatches[i] != null) {
                        return false;
                    }
                    if (this.messageBatches[i] != null && tState.messageBatches[i] == null) {
                        return false;
                    }
                    if (this.messageBatches[i] == null && tState.messageBatches[i] == null || this.messageBatches[i].equals(tState.messageBatches[i])) continue;
                    return false;
                }
            }
            return Arrays.equals(this.stateHash, tState.stateHash) && tState.lastCheckpointCID == this.lastCheckpointCID && tState.lastCID == this.lastCID && tState.hasState == this.hasState;
        }
        return false;
    }

    @Override
    public int hashCode() {
        int i;
        int hash = 1;
        hash = hash * 31 + this.lastCheckpointCID;
        hash = hash * 31 + this.lastCID;
        hash = hash * 31 + (this.hasState ? 1 : 0);
        if (this.stateHash != null) {
            for (i = 0; i < this.stateHash.length; ++i) {
                hash = hash * 31 + this.stateHash[i];
            }
        } else {
            hash = hash * 31 + 0;
        }
        if (this.messageBatches != null) {
            for (i = 0; i < this.messageBatches.length; ++i) {
                hash = this.messageBatches[i] != null ? hash * 31 + this.messageBatches[i].hashCode() : hash * 31 + 0;
            }
        } else {
            hash = hash * 31 + 0;
        }
        return hash;
    }
}

