/*
 * Decompiled with CFR 0.152.
 */
package bftsmart.tom.server.defaultservices;

import bftsmart.tom.server.defaultservices.CommandsInfo;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileRecoverer {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private byte[] ckpHash;
    private int ckpLastConsensusId;
    private int logLastConsensusId;
    private int replicaId;
    private String defaultDir;

    public FileRecoverer(int replicaId, String defaultDir) {
        this.replicaId = replicaId;
        this.defaultDir = defaultDir;
        this.ckpLastConsensusId = 0;
        this.logLastConsensusId = 0;
    }

    public CommandsInfo[] getLogState(int index, String logPath) {
        RandomAccessFile log = null;
        this.logger.info("GETTING LOG FROM " + logPath);
        log = this.openLogFile(logPath);
        if (log != null) {
            CommandsInfo[] logState = this.recoverLogState(log, index);
            try {
                log.close();
            }
            catch (IOException e) {
                this.logger.error("Failed to get state log", (Throwable)e);
            }
            return logState;
        }
        return null;
    }

    public CommandsInfo[] getLogState(long pointer, int startOffset, int number, String logPath) {
        RandomAccessFile log = null;
        this.logger.info("GETTING LOG FROM " + logPath);
        log = this.openLogFile(logPath);
        if (log != null) {
            CommandsInfo[] logState = this.recoverLogState(log, pointer, startOffset, number);
            try {
                log.close();
            }
            catch (IOException e) {
                this.logger.error("Failed to get state log", (Throwable)e);
            }
            return logState;
        }
        return null;
    }

    public byte[] getCkpState(String ckpPath) {
        RandomAccessFile ckp = null;
        this.logger.info("GETTING CHECKPOINT FROM " + ckpPath);
        ckp = this.openLogFile(ckpPath);
        if (ckp != null) {
            byte[] ckpState = this.recoverCkpState(ckp);
            try {
                ckp.close();
            }
            catch (IOException e) {
                this.logger.error("Failed to get checkpoint", (Throwable)e);
            }
            return ckpState;
        }
        return null;
    }

    public void recoverCkpHash(String ckpPath) {
        RandomAccessFile ckp = null;
        this.logger.info("GETTING HASH FROM CHECKPOINT" + ckpPath);
        ckp = this.openLogFile(ckpPath);
        if (ckp != null) {
            byte[] ckpHash = null;
            try {
                int ckpSize = ckp.readInt();
                ckp.skipBytes(ckpSize);
                int hashLength = ckp.readInt();
                ckpHash = new byte[hashLength];
                ckp.read(ckpHash);
                this.logger.debug("Last ckp size: " + ckpSize + " Last ckp hash: " + Arrays.toString(ckpHash));
            }
            catch (Exception e) {
                this.logger.error("State recover was aborted due to an unexpected exception", (Throwable)e);
            }
            this.ckpHash = ckpHash;
        }
    }

    private byte[] recoverCkpState(RandomAccessFile ckp) {
        byte[] ckpState = null;
        try {
            long ckpLength = ckp.length();
            boolean mayRead = true;
            while (mayRead) {
                try {
                    if (ckp.getFilePointer() < ckpLength) {
                        int size = ckp.readInt();
                        if (size > 0) {
                            ckpState = new byte[size];
                            int read = ckp.read(ckpState);
                            if (read == size) {
                                int hashSize = ckp.readInt();
                                if (hashSize <= 0) continue;
                                this.ckpHash = new byte[hashSize];
                                read = ckp.read(this.ckpHash);
                                if (read == hashSize) {
                                    mayRead = false;
                                    continue;
                                }
                                this.ckpHash = null;
                                ckpState = null;
                                continue;
                            }
                            mayRead = false;
                            ckp = null;
                            continue;
                        }
                        mayRead = false;
                        continue;
                    }
                    mayRead = false;
                }
                catch (Exception e) {
                    this.logger.error("Failed to recover from checkpoint", (Throwable)e);
                    ckp = null;
                    mayRead = false;
                }
            }
            if (ckp.readInt() == 0) {
                this.ckpLastConsensusId = ckp.readInt();
                this.logger.debug("LAST CKP read from file: " + this.ckpLastConsensusId);
            }
        }
        catch (Exception e) {
            this.logger.error("State recover was aborted due to an unexpected exception", (Throwable)e);
        }
        return ckpState;
    }

    public void transferLog(SocketChannel sChannel, int index, String logPath) {
        RandomAccessFile log = null;
        this.logger.info("GETTING STATE FROM LOG " + logPath);
        log = this.openLogFile(logPath);
        if (log != null) {
            this.transferLog(log, sChannel, index);
        }
    }

    private void transferLog(RandomAccessFile logFile, SocketChannel sChannel, int index) {
        try {
            long totalBytes = logFile.length();
            this.logger.info("Called transferLog." + totalBytes + " " + (sChannel == null));
            FileChannel fileChannel = logFile.getChannel();
            long bytesTransfered = 0L;
            while (bytesTransfered < totalBytes) {
                long bytesSent;
                long bufferSize = 65536L;
                if (totalBytes - bytesTransfered < bufferSize && (bufferSize = (long)((int)(totalBytes - bytesTransfered))) <= 0L) {
                    bufferSize = (int)totalBytes;
                }
                if ((bytesSent = fileChannel.transferTo(bytesTransfered, bufferSize, sChannel)) <= 0L) continue;
                bytesTransfered += bytesSent;
            }
        }
        catch (Exception e) {
            this.logger.error("State recover was aborted due to an unexpected exception", (Throwable)e);
        }
    }

    public void transferCkpState(SocketChannel sChannel, String ckpPath) {
        RandomAccessFile ckp = null;
        this.logger.info("GETTING CHECKPOINT FROM " + ckpPath);
        ckp = this.openLogFile(ckpPath);
        if (ckp != null) {
            this.transferCkpState(ckp, sChannel);
            try {
                ckp.close();
            }
            catch (IOException e) {
                this.logger.error("Failed to get checkpoint", (Throwable)e);
            }
        }
    }

    private void transferCkpState(RandomAccessFile ckp, SocketChannel sChannel) {
        try {
            long milliInit = System.currentTimeMillis();
            this.logger.info("Sending checkpoint." + ckp.length() + " " + (sChannel == null));
            FileChannel fileChannel = ckp.getChannel();
            long totalBytes = ckp.length();
            long bytesTransfered = 0L;
            while (bytesTransfered < totalBytes) {
                long bytesRead;
                long bufferSize = 65536L;
                if (totalBytes - bytesTransfered < bufferSize && (bufferSize = (long)((int)(totalBytes - bytesTransfered))) <= 0L) {
                    bufferSize = (int)totalBytes;
                }
                if ((bytesRead = fileChannel.transferTo(bytesTransfered, bufferSize, sChannel)) <= 0L) continue;
                bytesTransfered += bytesRead;
            }
            this.logger.debug("Took " + (System.currentTimeMillis() - milliInit) + " milliseconds to transfer the checkpoint");
            fileChannel.close();
        }
        catch (Exception e) {
            this.logger.error("State recover was aborted due to an unexpected exception", (Throwable)e);
        }
    }

    public byte[] getCkpStateHash() {
        return this.ckpHash;
    }

    public int getCkpLastConsensusId() {
        return this.ckpLastConsensusId;
    }

    public int getLogLastConsensusId() {
        return this.logLastConsensusId;
    }

    private RandomAccessFile openLogFile(String file) {
        try {
            return new RandomAccessFile(file, "r");
        }
        catch (Exception e) {
            this.logger.error("Failed to open log file", (Throwable)e);
            return null;
        }
    }

    private CommandsInfo[] recoverLogState(RandomAccessFile log, int endOffset) {
        try {
            long logLength = log.length();
            ArrayList<CommandsInfo> state = new ArrayList<CommandsInfo>();
            int recoveredBatches = 0;
            boolean mayRead = true;
            this.logger.debug("filepointer: " + log.getFilePointer() + " loglength " + logLength + " endoffset " + endOffset);
            while (mayRead) {
                try {
                    if (log.getFilePointer() < logLength) {
                        int size = log.readInt();
                        if (size > 0) {
                            byte[] bytes = new byte[size];
                            int read = log.read(bytes);
                            if (read == size) {
                                ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
                                ObjectInputStream ois = new ObjectInputStream(bis);
                                state.add((CommandsInfo)ois.readObject());
                                if (++recoveredBatches != endOffset) continue;
                                this.logger.debug("read all " + endOffset + " log messages");
                                return state.toArray(new CommandsInfo[state.size()]);
                            }
                            mayRead = false;
                            state.clear();
                            continue;
                        }
                        this.logLastConsensusId = log.readInt();
                        return state.toArray(new CommandsInfo[state.size()]);
                    }
                    mayRead = false;
                }
                catch (Exception e) {
                    this.logger.error("Failed to recover log state", (Throwable)e);
                    state.clear();
                    mayRead = false;
                }
            }
        }
        catch (Exception e) {
            this.logger.error("State recover was aborted due to an unexpected exception", (Throwable)e);
        }
        return null;
    }

    private CommandsInfo[] recoverLogState(RandomAccessFile log, long pointer, int startOffset, int number) {
        try {
            byte[] bytes;
            long logLength = log.length();
            ArrayList<CommandsInfo> state = new ArrayList<CommandsInfo>();
            int recoveredBatches = 0;
            boolean mayRead = true;
            log.seek(pointer);
            for (int index = 0; index < startOffset; ++index) {
                int size = log.readInt();
                bytes = new byte[size];
                log.read(bytes);
            }
            while (mayRead) {
                try {
                    if (log.getFilePointer() < logLength) {
                        int size = log.readInt();
                        if (size > 0) {
                            bytes = new byte[size];
                            int read = log.read(bytes);
                            if (read == size) {
                                ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
                                ObjectInputStream ois = new ObjectInputStream(bis);
                                state.add((CommandsInfo)ois.readObject());
                                if (++recoveredBatches != number) continue;
                                return state.toArray(new CommandsInfo[state.size()]);
                            }
                            mayRead = false;
                            state.clear();
                            continue;
                        }
                        mayRead = false;
                        continue;
                    }
                    mayRead = false;
                }
                catch (Exception e) {
                    this.logger.error("Failed to recolver log state", (Throwable)e);
                    state.clear();
                    mayRead = false;
                }
            }
        }
        catch (Exception e) {
            this.logger.error("State recover was aborted due to an unexpected exception", (Throwable)e);
        }
        return null;
    }

    public String getLatestFile(String extention) {
        File directory = new File(this.defaultDir);
        String latestFile = null;
        if (directory.isDirectory()) {
            File[] serverLogs = directory.listFiles(new FileListFilter(this.replicaId, extention));
            long timestamp = 0L;
            for (File f : serverLogs) {
                String[] nameItems = f.getName().split("\\.");
                long filets = new Long(nameItems[1]);
                if (filets <= timestamp) continue;
                timestamp = filets;
                latestFile = f.getAbsolutePath();
            }
        }
        return latestFile;
    }

    private class FileListFilter
    implements FilenameFilter {
        private int id;
        private String extention;

        public FileListFilter(int id, String extention) {
            this.id = id;
            this.extention = extention;
        }

        @Override
        public boolean accept(File directory, String filename) {
            boolean fileOK = false;
            if (this.id >= 0 && filename.startsWith(this.id + ".") && filename.endsWith(this.extention)) {
                fileOK = true;
            }
            return fileOK;
        }
    }
}

