/*
 * Decompiled with CFR 0.152.
 */
package bftsmart.tom.util;

import bftsmart.tom.core.messages.TOMMessage;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BatchBuilder {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private Random rnd;

    public BatchBuilder(long seed) {
        this.rnd = new Random(seed);
    }

    private byte[] createBatch(long timestamp, int numberOfNonces, long seed, int numberOfMessages, int totalMessagesSize, boolean useSignatures, byte[][] messages, byte[][] signatures) {
        int sigsSize = 0;
        if (useSignatures) {
            sigsSize = 4 * numberOfMessages;
            for (byte[] sig : signatures) {
                sigsSize += sig.length;
            }
        }
        int size = 20 + (numberOfNonces > 0 ? 8 : 0) + 4 * numberOfMessages + sigsSize + totalMessagesSize;
        ByteBuffer proposalBuffer = ByteBuffer.allocate(size);
        proposalBuffer.putLong(timestamp);
        proposalBuffer.putInt(numberOfNonces);
        if (numberOfNonces > 0) {
            proposalBuffer.putLong(seed);
        }
        proposalBuffer.putInt(numberOfMessages);
        for (int i = 0; i < numberOfMessages; ++i) {
            this.putMessage(proposalBuffer, messages[i], useSignatures, signatures[i]);
        }
        return proposalBuffer.array();
    }

    private void putMessage(ByteBuffer proposalBuffer, byte[] message, boolean addSig, byte[] signature) {
        proposalBuffer.putInt(message.length);
        proposalBuffer.put(message);
        if (addSig) {
            if (signature != null) {
                proposalBuffer.putInt(signature.length);
                proposalBuffer.put(signature);
            } else {
                proposalBuffer.putInt(0);
            }
        }
    }

    public byte[] makeBatch(List<TOMMessage> msgs, int numNounces, long timestamp, boolean useSignatures) {
        int numMsgs = msgs.size();
        int totalMessageSize = 0;
        byte[][] messages = new byte[numMsgs][];
        byte[][] signatures = new byte[numMsgs][];
        int i = 0;
        for (TOMMessage msg : msgs) {
            this.logger.debug("Adding request from client " + msg.getSender() + " with sequence number " + msg.getSequence() + " for session " + msg.getSession() + " to PROPOSE");
            messages[i] = msg.serializedMessage;
            signatures[i] = msg.serializedMessageSignature;
            totalMessageSize += messages[i].length;
            ++i;
        }
        return this.createBatch(timestamp, numNounces, this.rnd.nextLong(), numMsgs, totalMessageSize, useSignatures, messages, signatures);
    }

    public byte[] makeBatch(List<TOMMessage> msgs, int numNounces, long seed, long timestamp, boolean useSignatures) {
        int numMsgs = msgs.size();
        int totalMessageSize = 0;
        byte[][] messages = new byte[numMsgs][];
        byte[][] signatures = new byte[numMsgs][];
        int i = 0;
        for (TOMMessage msg : msgs) {
            messages[i] = msg.serializedMessage;
            signatures[i] = msg.serializedMessageSignature;
            totalMessageSize += messages[i].length;
            ++i;
        }
        return this.createBatch(timestamp, numNounces, seed, numMsgs, totalMessageSize, useSignatures, messages, signatures);
    }
}

