/*
 * Decompiled with CFR 0.152.
 */
package BFTSmartBlockchain;

import BFTSmartBlockchain.Transaction;
import java.io.ByteArrayOutputStream;
import java.io.Serializable;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.TreeSet;
import org.apache.commons.codec.binary.Hex;

public class Block
implements Serializable {
    private static final long serialVersionUID = 1L;
    public TreeSet<Transaction> transactions;
    public byte[] prevBlockHash;
    public byte[] blockHash;

    public Block(TreeSet<Transaction> transactions, byte[] prevBlockHash) {
        this.transactions = transactions;
        this.prevBlockHash = (byte[])(prevBlockHash != null ? (byte[])prevBlockHash.clone() : null);
        try {
            MessageDigest sha = MessageDigest.getInstance("SHA");
            this.blockHash = sha.digest(this.asByteArray());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean Verify() {
        try {
            MessageDigest sha = MessageDigest.getInstance("SHA");
            byte[] h = sha.digest(this.asByteArray());
            if (!Arrays.equals(h, this.blockHash)) {
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        for (Transaction t : this.transactions) {
            if (t.Verify()) continue;
            return false;
        }
        return true;
    }

    public byte[] asByteArray() {
        try {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            for (Transaction t : this.transactions) {
                stream.write(t.asByteArray());
            }
            if (this.prevBlockHash != null) {
                stream.write(this.prevBlockHash);
            }
            return stream.toByteArray();
        }
        catch (Exception e) {
            return null;
        }
    }

    public String toString() {
        if (this.prevBlockHash != null) {
            return "Block \n with hash: " + Hex.encodeHexString((byte[])this.blockHash) + "\n with: " + this.transactions.size() + " transactions," + "\n and previous Hash: " + Hex.encodeHexString((byte[])this.prevBlockHash);
        }
        return "Block \n with hash: " + Hex.encodeHexString((byte[])this.blockHash) + "\n with: " + this.transactions.size() + " transactions," + "\n and previous Hash: null";
    }
}

