import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECGenParameterSpec;
import java.util.HashSet;
import java.util.Set;

public class BlockchainTest {

	public static void main(String[] args) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException {
		
		// Select an Elliptic Curve (discrete logarithm) based key generator
		KeyPairGenerator keyPairGen = KeyPairGenerator.getInstance("EC");
		// Set algorithm parameters for key pair generator
		ECGenParameterSpec curveSpec = new ECGenParameterSpec("secp256k1");
		// Initialize the key pair generator with the curve specification and the random number generator
	    keyPairGen.initialize(curveSpec);	
	    // Generate a key pair
		KeyPair ECKeyPair = keyPairGen.generateKeyPair();
		ECPublicKey publicKey = (ECPublicKey) ECKeyPair.getPublic();
		ECPrivateKey privateKey = (ECPrivateKey) ECKeyPair.getPrivate();
		
		// Create a new blockchain
		Blockchain chain = new Blockchain();
		System.out.println(chain);
		System.out.println(chain.VerifyChain());
		
		// create and sign some transactions
		Set<Transaction> transactions1 = new HashSet<Transaction>();
		transactions1.add(new Transaction("Hello World".getBytes(), publicKey).Sign(privateKey));
		transactions1.add(new Transaction("I Love Blockchains".getBytes(), publicKey).Sign(privateKey));
		
		Block block1 = new Block(transactions1, null);
		// create a new block with these transactions
		chain.AddBlock(block1);
		System.out.println(chain);
		System.out.println(chain.VerifyChain());
		
		// create and sign some more transactions
		Set<Transaction> transactions2 = new HashSet<Transaction>();
		transactions2.add(new Transaction("Osnabrueck is the center of the world".getBytes(), publicKey).Sign(privateKey));
		transactions2.add(new Transaction("Blockchains are cool".getBytes(), publicKey).Sign(privateKey));
		
		Block block2 = new Block(transactions2, block1.blockHash);
		// create a new block with these transactions
		chain.AddBlock(block2);
		System.out.println(chain);		
		System.out.println(chain.VerifyChain());
	}

}
