import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Security;

import org.apache.commons.codec.binary.Hex;

public class CryptoHashTest {

		public static void main(String[] args) throws NoSuchAlgorithmException {

			/*
			 * A very simple (and not secure) cryptographic hash function
			 * with a constant output size of one byte (8 bits)
			 */
			byte p = Pearson.computePearson("blockweek".getBytes());
			System.out.println(p);

			/*
			 * Get a list of all available message digest algorithms
			 */
			for (String s : Security.getAlgorithms("MessageDigest")) {
				System.out.println(s);
			}

			/*
			 * Compute the MD5 hash using the built-in function
			 */
			MessageDigest md5 = MessageDigest.getInstance("MD5");
			byte[] digest = md5.digest("Hello Digest".getBytes());
			System.out.println(Hex.encodeHex(digest));

			/*
			 * Compute the MD5 hash using the MD5 class in this project
			 */
			digest = MD5.computeMD5("Hello Digest".getBytes());
			System.out.println(Hex.encodeHex(digest));
			
			/* 
			 * Computes the SHA1 digest using the built-in function
			 */
			MessageDigest sha = MessageDigest.getInstance("SHA");
			digest = sha.digest("Hello Digest".getBytes());
			System.out.println(Hex.encodeHex(digest));
		}
	}
